// Pakiet keyboard - wczytuje z klawiatury dane wejściowe od użytkownika.
package keyboard

import (
	"bufio"
	"os"
	"strconv"
	"strings"
)

// GetFloat wczytuje liczbę zmiennoprzecinkową z klawiatury.
// Zwraca wczytaną liczbę i informacje o błędach.
func GetFloat() (float64, error) {
	reader := bufio.NewReader(os.Stdin)
	input, err := reader.ReadString('\n')
	if err != nil {
		return 0, err
	}

	input = strings.TrimSpace(input)
	number, err := strconv.ParseFloat(input, 64)
	if err != nil {
		return 0, err
	}
	return number, nil
}
