package main

import "fmt"

type Liters float64
type Milliliters float64
type Gallons float64

func (l Liters) ToGallons() Gallons {
	return Gallons(l * 0.264)
}
func (m Milliliters) ToGallons() Gallons {
	return Gallons(m * 0.000264)
}

func main() {
	soda := Liters(2)
	fmt.Printf("%0.3f litrów to %0.3f galona.\n", soda, soda.ToGallons())
	water := Milliliters(500)
	fmt.Printf("%0.3f mililitrów to %0.3f galona.\n", water, water.ToGallons())
}
