// Copyright 2010, Mark C. Chu-Carroll (markcc@gmail.com).
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.pragprog.aebook.chat.client;

import com.google.gwt.user.client.rpc.IsSerializable;

//START: main
public class ChatRoom implements IsSerializable {
    
    String name;
    
    long date;

    public ChatRoom(String chat, long date) {
        this.date = date;
        this.name = chat;
    }
    
    public ChatRoom() {
    }

    public String getName() {
        return name;
    }
    
    public long getLastMessageDate() {
        return date;
    }
    
    public void updateLastMessageDate(long d) {
        date = d;
    }
}
//END: main
