﻿# -*- coding: utf-8 -*-
from google.appengine.ext import webapp
from google.appengine.ext.webapp.util import run_wsgi_app
import datetime

from google.appengine.ext import db

#START: ChatMessage
class ChatMessage(db.Model):
    user = db.StringProperty(required=True)
    timestamp = db.DateTimeProperty(auto_now_add=True)
    message = db.TextProperty(required=True)

    def __str__(self):
        return "%s (%s): %s" % (self.user, self.timestamp, self.message)
#END: ChatMessage


class ChatRoomPage(webapp.RequestHandler):
    def get(self):
        self.response.headers['Content-Type'] = 'text/html; charset=UTF-8'
        self.response.out.write(u"""
           <html>
             <head>
               <title>Pokój czatu MarkCC w App Engine</title>
             </head>
             <body>
               <h1>Witaj w pokoju czatu MarkCC w App Engine</h1>
               <p>(Dokladny czas Twojego logowania: %s)</p>
           """ % (datetime.datetime.now()))
#START: MessageLoop
        # Zwraca wszystkie zapisane wiadomości
        messages = db.GqlQuery("SELECT * From ChatMessage ORDER BY timestamp")
        for msg in messages:
            self.response.out.write("<p>%s</p>" % msg)
#END: MessageLoop
        self.response.out.write(u"""
           <form action="/talk" method="post"> 
          <div><b>Twój nick:</b> 
           <textarea name="name" rows="1" cols="20"></textarea></div>
           <p><b>Twoja wiadomość</b></p>
           <div><textarea name="message" rows="5" cols="60"></textarea></div>
           <div><input type="submit" value="Wyślij wiadomość"/></div>
           </form>
         </body>
       </html>
       """)
# END: MainPage    

class TmpChatRoomCountViewPage(webapp.RequestHandler):
    def get(self):
        self.response.headers['Content-Type'] = 'text/html; charset=UTF-8'
        self.response.out.write(u"""
           <html>
             <head>
               <title>Pokój czatu MarkCC w App Engine</title>
             </head>
             <body>
               <h1>Witaj w pokoju czatu MarkCC w App Engine</h1>
               <p>(Dokładny czas Twojego logowania: %s; Oglądasz 20 ostatnich wpisów.)</p>
           """ % (datetime.datetime.now()))
#START: MessageLoopLimited
        # Zwraca dwadzieścia zapisanych wiadomości
        messages = db.GqlQuery("SELECT * From ChatMessage ORDER BY " +
                               "timestamp DESC LIMIT 20").fetch()
        for msg in reversed(messages):
            self.response.out.write("<p>%s</p>" % msg)
#END: MessageLoopLimited
        self.response.out.write(u"""
           <form action="/talk" method="post"> 
          <div><b>Twój nick:</b> 
           <textarea name="name" rows="1" cols="20"></textarea></div>
           <p><b>Twoja wiadomość</b></p>
           <div><textarea name="message" rows="5" cols="60"></textarea></div>
           <div><input type="submit" value="Wyślij wiadomość"/></div>
           </form>
         </body>
       </html>
       """)

#START: CountPage
class ChatRoomCountViewPage(webapp.RequestHandler):
    def get(self):
        self.response.headers['Content-Type'] = 'text/html; charset=UTF-8'
        self.response.out.write(u"""
           <html>
             <head>
               <title>Pokój czatu MarkCC w App Engine (ostatnie 20 wpisów)</title>
             </head>
             <body>
               <h1>Witaj w pokoju czatu MarkCC w App Engine</h1>
               <p>(Dokładny czas Twojego logowania: %s; Oglądasz 20 ostatnich wpisów.)</p>
           """ % (datetime.datetime.now()))
        # Zwraca dwadzieścia zapisanych wiadomości
        messages = db.GqlQuery("SELECT * From ChatMessage " +#<callout id="co.limit-query"/>
				"ORDER BY timestamp DESC LIMIT 20").fetch(20)
        messages.reverse()#<callout id="co.limit-reverse"/>
        for msg in list(messages):
            self.response.out.write("<p>%s</p>" % msg)
        self.response.out.write(u"""
           <form action="/talk" method="post"> 
          <div><b>Twój nick:</b> 
           <textarea name="name" rows="1" cols="20"></textarea></div>
           <p><b>Twoja wiadomość</b></p>
           <div><textarea name="message" rows="5" cols="60"></textarea></div>
           <div><input type="submit" value="Wyślij wiadomość"/></div>
           </form>
         </body>
       </html>
       """)
#END: CountPage

class ChatRoomTimeViewPage(webapp.RequestHandler):
    def get(self):
        self.response.headers['Content-Type'] = 'text/html; charset=UTF-8'
        self.response.out.write(u"""
           <html>
           <head><title>Pokój czatu MarkCC w App Engine (wiadomości z ostatnich 5-ciu minut)</title>
           </head>
           <body><h1>Witaj w pokoju czatu MarkCC w App Engine</h1>
           <p>(Czas: %s; oglądasz wiadomości zapisane w ciągu ostatnich 5-ciu minut.)</p>
           """ % (datetime.datetime.now()))
        # Zwraca wpisy z sotatnich 5-ciu minut
        messages = ChatMessage.gql("WHERE timestamp > :fiveago ORDER BY time", 
                                  fiveago=datetime.now() - timedelta(minutes=5))
        for msg in messages:
            self.response.out.write("<p>%s</p>" % msg)
        self.response.out.write("""
          <form action="/talk" method="post"> 
          <div><b>Twój nick:</b> 
           <textarea name="name" rows="1" cols="20"></textarea></div>
           <p><b>Twoja wiadomość</b></p>
           <div><textarea name="message" rows="5" cols="60"></textarea></div>
           <div><input type="submit" value="Wyślij wiadomość"/></div>
          </form>
         </body>
       </html>""")




# START: PostHandler
class ChatRoomPoster(webapp.RequestHandler):
    def post(self):
        chatter = self.request.get("name")
        msgtext = self.request.get("message")
        msg = ChatMessage(user=chatter, message=msgtext)
        msg.put() #<callout id="co.put"/>
        # Po dodaniu wiadomości do czatu, przekierujemy go
        # na naszą stronę główną,
        self.redirect('/')        
# END: PostHandler




# START: Frame
chatapp = webapp.WSGIApplication([('/', ChatRoomPage),
                                  ('/talk', ChatRoomPoster),
                                  ('/limited/count', ChatRoomCountViewPage),
                                  ('/limited/time', ChatRoomTimeViewPage)])
# END: Frame
def main():
    run_wsgi_app(chatapp)

if __name__ == "__main__":
    main()



