﻿# -*- coding: utf-8 -*-
from google.appengine.ext import webapp
from google.appengine.ext.webapp.util import run_wsgi_app
import datetime


# START: MainPage
class ChatMessage(object):
    def __init__(self, user, msg):
        self.user = user
        self.message = msg
        self.time = datetime.datetime.now()

    def __str__(self):
        return "%s (%s): %s" % (self.user, self.time, self.message)
	def __unicode__(self):
		return "%s (%s): %s" % (self.user, self.time, self.message)
		

Messages = []
class ChatRoomPage(webapp.RequestHandler):
    def get(self):
        self.response.headers['Content-Type'] = "text/html; charset=UTF-8"
        self.response.out.write("""
           <html>
             <head>
               <title>Witaj w pokoju czatu MarkCC w App Engine</title>
			   <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
             </head>
             <body>
               <h1>Witaj w pokoju czatu MarkCC w App Engine</h1>
               <p>(Dokladny czas Twojego logowania to: %s)</p>
           """ % (datetime.datetime.now()))
        # Zwraca wszystkie zapisane wiadomości
        global Messages
        for msg in Messages:
            self.response.out.write("<p>%s</p>" % msg)
        self.response.out.write("""
           <form action="" method="post">
           <div><b>Twój Nick:</b> 
           <textarea name="name" rows="1" cols="20"></textarea></div>
           <p><b>Twoja Wiadomość</b></p>
           <div><textarea name="message" rows="5" cols="60"></textarea></div>
           <div><input type="submit" value="Wyślij wiadomość"></input></div>
           </form>
         </body>
       </html>
       """)
# END: MainPage    
# START: PostHandler
    def post(self):
        chatter = self.request.get("name")
        msg = self.request.get("message")
        global Messages
        Messages.append(ChatMessage(chatter.encode( "utf-8" ), msg.encode( "utf-8" )))
        #Po tym jak dodaliśmy naszą wiadomość do czatu, przekierujmy naszą aplikację na jej 
		#własny adres, aby ją odświeżyć,co spowoduje wyświetlenie nowej wiadomości. 
        self.redirect('/')        
# END: PostHandler




# START: Frame
chatapp = webapp.WSGIApplication([('/', ChatRoomPage)])


def main():
    run_wsgi_app(chatapp)

if __name__ == "__main__":
    main()
# END: Frame


