/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.jdbc.internal;

import com.google.cloud.sql.jdbc.internal.Url;
import com.google.cloud.sql.jdbc.internal.Util;
import com.google.protos.cloud.sql.ExecRequest;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public final class SqlRpcOptions
implements Cloneable {
    private Long queryTimeOutMillis;
    private Long connectTimeOutMillis;
    private Long retryIntervalMillis;
    private boolean includeExportedKeys;
    private int[] generatedColumnIndices;
    private String[] generatedColumnNames;
    private int fetchSize;
    private int resultSetType = 1003;
    private int resultSetConcurrency = 1007;
    private int resultSetHoldability = 2;
    private ExecRequest.StatementType statementType = ExecRequest.StatementType.STATEMENT;
    private boolean poolable;
    private int fetchDirection = 1000;
    private String cursorName;
    private int maxFieldSize;
    private int maxRows;
    private boolean escapeProcessing;
    public static final long DEFAULT_QUERY_TIMEOUT_MILLIS = TimeUnit.DAYS.toMillis(1L);
    public static final long DEFAULT_CONNECT_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(30L);
    public static final long DEFAULT_RETRY_INTERVAL_MILLIS = TimeUnit.SECONDS.toMillis(30L);

    private SqlRpcOptions() {
    }

    public final SqlRpcOptions setQueryTimeOutMillis(long millis) {
        this.queryTimeOutMillis = millis;
        return this;
    }

    public long getQueryTimeOutMillis() {
        return this.queryTimeOutMillis != null ? this.queryTimeOutMillis : DEFAULT_QUERY_TIMEOUT_MILLIS;
    }

    public void clearQueryTimeOutMillis() {
        this.queryTimeOutMillis = null;
    }

    public final SqlRpcOptions setConnectTimeOutMillis(long millis) {
        this.connectTimeOutMillis = millis;
        return this;
    }

    public long getConnectTimeOutMillis() {
        return this.connectTimeOutMillis != null ? this.connectTimeOutMillis : DEFAULT_CONNECT_TIMEOUT_MILLIS;
    }

    public void clearConnectTimeOutMillis() {
        this.connectTimeOutMillis = null;
    }

    public final SqlRpcOptions setRetryIntervalMillis(long millis) {
        this.retryIntervalMillis = millis;
        return this;
    }

    public long getRetryIntervalMillis() {
        return this.retryIntervalMillis != null ? this.retryIntervalMillis : DEFAULT_RETRY_INTERVAL_MILLIS;
    }

    public void clearRetryIntervalTimeOutMillis() {
        this.retryIntervalMillis = null;
    }

    public SqlRpcOptions setIncludeExportedKeys(boolean includeExportedKeys) {
        this.includeExportedKeys = includeExportedKeys;
        return this;
    }

    public boolean getIncludeExportedKeys() {
        return this.includeExportedKeys;
    }

    public SqlRpcOptions setGeneratedColumnIndices(int ... generatedColumnIndices) {
        this.generatedColumnIndices = generatedColumnIndices;
        return this;
    }

    public int[] getGeneratedColumnIndices() {
        return this.generatedColumnIndices;
    }

    public SqlRpcOptions setGeneratedColumnNames(String ... generatedColumnNames) {
        this.generatedColumnNames = generatedColumnNames;
        return this;
    }

    public String[] getGeneratedColumnNames() {
        return this.generatedColumnNames;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public SqlRpcOptions setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        return this;
    }

    public int getResultSetType() {
        return this.resultSetType;
    }

    public SqlRpcOptions setResultSetType(int resultSetType) {
        this.resultSetType = resultSetType;
        return this;
    }

    public int getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    public SqlRpcOptions setResultSetConcurrency(int resultSetConcurrency) {
        this.resultSetConcurrency = resultSetConcurrency;
        return this;
    }

    public int getResultSetHoldability() {
        return this.resultSetHoldability;
    }

    public SqlRpcOptions setResultSetHoldability(int resultSetHoldability) {
        this.resultSetHoldability = resultSetHoldability;
        return this;
    }

    public ExecRequest.StatementType getStatementType() {
        return this.statementType;
    }

    public SqlRpcOptions setStatementType(ExecRequest.StatementType statementType) {
        Util.checkNotNull(statementType, "statement type cannot be null");
        this.statementType = statementType;
        return this;
    }

    public SqlRpcOptions setPoolable(boolean poolable) {
        this.poolable = poolable;
        return this;
    }

    public boolean isPoolable() {
        return this.poolable;
    }

    public SqlRpcOptions setFetchDirection(int fetchDirection) {
        this.fetchDirection = fetchDirection;
        return this;
    }

    public SqlRpcOptions setCursorName(String cursorName) {
        this.cursorName = cursorName;
        return this;
    }

    public String getCursorName() {
        return this.cursorName;
    }

    public SqlRpcOptions setMaxFieldSize(int maxFieldSize) {
        this.maxFieldSize = maxFieldSize;
        return this;
    }

    public int getMaxFieldSize() {
        return this.maxFieldSize;
    }

    public SqlRpcOptions setMaxRows(int maxRows) {
        this.maxRows = maxRows;
        return this;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public int getFetchDirection() {
        return this.fetchDirection;
    }

    public SqlRpcOptions setEscapeProcessing(boolean escapeProcessing) {
        this.escapeProcessing = escapeProcessing;
        return this;
    }

    public boolean getEscapeProcessing() {
        return this.escapeProcessing;
    }

    public static SqlRpcOptions defaultOptions() {
        return new SqlRpcOptions();
    }

    public static SqlRpcOptions defaultOptions(Url url) {
        Integer queryTimeoutSeconds;
        SqlRpcOptions options = SqlRpcOptions.defaultOptions();
        Integer connectTimeOutSeconds = url.getConnectTimeoutSeconds();
        if (connectTimeOutSeconds != null) {
            options.setConnectTimeOutMillis(TimeUnit.SECONDS.toMillis(connectTimeOutSeconds.intValue()));
        }
        if ((queryTimeoutSeconds = url.getQueryTimeoutSeconds()) != null) {
            options.setQueryTimeOutMillis(TimeUnit.SECONDS.toMillis(queryTimeoutSeconds.intValue()));
        }
        return options;
    }

    public int hashCode() {
        return SqlRpcOptions.hashCode(this.queryTimeOutMillis, this.connectTimeOutMillis, this.retryIntervalMillis, this.includeExportedKeys, this.generatedColumnIndices, this.generatedColumnNames, this.fetchSize, this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability, this.poolable, this.statementType, this.fetchDirection, this.cursorName, this.maxFieldSize, this.maxRows, this.escapeProcessing);
    }

    private static int hashCode(Object ... objects) {
        return Arrays.hashCode(objects);
    }

    public SqlRpcOptions clone() {
        try {
            return (SqlRpcOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)"Not Possible.");
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SqlRpcOptions)) {
            return false;
        }
        SqlRpcOptions that = (SqlRpcOptions)o;
        return Util.equal(this.queryTimeOutMillis, that.queryTimeOutMillis) && Util.equal(this.connectTimeOutMillis, that.connectTimeOutMillis) && Util.equal(this.retryIntervalMillis, that.retryIntervalMillis) && this.includeExportedKeys == that.includeExportedKeys && Arrays.equals(this.generatedColumnIndices, that.generatedColumnIndices) && Arrays.equals(this.generatedColumnNames, that.generatedColumnNames) && this.fetchSize == that.fetchSize && this.resultSetType == that.resultSetType && this.resultSetConcurrency == that.resultSetConcurrency && this.resultSetHoldability == that.resultSetHoldability && this.statementType == that.statementType && this.poolable == that.poolable && this.fetchDirection == that.fetchDirection && Util.equal(this.cursorName, that.cursorName) && this.maxFieldSize == that.maxFieldSize && this.maxRows == that.maxRows && this.escapeProcessing == that.escapeProcessing;
    }

    public String toString() {
        return "SqlRpcOptions " + "{queryTimeOutMillis = " + this.queryTimeOutMillis + "}" + "{connectTimeOutMillis = " + this.connectTimeOutMillis + "}" + "{retryIntervalMillis = " + this.retryIntervalMillis + "}" + "{includeExportedKeys = " + this.includeExportedKeys + "}" + "{generatedColumnIndices = " + Arrays.toString(this.generatedColumnIndices) + "}" + "{generatedColumnNames = " + Arrays.toString(this.generatedColumnNames) + "}" + "{fetchSize = " + this.fetchSize + "}" + "{resultSetType = " + this.resultSetType + "}" + "{resultSetConcurrency = " + this.resultSetConcurrency + "}" + "{resultSetHoldability = " + this.resultSetHoldability + "}" + "{poolable = " + this.poolable + "}" + "{fetchDirection = " + this.fetchDirection + "}" + "{cursorName = " + this.cursorName + "}" + "{maxFieldSize = " + this.maxFieldSize + "}" + "{maxRows = " + this.maxRows + "}" + "{escapeProcessing = " + this.escapeProcessing + "}";
    }
}

