/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import com.google.appengine.repackaged.com.google.common.base.AtomicTracerStatMap;
import com.google.appengine.repackaged.com.google.common.base.Join;
import com.google.appengine.repackaged.com.google.common.base.TracingStatistic;
import com.google.appengine.repackaged.com.google.common.base.X;
import com.google.common.annotations.GoogleInternal;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GoogleInternal
public final class Tracer {
    static final Logger logger = Logger.getLogger(Tracer.class.getName());
    private static volatile boolean defaultPrettyPrint;
    private static List<TracingStatistic> extraTracingStatistics;
    private long[] extraTracingValues;
    private final String type;
    private final String comment;
    private final long startTimeMs;
    private long stopTimeMs;
    final Thread startThread;
    static final int MAX_TRACE_SIZE = 1000;
    static InternalClock clock;
    private static AtomicTracerStatMap typeToCountMap;
    private static AtomicTracerStatMap typeToSilentMap;
    private static AtomicTracerStatMap typeToTimeMap;
    private static final Stat ZERO_STAT;
    private static ThreadLocal<ThreadTrace> traces;

    public Tracer(@Nullable String type, @Nullable String comment) {
        ThreadTrace trace;
        this.type = type;
        this.comment = comment == null ? "" : comment;
        this.startTimeMs = clock.currentTimeMillis();
        this.startThread = Thread.currentThread();
        if (!extraTracingStatistics.isEmpty()) {
            int size = extraTracingStatistics.size();
            this.extraTracingValues = new long[size];
            int i = 0;
            for (TracingStatistic tracingStatistic : extraTracingStatistics) {
                this.extraTracingValues[i] = tracingStatistic.start(this.startThread);
                ++i;
            }
        }
        if (!(trace = Tracer.getThreadTrace()).isInitialized()) {
            return;
        }
        if (trace.events.size() >= 1000) {
            logger.log(Level.WARNING, "Giant thread trace. Too many Tracers created. Clearing to avoid memory leak.", new Throwable(trace.toString()));
            trace.truncateEvents();
        }
        if (trace.outstandingEvents.size() >= 1000) {
            logger.log(Level.WARNING, "Too many outstanding Tracers. Tracer.stop() is missing or Tracer.stop() is not wrapped in a try/finally block. Clearing to avoid memory leak.", new Throwable(trace.toString()));
            trace.truncateOutstandingEvents();
        }
        trace.startEvent(this);
    }

    public Tracer(@Nullable String comment) {
        this(null, comment);
    }

    public static Tracer shortName(@Nullable Object object, @Nullable String comment) {
        if (object == null) {
            return new Tracer(comment);
        }
        return new Tracer(object.getClass().getSimpleName(), comment);
    }

    private static String longToPaddedString(long v, int digits_column_width) {
        int digit_width = Tracer.numDigits(v);
        StringBuilder sb = new StringBuilder();
        Tracer.appendSpaces(sb, digits_column_width - digit_width);
        sb.append(v);
        return sb.toString();
    }

    private static int numDigits(long n) {
        int i = 0;
        do {
            ++i;
        } while ((n /= 10L) > 0L);
        return i;
    }

    @VisibleForTesting
    static void appendSpaces(StringBuilder sb, int numSpaces) {
        if (numSpaces > 16) {
            logger.warning("Tracer.appendSpaces called with large numSpaces");
            numSpaces = 16;
        }
        while (numSpaces >= 5) {
            sb.append("     ");
            numSpaces -= 5;
        }
        switch (numSpaces) {
            case 1: {
                sb.append(" ");
                break;
            }
            case 2: {
                sb.append("  ");
                break;
            }
            case 3: {
                sb.append("   ");
                break;
            }
            case 4: {
                sb.append("    ");
            }
        }
    }

    public static int addTracingStatistic(TracingStatistic tracingStatistic) {
        if (tracingStatistic.enable()) {
            extraTracingStatistics.add(tracingStatistic);
            return extraTracingStatistics.lastIndexOf(tracingStatistic);
        }
        return -1;
    }

    @VisibleForTesting
    static void clearTracingStatisticsTestingOnly() {
        extraTracingStatistics.clear();
    }

    public long stop(int silence_threshold) {
        X.assertTrue(Thread.currentThread() == this.startThread);
        ThreadTrace trace = Tracer.getThreadTrace();
        if (!trace.isInitialized()) {
            return 0L;
        }
        this.stopTimeMs = clock.currentTimeMillis();
        if (this.extraTracingValues != null) {
            for (int i = 0; i < this.extraTracingValues.length; ++i) {
                long value = extraTracingStatistics.get(i).stop(this.startThread);
                this.extraTracingValues[i] = value - this.extraTracingValues[i];
            }
        }
        if (!trace.isInitialized()) {
            return 0L;
        }
        trace.endEvent(this, silence_threshold);
        return this.stopTimeMs - this.startTimeMs;
    }

    public long stop() {
        return this.stop(-1);
    }

    public String toString() {
        if (this.type == null) {
            return this.comment;
        }
        return "[" + this.type + "] " + this.comment;
    }

    public static void setDefaultSilenceThreshold(int threshold) {
        Tracer.getThreadTrace().defaultSilenceThreshold = threshold;
    }

    public static void initCurrentThreadTrace() {
        ThreadTrace events = Tracer.getThreadTrace();
        if (!events.isEmpty()) {
            logger.log(Level.WARNING, "Non-empty timer log:\n" + events, new Throwable());
            Tracer.clearThreadTrace();
            events = Tracer.getThreadTrace();
        }
        events.init();
    }

    public static void initCurrentThreadTrace(int default_silence_threshold) {
        Tracer.initCurrentThreadTrace();
        Tracer.setDefaultSilenceThreshold(default_silence_threshold);
    }

    public static String getCurrentThreadTraceReport() {
        return Tracer.getThreadTrace().toString();
    }

    public static void logCurrentThreadTrace() {
        ThreadTrace trace = Tracer.getThreadTrace();
        if (!trace.isInitialized()) {
            logger.log(Level.WARNING, "Tracer log requested for this thread but was not initialized using Tracer.initCurrentThreadTrace().", new Throwable());
            return;
        }
        if (!trace.isEmpty()) {
            logger.log(Level.INFO, "timers:\n{0}", Tracer.getCurrentThreadTraceReport());
        }
    }

    public static void clearCurrentThreadTrace() {
        Tracer.clearThreadTrace();
    }

    public static void logAndClearCurrentThreadTrace() {
        Tracer.logCurrentThreadTrace();
        Tracer.clearThreadTrace();
    }

    public static void setPrettyPrint(boolean enabled) {
        defaultPrettyPrint = enabled;
    }

    public static synchronized void enableTypeMaps() {
        if (typeToCountMap == null) {
            typeToCountMap = new AtomicTracerStatMap();
            typeToSilentMap = new AtomicTracerStatMap();
            typeToTimeMap = new AtomicTracerStatMap();
        }
    }

    public static Map<String, Long> getTypeToCountMap() {
        return typeToCountMap != null ? typeToCountMap.getMap() : null;
    }

    public static Map<String, Long> getTypeToSilentMap() {
        return typeToSilentMap != null ? typeToSilentMap.getMap() : null;
    }

    public static Map<String, Long> getTypeToTimeMap() {
        return typeToTimeMap != null ? typeToTimeMap.getMap() : null;
    }

    public static Stat getStatsForType(String type) {
        Stat stat = Tracer.getThreadTrace().stats.get(type);
        return stat != null ? stat : ZERO_STAT;
    }

    private static String formatTime(long time) {
        int sec = (int)(time / 1000L % 60L);
        int ms = (int)(time % 1000L);
        return String.format("%02d.%03d", sec, ms);
    }

    static ThreadTrace getThreadTrace() {
        ThreadTrace t = traces.get();
        if (t == null) {
            t = new ThreadTrace();
            t.prettyPrint = defaultPrettyPrint;
            traces.set(t);
        }
        return t;
    }

    static void clearThreadTrace() {
        traces.set(null);
    }

    static {
        extraTracingStatistics = new CopyOnWriteArrayList<TracingStatistic>();
        clock = new InternalClock(){

            public long currentTimeMillis() {
                return System.currentTimeMillis();
            }
        };
        ZERO_STAT = new Stat();
        traces = new ThreadLocal();
    }

    static final class ThreadTrace {
        int defaultSilenceThreshold;
        final ArrayList<Event> events = new ArrayList();
        final HashSet<Tracer> outstandingEvents = new HashSet();
        final Map<String, Stat> stats = new HashMap<String, Stat>();
        boolean isOutstandingEventsTruncated = false;
        boolean isEventsTruncated = false;
        boolean isInitialized = false;
        boolean prettyPrint = false;

        ThreadTrace() {
        }

        void init() {
            this.isInitialized = true;
        }

        boolean isInitialized() {
            return this.isInitialized;
        }

        void startEvent(Tracer t) {
            this.events.add(new Event(true, t));
            boolean notAlreadyOutstanding = this.outstandingEvents.add(t);
            X.assertTrue(notAlreadyOutstanding);
        }

        void endEvent(Tracer t, int silenceThreshold) {
            boolean wasOutstanding = this.outstandingEvents.remove(t);
            if (!wasOutstanding) {
                if (this.isOutstandingEventsTruncated) {
                    logger.log(Level.WARNING, "event not found, probably because the event stack overflowed and was truncated", new Throwable());
                } else {
                    X.assertTrue(false);
                }
            }
            long elapsed = t.stopTimeMs - t.startTimeMs;
            if (silenceThreshold == -1) {
                silenceThreshold = this.defaultSilenceThreshold;
            }
            if (elapsed < (long)silenceThreshold) {
                boolean removed = false;
                for (int i = 0; i < this.events.size(); ++i) {
                    Event e = this.events.get(i);
                    if (e.tracer != t) continue;
                    X.assertTrue(e.isStart);
                    this.events.remove(i);
                    removed = true;
                    break;
                }
                X.assertTrue(removed || this.isEventsTruncated);
            } else {
                this.events.add(new Event(false, t));
            }
            if (t.type != null) {
                Stat stat = this.stats.get(t.type);
                if (stat == null) {
                    stat = new Stat();
                    if (!extraTracingStatistics.isEmpty()) {
                        Stat.access$702(stat, new int[extraTracingStatistics.size()]);
                    }
                    this.stats.put(t.type, stat);
                }
                stat.count++;
                if (typeToCountMap != null) {
                    typeToCountMap.incrementBy(t.type, 1L);
                }
                stat.clockTime = (int)((long)stat.clockTime + elapsed);
                if (typeToTimeMap != null) {
                    typeToTimeMap.incrementBy(t.type, elapsed);
                }
                if (stat.extraInfo != null && t.extraTracingValues != null) {
                    int overlapLength = Math.min(stat.extraInfo.length, t.extraTracingValues.length);
                    for (int i = 0; i < overlapLength; ++i) {
                        int[] nArray = stat.extraInfo;
                        int n = i;
                        nArray[n] = (int)((long)nArray[n] + t.extraTracingValues[i]);
                        AtomicTracerStatMap map = ((TracingStatistic)extraTracingStatistics.get(i)).getTracingStat();
                        if (map == null) continue;
                        map.incrementBy(t.type, t.extraTracingValues[i]);
                    }
                }
                if (elapsed < (long)silenceThreshold) {
                    stat.silent++;
                    if (typeToSilentMap != null) {
                        typeToSilentMap.incrementBy(t.type, 1L);
                    }
                }
            }
        }

        boolean isEmpty() {
            return this.events.size() == 0 && this.outstandingEvents.size() == 0;
        }

        void truncateOutstandingEvents() {
            this.isOutstandingEventsTruncated = true;
            this.outstandingEvents.clear();
        }

        void truncateEvents() {
            this.isEventsTruncated = true;
            this.events.clear();
        }

        public String toString() {
            int numDigits = this.getMaxDigits();
            StringBuilder sb = new StringBuilder();
            long etime = -1L;
            LinkedList<String> indent = this.prettyPrint ? new LinkedList<String>() : null;
            for (Event e : this.events) {
                if (this.prettyPrint && !e.isStart && !indent.isEmpty()) {
                    indent.pop();
                }
                sb.append(" ");
                if (this.prettyPrint) {
                    sb.append(e.toString(etime, Join.join("", indent), numDigits));
                } else {
                    sb.append(e.toString(etime, "", 4));
                }
                etime = e.eventTime();
                sb.append('\n');
                if (!this.prettyPrint || !e.isStart) continue;
                indent.push("|  ");
            }
            if (this.outstandingEvents.size() != 0) {
                long now = clock.currentTimeMillis();
                sb.append(" Unstopped timers:\n");
                for (Tracer t : this.outstandingEvents) {
                    sb.append("  ").append(t).append(" (").append(now - t.startTimeMs).append(" ms, started at ").append(Tracer.formatTime(t.startTimeMs)).append(")\n");
                }
            }
            for (String key : this.stats.keySet()) {
                Stat stat = this.stats.get(key);
                if (stat.count <= 1) continue;
                sb.append(" TOTAL ").append(key).append(" ").append(stat.count).append(" (").append(stat.clockTime).append(" ms");
                if (stat.extraInfo != null) {
                    for (int i = 0; i < stat.extraInfo.length; ++i) {
                        sb.append("; ");
                        sb.append(stat.extraInfo[i]).append(' ').append(((TracingStatistic)extraTracingStatistics.get(i)).getUnits());
                    }
                }
                sb.append(")\n");
            }
            return sb.toString();
        }

        private int getMaxDigits() {
            long etime = -1L;
            long max_time = 0L;
            for (Event e : this.events) {
                long time;
                if (etime != -1L) {
                    time = e.eventTime() - etime;
                    max_time = Math.max(max_time, time);
                }
                if (!e.isStart) {
                    time = e.tracer.stopTimeMs - e.tracer.startTimeMs;
                    max_time = Math.max(max_time, time);
                }
                etime = e.eventTime();
            }
            return Math.max(3, Tracer.numDigits(max_time));
        }
    }

    private static final class Event {
        boolean isStart;
        Tracer tracer;

        Event(boolean start, Tracer t) {
            this.isStart = start;
            this.tracer = t;
        }

        long eventTime() {
            return this.isStart ? this.tracer.startTimeMs : this.tracer.stopTimeMs;
        }

        String toString(long prevEventTime, String indent, int digitsColWidth) {
            StringBuilder sb = new StringBuilder(120);
            if (prevEventTime == -1L) {
                Tracer.appendSpaces(sb, digitsColWidth);
            } else {
                sb.append(Tracer.longToPaddedString(this.eventTime() - prevEventTime, digitsColWidth));
            }
            sb.append(' ');
            sb.append(Tracer.formatTime(this.eventTime()));
            if (this.isStart) {
                sb.append(" Start ");
                Tracer.appendSpaces(sb, digitsColWidth);
                sb.append("   ");
            } else {
                sb.append(" Done ");
                long delta = this.tracer.stopTimeMs - this.tracer.startTimeMs;
                sb.append(Tracer.longToPaddedString(delta, digitsColWidth));
                sb.append(" ms ");
                if (this.tracer.extraTracingValues != null) {
                    for (int i = 0; i < this.tracer.extraTracingValues.length; ++i) {
                        delta = this.tracer.extraTracingValues[i];
                        sb.append(String.format("%4d", delta));
                        sb.append(((TracingStatistic)extraTracingStatistics.get(i)).getUnits());
                        sb.append(";  ");
                    }
                }
            }
            sb.append(indent);
            sb.append(this.tracer.toString());
            return sb.toString();
        }
    }

    public static final class Stat {
        private int count;
        private int silent;
        private int clockTime;
        private int[] extraInfo;

        public int getCount() {
            return this.count;
        }

        public int getSilentCount() {
            return this.silent;
        }

        public int getTotalTime() {
            return this.clockTime;
        }

        @VisibleForTesting
        public int getExtraInfo(int index) {
            return index >= this.extraInfo.length ? 0 : this.extraInfo[index];
        }

        static /* synthetic */ int[] access$702(Stat x0, int[] x1) {
            x0.extraInfo = x1;
            return x1;
        }
    }

    static interface InternalClock {
        public long currentTimeMillis();
    }
}

