/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.labs.taskqueue;

import com.google.appengine.api.labs.taskqueue.Queue;
import com.google.appengine.api.labs.taskqueue.QueueApiHelper;
import com.google.appengine.api.labs.taskqueue.QueueConstants;
import com.google.appengine.api.labs.taskqueue.TaskHandle;
import com.google.appengine.api.labs.taskqueue.TaskOptions;
import com.google.appengine.api.labs.taskqueue.TaskQueuePb;
import com.google.appengine.api.labs.taskqueue.Transaction;
import com.google.appengine.api.labs.taskqueue.UnsupportedTranslationException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class QueueImpl
implements Queue {
    private final String queueName;
    final QueueApiHelper apiHelper;

    QueueImpl(String queueName, QueueApiHelper apiHelper) {
        if (queueName == null || queueName.length() == 0 || !QueueConstants.QUEUE_NAME_PATTERN.matcher(queueName).matches()) {
            throw new IllegalArgumentException("Queue name does not match expression " + QueueConstants.QUEUE_NAME_REGEX + "; found '" + queueName + "'");
        }
        this.apiHelper = apiHelper;
        this.queueName = queueName;
    }

    @Override
    public TaskHandle add() {
        return this.add(null, TaskOptions.Builder.withDefaults());
    }

    private URI parsePartialUrl(String urlString) {
        URI uri;
        if (urlString == null) {
            throw new IllegalArgumentException("url must not be null");
        }
        if (urlString.length() > QueueConstants.maxUrlLength()) {
            throw new IllegalArgumentException("url is longer than " + Integer.valueOf(QueueConstants.maxUrlLength()).toString() + ".");
        }
        try {
            uri = new URI(urlString);
        }
        catch (URISyntaxException exception) {
            throw new IllegalArgumentException("URL syntax error", exception);
        }
        this.uriCheckNull(uri.getScheme(), "scheme");
        this.uriCheckNull(uri.getRawAuthority(), "authority");
        this.uriCheckNull(uri.getRawFragment(), "fragment");
        String path = uri.getPath();
        if (path == null || path.length() == 0 || path.charAt(0) != '/') {
            if (path == null) {
                path = "(null)";
            } else if (path.length() == 0) {
                path = "<empty string>";
            }
            throw new IllegalArgumentException("url must contain a path starting with '/' part - contains :" + path);
        }
        return uri;
    }

    private void uriCheckNull(String value, String valueName) {
        if (value != null) {
            throw new IllegalArgumentException("url must not contain a '" + valueName + "' part - contains :" + value);
        }
    }

    private TaskQueuePb.TaskQueueAddRequest createAddRequest(com.google.appengine.api.datastore.Transaction txn, TaskOptions taskOptions) {
        String taskName = taskOptions.getTaskName();
        boolean useUrlEncodedContentType = false;
        if (taskName != null && txn != null) {
            throw new IllegalArgumentException("transactional tasks cannot be named: " + taskOptions);
        }
        HashMap<String, List<String>> headers = taskOptions.getHeaders();
        String url = taskOptions.getUrl();
        if (url == null) {
            url = this.defaultUrl();
        }
        URI parsedUrl = this.parsePartialUrl(url);
        String query = parsedUrl.getQuery();
        byte[] payload = taskOptions.getPayload();
        List<TaskOptions.Param> params = taskOptions.getParams();
        StringBuilder relativeUrl = new StringBuilder(parsedUrl.getRawPath());
        if (query != null && query.length() != 0 && !params.isEmpty()) {
            throw new IllegalArgumentException("Query string and parameters both present; only one of these may be supplied");
        }
        if (taskOptions.getMethod() == TaskOptions.Method.POST) {
            if (!params.isEmpty() && payload != null) {
                throw new IllegalArgumentException("Message body and parameters both present for POST method; only one of these may be supplied");
            }
            if (query != null && query.length() != 0) {
                throw new IllegalArgumentException("POST method may not have a query string; use the setParamater(s) instead");
            }
            if (!params.isEmpty() || payload == null) {
                payload = this.encodeParamsPost(params);
                useUrlEncodedContentType = true;
            }
        } else {
            if (!params.isEmpty()) {
                query = this.encodeParamsUrlEncoded(params);
            }
            if (query != null && query.length() != 0) {
                relativeUrl.append("?").append(query);
            }
        }
        if (payload != null && payload.length != 0 && !taskOptions.getMethod().supportsBody()) {
            throw new IllegalArgumentException(taskOptions.getMethod().toString() + " method may not specify a payload.");
        }
        TaskQueuePb.TaskQueueAddRequest addRequest = new TaskQueuePb.TaskQueueAddRequest();
        long etaMillis = this.determineEta(taskOptions);
        addRequest.setQueueName(this.queueName);
        addRequest.setEtaUsec(etaMillis * 1000L);
        addRequest.setMethod(taskOptions.getMethod().getPbMethod());
        addRequest.setTaskName(taskName == null ? "" : taskName);
        addRequest.setUrl(relativeUrl.toString());
        if (payload != null) {
            addRequest.setBodyAsBytes(payload);
        }
        if (txn != null) {
            addRequest.setTransaction(QueueImpl.localTxnToRemoteTxn(txn));
        }
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            if (useUrlEncodedContentType && entry.getKey().toLowerCase().equals("content-type")) continue;
            for (String value : entry.getValue()) {
                TaskQueuePb.TaskQueueAddRequest.Header header = addRequest.addHeader();
                header.setKey(entry.getKey());
                header.setValue(value);
            }
        }
        if (useUrlEncodedContentType) {
            TaskQueuePb.TaskQueueAddRequest.Header contentTypeHeader = addRequest.addHeader();
            contentTypeHeader.setKey("content-type");
            contentTypeHeader.setValue("application/x-www-form-urlencoded");
        }
        if (addRequest.toProtocolSink().position() > QueueConstants.maxTaskSizeBytes()) {
            throw new IllegalArgumentException("Task size too large");
        }
        return addRequest;
    }

    private static Transaction localTxnToRemoteTxn(com.google.appengine.api.datastore.Transaction local) {
        Transaction remote = new Transaction();
        remote.setHandle(Long.parseLong(local.getId()));
        return remote;
    }

    @Override
    public TaskHandle add(TaskOptions taskOptions) {
        return this.add(null, taskOptions);
    }

    @Override
    public TaskHandle add(com.google.appengine.api.datastore.Transaction txn, TaskOptions taskOptions) {
        TaskQueuePb.TaskQueueAddRequest addRequest = this.createAddRequest(txn, taskOptions);
        TaskQueuePb.TaskQueueAddResponse addResponse = new TaskQueuePb.TaskQueueAddResponse();
        this.apiHelper.makeSyncCall("Add", addRequest, addResponse);
        String taskName = taskOptions.getTaskName();
        if (addResponse.hasChosenTaskName()) {
            taskName = addResponse.getChosenTaskName();
        }
        return new TaskHandle(taskName, this.queueName, addRequest.getEtaUsec() / 1000L);
    }

    long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    private long determineEta(TaskOptions taskOptions) {
        Long etaMillis = taskOptions.getEtaMillis();
        Long countdownMillis = taskOptions.getCountdownMillis();
        if (etaMillis == null) {
            if (countdownMillis == null) {
                return this.currentTimeMillis();
            }
            if (countdownMillis > QueueConstants.getMaxEtaDeltaMillis()) {
                throw new IllegalArgumentException("ETA too far into the future");
            }
            if (countdownMillis < 0L) {
                throw new IllegalArgumentException("Negative countdown is not allowed");
            }
            return this.currentTimeMillis() + countdownMillis;
        }
        if (countdownMillis == null) {
            if (etaMillis - this.currentTimeMillis() > QueueConstants.getMaxEtaDeltaMillis()) {
                throw new IllegalArgumentException("ETA too far into the future");
            }
            if (etaMillis < 0L) {
                throw new IllegalArgumentException("Negative ETA is invalid");
            }
            return etaMillis;
        }
        throw new IllegalArgumentException("Only one or neither of EtaMillis and CountdownMillis may be specified");
    }

    byte[] encodeParamsPost(List<TaskOptions.Param> params) {
        byte[] payload;
        try {
            payload = this.encodeParamsUrlEncoded(params).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException exception) {
            throw new UnsupportedTranslationException(exception);
        }
        return payload;
    }

    String encodeParamsUrlEncoded(List<TaskOptions.Param> params) {
        StringBuilder result = new StringBuilder();
        try {
            String appender = "";
            for (TaskOptions.Param param : params) {
                result.append(appender);
                appender = "&";
                result.append(param.getURLEncodedName());
                result.append("=");
                result.append(param.getURLEncodedValue());
            }
        }
        catch (UnsupportedEncodingException exception) {
            throw new UnsupportedTranslationException(exception);
        }
        return result.toString();
    }

    private String defaultUrl() {
        return "/_ah/queue/" + this.queueName;
    }

    @Override
    public String getQueueName() {
        return this.queueName;
    }
}

