/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.jdo;

import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.Set;
import javax.jdo.Extent;
import javax.jdo.FetchGroup;
import javax.jdo.FetchPlan;
import javax.jdo.JDOException;
import javax.jdo.ObjectState;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import javax.jdo.Transaction;
import javax.jdo.datastore.JDOConnection;
import javax.jdo.datastore.Sequence;
import javax.jdo.listener.InstanceLifecycleListener;
import org.datanucleus.jdo.JDOPersistenceManagerFactory;
import org.datanucleus.metadata.TransactionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDOPersistenceManagerProxy
implements PersistenceManager {
    protected JDOPersistenceManagerFactory pmf;

    public JDOPersistenceManagerProxy(JDOPersistenceManagerFactory pmf) {
        this.pmf = pmf;
    }

    protected PersistenceManager getPM() {
        return this.pmf.getPMProxyDelegate();
    }

    public void close() {
        String txnType = this.getPersistenceManagerFactory().getTransactionType();
        if (TransactionType.RESOURCE_LOCAL.toString().equalsIgnoreCase(txnType)) {
            this.getPM().close();
            this.pmf.clearPMProxyDelegate();
        } else if (TransactionType.JTA.toString().equalsIgnoreCase(txnType)) {
            // empty if block
        }
    }

    public void addInstanceLifecycleListener(InstanceLifecycleListener listener, Class ... classes) {
        this.getPM().addInstanceLifecycleListener(listener, classes);
    }

    public void checkConsistency() {
        this.getPM().checkConsistency();
    }

    public Transaction currentTransaction() {
        return this.getPM().currentTransaction();
    }

    public void deletePersistent(Object obj) {
        this.getPM().deletePersistent(obj);
    }

    public void deletePersistentAll(Object ... pcs) {
        this.getPM().deletePersistentAll(pcs);
    }

    public void deletePersistentAll(Collection pcs) {
        this.getPM().deletePersistentAll(pcs);
    }

    public <T> T detachCopy(T pc) {
        return (T)this.getPM().detachCopy(pc);
    }

    public <T> Collection<T> detachCopyAll(Collection<T> pcs) {
        return this.getPM().detachCopyAll(pcs);
    }

    public <T> T[] detachCopyAll(T ... pcs) {
        return this.getPM().detachCopyAll((Object[])pcs);
    }

    public void evict(Object obj) {
        this.getPM().evict(obj);
    }

    public void evictAll() {
        this.getPM().evictAll();
    }

    public void evictAll(Object ... pcs) {
        this.getPM().evictAll(pcs);
    }

    public void evictAll(Collection pcs) {
        this.getPM().evictAll(pcs);
    }

    public void evictAll(boolean subclasses, Class cls) {
        this.getPM().evictAll(subclasses, cls);
    }

    public void flush() {
        this.getPM().flush();
    }

    public boolean getCopyOnAttach() {
        return this.getPM().getCopyOnAttach();
    }

    public JDOConnection getDataStoreConnection() {
        return this.getPM().getDataStoreConnection();
    }

    public boolean getDetachAllOnCommit() {
        return this.getPM().getDetachAllOnCommit();
    }

    public <T> Extent<T> getExtent(Class<T> pcClass) {
        return this.getPM().getExtent(pcClass);
    }

    public <T> Extent<T> getExtent(Class<T> pcClass, boolean subclasses) {
        return this.getPM().getExtent(pcClass, subclasses);
    }

    public FetchGroup getFetchGroup(Class arg0, String arg1) {
        return this.getFetchGroup(arg0, arg1);
    }

    public FetchPlan getFetchPlan() {
        return this.getPM().getFetchPlan();
    }

    public boolean getIgnoreCache() {
        return this.getPM().getIgnoreCache();
    }

    public Set getManagedObjects() {
        return this.getPM().getManagedObjects();
    }

    public Set getManagedObjects(EnumSet<ObjectState> states) {
        return this.getPM().getManagedObjects(states);
    }

    public Set getManagedObjects(Class ... classes) {
        return this.getPM().getManagedObjects(classes);
    }

    public Set getManagedObjects(EnumSet<ObjectState> states, Class ... classes) {
        return this.getPM().getManagedObjects(states, classes);
    }

    public boolean getMultithreaded() {
        return this.getPM().getMultithreaded();
    }

    public Object getObjectById(Object id) {
        return this.getPM().getObjectById(id);
    }

    public Object getObjectById(Object id, boolean validate) {
        return this.getPM().getObjectById(id, validate);
    }

    public <T> T getObjectById(Class<T> cls, Object key) {
        return (T)this.getPM().getObjectById(cls, key);
    }

    public Object getObjectId(Object pc) {
        return this.getPM().getObjectId(pc);
    }

    public Class getObjectIdClass(Class cls) {
        return this.getPM().getObjectIdClass(cls);
    }

    public Collection getObjectsById(Collection oids) {
        return this.getPM().getObjectsById(oids);
    }

    public Object[] getObjectsById(Object ... oids) {
        return this.getPM().getObjectsById(oids);
    }

    public Collection getObjectsById(Collection oids, boolean validate) {
        return this.getPM().getObjectsById(oids, validate);
    }

    public Object[] getObjectsById(Object[] oids, boolean validate) {
        return this.getPM().getObjectsById(validate, oids);
    }

    public Object[] getObjectsById(boolean validate, Object ... oids) {
        return this.getPM().getObjectsById(validate, oids);
    }

    public PersistenceManagerFactory getPersistenceManagerFactory() {
        return this.getPM().getPersistenceManagerFactory();
    }

    public Sequence getSequence(String sequenceName) {
        return this.getPM().getSequence(sequenceName);
    }

    public Date getServerDate() {
        return this.getPM().getServerDate();
    }

    public Object getTransactionalObjectId(Object pc) {
        return this.getPM().getTransactionalObjectId(pc);
    }

    public Object getUserObject() {
        return this.getPM().getUserObject();
    }

    public Object getUserObject(Object key) {
        return this.getPM().getUserObject(key);
    }

    public boolean isClosed() {
        return this.getPM().isClosed();
    }

    public void makeNontransactional(Object pc) {
        this.getPM().makeNontransactional(pc);
    }

    public void makeNontransactionalAll(Object ... pcs) {
        this.getPM().makeNontransactionalAll(pcs);
    }

    public void makeNontransactionalAll(Collection arg0) {
        this.getPM().makeNontransactionalAll(arg0);
    }

    public <T> T makePersistent(T obj) {
        return (T)this.getPM().makePersistent(obj);
    }

    public <T> T[] makePersistentAll(T ... arg0) {
        return this.getPM().makePersistentAll((Object[])arg0);
    }

    public <T> Collection<T> makePersistentAll(Collection<T> arg0) {
        return this.getPM().makePersistentAll(arg0);
    }

    public void makeTransactional(Object arg0) {
        this.getPM().makeTransactional(arg0);
    }

    public void makeTransactionalAll(Object ... arg0) {
        this.getPM().makeTransactionalAll(arg0);
    }

    public void makeTransactionalAll(Collection arg0) {
        this.getPM().makeTransactionalAll(arg0);
    }

    public void makeTransient(Object pc) {
        this.getPM().makeTransient(pc);
    }

    public void makeTransient(Object pc, boolean useFetchPlan) {
        this.getPM().makeTransient(pc, useFetchPlan);
    }

    public void makeTransientAll(Object ... pcs) {
        this.getPM().makeTransientAll(pcs);
    }

    public void makeTransientAll(Collection pcs) {
        this.getPM().makeTransientAll(pcs);
    }

    public void makeTransientAll(Object[] pcs, boolean includeFetchPlan) {
        this.getPM().makeTransientAll(includeFetchPlan, pcs);
    }

    public void makeTransientAll(boolean includeFetchPlan, Object ... pcs) {
        this.getPM().makeTransientAll(includeFetchPlan, pcs);
    }

    public void makeTransientAll(Collection pcs, boolean useFetchPlan) {
        this.getPM().makeTransientAll(pcs, useFetchPlan);
    }

    public <T> T newInstance(Class<T> pc) {
        return (T)this.getPM().newInstance(pc);
    }

    public Query newNamedQuery(Class cls, String filter) {
        return this.getPM().newQuery(cls, filter);
    }

    public Object newObjectIdInstance(Class pcClass, Object key) {
        return this.getPM().newObjectIdInstance(pcClass, key);
    }

    public Query newQuery() {
        return this.getPM().newQuery();
    }

    public Query newQuery(Object obj) {
        return this.getPM().newQuery(obj);
    }

    public Query newQuery(String query) {
        return this.getPM().newQuery(query);
    }

    public Query newQuery(Class cls) {
        return this.getPM().newQuery(cls);
    }

    public Query newQuery(Extent cln) {
        return this.getPM().newQuery(cln);
    }

    public Query newQuery(String language, Object query) {
        return this.getPM().newQuery(language, query);
    }

    public Query newQuery(Class cls, Collection cln) {
        return this.getPM().newQuery(cls, cln);
    }

    public Query newQuery(Class cls, String filter) {
        return this.getPM().newQuery(cls, filter);
    }

    public Query newQuery(Extent cln, String filter) {
        return this.getPM().newQuery(cln, filter);
    }

    public Query newQuery(Class cls, Collection cln, String filter) {
        return this.getPM().newQuery(cls, cln, filter);
    }

    public Object putUserObject(Object key, Object value) {
        return this.getPM().putUserObject(key, value);
    }

    public void refresh(Object obj) {
        this.getPM().refresh(obj);
    }

    public void refreshAll() {
        this.getPM().refreshAll();
    }

    public void refreshAll(Object ... pcs) {
        this.getPM().refreshAll(pcs);
    }

    public void refreshAll(Collection pcs) {
        this.getPM().refreshAll(pcs);
    }

    public void refreshAll(JDOException exc) {
        this.getPM().refreshAll(exc);
    }

    public void removeInstanceLifecycleListener(InstanceLifecycleListener listener) {
        this.getPM().removeInstanceLifecycleListener(listener);
    }

    public Object removeUserObject(Object key) {
        return this.getPM().removeUserObject(key);
    }

    public void retrieve(Object pc) {
        this.getPM().retrieve(pc);
    }

    public void retrieve(Object pc, boolean fgOnly) {
        this.getPM().retrieve(pc, fgOnly);
    }

    public void retrieveAll(Collection pcs) {
        this.getPM().retrieveAll(pcs);
    }

    public void retrieveAll(Object ... pcs) {
        this.getPM().retrieveAll(pcs);
    }

    public void retrieveAll(Collection pcs, boolean fgOnly) {
        this.getPM().retrieveAll(pcs, fgOnly);
    }

    public void retrieveAll(Object[] pcs, boolean fgOnly) {
        this.getPM().retrieveAll(fgOnly, pcs);
    }

    public void retrieveAll(boolean fgOnly, Object ... pcs) {
        this.getPM().retrieveAll(fgOnly, pcs);
    }

    public void setCopyOnAttach(boolean flag) {
        this.getPM().setCopyOnAttach(flag);
    }

    public void setDetachAllOnCommit(boolean flag) {
        this.getPM().setDetachAllOnCommit(flag);
    }

    public void setIgnoreCache(boolean flag) {
        this.getPM().setIgnoreCache(flag);
    }

    public void setMultithreaded(boolean flag) {
        this.getPM().setMultithreaded(flag);
    }

    public void setUserObject(Object userObject) {
        this.getPM().setUserObject(userObject);
    }

    public Integer getQueryTimeoutMillis() {
        return this.getPM().getQueryTimeoutMillis();
    }

    public void setQueryTimeoutMillis(Integer intvl) {
        this.getPM().setQueryTimeoutMillis(intvl);
    }
}

