/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.store.appengine.DatastoreManager;
import org.datanucleus.store.appengine.DatastoreTransaction;
import org.datanucleus.store.appengine.EmulatedXAResource;
import org.datanucleus.store.appengine.FatalNucleusUserException;
import org.datanucleus.store.mapped.IdentifierFactory;
import org.datanucleus.store.mapped.MappedStoreManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EntityUtils {
    public static String getPropertyName(IdentifierFactory idFactory, AbstractMemberMetaData ammd) {
        AbstractClassMetaData acmd = ammd.getAbstractClassMetaData();
        if (acmd.hasVersionStrategy() && ammd.getName().equals(acmd.getVersionMetaData().getFieldName())) {
            return EntityUtils.getVersionPropertyName(idFactory, acmd.getVersionMetaData());
        }
        if (ammd.getColumn() != null) {
            return ammd.getColumn();
        }
        if (ammd.getColumnMetaData() != null && ammd.getColumnMetaData().length > 0) {
            if (ammd.getColumnMetaData().length != 1) {
                throw new UnsupportedOperationException();
            }
            return ammd.getColumnMetaData()[0].getName();
        }
        return idFactory.newDatastoreFieldIdentifier(ammd.getName()).getIdentifierName();
    }

    public static Object getVersionFromEntity(IdentifierFactory idFactory, VersionMetaData vmd, Entity entity) {
        return entity.getProperty(EntityUtils.getVersionPropertyName(idFactory, vmd));
    }

    public static String getVersionPropertyName(IdentifierFactory idFactory, VersionMetaData vmd) {
        ColumnMetaData[] columnMetaData = vmd.getColumnMetaData();
        if (columnMetaData == null || columnMetaData.length == 0) {
            return idFactory.newVersionFieldIdentifier().getIdentifierName();
        }
        if (columnMetaData.length != 1) {
            throw new IllegalArgumentException("Please specify 0 or 1 column name for the version property.");
        }
        return columnMetaData[0].getName();
    }

    public static String determineKind(AbstractClassMetaData acmd, ObjectManager om) {
        MappedStoreManager storeMgr = (MappedStoreManager)om.getStoreManager();
        return EntityUtils.determineKind(acmd, storeMgr.getIdentifierFactory());
    }

    public static String determineKind(AbstractClassMetaData acmd, IdentifierFactory idFactory) {
        if (acmd.getTable() != null) {
            return acmd.getTable();
        }
        return idFactory.newDatastoreContainerIdentifier(acmd).getIdentifierName();
    }

    public static Object idToInternalKey(ObjectManager om, Class<?> cls, Object val, boolean allowSubclasses) {
        AbstractClassMetaData cmd = om.getMetaDataManager().getMetaDataForClass(cls, om.getClassLoaderResolver());
        String kind = EntityUtils.determineKind(cmd, om);
        AbstractMemberMetaData pkMemberMetaData = EntityUtils.getPKMemberMetaData(om, cls);
        return EntityUtils.idToInternalKey(kind, pkMemberMetaData, cls, val, om, allowSubclasses);
    }

    static Object idToInternalKey(String kind, AbstractMemberMetaData pkMemberMetaData, Class<?> cls, Object val, ObjectManager om, boolean allowSubclasses) {
        Object result = null;
        Class pkType = pkMemberMetaData.getType();
        if (val instanceof String) {
            result = EntityUtils.stringToInternalKey(kind, pkType, pkMemberMetaData, cls, val);
        } else if (val instanceof Long || val instanceof Integer) {
            result = EntityUtils.intOrLongToInternalKey(kind, pkType, pkMemberMetaData, cls, val);
        } else if (val instanceof Key) {
            result = EntityUtils.keyToInternalKey(kind, pkType, pkMemberMetaData, cls, (Key)val, om, allowSubclasses);
        }
        if (result == null && val != null) {
            throw new FatalNucleusUserException("Received a request to find an object of type " + cls.getName() + " identified by " + val + ".  This is not a valid representation of a primary key for an instance of " + cls.getName() + ".");
        }
        return result;
    }

    static Key getPkAsKey(Object pk, AbstractClassMetaData acmd, ObjectManager om) {
        if (pk == null) {
            throw new IllegalStateException("Primary key for object of type " + acmd.getName() + " is null.");
        }
        if (pk instanceof Key) {
            return (Key)pk;
        }
        if (pk instanceof String) {
            if (DatastoreManager.hasEncodedPKField(acmd)) {
                return KeyFactory.stringToKey((String)((String)pk));
            }
            String kind = EntityUtils.determineKind(acmd, om);
            return KeyFactory.createKey((String)kind, (String)((String)pk));
        }
        if (pk instanceof Long) {
            String kind = EntityUtils.determineKind(acmd, om);
            return KeyFactory.createKey((String)kind, (long)((Long)pk));
        }
        throw new IllegalStateException("Primary key for object of type " + acmd.getName() + " is of unexpected type " + pk.getClass().getName() + " (must be String, Long, or " + Key.class.getName() + ")");
    }

    private static boolean keyKindIsValid(String kind, AbstractMemberMetaData pkMemberMetaData, Class<?> cls, Key key, ObjectManager om, boolean allowSubclasses) {
        if (key.getKind().equals(kind)) {
            return true;
        }
        if (!allowSubclasses) {
            return false;
        }
        MetaDataManager mdm = pkMemberMetaData.getMetaDataManager();
        String[] subclasses = mdm.getSubclassesForClass(cls.getName(), true);
        if (subclasses != null) {
            for (String subclass : subclasses) {
                AbstractClassMetaData subAcmd = mdm.getMetaDataForClass(subclass, om.getClassLoaderResolver());
                if (!key.getKind().equals(EntityUtils.determineKind(subAcmd, om))) continue;
                return true;
            }
        }
        return false;
    }

    private static Object keyToInternalKey(String kind, Class<?> pkType, AbstractMemberMetaData pkMemberMetaData, Class<?> cls, Key key, ObjectManager om, boolean allowSubclasses) {
        Object result = null;
        if (!EntityUtils.keyKindIsValid(kind, pkMemberMetaData, cls, key, om, allowSubclasses)) {
            throw new FatalNucleusUserException("Received a request to find an object of kind " + kind + " but the provided " + "identifier is a Key for kind " + key.getKind());
        }
        if (!key.isComplete()) {
            throw new FatalNucleusUserException("Received a request to find an object of kind " + kind + " but the provided " + "identifier is is an incomplete Key");
        }
        if (pkType.equals(String.class)) {
            if (pkMemberMetaData.hasExtension("gae.encoded-pk")) {
                result = KeyFactory.keyToString((Key)key);
            } else {
                if (key.getParent() != null) {
                    throw new FatalNucleusUserException("Received a request to find an object of type " + cls.getName() + ".  The primary " + "key for this type is an unencoded String, which means instances of this type " + "never have parents.  However, the Key that was provided as an argument has a " + "parent.");
                }
                result = key.getName();
            }
        } else if (pkType.equals(Long.class)) {
            if (key.getParent() != null) {
                throw new FatalNucleusUserException("Received a request to find an object of type " + cls.getName() + ".  The primary " + "key for this type is a Long, which means instances of this type " + "never have parents.  However, the Key that was provided as an argument has a " + "parent.");
            }
            if (key.getName() != null) {
                throw new FatalNucleusUserException("Received a request to find an object of type " + cls.getName() + ".  The primary " + "key for this type is a Long.  However, the encoded string " + "representation of the Key that was provided as an argument has its name field " + "set, not its id.  This makes it an invalid key for this class.");
            }
            result = key.getId();
        } else if (pkType.equals(Key.class)) {
            result = key;
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object intOrLongToInternalKey(String kind, Class<?> pkType, AbstractMemberMetaData pkMemberMetaData, Class<?> cls, Object val) {
        String result = null;
        Key keyWithId = KeyFactory.createKey((String)kind, (long)((Number)val).longValue());
        if (pkType.equals(String.class)) {
            if (!pkMemberMetaData.hasExtension("gae.encoded-pk")) throw new FatalNucleusUserException("Received a request to find an object of type " + cls.getName() + ".  The primary " + "key for this type is an unencoded String.  However, the provided value is of type " + val.getClass().getName() + ".");
            return KeyFactory.keyToString((Key)keyWithId);
        }
        if (pkType.equals(Long.class)) {
            return keyWithId.getId();
        }
        if (!pkType.equals(Key.class)) return result;
        return keyWithId;
    }

    private static Object stringToInternalKey(String kind, Class<?> pkType, AbstractMemberMetaData pkMemberMetaData, Class<?> cls, Object val) {
        Key decodedKey;
        Object result = null;
        try {
            decodedKey = KeyFactory.stringToKey((String)((String)val));
            if (!decodedKey.isComplete()) {
                throw new FatalNucleusUserException("Received a request to find an object of kind " + kind + " but the provided " + "identifier is the String representation of an incomplete Key for kind " + decodedKey.getKind());
            }
        }
        catch (IllegalArgumentException iae) {
            if (pkType.equals(Long.class)) {
                throw new FatalNucleusUserException("Received a request to find an object of type " + cls.getName() + " identified by the String " + val + ", but the primary key of " + cls.getName() + " is of type Long.");
            }
            decodedKey = KeyFactory.createKey((String)kind, (String)((String)val));
        }
        if (!decodedKey.getKind().equals(kind)) {
            throw new FatalNucleusUserException("Received a request to find an object of kind " + kind + " but the provided " + "identifier is the String representation of a Key for kind " + decodedKey.getKind());
        }
        if (pkType.equals(String.class)) {
            if (pkMemberMetaData.hasExtension("gae.encoded-pk")) {
                result = KeyFactory.keyToString((Key)decodedKey);
            } else {
                if (decodedKey.getParent() != null) {
                    throw new FatalNucleusUserException("Received a request to find an object of type " + cls.getName() + ".  The primary " + "key for this type is an unencoded String, which means instances of this type " + "never have parents.  However, the encoded string representation of the Key that " + "was provided as an argument has a parent.");
                }
                if (decodedKey.getName() == null) {
                    throw new FatalNucleusUserException("Received a request to find an object of type " + cls.getName() + ".  The primary " + "key for this type is an unencoded String.  However, the encoded string " + "representation of the Key that was provided as an argument has its id field " + "set, not its name.  This makes it an invalid key for this class.");
                }
                result = decodedKey.getName();
            }
        } else if (pkType.equals(Long.class)) {
            if (decodedKey.getParent() != null) {
                throw new FatalNucleusUserException("Received a request to find an object of type " + cls.getName() + ".  The primary " + "key for this type is a Long, which means instances of this type " + "never have parents.  However, the encoded string representation of the Key that " + "was provided as an argument has a parent.");
            }
            if (decodedKey.getName() != null) {
                throw new FatalNucleusUserException("Received a request to find an object of type " + cls.getName() + " identified by the " + "encoded String representation of " + decodedKey + ", but the primary key of " + cls.getName() + " is of type Long and the " + "encoded String has its name component set.  It must have its id component set " + "instead in order to be legal.");
            }
            result = decodedKey.getId();
        } else if (pkType.equals(Key.class)) {
            result = decodedKey;
        }
        return result;
    }

    private static AbstractMemberMetaData getPKMemberMetaData(ObjectManager om, Class<?> cls) {
        AbstractClassMetaData cmd = om.getMetaDataManager().getMetaDataForClass(cls, om.getClassLoaderResolver());
        return cmd.getMetaDataForManagedMemberAtAbsolutePosition(cmd.getPKMemberPositions()[0]);
    }

    public static DatastoreTransaction getCurrentTransaction(ObjectManager om) {
        ManagedConnection mconn = om.getStoreManager().getConnection(om);
        return ((EmulatedXAResource)mconn.getXAResource()).getCurrentTransaction();
    }

    public static Key getPrimaryKeyAsKey(ApiAdapter apiAdapter, StateManager sm) {
        Object primaryKey = apiAdapter.getTargetKeyForSingleFieldIdentity(sm.getInternalObjectId());
        String kind = EntityUtils.determineKind(sm.getClassMetaData(), sm.getObjectManager());
        if (primaryKey instanceof Key) {
            return (Key)primaryKey;
        }
        if (primaryKey instanceof Long) {
            return KeyFactory.createKey((String)kind, (long)((Long)primaryKey));
        }
        try {
            return KeyFactory.stringToKey((String)((String)primaryKey));
        }
        catch (IllegalArgumentException iae) {
            return KeyFactory.createKey((String)kind, (String)((String)primaryKey));
        }
    }
}

