/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine.jpa;

import com.google.appengine.api.datastore.DatastoreServiceConfig;
import com.google.appengine.api.datastore.Transaction;
import org.datanucleus.ObjectManager;
import org.datanucleus.jpa.EntityTransactionImpl;
import org.datanucleus.store.appengine.DatastoreManager;
import org.datanucleus.store.appengine.DatastoreServiceFactoryInternal;
import org.datanucleus.util.NucleusLogger;

public class DatastoreEntityTransactionImpl
extends EntityTransactionImpl {
    private final DatastoreServiceConfig config;

    public DatastoreEntityTransactionImpl(ObjectManager om) {
        super(om);
        this.config = ((DatastoreManager)om.getStoreManager()).getDefaultDatastoreServiceConfigForWrites();
    }

    public void begin() {
        super.begin();
        Transaction txn = DatastoreServiceFactoryInternal.getDatastoreService(this.config).beginTransaction();
        NucleusLogger.DATASTORE.debug((Object)("Started new datastore transaction: " + txn.getId()));
    }

    public void commit() {
        super.commit();
        Transaction txn = DatastoreServiceFactoryInternal.getDatastoreService(this.config).getCurrentTransaction(null);
        if (txn != null) {
            txn.commit();
        }
    }

    public void rollback() {
        super.rollback();
        Transaction txn = DatastoreServiceFactoryInternal.getDatastoreService(this.config).getCurrentTransaction(null);
        if (txn != null) {
            txn.rollback();
        }
    }
}

