/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.appidentity;

import com.google.appengine.api.appidentity.AppIdentityService;
import com.google.appengine.api.appidentity.AppIdentityServiceFailureException;
import com.google.appengine.api.appidentity.AppIdentityServicePb;
import com.google.appengine.api.appidentity.PublicCertificate;
import com.google.appengine.api.memcache.Expiration;
import com.google.appengine.api.memcache.MemcacheService;
import com.google.appengine.api.memcache.MemcacheServiceFactory;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.apphosting.api.ApiProxy;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AppIdentityServiceImpl
implements AppIdentityService {
    public static final String PACKAGE_NAME = "app_identity_service";
    public static final String SIGN_FOR_APP_METHOD_NAME = "SignForApp";
    public static final String GET_SERVICE_ACCOUNT_NAME_METHOD_NAME = "GetServiceAccountName";
    public static final String GET_CERTS_METHOD_NAME = "GetPublicCertificatesForApp";
    public static final String GET_ACCESS_TOKEN_METHOD_NAME = "GetAccessToken";
    public static final String MEMCACHE_NAMESPACE = "_ah_";
    public static final String MEMCACHE_KEY_PREFIX = "_ah_app_identity_";

    AppIdentityServiceImpl() {
    }

    private void handleApplicationError(ApiProxy.ApplicationException e) {
        switch (AppIdentityServicePb.AppIdentityServiceError.ErrorCode.valueOf(e.getApplicationError())) {
            case BLOB_TOO_LARGE: {
                throw new AppIdentityServiceFailureException(e.getErrorDetail());
            }
            case NOT_A_VALID_APP: {
                throw new AppIdentityServiceFailureException(e.getErrorDetail());
            }
            case DEADLINE_EXCEEDED: {
                throw new AppIdentityServiceFailureException(e.getErrorDetail());
            }
            case UNKNOWN_ERROR: {
                throw new AppIdentityServiceFailureException(e.getErrorDetail());
            }
            case UNKNOWN_SCOPE: {
                throw new AppIdentityServiceFailureException(e.getErrorDetail());
            }
        }
        throw new AppIdentityServiceFailureException(e.getErrorDetail());
    }

    public List<PublicCertificate> getPublicCertificatesForApp() {
        AppIdentityServicePb.GetPublicCertificateForAppRequest.Builder requestBuilder = AppIdentityServicePb.GetPublicCertificateForAppRequest.newBuilder();
        AppIdentityServicePb.GetPublicCertificateForAppResponse.Builder responseBuilder = AppIdentityServicePb.GetPublicCertificateForAppResponse.newBuilder();
        try {
            responseBuilder.mergeFrom(ApiProxy.makeSyncCall(PACKAGE_NAME, GET_CERTS_METHOD_NAME, requestBuilder.build().toByteArray()));
        }
        catch (ApiProxy.ApplicationException e) {
            this.handleApplicationError(e);
        }
        catch (InvalidProtocolBufferException e) {
            throw new AppIdentityServiceFailureException(e.getMessage());
        }
        AppIdentityServicePb.GetPublicCertificateForAppResponse response = responseBuilder.build();
        ArrayList<PublicCertificate> certs = Lists.newArrayList();
        for (AppIdentityServicePb.PublicCertificate cert : response.getPublicCertificateListList()) {
            certs.add(new PublicCertificate(cert.getKeyName(), cert.getX509CertificatePem()));
        }
        return certs;
    }

    @Override
    public AppIdentityService.SigningResult signForApp(byte[] signBlob) {
        AppIdentityServicePb.SignForAppRequest.Builder requestBuilder = AppIdentityServicePb.SignForAppRequest.newBuilder();
        requestBuilder.setBytesToSign(ByteString.copyFrom(signBlob));
        AppIdentityServicePb.SignForAppResponse.Builder responseBuilder = AppIdentityServicePb.SignForAppResponse.newBuilder();
        try {
            responseBuilder.mergeFrom(ApiProxy.makeSyncCall(PACKAGE_NAME, SIGN_FOR_APP_METHOD_NAME, requestBuilder.build().toByteArray()));
        }
        catch (ApiProxy.ApplicationException e) {
            this.handleApplicationError(e);
        }
        catch (InvalidProtocolBufferException e) {
            throw new AppIdentityServiceFailureException(e.getMessage());
        }
        AppIdentityServicePb.SignForAppResponse response = responseBuilder.build();
        return new AppIdentityService.SigningResult(response.getKeyName(), response.getSignatureBytes().toByteArray());
    }

    @Override
    public String getServiceAccountName() {
        AppIdentityServicePb.GetServiceAccountNameRequest.Builder requestBuilder = AppIdentityServicePb.GetServiceAccountNameRequest.newBuilder();
        AppIdentityServicePb.GetServiceAccountNameResponse.Builder responseBuilder = AppIdentityServicePb.GetServiceAccountNameResponse.newBuilder();
        try {
            responseBuilder.mergeFrom(ApiProxy.makeSyncCall(PACKAGE_NAME, GET_SERVICE_ACCOUNT_NAME_METHOD_NAME, requestBuilder.build().toByteArray()));
        }
        catch (ApiProxy.ApplicationException e) {
            this.handleApplicationError(e);
        }
        catch (InvalidProtocolBufferException e) {
            throw new AppIdentityServiceFailureException(e.getMessage());
        }
        AppIdentityServicePb.GetServiceAccountNameResponse response = responseBuilder.build();
        return response.getServiceAccountName();
    }

    @Override
    public AppIdentityService.GetAccessTokenResult getAccessTokenUncached(Iterable<String> scopes) {
        AppIdentityServicePb.GetAccessTokenRequest.Builder requestBuilder = AppIdentityServicePb.GetAccessTokenRequest.newBuilder();
        for (String scope : scopes) {
            requestBuilder.addScope(scope);
        }
        if (requestBuilder.getScopeCount() == 0) {
            throw new AppIdentityServiceFailureException("No scopes specified.");
        }
        AppIdentityServicePb.GetAccessTokenResponse.Builder responseBuilder = AppIdentityServicePb.GetAccessTokenResponse.newBuilder();
        try {
            responseBuilder.mergeFrom(ApiProxy.makeSyncCall(PACKAGE_NAME, GET_ACCESS_TOKEN_METHOD_NAME, requestBuilder.build().toByteArray()));
        }
        catch (ApiProxy.ApplicationException e) {
            this.handleApplicationError(e);
        }
        catch (InvalidProtocolBufferException e) {
            throw new AppIdentityServiceFailureException(e.getMessage());
        }
        AppIdentityServicePb.GetAccessTokenResponse response = responseBuilder.build();
        return new AppIdentityService.GetAccessTokenResult(response.getAccessToken(), new Date(response.getExpirationTime() * 1000L));
    }

    private String memcacheKeyForScopes(Iterable<String> scopes) {
        StringBuilder builder = new StringBuilder();
        builder.append(MEMCACHE_KEY_PREFIX);
        builder.append("[");
        boolean first = true;
        for (String scope : scopes) {
            if (first) {
                first = false;
            } else {
                builder.append(",");
            }
            builder.append("'");
            builder.append(scope);
            builder.append("'");
        }
        builder.append("]");
        return builder.toString();
    }

    @Override
    public AppIdentityService.GetAccessTokenResult getAccessToken(Iterable<String> scopes) {
        AppIdentityService.GetAccessTokenResult result;
        String memcacheKey;
        MemcacheService memcache = MemcacheServiceFactory.getMemcacheService(MEMCACHE_NAMESPACE);
        Object memcacheResult = memcache.get(memcacheKey = this.memcacheKeyForScopes(scopes));
        if (memcacheResult != null) {
            result = (AppIdentityService.GetAccessTokenResult)memcacheResult;
        } else {
            result = this.getAccessTokenUncached(scopes);
            Date memcacheExpiration = new Date(result.getExpirationTime().getTime() - 300000L);
            memcache.put(memcacheKey, result, Expiration.onDate(memcacheExpiration));
        }
        return result;
    }
}

