/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine.query;

import java.util.Map;
import org.datanucleus.ObjectManager;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.appengine.FatalNucleusUserException;
import org.datanucleus.store.appengine.query.DatastoreQuery;
import org.datanucleus.store.query.AbstractJDOQLQuery;
import org.datanucleus.store.query.AbstractJavaQuery;

public class JDOQLQuery
extends AbstractJDOQLQuery {
    private final DatastoreQuery datastoreQuery = new DatastoreQuery((AbstractJavaQuery)this);

    public JDOQLQuery(ObjectManager om) {
        this(om, (JDOQLQuery)null);
    }

    public JDOQLQuery(ObjectManager om, JDOQLQuery q) {
        super(om, (AbstractJDOQLQuery)q);
    }

    public JDOQLQuery(ObjectManager om, String query) {
        super(om, query);
    }

    protected Object performExecute(Map parameters) {
        Map params = parameters;
        if (this.range != null && !this.range.equals("")) {
            String[] fromTo = this.range.split(",");
            if (fromTo.length != 2) {
                throw new NucleusUserException("Malformed RANGE clause: " + this.range);
            }
            this.fromInclNo = Long.parseLong(fromTo[0].trim());
            this.toExclNo = Long.parseLong(fromTo[1].trim());
        }
        return this.datastoreQuery.performExecute(LOCALISER, this.compilation, this.fromInclNo, this.toExclNo, params);
    }

    DatastoreQuery getDatastoreQuery() {
        return this.datastoreQuery;
    }

    protected void checkParameterTypesAgainstCompilation(Map parameterValues) {
    }

    public void setSubclasses(boolean subclasses) {
        if (subclasses) {
            throw new FatalNucleusUserException("The App Engine datastore does not support queries that return subclass entities.");
        }
        super.setSubclasses(subclasses);
    }
}

