/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine.jpa;

import java.util.LinkedList;
import org.datanucleus.jpa.JPACallbackHandler;

public class DatastoreJPACallbackHandler
extends JPACallbackHandler {
    private static final ThreadLocal<LinkedList<Object>> attaching = new ThreadLocal<LinkedList<Object>>(){

        @Override
        protected LinkedList<Object> initialValue() {
            return new LinkedList<Object>();
        }
    };

    public void preAttach(Object pc) {
        super.preAttach(pc);
        attaching.get().addFirst(pc);
    }

    public void postAttach(Object pc, Object detachedPC) {
        LinkedList<Object> list = attaching.get();
        while (!list.isEmpty() && detachedPC != list.removeFirst()) {
        }
        super.postAttach(pc, detachedPC);
    }

    public static Object getAttachingParent(Object child) {
        for (Object e : attaching.get()) {
            if (e == child) continue;
            return e;
        }
        return null;
    }

    static void clearAttaching() {
        attaching.get().clear();
    }
}

