/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.labs.taskqueue;

import com.google.appengine.api.labs.taskqueue.Transaction;
import com.google.appengine.repackaged.com.google.common.collect.Multimap;
import com.google.appengine.repackaged.com.google.io.protocol.MessageAppender;
import com.google.appengine.repackaged.com.google.io.protocol.MessageSet;
import com.google.appengine.repackaged.com.google.io.protocol.Protocol;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessageEnum;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSink;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSource;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSupport;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolType;
import com.google.appengine.repackaged.com.google.io.protocol.UninterpretedTags;
import com.google.net.rpc.DefaultStubCreationFilter;
import com.google.net.rpc.RPC;
import com.google.net.rpc.RpcCallback;
import com.google.net.rpc.RpcCancelCallback;
import com.google.net.rpc.RpcException;
import com.google.net.rpc.RpcInterface;
import com.google.net.rpc.RpcServerParameters;
import com.google.net.rpc.RpcService;
import com.google.net.rpc.RpcStub;
import com.google.net.rpc.RpcStubFactory;
import com.google.net.rpc.RpcStubParameters;
import com.google.net.rpc.StubCreationFilter;
import com.google.net.rpc.impl.ApplicationHandler;
import com.google.net.rpc.impl.BlockingApplicationHandler;
import com.google.net.rpc.impl.RpcHandlerRegistry;
import com.google.net.rpc.impl.RpcServerConfig;
import com.google.net.rpc3.impl.compatibility.Rpc1CompatibilityStub;
import com.google.net.rpc3.impl.compatibility.Rpc1HandlerRegistry;
import com.google.net.rpc3.server.RpcServer;
import com.google.net.rpc3.server.RpcServiceParameters;
import com.google.net.ssl.SslSecurityLevel;
import java.nio.charset.Charset;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;

public class TaskQueuePb {
    private TaskQueuePb() {
    }

    public static final class TaskQueueService {
        private static volatile StubCreationFilter stubCreationFilter_ = new DefaultStubCreationFilter();
        private static final RpcStubFactory stubFactory_ = new RpcStubFactory(){

            public RpcStub newRpcStub(RpcStubParameters params) {
                return new SimpleStub(stubCreationFilter_.filterStubParameters("TaskQueueService", params));
            }
        };

        private TaskQueueService() {
        }

        public static void setStubCreationFilter(StubCreationFilter filter) {
            stubCreationFilter_ = filter == null ? new DefaultStubCreationFilter() : filter;
        }

        public static RpcStubFactory stubFactory() {
            return stubFactory_;
        }

        public static BlockingStub newBlockingStub(RpcStubParameters params) {
            return new BlockingStub(stubCreationFilter_.filterStubParameters("TaskQueueService", params));
        }

        public static Stub newStub(RpcStubParameters params) {
            return new Stub(stubCreationFilter_.filterStubParameters("TaskQueueService", params));
        }

        public static ServerConfig exportService(Interface service, RpcHandlerRegistry registry) {
            ServerConfig config = new ServerConfig();
            TaskQueueService.exportServiceUsingConfig(service, registry, config);
            return config;
        }

        public static void exportServiceUsingConfig(final Interface service, RpcHandlerRegistry registry, ServerConfig config) {
            registry.registerHandler(config.serviceName(), "Add", (ProtocolMessage)new TaskQueueAddRequest(), (ProtocolMessage)new TaskQueueAddResponse(), null, config.Add_parameters_, new ApplicationHandler(){

                public void handleRequest(RPC rpc) {
                    service.add(rpc, (TaskQueueAddRequest)rpc.internalRequest(), (TaskQueueAddResponse)rpc.internalResponse(), rpc.internalCallback());
                }
            });
            registry.registerHandler(config.serviceName(), "BulkAdd", (ProtocolMessage)new TaskQueueBulkAddRequest(), (ProtocolMessage)new TaskQueueBulkAddResponse(), null, config.BulkAdd_parameters_, new ApplicationHandler(){

                public void handleRequest(RPC rpc) {
                    service.bulkAdd(rpc, (TaskQueueBulkAddRequest)rpc.internalRequest(), (TaskQueueBulkAddResponse)rpc.internalResponse(), rpc.internalCallback());
                }
            });
            registry.registerHandler(config.serviceName(), "Delete", (ProtocolMessage)new TaskQueueDeleteRequest(), (ProtocolMessage)new TaskQueueDeleteResponse(), null, config.Delete_parameters_, new ApplicationHandler(){

                public void handleRequest(RPC rpc) {
                    service.delete(rpc, (TaskQueueDeleteRequest)rpc.internalRequest(), (TaskQueueDeleteResponse)rpc.internalResponse(), rpc.internalCallback());
                }
            });
            registry.registerHandler(config.serviceName(), "UpdateQueue", (ProtocolMessage)new TaskQueueUpdateQueueRequest(), (ProtocolMessage)new TaskQueueUpdateQueueResponse(), null, config.UpdateQueue_parameters_, new ApplicationHandler(){

                public void handleRequest(RPC rpc) {
                    service.updateQueue(rpc, (TaskQueueUpdateQueueRequest)rpc.internalRequest(), (TaskQueueUpdateQueueResponse)rpc.internalResponse(), rpc.internalCallback());
                }
            });
            registry.registerHandler(config.serviceName(), "FetchQueues", (ProtocolMessage)new TaskQueueFetchQueuesRequest(), (ProtocolMessage)new TaskQueueFetchQueuesResponse(), null, config.FetchQueues_parameters_, new ApplicationHandler(){

                public void handleRequest(RPC rpc) {
                    service.fetchQueues(rpc, (TaskQueueFetchQueuesRequest)rpc.internalRequest(), (TaskQueueFetchQueuesResponse)rpc.internalResponse(), rpc.internalCallback());
                }
            });
            registry.registerHandler(config.serviceName(), "FetchQueueStats", (ProtocolMessage)new TaskQueueFetchQueueStatsRequest(), (ProtocolMessage)new TaskQueueFetchQueueStatsResponse(), null, config.FetchQueueStats_parameters_, new ApplicationHandler(){

                public void handleRequest(RPC rpc) {
                    service.fetchQueueStats(rpc, (TaskQueueFetchQueueStatsRequest)rpc.internalRequest(), (TaskQueueFetchQueueStatsResponse)rpc.internalResponse(), rpc.internalCallback());
                }
            });
            registry.registerHandler(config.serviceName(), "PauseQueue", (ProtocolMessage)new TaskQueuePauseQueueRequest(), (ProtocolMessage)new TaskQueuePauseQueueResponse(), null, config.PauseQueue_parameters_, new ApplicationHandler(){

                public void handleRequest(RPC rpc) {
                    service.pauseQueue(rpc, (TaskQueuePauseQueueRequest)rpc.internalRequest(), (TaskQueuePauseQueueResponse)rpc.internalResponse(), rpc.internalCallback());
                }
            });
            registry.registerHandler(config.serviceName(), "PurgeQueue", (ProtocolMessage)new TaskQueuePurgeQueueRequest(), (ProtocolMessage)new TaskQueuePurgeQueueResponse(), null, config.PurgeQueue_parameters_, new ApplicationHandler(){

                public void handleRequest(RPC rpc) {
                    service.purgeQueue(rpc, (TaskQueuePurgeQueueRequest)rpc.internalRequest(), (TaskQueuePurgeQueueResponse)rpc.internalResponse(), rpc.internalCallback());
                }
            });
            registry.registerHandler(config.serviceName(), "DeleteQueue", (ProtocolMessage)new TaskQueueDeleteQueueRequest(), (ProtocolMessage)new TaskQueueDeleteQueueResponse(), null, config.DeleteQueue_parameters_, new ApplicationHandler(){

                public void handleRequest(RPC rpc) {
                    service.deleteQueue(rpc, (TaskQueueDeleteQueueRequest)rpc.internalRequest(), (TaskQueueDeleteQueueResponse)rpc.internalResponse(), rpc.internalCallback());
                }
            });
            registry.registerHandler(config.serviceName(), "QueryTasks", (ProtocolMessage)new TaskQueueQueryTasksRequest(), (ProtocolMessage)new TaskQueueQueryTasksResponse(), null, config.QueryTasks_parameters_, new ApplicationHandler(){

                public void handleRequest(RPC rpc) {
                    service.queryTasks(rpc, (TaskQueueQueryTasksRequest)rpc.internalRequest(), (TaskQueueQueryTasksResponse)rpc.internalResponse(), rpc.internalCallback());
                }
            });
            registry.registerHandler(config.serviceName(), "UpdateStorageLimit", (ProtocolMessage)new TaskQueueUpdateStorageLimitRequest(), (ProtocolMessage)new TaskQueueUpdateStorageLimitResponse(), null, config.UpdateStorageLimit_parameters_, new ApplicationHandler(){

                public void handleRequest(RPC rpc) {
                    service.updateStorageLimit(rpc, (TaskQueueUpdateStorageLimitRequest)rpc.internalRequest(), (TaskQueueUpdateStorageLimitResponse)rpc.internalResponse(), rpc.internalCallback());
                }
            });
        }

        public static RpcService newService(final Interface impl) {
            return new RpcService(){

                protected RpcServerConfig export(RpcHandlerRegistry registry) {
                    return TaskQueueService.exportService(impl, registry);
                }
            };
        }

        public static ServerConfig exportService(Interface service, RpcServer.Builder builder) {
            ServerConfig config = new ServerConfig();
            TaskQueueService.exportServiceUsingConfig(service, builder, config);
            return config;
        }

        public static void exportServiceUsingConfig(Interface service, RpcServer.Builder builder, ServerConfig config) {
            Rpc1HandlerRegistry registry = new Rpc1HandlerRegistry(config.serviceName());
            TaskQueueService.exportServiceUsingConfig(service, (RpcHandlerRegistry)registry, config);
            builder.addService((RpcServiceParameters)registry);
        }

        public static ServerConfig exportBlockingService(BlockingInterface service, RpcHandlerRegistry registry) {
            ServerConfig config = new ServerConfig();
            TaskQueueService.exportBlockingServiceUsingConfig(service, registry, config);
            return config;
        }

        public static void exportBlockingServiceUsingConfig(final BlockingInterface service, RpcHandlerRegistry registry, ServerConfig config) {
            registry.registerHandler(config.serviceName(), "Add", (ProtocolMessage)new TaskQueueAddRequest(), (ProtocolMessage)new TaskQueueAddResponse(), null, config.Add_parameters_, (ApplicationHandler)new BlockingApplicationHandler(){

                public TaskQueueAddResponse handleBlockingRequest(RPC rpc) throws RpcException {
                    return service.add(rpc, (TaskQueueAddRequest)rpc.internalRequest());
                }
            });
            registry.registerHandler(config.serviceName(), "BulkAdd", (ProtocolMessage)new TaskQueueBulkAddRequest(), (ProtocolMessage)new TaskQueueBulkAddResponse(), null, config.BulkAdd_parameters_, (ApplicationHandler)new BlockingApplicationHandler(){

                public TaskQueueBulkAddResponse handleBlockingRequest(RPC rpc) throws RpcException {
                    return service.bulkAdd(rpc, (TaskQueueBulkAddRequest)rpc.internalRequest());
                }
            });
            registry.registerHandler(config.serviceName(), "Delete", (ProtocolMessage)new TaskQueueDeleteRequest(), (ProtocolMessage)new TaskQueueDeleteResponse(), null, config.Delete_parameters_, (ApplicationHandler)new BlockingApplicationHandler(){

                public TaskQueueDeleteResponse handleBlockingRequest(RPC rpc) throws RpcException {
                    return service.delete(rpc, (TaskQueueDeleteRequest)rpc.internalRequest());
                }
            });
            registry.registerHandler(config.serviceName(), "UpdateQueue", (ProtocolMessage)new TaskQueueUpdateQueueRequest(), (ProtocolMessage)new TaskQueueUpdateQueueResponse(), null, config.UpdateQueue_parameters_, (ApplicationHandler)new BlockingApplicationHandler(){

                public TaskQueueUpdateQueueResponse handleBlockingRequest(RPC rpc) throws RpcException {
                    return service.updateQueue(rpc, (TaskQueueUpdateQueueRequest)rpc.internalRequest());
                }
            });
            registry.registerHandler(config.serviceName(), "FetchQueues", (ProtocolMessage)new TaskQueueFetchQueuesRequest(), (ProtocolMessage)new TaskQueueFetchQueuesResponse(), null, config.FetchQueues_parameters_, (ApplicationHandler)new BlockingApplicationHandler(){

                public TaskQueueFetchQueuesResponse handleBlockingRequest(RPC rpc) throws RpcException {
                    return service.fetchQueues(rpc, (TaskQueueFetchQueuesRequest)rpc.internalRequest());
                }
            });
            registry.registerHandler(config.serviceName(), "FetchQueueStats", (ProtocolMessage)new TaskQueueFetchQueueStatsRequest(), (ProtocolMessage)new TaskQueueFetchQueueStatsResponse(), null, config.FetchQueueStats_parameters_, (ApplicationHandler)new BlockingApplicationHandler(){

                public TaskQueueFetchQueueStatsResponse handleBlockingRequest(RPC rpc) throws RpcException {
                    return service.fetchQueueStats(rpc, (TaskQueueFetchQueueStatsRequest)rpc.internalRequest());
                }
            });
            registry.registerHandler(config.serviceName(), "PauseQueue", (ProtocolMessage)new TaskQueuePauseQueueRequest(), (ProtocolMessage)new TaskQueuePauseQueueResponse(), null, config.PauseQueue_parameters_, (ApplicationHandler)new BlockingApplicationHandler(){

                public TaskQueuePauseQueueResponse handleBlockingRequest(RPC rpc) throws RpcException {
                    return service.pauseQueue(rpc, (TaskQueuePauseQueueRequest)rpc.internalRequest());
                }
            });
            registry.registerHandler(config.serviceName(), "PurgeQueue", (ProtocolMessage)new TaskQueuePurgeQueueRequest(), (ProtocolMessage)new TaskQueuePurgeQueueResponse(), null, config.PurgeQueue_parameters_, (ApplicationHandler)new BlockingApplicationHandler(){

                public TaskQueuePurgeQueueResponse handleBlockingRequest(RPC rpc) throws RpcException {
                    return service.purgeQueue(rpc, (TaskQueuePurgeQueueRequest)rpc.internalRequest());
                }
            });
            registry.registerHandler(config.serviceName(), "DeleteQueue", (ProtocolMessage)new TaskQueueDeleteQueueRequest(), (ProtocolMessage)new TaskQueueDeleteQueueResponse(), null, config.DeleteQueue_parameters_, (ApplicationHandler)new BlockingApplicationHandler(){

                public TaskQueueDeleteQueueResponse handleBlockingRequest(RPC rpc) throws RpcException {
                    return service.deleteQueue(rpc, (TaskQueueDeleteQueueRequest)rpc.internalRequest());
                }
            });
            registry.registerHandler(config.serviceName(), "QueryTasks", (ProtocolMessage)new TaskQueueQueryTasksRequest(), (ProtocolMessage)new TaskQueueQueryTasksResponse(), null, config.QueryTasks_parameters_, (ApplicationHandler)new BlockingApplicationHandler(){

                public TaskQueueQueryTasksResponse handleBlockingRequest(RPC rpc) throws RpcException {
                    return service.queryTasks(rpc, (TaskQueueQueryTasksRequest)rpc.internalRequest());
                }
            });
            registry.registerHandler(config.serviceName(), "UpdateStorageLimit", (ProtocolMessage)new TaskQueueUpdateStorageLimitRequest(), (ProtocolMessage)new TaskQueueUpdateStorageLimitResponse(), null, config.UpdateStorageLimit_parameters_, (ApplicationHandler)new BlockingApplicationHandler(){

                public TaskQueueUpdateStorageLimitResponse handleBlockingRequest(RPC rpc) throws RpcException {
                    return service.updateStorageLimit(rpc, (TaskQueueUpdateStorageLimitRequest)rpc.internalRequest());
                }
            });
        }

        public static RpcService newBlockingService(final BlockingInterface impl) {
            return new RpcService(){

                protected RpcServerConfig export(RpcHandlerRegistry registry) {
                    return TaskQueueService.exportBlockingService(impl, registry);
                }
            };
        }

        public static ServerConfig exportBlockingService(BlockingInterface service, RpcServer.Builder builder) {
            ServerConfig config = new ServerConfig();
            TaskQueueService.exportBlockingServiceUsingConfig(service, builder, config);
            return config;
        }

        public static void exportBlockingServiceUsingConfig(BlockingInterface service, RpcServer.Builder builder, ServerConfig config) {
            Rpc1HandlerRegistry registry = new Rpc1HandlerRegistry(config.serviceName());
            TaskQueueService.exportBlockingServiceUsingConfig(service, (RpcHandlerRegistry)registry, config);
            builder.addService((RpcServiceParameters)registry);
        }

        public static void unexport(RpcHandlerRegistry registry) {
            registry.unregisterService("TaskQueueService");
        }

        public static class ServerConfig
        extends RpcServerConfig {
            final RpcServerParameters Add_parameters_ = new RpcServerParameters();
            final RpcServerParameters BulkAdd_parameters_ = new RpcServerParameters();
            final RpcServerParameters Delete_parameters_ = new RpcServerParameters();
            final RpcServerParameters UpdateQueue_parameters_ = new RpcServerParameters();
            final RpcServerParameters FetchQueues_parameters_ = new RpcServerParameters();
            final RpcServerParameters FetchQueueStats_parameters_ = new RpcServerParameters();
            final RpcServerParameters PauseQueue_parameters_ = new RpcServerParameters();
            final RpcServerParameters PurgeQueue_parameters_ = new RpcServerParameters();
            final RpcServerParameters DeleteQueue_parameters_ = new RpcServerParameters();
            final RpcServerParameters QueryTasks_parameters_ = new RpcServerParameters();
            final RpcServerParameters UpdateStorageLimit_parameters_ = new RpcServerParameters();

            public ServerConfig() {
                this("TaskQueueService");
            }

            public ServerConfig(String serviceName) {
                super(serviceName);
            }

            public void setRpcRunner(Executor t) {
                this.setRpcRunner_Add(t);
                this.setRpcRunner_BulkAdd(t);
                this.setRpcRunner_Delete(t);
                this.setRpcRunner_UpdateQueue(t);
                this.setRpcRunner_FetchQueues(t);
                this.setRpcRunner_FetchQueueStats(t);
                this.setRpcRunner_PauseQueue(t);
                this.setRpcRunner_PurgeQueue(t);
                this.setRpcRunner_DeleteQueue(t);
                this.setRpcRunner_QueryTasks(t);
                this.setRpcRunner_UpdateStorageLimit(t);
            }

            public void setRpcRunner_Add(Executor t) {
                this.Add_parameters_.setRpcRunner(t);
            }

            public void setRpcRunner_BulkAdd(Executor t) {
                this.BulkAdd_parameters_.setRpcRunner(t);
            }

            public void setRpcRunner_Delete(Executor t) {
                this.Delete_parameters_.setRpcRunner(t);
            }

            public void setRpcRunner_UpdateQueue(Executor t) {
                this.UpdateQueue_parameters_.setRpcRunner(t);
            }

            public void setRpcRunner_FetchQueues(Executor t) {
                this.FetchQueues_parameters_.setRpcRunner(t);
            }

            public void setRpcRunner_FetchQueueStats(Executor t) {
                this.FetchQueueStats_parameters_.setRpcRunner(t);
            }

            public void setRpcRunner_PauseQueue(Executor t) {
                this.PauseQueue_parameters_.setRpcRunner(t);
            }

            public void setRpcRunner_PurgeQueue(Executor t) {
                this.PurgeQueue_parameters_.setRpcRunner(t);
            }

            public void setRpcRunner_DeleteQueue(Executor t) {
                this.DeleteQueue_parameters_.setRpcRunner(t);
            }

            public void setRpcRunner_QueryTasks(Executor t) {
                this.QueryTasks_parameters_.setRpcRunner(t);
            }

            public void setRpcRunner_UpdateStorageLimit(Executor t) {
                this.UpdateStorageLimit_parameters_.setRpcRunner(t);
            }

            public void setServerLogging_Add(int t) {
                this.Add_parameters_.setServerLogging(t);
            }

            public void setServerLogging_BulkAdd(int t) {
                this.BulkAdd_parameters_.setServerLogging(t);
            }

            public void setServerLogging_Delete(int t) {
                this.Delete_parameters_.setServerLogging(t);
            }

            public void setServerLogging_UpdateQueue(int t) {
                this.UpdateQueue_parameters_.setServerLogging(t);
            }

            public void setServerLogging_FetchQueues(int t) {
                this.FetchQueues_parameters_.setServerLogging(t);
            }

            public void setServerLogging_FetchQueueStats(int t) {
                this.FetchQueueStats_parameters_.setServerLogging(t);
            }

            public void setServerLogging_PauseQueue(int t) {
                this.PauseQueue_parameters_.setServerLogging(t);
            }

            public void setServerLogging_PurgeQueue(int t) {
                this.PurgeQueue_parameters_.setServerLogging(t);
            }

            public void setServerLogging_DeleteQueue(int t) {
                this.DeleteQueue_parameters_.setServerLogging(t);
            }

            public void setServerLogging_QueryTasks(int t) {
                this.QueryTasks_parameters_.setServerLogging(t);
            }

            public void setServerLogging_UpdateStorageLimit(int t) {
                this.UpdateStorageLimit_parameters_.setServerLogging(t);
            }

            public void setSecurityLevel_Add(SslSecurityLevel t) {
                this.Add_parameters_.setSecurityLevel(t);
            }

            public void setSecurityLevel_BulkAdd(SslSecurityLevel t) {
                this.BulkAdd_parameters_.setSecurityLevel(t);
            }

            public void setSecurityLevel_Delete(SslSecurityLevel t) {
                this.Delete_parameters_.setSecurityLevel(t);
            }

            public void setSecurityLevel_UpdateQueue(SslSecurityLevel t) {
                this.UpdateQueue_parameters_.setSecurityLevel(t);
            }

            public void setSecurityLevel_FetchQueues(SslSecurityLevel t) {
                this.FetchQueues_parameters_.setSecurityLevel(t);
            }

            public void setSecurityLevel_FetchQueueStats(SslSecurityLevel t) {
                this.FetchQueueStats_parameters_.setSecurityLevel(t);
            }

            public void setSecurityLevel_PauseQueue(SslSecurityLevel t) {
                this.PauseQueue_parameters_.setSecurityLevel(t);
            }

            public void setSecurityLevel_PurgeQueue(SslSecurityLevel t) {
                this.PurgeQueue_parameters_.setSecurityLevel(t);
            }

            public void setSecurityLevel_DeleteQueue(SslSecurityLevel t) {
                this.DeleteQueue_parameters_.setSecurityLevel(t);
            }

            public void setSecurityLevel_QueryTasks(SslSecurityLevel t) {
                this.QueryTasks_parameters_.setSecurityLevel(t);
            }

            public void setSecurityLevel_UpdateStorageLimit(SslSecurityLevel t) {
                this.UpdateStorageLimit_parameters_.setSecurityLevel(t);
            }

            public void setRpcCancelCallback_Add(RpcCancelCallback t) {
                this.Add_parameters_.setRpcCancelCallback(t);
            }

            public void setRpcCancelCallback_BulkAdd(RpcCancelCallback t) {
                this.BulkAdd_parameters_.setRpcCancelCallback(t);
            }

            public void setRpcCancelCallback_Delete(RpcCancelCallback t) {
                this.Delete_parameters_.setRpcCancelCallback(t);
            }

            public void setRpcCancelCallback_UpdateQueue(RpcCancelCallback t) {
                this.UpdateQueue_parameters_.setRpcCancelCallback(t);
            }

            public void setRpcCancelCallback_FetchQueues(RpcCancelCallback t) {
                this.FetchQueues_parameters_.setRpcCancelCallback(t);
            }

            public void setRpcCancelCallback_FetchQueueStats(RpcCancelCallback t) {
                this.FetchQueueStats_parameters_.setRpcCancelCallback(t);
            }

            public void setRpcCancelCallback_PauseQueue(RpcCancelCallback t) {
                this.PauseQueue_parameters_.setRpcCancelCallback(t);
            }

            public void setRpcCancelCallback_PurgeQueue(RpcCancelCallback t) {
                this.PurgeQueue_parameters_.setRpcCancelCallback(t);
            }

            public void setRpcCancelCallback_DeleteQueue(RpcCancelCallback t) {
                this.DeleteQueue_parameters_.setRpcCancelCallback(t);
            }

            public void setRpcCancelCallback_QueryTasks(RpcCancelCallback t) {
                this.QueryTasks_parameters_.setRpcCancelCallback(t);
            }

            public void setRpcCancelCallback_UpdateStorageLimit(RpcCancelCallback t) {
                this.UpdateStorageLimit_parameters_.setRpcCancelCallback(t);
            }
        }

        public static class Stub
        extends BlockingStub
        implements Interface {
            Stub(RpcStubParameters params) {
                super(params);
            }

            public void add(RPC rpc, TaskQueueAddRequest req, TaskQueueAddResponse reply, RpcCallback cb) {
                this.startNonBlockingRpc(rpc, this.Add_method_, "Add", req, reply, cb, this.Add_parameters_);
            }

            public void bulkAdd(RPC rpc, TaskQueueBulkAddRequest req, TaskQueueBulkAddResponse reply, RpcCallback cb) {
                this.startNonBlockingRpc(rpc, this.BulkAdd_method_, "BulkAdd", req, reply, cb, this.BulkAdd_parameters_);
            }

            public void delete(RPC rpc, TaskQueueDeleteRequest req, TaskQueueDeleteResponse reply, RpcCallback cb) {
                this.startNonBlockingRpc(rpc, this.Delete_method_, "Delete", req, reply, cb, this.Delete_parameters_);
            }

            public void updateQueue(RPC rpc, TaskQueueUpdateQueueRequest req, TaskQueueUpdateQueueResponse reply, RpcCallback cb) {
                this.startNonBlockingRpc(rpc, this.UpdateQueue_method_, "UpdateQueue", req, reply, cb, this.UpdateQueue_parameters_);
            }

            public void fetchQueues(RPC rpc, TaskQueueFetchQueuesRequest req, TaskQueueFetchQueuesResponse reply, RpcCallback cb) {
                this.startNonBlockingRpc(rpc, this.FetchQueues_method_, "FetchQueues", req, reply, cb, this.FetchQueues_parameters_);
            }

            public void fetchQueueStats(RPC rpc, TaskQueueFetchQueueStatsRequest req, TaskQueueFetchQueueStatsResponse reply, RpcCallback cb) {
                this.startNonBlockingRpc(rpc, this.FetchQueueStats_method_, "FetchQueueStats", req, reply, cb, this.FetchQueueStats_parameters_);
            }

            public void pauseQueue(RPC rpc, TaskQueuePauseQueueRequest req, TaskQueuePauseQueueResponse reply, RpcCallback cb) {
                this.startNonBlockingRpc(rpc, this.PauseQueue_method_, "PauseQueue", req, reply, cb, this.PauseQueue_parameters_);
            }

            public void purgeQueue(RPC rpc, TaskQueuePurgeQueueRequest req, TaskQueuePurgeQueueResponse reply, RpcCallback cb) {
                this.startNonBlockingRpc(rpc, this.PurgeQueue_method_, "PurgeQueue", req, reply, cb, this.PurgeQueue_parameters_);
            }

            public void deleteQueue(RPC rpc, TaskQueueDeleteQueueRequest req, TaskQueueDeleteQueueResponse reply, RpcCallback cb) {
                this.startNonBlockingRpc(rpc, this.DeleteQueue_method_, "DeleteQueue", req, reply, cb, this.DeleteQueue_parameters_);
            }

            public void queryTasks(RPC rpc, TaskQueueQueryTasksRequest req, TaskQueueQueryTasksResponse reply, RpcCallback cb) {
                this.startNonBlockingRpc(rpc, this.QueryTasks_method_, "QueryTasks", req, reply, cb, this.QueryTasks_parameters_);
            }

            public void updateStorageLimit(RPC rpc, TaskQueueUpdateStorageLimitRequest req, TaskQueueUpdateStorageLimitResponse reply, RpcCallback cb) {
                this.startNonBlockingRpc(rpc, this.UpdateStorageLimit_method_, "UpdateStorageLimit", req, reply, cb, this.UpdateStorageLimit_parameters_);
            }
        }

        public static interface Interface
        extends RpcInterface {
            public void add(RPC var1, TaskQueueAddRequest var2, TaskQueueAddResponse var3, RpcCallback var4);

            public void bulkAdd(RPC var1, TaskQueueBulkAddRequest var2, TaskQueueBulkAddResponse var3, RpcCallback var4);

            public void delete(RPC var1, TaskQueueDeleteRequest var2, TaskQueueDeleteResponse var3, RpcCallback var4);

            public void updateQueue(RPC var1, TaskQueueUpdateQueueRequest var2, TaskQueueUpdateQueueResponse var3, RpcCallback var4);

            public void fetchQueues(RPC var1, TaskQueueFetchQueuesRequest var2, TaskQueueFetchQueuesResponse var3, RpcCallback var4);

            public void fetchQueueStats(RPC var1, TaskQueueFetchQueueStatsRequest var2, TaskQueueFetchQueueStatsResponse var3, RpcCallback var4);

            public void pauseQueue(RPC var1, TaskQueuePauseQueueRequest var2, TaskQueuePauseQueueResponse var3, RpcCallback var4);

            public void purgeQueue(RPC var1, TaskQueuePurgeQueueRequest var2, TaskQueuePurgeQueueResponse var3, RpcCallback var4);

            public void deleteQueue(RPC var1, TaskQueueDeleteQueueRequest var2, TaskQueueDeleteQueueResponse var3, RpcCallback var4);

            public void queryTasks(RPC var1, TaskQueueQueryTasksRequest var2, TaskQueueQueryTasksResponse var3, RpcCallback var4);

            public void updateStorageLimit(RPC var1, TaskQueueUpdateStorageLimitRequest var2, TaskQueueUpdateStorageLimitResponse var3, RpcCallback var4);
        }

        public static class BlockingStub
        extends BaseStub
        implements BlockingInterface {
            BlockingStub(RpcStubParameters params) {
                super(params);
            }

            public TaskQueueAddResponse add(RPC rpc, TaskQueueAddRequest req) throws RpcException {
                TaskQueueAddResponse reply = new TaskQueueAddResponse();
                this.startBlockingRpc(rpc, this.Add_method_, "Add", req, reply, this.Add_parameters_);
                return reply;
            }

            public TaskQueueBulkAddResponse bulkAdd(RPC rpc, TaskQueueBulkAddRequest req) throws RpcException {
                TaskQueueBulkAddResponse reply = new TaskQueueBulkAddResponse();
                this.startBlockingRpc(rpc, this.BulkAdd_method_, "BulkAdd", req, reply, this.BulkAdd_parameters_);
                return reply;
            }

            public TaskQueueDeleteResponse delete(RPC rpc, TaskQueueDeleteRequest req) throws RpcException {
                TaskQueueDeleteResponse reply = new TaskQueueDeleteResponse();
                this.startBlockingRpc(rpc, this.Delete_method_, "Delete", req, reply, this.Delete_parameters_);
                return reply;
            }

            public TaskQueueUpdateQueueResponse updateQueue(RPC rpc, TaskQueueUpdateQueueRequest req) throws RpcException {
                TaskQueueUpdateQueueResponse reply = new TaskQueueUpdateQueueResponse();
                this.startBlockingRpc(rpc, this.UpdateQueue_method_, "UpdateQueue", req, reply, this.UpdateQueue_parameters_);
                return reply;
            }

            public TaskQueueFetchQueuesResponse fetchQueues(RPC rpc, TaskQueueFetchQueuesRequest req) throws RpcException {
                TaskQueueFetchQueuesResponse reply = new TaskQueueFetchQueuesResponse();
                this.startBlockingRpc(rpc, this.FetchQueues_method_, "FetchQueues", req, reply, this.FetchQueues_parameters_);
                return reply;
            }

            public TaskQueueFetchQueueStatsResponse fetchQueueStats(RPC rpc, TaskQueueFetchQueueStatsRequest req) throws RpcException {
                TaskQueueFetchQueueStatsResponse reply = new TaskQueueFetchQueueStatsResponse();
                this.startBlockingRpc(rpc, this.FetchQueueStats_method_, "FetchQueueStats", req, reply, this.FetchQueueStats_parameters_);
                return reply;
            }

            public TaskQueuePauseQueueResponse pauseQueue(RPC rpc, TaskQueuePauseQueueRequest req) throws RpcException {
                TaskQueuePauseQueueResponse reply = new TaskQueuePauseQueueResponse();
                this.startBlockingRpc(rpc, this.PauseQueue_method_, "PauseQueue", req, reply, this.PauseQueue_parameters_);
                return reply;
            }

            public TaskQueuePurgeQueueResponse purgeQueue(RPC rpc, TaskQueuePurgeQueueRequest req) throws RpcException {
                TaskQueuePurgeQueueResponse reply = new TaskQueuePurgeQueueResponse();
                this.startBlockingRpc(rpc, this.PurgeQueue_method_, "PurgeQueue", req, reply, this.PurgeQueue_parameters_);
                return reply;
            }

            public TaskQueueDeleteQueueResponse deleteQueue(RPC rpc, TaskQueueDeleteQueueRequest req) throws RpcException {
                TaskQueueDeleteQueueResponse reply = new TaskQueueDeleteQueueResponse();
                this.startBlockingRpc(rpc, this.DeleteQueue_method_, "DeleteQueue", req, reply, this.DeleteQueue_parameters_);
                return reply;
            }

            public TaskQueueQueryTasksResponse queryTasks(RPC rpc, TaskQueueQueryTasksRequest req) throws RpcException {
                TaskQueueQueryTasksResponse reply = new TaskQueueQueryTasksResponse();
                this.startBlockingRpc(rpc, this.QueryTasks_method_, "QueryTasks", req, reply, this.QueryTasks_parameters_);
                return reply;
            }

            public TaskQueueUpdateStorageLimitResponse updateStorageLimit(RPC rpc, TaskQueueUpdateStorageLimitRequest req) throws RpcException {
                TaskQueueUpdateStorageLimitResponse reply = new TaskQueueUpdateStorageLimitResponse();
                this.startBlockingRpc(rpc, this.UpdateStorageLimit_method_, "UpdateStorageLimit", req, reply, this.UpdateStorageLimit_parameters_);
                return reply;
            }
        }

        public static interface BlockingInterface
        extends RpcInterface {
            public TaskQueueAddResponse add(RPC var1, TaskQueueAddRequest var2) throws RpcException;

            public TaskQueueBulkAddResponse bulkAdd(RPC var1, TaskQueueBulkAddRequest var2) throws RpcException;

            public TaskQueueDeleteResponse delete(RPC var1, TaskQueueDeleteRequest var2) throws RpcException;

            public TaskQueueUpdateQueueResponse updateQueue(RPC var1, TaskQueueUpdateQueueRequest var2) throws RpcException;

            public TaskQueueFetchQueuesResponse fetchQueues(RPC var1, TaskQueueFetchQueuesRequest var2) throws RpcException;

            public TaskQueueFetchQueueStatsResponse fetchQueueStats(RPC var1, TaskQueueFetchQueueStatsRequest var2) throws RpcException;

            public TaskQueuePauseQueueResponse pauseQueue(RPC var1, TaskQueuePauseQueueRequest var2) throws RpcException;

            public TaskQueuePurgeQueueResponse purgeQueue(RPC var1, TaskQueuePurgeQueueRequest var2) throws RpcException;

            public TaskQueueDeleteQueueResponse deleteQueue(RPC var1, TaskQueueDeleteQueueRequest var2) throws RpcException;

            public TaskQueueQueryTasksResponse queryTasks(RPC var1, TaskQueueQueryTasksRequest var2) throws RpcException;

            public TaskQueueUpdateStorageLimitResponse updateStorageLimit(RPC var1, TaskQueueUpdateStorageLimitRequest var2) throws RpcException;
        }

        private static class BaseStub
        extends Rpc1CompatibilityStub {
            protected final String Add_method_;
            protected final RPC Add_parameters_ = this.newRpcPrototype(Method.Add);
            protected final String BulkAdd_method_;
            protected final RPC BulkAdd_parameters_ = this.newRpcPrototype(Method.BulkAdd);
            protected final String Delete_method_;
            protected final RPC Delete_parameters_ = this.newRpcPrototype(Method.Delete);
            protected final String UpdateQueue_method_;
            protected final RPC UpdateQueue_parameters_ = this.newRpcPrototype(Method.UpdateQueue);
            protected final String FetchQueues_method_;
            protected final RPC FetchQueues_parameters_ = this.newRpcPrototype(Method.FetchQueues);
            protected final String FetchQueueStats_method_;
            protected final RPC FetchQueueStats_parameters_ = this.newRpcPrototype(Method.FetchQueueStats);
            protected final String PauseQueue_method_;
            protected final RPC PauseQueue_parameters_ = this.newRpcPrototype(Method.PauseQueue);
            protected final String PurgeQueue_method_;
            protected final RPC PurgeQueue_parameters_ = this.newRpcPrototype(Method.PurgeQueue);
            protected final String DeleteQueue_method_;
            protected final RPC DeleteQueue_parameters_ = this.newRpcPrototype(Method.DeleteQueue);
            protected final String QueryTasks_method_;
            protected final RPC QueryTasks_parameters_ = this.newRpcPrototype(Method.QueryTasks);
            protected final String UpdateStorageLimit_method_;
            protected final RPC UpdateStorageLimit_parameters_ = this.newRpcPrototype(Method.UpdateStorageLimit);

            protected BaseStub(RpcStubParameters params) {
                super("TaskQueueService", params, Method.class);
                this.Add_method_ = this.makeFullMethodName("Add");
                this.BulkAdd_method_ = this.makeFullMethodName("BulkAdd");
                this.Delete_method_ = this.makeFullMethodName("Delete");
                this.UpdateQueue_method_ = this.makeFullMethodName("UpdateQueue");
                this.FetchQueues_method_ = this.makeFullMethodName("FetchQueues");
                this.FetchQueueStats_method_ = this.makeFullMethodName("FetchQueueStats");
                this.PauseQueue_method_ = this.makeFullMethodName("PauseQueue");
                this.PurgeQueue_method_ = this.makeFullMethodName("PurgeQueue");
                this.DeleteQueue_method_ = this.makeFullMethodName("DeleteQueue");
                this.QueryTasks_method_ = this.makeFullMethodName("QueryTasks");
                this.UpdateStorageLimit_method_ = this.makeFullMethodName("UpdateStorageLimit");
            }
        }

        private static class SimpleStub
        extends Rpc1CompatibilityStub {
            public SimpleStub(RpcStubParameters params) {
                super("TaskQueueService", params, Method.class);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Method {
            Add,
            BulkAdd,
            Delete,
            UpdateQueue,
            FetchQueues,
            FetchQueueStats,
            PauseQueue,
            PurgeQueue,
            DeleteQueue,
            QueryTasks,
            UpdateStorageLimit;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TaskQueueUpdateStorageLimitResponse
    extends ProtocolMessage<TaskQueueUpdateStorageLimitResponse> {
        private static final long serialVersionUID = 1L;
        private long new_limit_ = 0L;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final TaskQueueUpdateStorageLimitResponse IMMUTABLE_DEFAULT_INSTANCE = new TaskQueueUpdateStorageLimitResponse(){
            private static final long serialVersionUID = 1L;

            public TaskQueueUpdateStorageLimitResponse clearNewLimit() {
                return this;
            }

            public TaskQueueUpdateStorageLimitResponse setNewLimit(long x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueUpdateStorageLimitResponse mergeFrom(TaskQueueUpdateStorageLimitResponse that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public TaskQueueUpdateStorageLimitResponse freeze() {
                return this;
            }

            public TaskQueueUpdateStorageLimitResponse unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int knew_limit = 1;
        public static final String[] text = new String[2];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final long getNewLimit() {
            return this.new_limit_;
        }

        public final boolean hasNewLimit() {
            return (this.optional_0_ & 1) != 0;
        }

        public TaskQueueUpdateStorageLimitResponse clearNewLimit() {
            this.optional_0_ &= 0xFFFFFFFE;
            this.new_limit_ = 0L;
            return this;
        }

        public TaskQueueUpdateStorageLimitResponse setNewLimit(long x) {
            this.optional_0_ |= 1;
            this.new_limit_ = x;
            return this;
        }

        public TaskQueueUpdateStorageLimitResponse mergeFrom(TaskQueueUpdateStorageLimitResponse that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                this.new_limit_ = that.new_limit_;
            }
            if (that.uninterpreted != null) {
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll((Multimap)that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        public boolean equalsIgnoreUninterpreted(TaskQueueUpdateStorageLimitResponse that) {
            return this.equals(that, true);
        }

        public boolean equals(TaskQueueUpdateStorageLimitResponse that) {
            return this.equals(that, false);
        }

        public boolean equals(TaskQueueUpdateStorageLimitResponse that, boolean ignoreUninterpreted) {
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (this_t0 != that_t0) {
                return false;
            }
            if ((this_t0 & 1) != 0 && this.new_limit_ != that.new_limit_) {
                return false;
            }
            return ignoreUninterpreted || UninterpretedTags.equivalent((UninterpretedTags)this.uninterpreted, (UninterpretedTags)that.uninterpreted);
        }

        public boolean equals(Object that) {
            return that instanceof TaskQueueUpdateStorageLimitResponse && this.equals((TaskQueueUpdateStorageLimitResponse)((Object)that));
        }

        public int hashCode() {
            int hash = 317230995;
            int this_t0 = this.optional_0_;
            hash = hash * 31 + ((this_t0 & 1) != 0 ? ProtocolSupport.hashCode((long)this.new_limit_) : -113);
            if (this.uninterpreted != null && !this.uninterpreted.isEmpty()) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        public boolean isInitialized() {
            int this_t0 = this.optional_0_;
            return (this_t0 & 1) == 1;
        }

        public int encodingSize() {
            int n = 1 + Protocol.varLongSize((long)this.new_limit_);
            return this.uninterpreted != null ? n + this.uninterpreted.encodingSize() : n;
        }

        public int maxEncodingSize() {
            int n = 11;
            return this.uninterpreted != null ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        public void clear() {
            this.optional_0_ = 0;
            this.new_limit_ = 0L;
            this.uninterpreted = null;
        }

        public TaskQueueUpdateStorageLimitResponse newInstance() {
            return new TaskQueueUpdateStorageLimitResponse();
        }

        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        public void outputTo(ProtocolSink sink) {
            sink.putByte((byte)8);
            sink.putVarLong(this.new_limit_);
            if (this.uninterpreted != null) {
                this.uninterpreted.put(sink);
            }
        }

        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block4: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block4;
                    }
                    case 8: {
                        this.new_limit_ = source.getVarLong();
                        this_t0 |= 1;
                        continue block4;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put((Object)tt, (Object)source.getUninterpreted(tt));
                        continue block4;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        public TaskQueueUpdateStorageLimitResponse getDefaultInstanceForType() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public static final TaskQueueUpdateStorageLimitResponse getDefaultInstance() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        static {
            TaskQueueUpdateStorageLimitResponse.text[0] = "ErrorCode";
            TaskQueueUpdateStorageLimitResponse.text[1] = "new_limit";
            types = new int[2];
            Arrays.fill(types, 6);
            TaskQueueUpdateStorageLimitResponse.types[0] = 0;
            TaskQueueUpdateStorageLimitResponse.types[1] = 0;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(TaskQueueUpdateStorageLimitResponse.class, "Z0apphosting/api/taskqueue/taskqueue_service.proto\n.apphosting.TaskQueueUpdateStorageLimitResponse\u0013\u001a\tnew_limit \u0001(\u00000\u00038\u0002\u0014", new ProtocolType.FieldType[]{new ProtocolType.FieldType("new_limit", "new_limit", 1, 0, ProtocolType.FieldBaseType.INT64, ProtocolType.Presence.REQUIRED)});

            private StaticHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TaskQueueUpdateStorageLimitRequest
    extends ProtocolMessage<TaskQueueUpdateStorageLimitRequest> {
        private static final long serialVersionUID = 1L;
        private byte[] app_id_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private long limit_ = 0L;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final TaskQueueUpdateStorageLimitRequest IMMUTABLE_DEFAULT_INSTANCE = new TaskQueueUpdateStorageLimitRequest(){
            private static final long serialVersionUID = 1L;

            public TaskQueueUpdateStorageLimitRequest clearAppId() {
                return this;
            }

            public TaskQueueUpdateStorageLimitRequest setAppIdAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueUpdateStorageLimitRequest setAppId(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueUpdateStorageLimitRequest setAppId(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueUpdateStorageLimitRequest clearLimit() {
                return this;
            }

            public TaskQueueUpdateStorageLimitRequest setLimit(long x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueUpdateStorageLimitRequest mergeFrom(TaskQueueUpdateStorageLimitRequest that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public TaskQueueUpdateStorageLimitRequest freeze() {
                return this;
            }

            public TaskQueueUpdateStorageLimitRequest unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kapp_id = 1;
        public static final int klimit = 2;
        public static final String[] text = new String[3];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final byte[] getAppIdAsBytes() {
            return this.app_id_;
        }

        public final boolean hasAppId() {
            return (this.optional_0_ & 1) != 0;
        }

        public TaskQueueUpdateStorageLimitRequest clearAppId() {
            this.optional_0_ &= 0xFFFFFFFE;
            this.app_id_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public TaskQueueUpdateStorageLimitRequest setAppIdAsBytes(byte[] x) {
            this.optional_0_ |= 1;
            this.app_id_ = x;
            return this;
        }

        public final String getAppId() {
            return ProtocolSupport.toStringUtf8((byte[])this.app_id_);
        }

        public TaskQueueUpdateStorageLimitRequest setAppId(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.app_id_ = ProtocolSupport.toBytesUtf8((String)v);
            return this;
        }

        public final String getAppId(Charset cs) {
            return ProtocolSupport.toString((byte[])this.app_id_, (Charset)cs);
        }

        public TaskQueueUpdateStorageLimitRequest setAppId(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.app_id_ = ProtocolSupport.toBytes((String)v, (Charset)cs);
            return this;
        }

        public final long getLimit() {
            return this.limit_;
        }

        public final boolean hasLimit() {
            return (this.optional_0_ & 2) != 0;
        }

        public TaskQueueUpdateStorageLimitRequest clearLimit() {
            this.optional_0_ &= 0xFFFFFFFD;
            this.limit_ = 0L;
            return this;
        }

        public TaskQueueUpdateStorageLimitRequest setLimit(long x) {
            this.optional_0_ |= 2;
            this.limit_ = x;
            return this;
        }

        public TaskQueueUpdateStorageLimitRequest mergeFrom(TaskQueueUpdateStorageLimitRequest that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                this.app_id_ = that.app_id_;
            }
            if ((that_t0 & 2) != 0) {
                this_t0 |= 2;
                this.limit_ = that.limit_;
            }
            if (that.uninterpreted != null) {
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll((Multimap)that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        public boolean equalsIgnoreUninterpreted(TaskQueueUpdateStorageLimitRequest that) {
            return this.equals(that, true);
        }

        public boolean equals(TaskQueueUpdateStorageLimitRequest that) {
            return this.equals(that, false);
        }

        public boolean equals(TaskQueueUpdateStorageLimitRequest that, boolean ignoreUninterpreted) {
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (this_t0 != that_t0) {
                return false;
            }
            if ((this_t0 & 1) != 0 && !Arrays.equals(this.app_id_, that.app_id_)) {
                return false;
            }
            if ((this_t0 & 2) != 0 && this.limit_ != that.limit_) {
                return false;
            }
            return ignoreUninterpreted || UninterpretedTags.equivalent((UninterpretedTags)this.uninterpreted, (UninterpretedTags)that.uninterpreted);
        }

        public boolean equals(Object that) {
            return that instanceof TaskQueueUpdateStorageLimitRequest && this.equals((TaskQueueUpdateStorageLimitRequest)((Object)that));
        }

        public int hashCode() {
            int hash = -530991606;
            int this_t0 = this.optional_0_;
            hash = hash * 31 + ((this_t0 & 1) != 0 ? Arrays.hashCode(this.app_id_) : -113);
            hash = hash * 31 + ((this_t0 & 2) != 0 ? ProtocolSupport.hashCode((long)this.limit_) : -113);
            if (this.uninterpreted != null && !this.uninterpreted.isEmpty()) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        public boolean isInitialized() {
            int this_t0 = this.optional_0_;
            if ((this_t0 & 3) != 3) {
                if ((this_t0 & 1) == 0) {
                    return false;
                }
                return false;
            }
            return true;
        }

        public int encodingSize() {
            int n = 2 + Protocol.stringSize((int)this.app_id_.length) + Protocol.varLongSize((long)this.limit_);
            return this.uninterpreted != null ? n + this.uninterpreted.encodingSize() : n;
        }

        public int maxEncodingSize() {
            int n = 17 + this.app_id_.length;
            return this.uninterpreted != null ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        public void clear() {
            this.optional_0_ = 0;
            this.app_id_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.limit_ = 0L;
            this.uninterpreted = null;
        }

        public TaskQueueUpdateStorageLimitRequest newInstance() {
            return new TaskQueueUpdateStorageLimitRequest();
        }

        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        public void outputTo(ProtocolSink sink) {
            sink.putByte((byte)10);
            sink.putPrefixedData(this.app_id_);
            sink.putByte((byte)16);
            sink.putVarLong(this.limit_);
            if (this.uninterpreted != null) {
                this.uninterpreted.put(sink);
            }
        }

        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block5: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block5;
                    }
                    case 10: {
                        this.app_id_ = source.getPrefixedData();
                        this_t0 |= 1;
                        continue block5;
                    }
                    case 16: {
                        this.limit_ = source.getVarLong();
                        this_t0 |= 2;
                        continue block5;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put((Object)tt, (Object)source.getUninterpreted(tt));
                        continue block5;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        public TaskQueueUpdateStorageLimitRequest getDefaultInstanceForType() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public static final TaskQueueUpdateStorageLimitRequest getDefaultInstance() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public TaskQueueUpdateStorageLimitRequest freeze() {
            this.app_id_ = ProtocolSupport.freezeString((byte[])this.app_id_);
            return this;
        }

        static {
            TaskQueueUpdateStorageLimitRequest.text[0] = "ErrorCode";
            TaskQueueUpdateStorageLimitRequest.text[1] = "app_id";
            TaskQueueUpdateStorageLimitRequest.text[2] = "limit";
            types = new int[3];
            Arrays.fill(types, 6);
            TaskQueueUpdateStorageLimitRequest.types[0] = 0;
            TaskQueueUpdateStorageLimitRequest.types[1] = 2;
            TaskQueueUpdateStorageLimitRequest.types[2] = 0;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(TaskQueueUpdateStorageLimitRequest.class, "Z0apphosting/api/taskqueue/taskqueue_service.proto\n-apphosting.TaskQueueUpdateStorageLimitRequest\u0013\u001a\u0006app_id \u0001(\u00020\t8\u0002\u0014\u0013\u001a\u0005limit \u0002(\u00000\u00038\u0002\u0014", new ProtocolType.FieldType[]{new ProtocolType.FieldType("app_id", "app_id", 1, 0, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("limit", "limit", 2, 1, ProtocolType.FieldBaseType.INT64, ProtocolType.Presence.REQUIRED)});

            private StaticHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TaskQueueQueryTasksResponse
    extends ProtocolMessage<TaskQueueQueryTasksResponse> {
        private static final long serialVersionUID = 1L;
        private List<Task> task_ = null;
        private UninterpretedTags uninterpreted;
        public static final TaskQueueQueryTasksResponse IMMUTABLE_DEFAULT_INSTANCE = new TaskQueueQueryTasksResponse(){
            private static final long serialVersionUID = 1L;

            public TaskQueueQueryTasksResponse clearTask() {
                return this;
            }

            public Task getMutableTask(int i) {
                return (Task)((Object)ProtocolSupport.unsupportedOperation());
            }

            public Task addTask() {
                return (Task)((Object)ProtocolSupport.unsupportedOperation());
            }

            public Task addTask(Task v) {
                return (Task)((Object)ProtocolSupport.unsupportedOperation());
            }

            public Task insertTask(int i, Task v) {
                return (Task)((Object)ProtocolSupport.unsupportedOperation());
            }

            public Task removeTask(int i) {
                return (Task)((Object)ProtocolSupport.unsupportedOperation());
            }

            public TaskQueueQueryTasksResponse mergeFrom(TaskQueueQueryTasksResponse that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public TaskQueueQueryTasksResponse freeze() {
                return this;
            }

            public TaskQueueQueryTasksResponse unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kTaskGroup = 1;
        public static final int kTasktask_name = 2;
        public static final int kTasketa_usec = 3;
        public static final int kTaskurl = 4;
        public static final int kTaskmethod = 5;
        public static final int kTaskretry_count = 6;
        public static final int kTaskHeaderGroup = 7;
        public static final int kTaskHeaderkey = 8;
        public static final int kTaskHeadervalue = 9;
        public static final int kTaskbody_size = 10;
        public static final int kTaskbody = 11;
        public static final int kTaskcreation_time_usec = 12;
        public static final int kTaskCronTimetableGroup = 13;
        public static final int kTaskCronTimetableschedule = 14;
        public static final int kTaskCronTimetabletimezone = 15;
        public static final int kTaskRunLogGroup = 16;
        public static final int kTaskRunLogdispatched_usec = 17;
        public static final int kTaskRunLoglag_usec = 18;
        public static final int kTaskRunLogelapsed_usec = 19;
        public static final int kTaskRunLogresponse_code = 20;
        public static final int kTaskdescription = 21;
        public static final int kTaskpayload = 22;
        public static final String[] text = new String[23];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final int taskSize() {
            return this.task_ != null ? this.task_.size() : 0;
        }

        public final Task getTask(int i) {
            assert (i >= 0 && i < (this.task_ != null ? this.task_.size() : 0));
            return this.task_.get(i);
        }

        public TaskQueueQueryTasksResponse clearTask() {
            if (this.task_ != null) {
                this.task_.clear();
            }
            return this;
        }

        public Task getMutableTask(int i) {
            assert (i >= 0 && this.task_ != null && i < this.task_.size());
            return this.task_.get(i);
        }

        public Task addTask() {
            Task v = new Task();
            if (this.task_ == null) {
                this.task_ = new ArrayList<Task>(4);
            }
            this.task_.add(v);
            return v;
        }

        public Task addTask(Task v) {
            if (this.task_ == null) {
                this.task_ = new ArrayList<Task>(4);
            }
            this.task_.add(v);
            return v;
        }

        public Task insertTask(int i, Task v) {
            if (this.task_ == null) {
                this.task_ = new ArrayList<Task>(4);
            }
            this.task_.add(i, v);
            return v;
        }

        public Task removeTask(int i) {
            return this.task_.remove(i);
        }

        public final Iterator<Task> taskIterator() {
            if (this.task_ == null) {
                return ProtocolSupport.emptyIterator();
            }
            return this.task_.iterator();
        }

        public final List<Task> tasks() {
            return ProtocolSupport.unmodifiableList(this.task_);
        }

        public final List<Task> mutableTasks() {
            if (this.task_ == null) {
                this.task_ = new ArrayList<Task>(4);
            }
            return this.task_;
        }

        public TaskQueueQueryTasksResponse mergeFrom(TaskQueueQueryTasksResponse that) {
            assert (that != this);
            if (that.task_ != null) {
                for (Task v : that.task_) {
                    this.addTask().mergeFrom(v);
                }
            }
            if (that.uninterpreted != null) {
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll((Multimap)that.uninterpreted);
            }
            return this;
        }

        public boolean equalsIgnoreUninterpreted(TaskQueueQueryTasksResponse that) {
            return this.equals(that, true);
        }

        public boolean equals(TaskQueueQueryTasksResponse that) {
            return this.equals(that, false);
        }

        public boolean equals(TaskQueueQueryTasksResponse that, boolean ignoreUninterpreted) {
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            int n = this.task_ != null ? this.task_.size() : 0;
            if (n != (that.task_ != null ? that.task_.size() : 0)) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (this.task_.get(i).equals(that.task_.get(i), ignoreUninterpreted)) continue;
                return false;
            }
            return ignoreUninterpreted || UninterpretedTags.equivalent((UninterpretedTags)this.uninterpreted, (UninterpretedTags)that.uninterpreted);
        }

        public boolean equals(Object that) {
            return that instanceof TaskQueueQueryTasksResponse && this.equals((TaskQueueQueryTasksResponse)((Object)that));
        }

        public int hashCode() {
            int n;
            int hash = 1009609081;
            hash *= 31;
            int n2 = n = this.task_ != null ? this.task_.size() : 0;
            for (int i = 0; i < n; ++i) {
                hash = hash * 31 + this.task_.get(i).hashCode();
            }
            if (this.uninterpreted != null && !this.uninterpreted.isEmpty()) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        public boolean isInitialized() {
            if (this.task_ != null) {
                for (Task v : this.task_) {
                    if (v.isInitialized()) continue;
                    return false;
                }
            }
            return true;
        }

        public int encodingSize() {
            int n = 0;
            int m = this.task_ != null ? this.task_.size() : 0;
            n += m;
            for (int i = 0; i < m; ++i) {
                n += this.task_.get(i).encodingSize();
            }
            return this.uninterpreted != null ? n + this.uninterpreted.encodingSize() : n;
        }

        public int maxEncodingSize() {
            int n = 0;
            int m = this.task_ != null ? this.task_.size() : 0;
            n += m;
            for (int i = 0; i < m; ++i) {
                n += this.task_.get(i).maxEncodingSize();
            }
            return this.uninterpreted != null ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        public void clear() {
            if (this.task_ != null) {
                this.task_.clear();
            }
            this.uninterpreted = null;
        }

        public TaskQueueQueryTasksResponse newInstance() {
            return new TaskQueueQueryTasksResponse();
        }

        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        public void outputTo(ProtocolSink sink) {
            int m;
            int n = m = this.task_ != null ? this.task_.size() : 0;
            for (int i = 0; i < m; ++i) {
                Task v = this.task_.get(i);
                sink.putByte((byte)11);
                v.outputTo(sink);
            }
            if (this.uninterpreted != null) {
                this.uninterpreted.put(sink);
            }
        }

        public boolean merge(ProtocolSource source) {
            boolean result = true;
            block4: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block4;
                    }
                    case 11: {
                        if (this.addTask().merge(source)) continue block4;
                        result = false;
                        break block4;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put((Object)tt, (Object)source.getUninterpreted(tt));
                        continue block4;
                    }
                }
            }
            return result;
        }

        public TaskQueueQueryTasksResponse getDefaultInstanceForType() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public static final TaskQueueQueryTasksResponse getDefaultInstance() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public TaskQueueQueryTasksResponse freeze() {
            this.task_ = ProtocolSupport.freezeMessages(this.task_);
            return this;
        }

        public TaskQueueQueryTasksResponse unfreeze() {
            this.task_ = ProtocolSupport.unfreezeMessages(this.task_);
            return this;
        }

        public boolean isFrozen() {
            return ProtocolSupport.isFrozenMessages(this.task_);
        }

        static {
            TaskQueueQueryTasksResponse.text[0] = "ErrorCode";
            TaskQueueQueryTasksResponse.text[1] = "Task";
            TaskQueueQueryTasksResponse.text[2] = "task_name";
            TaskQueueQueryTasksResponse.text[3] = "eta_usec";
            TaskQueueQueryTasksResponse.text[4] = "url";
            TaskQueueQueryTasksResponse.text[5] = "method";
            TaskQueueQueryTasksResponse.text[6] = "retry_count";
            TaskQueueQueryTasksResponse.text[7] = "Header";
            TaskQueueQueryTasksResponse.text[8] = "key";
            TaskQueueQueryTasksResponse.text[9] = "value";
            TaskQueueQueryTasksResponse.text[10] = "body_size";
            TaskQueueQueryTasksResponse.text[11] = "body";
            TaskQueueQueryTasksResponse.text[12] = "creation_time_usec";
            TaskQueueQueryTasksResponse.text[13] = "CronTimetable";
            TaskQueueQueryTasksResponse.text[14] = "schedule";
            TaskQueueQueryTasksResponse.text[15] = "timezone";
            TaskQueueQueryTasksResponse.text[16] = "RunLog";
            TaskQueueQueryTasksResponse.text[17] = "dispatched_usec";
            TaskQueueQueryTasksResponse.text[18] = "lag_usec";
            TaskQueueQueryTasksResponse.text[19] = "elapsed_usec";
            TaskQueueQueryTasksResponse.text[20] = "response_code";
            TaskQueueQueryTasksResponse.text[21] = "description";
            TaskQueueQueryTasksResponse.text[22] = "payload";
            types = new int[23];
            Arrays.fill(types, 6);
            TaskQueueQueryTasksResponse.types[0] = 0;
            TaskQueueQueryTasksResponse.types[1] = 3;
            TaskQueueQueryTasksResponse.types[2] = 2;
            TaskQueueQueryTasksResponse.types[3] = 0;
            TaskQueueQueryTasksResponse.types[4] = 2;
            TaskQueueQueryTasksResponse.types[5] = 0;
            TaskQueueQueryTasksResponse.types[6] = 0;
            TaskQueueQueryTasksResponse.types[7] = 3;
            TaskQueueQueryTasksResponse.types[8] = 2;
            TaskQueueQueryTasksResponse.types[9] = 2;
            TaskQueueQueryTasksResponse.types[10] = 0;
            TaskQueueQueryTasksResponse.types[11] = 2;
            TaskQueueQueryTasksResponse.types[12] = 0;
            TaskQueueQueryTasksResponse.types[13] = 3;
            TaskQueueQueryTasksResponse.types[14] = 2;
            TaskQueueQueryTasksResponse.types[15] = 2;
            TaskQueueQueryTasksResponse.types[16] = 3;
            TaskQueueQueryTasksResponse.types[17] = 0;
            TaskQueueQueryTasksResponse.types[18] = 0;
            TaskQueueQueryTasksResponse.types[19] = 0;
            TaskQueueQueryTasksResponse.types[20] = 0;
            TaskQueueQueryTasksResponse.types[21] = 2;
            TaskQueueQueryTasksResponse.types[22] = 2;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(TaskQueueQueryTasksResponse.class, "Z0apphosting/api/taskqueue/taskqueue_service.proto\n&apphosting.TaskQueueQueryTasksResponse\u0013\u001a\u0004Task \u0001(\u00030\n8\u0003\u0014\u0013\u001a\u000eTask.task_name \u0002(\u00020\t8\u0002`\u0000\u0014\u0013\u001a\rTask.eta_usec \u0003(\u00000\u00038\u0002`\u0000\u0014\u0013\u001a\bTask.url \u0004(\u00020\t8\u0001`\u0000\u0014\u0013\u001a\u000bTask.method \u0005(\u00000\u00058\u0002`\u0000h\u0000\u0014\u0013\u001a\u0010Task.retry_count \u0006(\u00000\u00058\u0001B\u00010`\u0000\u00a3\u0001\u00aa\u0001\u0007default\u00b2\u0001\u00010\u00a4\u0001\u0014\u0013\u001a\u000bTask.Header \u0007(\u00030\n8\u0003`\u0000\u0014\u0013\u001a\u000fTask.Header.key \b(\u00020\t8\u0002`\u0006\u0014\u0013\u001a\u0011Task.Header.value \t(\u00020\t8\u0002`\u0006\u0014\u0013\u001a\u000eTask.body_size \n(\u00000\u00058\u0001`\u0000\u0014\u0013\u001a\tTask.body \u000b(\u00020\t8\u0001`\u0000\u00a3\u0001\u00aa\u0001\u0005ctype\u00b2\u0001\u0004Cord\u00a4\u0001\u0014\u0013\u001a\u0017Task.creation_time_usec \f(\u00000\u00038\u0002`\u0000\u0014\u0013\u001a\u0012Task.CronTimetable \r(\u00030\n8\u0001`\u0000\u0014\u0013\u001a\u001bTask.CronTimetable.schedule \u000e(\u00020\t8\u0002`\f\u0014\u0013\u001a\u001bTask.CronTimetable.timezone \u000f(\u00020\t8\u0002`\f\u0014\u0013\u001a\u000bTask.RunLog \u0010(\u00030\n8\u0001`\u0000\u0014\u0013\u001a\u001bTask.RunLog.dispatched_usec \u0011(\u00000\u00038\u0002`\u000f\u0014\u0013\u001a\u0014Task.RunLog.lag_usec \u0012(\u00000\u00038\u0002`\u000f\u0014\u0013\u001a\u0018Task.RunLog.elapsed_usec \u0013(\u00000\u00038\u0002`\u000f\u0014\u0013\u001a\u0019Task.RunLog.response_code \u0014(\u00000\u00038\u0001`\u000f\u0014\u0013\u001a\u0010Task.description \u0015(\u00020\t8\u0001`\u0000\u0014\u0013\u001a\fTask.payload \u0016(\u00020\u000b8\u0001J\nMessageSet`\u0000\u0014sz\rRequestMethod\u0080\u0001\u0000\u008b\u0001\u0092\u0001\u0003GET\u0098\u0001\u0001\u008c\u0001\u008b\u0001\u0092\u0001\u0004POST\u0098\u0001\u0002\u008c\u0001\u008b\u0001\u0092\u0001\u0004HEAD\u0098\u0001\u0003\u008c\u0001\u008b\u0001\u0092\u0001\u0003PUT\u0098\u0001\u0004\u008c\u0001\u008b\u0001\u0092\u0001\u0006DELETE\u0098\u0001\u0005\u008c\u0001t", new ProtocolType.FieldType[]{new ProtocolType.FieldType("Task", "task", 1, -1, ProtocolType.FieldBaseType.GROUP, ProtocolType.Presence.REPEATED, Task.class)});

            private StaticHolder() {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Task
        extends ProtocolMessage<Task> {
            private static final long serialVersionUID = 1L;
            private byte[] task_name_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            private long eta_usec_ = 0L;
            private byte[] url_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            private int method_ = 0;
            private int retry_count_ = 0;
            private List<TaskHeader> header_ = null;
            private int body_size_ = 0;
            private byte[] body_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            private long creation_time_usec_ = 0L;
            private TaskCronTimetable crontimetable_ = null;
            private TaskRunLog runlog_ = null;
            private byte[] description_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            private MessageSet payload_ = null;
            private UninterpretedTags uninterpreted;
            private int optional_0_;
            public static final Task IMMUTABLE_DEFAULT_INSTANCE = new Task(){
                private static final long serialVersionUID = 1L;

                public Task clearTaskName() {
                    return this;
                }

                public Task setTaskNameAsBytes(byte[] x) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Task setTaskName(String v) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Task setTaskName(String v, Charset cs) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Task clearEtaUsec() {
                    return this;
                }

                public Task setEtaUsec(long x) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Task clearUrl() {
                    return this;
                }

                public Task setUrlAsBytes(byte[] x) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Task setUrl(String v) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Task setUrl(String v, Charset cs) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Task clearMethod() {
                    return this;
                }

                public Task setMethod(int x) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Task clearRetryCount() {
                    return this;
                }

                public Task setRetryCount(int x) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Task clearHeader() {
                    return this;
                }

                public TaskHeader getMutableHeader(int i) {
                    return (TaskHeader)((Object)ProtocolSupport.unsupportedOperation());
                }

                public TaskHeader addHeader() {
                    return (TaskHeader)((Object)ProtocolSupport.unsupportedOperation());
                }

                public TaskHeader addHeader(TaskHeader v) {
                    return (TaskHeader)((Object)ProtocolSupport.unsupportedOperation());
                }

                public TaskHeader insertHeader(int i, TaskHeader v) {
                    return (TaskHeader)((Object)ProtocolSupport.unsupportedOperation());
                }

                public TaskHeader removeHeader(int i) {
                    return (TaskHeader)((Object)ProtocolSupport.unsupportedOperation());
                }

                public Task clearBodySize() {
                    return this;
                }

                public Task setBodySize(int x) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Task clearBody() {
                    return this;
                }

                public Task setBodyAsBytes(byte[] x) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Task setBody(String v) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Task setBody(String v, Charset cs) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Task clearCreationTimeUsec() {
                    return this;
                }

                public Task setCreationTimeUsec(long x) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Task clearCronTimetable() {
                    return this;
                }

                public Task setCronTimetable(TaskCronTimetable x) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public TaskCronTimetable getMutableCronTimetable() {
                    return (TaskCronTimetable)((Object)ProtocolSupport.unsupportedOperation());
                }

                public Task clearRunLog() {
                    return this;
                }

                public Task setRunLog(TaskRunLog x) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public TaskRunLog getMutableRunLog() {
                    return (TaskRunLog)((Object)ProtocolSupport.unsupportedOperation());
                }

                public Task clearDescription() {
                    return this;
                }

                public Task setDescriptionAsBytes(byte[] x) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Task setDescription(String v) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Task setDescription(String v, Charset cs) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Task clearPayload() {
                    return this;
                }

                public Task setPayload(MessageSet x) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public MessageSet getMutablePayload() {
                    return (MessageSet)ProtocolSupport.unsupportedOperation();
                }

                public Task mergeFrom(Task that) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public boolean merge(ProtocolSource source) {
                    ProtocolSupport.unsupportedOperation();
                    return false;
                }

                public Task freeze() {
                    return this;
                }

                public Task unfreeze() {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public boolean isFrozen() {
                    return true;
                }
            };

            public final byte[] getTaskNameAsBytes() {
                return this.task_name_;
            }

            public final boolean hasTaskName() {
                return (this.optional_0_ & 1) != 0;
            }

            public Task clearTaskName() {
                this.optional_0_ &= 0xFFFFFFFE;
                this.task_name_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
                return this;
            }

            public Task setTaskNameAsBytes(byte[] x) {
                this.optional_0_ |= 1;
                this.task_name_ = x;
                return this;
            }

            public final String getTaskName() {
                return ProtocolSupport.toStringUtf8((byte[])this.task_name_);
            }

            public Task setTaskName(String v) {
                if (v == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 1;
                this.task_name_ = ProtocolSupport.toBytesUtf8((String)v);
                return this;
            }

            public final String getTaskName(Charset cs) {
                return ProtocolSupport.toString((byte[])this.task_name_, (Charset)cs);
            }

            public Task setTaskName(String v, Charset cs) {
                if (v == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 1;
                this.task_name_ = ProtocolSupport.toBytes((String)v, (Charset)cs);
                return this;
            }

            public final long getEtaUsec() {
                return this.eta_usec_;
            }

            public final boolean hasEtaUsec() {
                return (this.optional_0_ & 2) != 0;
            }

            public Task clearEtaUsec() {
                this.optional_0_ &= 0xFFFFFFFD;
                this.eta_usec_ = 0L;
                return this;
            }

            public Task setEtaUsec(long x) {
                this.optional_0_ |= 2;
                this.eta_usec_ = x;
                return this;
            }

            public final byte[] getUrlAsBytes() {
                return this.url_;
            }

            public final boolean hasUrl() {
                return (this.optional_0_ & 4) != 0;
            }

            public Task clearUrl() {
                this.optional_0_ &= 0xFFFFFFFB;
                this.url_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
                return this;
            }

            public Task setUrlAsBytes(byte[] x) {
                this.optional_0_ |= 4;
                this.url_ = x;
                return this;
            }

            public final String getUrl() {
                return ProtocolSupport.toStringUtf8((byte[])this.url_);
            }

            public Task setUrl(String v) {
                if (v == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 4;
                this.url_ = ProtocolSupport.toBytesUtf8((String)v);
                return this;
            }

            public final String getUrl(Charset cs) {
                return ProtocolSupport.toString((byte[])this.url_, (Charset)cs);
            }

            public Task setUrl(String v, Charset cs) {
                if (v == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 4;
                this.url_ = ProtocolSupport.toBytes((String)v, (Charset)cs);
                return this;
            }

            public final int getMethod() {
                return this.method_;
            }

            public RequestMethod getMethodEnum() {
                return this.hasMethod() ? RequestMethod.valueOf(this.getMethod()) : null;
            }

            public final boolean hasMethod() {
                return (this.optional_0_ & 8) != 0;
            }

            public Task clearMethod() {
                this.optional_0_ &= 0xFFFFFFF7;
                this.method_ = 0;
                return this;
            }

            public Task setMethod(int x) {
                this.optional_0_ |= 8;
                this.method_ = x;
                return this;
            }

            public Task setMethod(RequestMethod x) {
                if (x == null) {
                    this.optional_0_ &= 0xFFFFFFF7;
                    this.method_ = 0;
                } else {
                    this.setMethod(x.getValue());
                }
                return this;
            }

            public final int getRetryCount() {
                return this.retry_count_;
            }

            public final boolean hasRetryCount() {
                return (this.optional_0_ & 0x10) != 0;
            }

            public Task clearRetryCount() {
                this.optional_0_ &= 0xFFFFFFEF;
                this.retry_count_ = 0;
                return this;
            }

            public Task setRetryCount(int x) {
                this.optional_0_ |= 0x10;
                this.retry_count_ = x;
                return this;
            }

            public final int headerSize() {
                return this.header_ != null ? this.header_.size() : 0;
            }

            public final TaskHeader getHeader(int i) {
                assert (i >= 0 && i < (this.header_ != null ? this.header_.size() : 0));
                return this.header_.get(i);
            }

            public Task clearHeader() {
                if (this.header_ != null) {
                    this.header_.clear();
                }
                return this;
            }

            public TaskHeader getMutableHeader(int i) {
                assert (i >= 0 && this.header_ != null && i < this.header_.size());
                return this.header_.get(i);
            }

            public TaskHeader addHeader() {
                TaskHeader v = new TaskHeader();
                if (this.header_ == null) {
                    this.header_ = new ArrayList<TaskHeader>(4);
                }
                this.header_.add(v);
                return v;
            }

            public TaskHeader addHeader(TaskHeader v) {
                if (this.header_ == null) {
                    this.header_ = new ArrayList<TaskHeader>(4);
                }
                this.header_.add(v);
                return v;
            }

            public TaskHeader insertHeader(int i, TaskHeader v) {
                if (this.header_ == null) {
                    this.header_ = new ArrayList<TaskHeader>(4);
                }
                this.header_.add(i, v);
                return v;
            }

            public TaskHeader removeHeader(int i) {
                return this.header_.remove(i);
            }

            public final Iterator<TaskHeader> headerIterator() {
                if (this.header_ == null) {
                    return ProtocolSupport.emptyIterator();
                }
                return this.header_.iterator();
            }

            public final List<TaskHeader> headers() {
                return ProtocolSupport.unmodifiableList(this.header_);
            }

            public final List<TaskHeader> mutableHeaders() {
                if (this.header_ == null) {
                    this.header_ = new ArrayList<TaskHeader>(4);
                }
                return this.header_;
            }

            public final int getBodySize() {
                return this.body_size_;
            }

            public final boolean hasBodySize() {
                return (this.optional_0_ & 0x20) != 0;
            }

            public Task clearBodySize() {
                this.optional_0_ &= 0xFFFFFFDF;
                this.body_size_ = 0;
                return this;
            }

            public Task setBodySize(int x) {
                this.optional_0_ |= 0x20;
                this.body_size_ = x;
                return this;
            }

            public final byte[] getBodyAsBytes() {
                return this.body_;
            }

            public final boolean hasBody() {
                return (this.optional_0_ & 0x40) != 0;
            }

            public Task clearBody() {
                this.optional_0_ &= 0xFFFFFFBF;
                this.body_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
                return this;
            }

            public Task setBodyAsBytes(byte[] x) {
                this.optional_0_ |= 0x40;
                this.body_ = x;
                return this;
            }

            public final String getBody() {
                return ProtocolSupport.toStringUtf8((byte[])this.body_);
            }

            public Task setBody(String v) {
                if (v == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 0x40;
                this.body_ = ProtocolSupport.toBytesUtf8((String)v);
                return this;
            }

            public final String getBody(Charset cs) {
                return ProtocolSupport.toString((byte[])this.body_, (Charset)cs);
            }

            public Task setBody(String v, Charset cs) {
                if (v == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 0x40;
                this.body_ = ProtocolSupport.toBytes((String)v, (Charset)cs);
                return this;
            }

            public final long getCreationTimeUsec() {
                return this.creation_time_usec_;
            }

            public final boolean hasCreationTimeUsec() {
                return (this.optional_0_ & 0x80) != 0;
            }

            public Task clearCreationTimeUsec() {
                this.optional_0_ &= 0xFFFFFF7F;
                this.creation_time_usec_ = 0L;
                return this;
            }

            public Task setCreationTimeUsec(long x) {
                this.optional_0_ |= 0x80;
                this.creation_time_usec_ = x;
                return this;
            }

            public final TaskCronTimetable getCronTimetable() {
                if (this.crontimetable_ == null) {
                    return TaskCronTimetable.IMMUTABLE_DEFAULT_INSTANCE;
                }
                return this.crontimetable_;
            }

            public final boolean hasCronTimetable() {
                return (this.optional_0_ & 0x100) != 0;
            }

            public Task clearCronTimetable() {
                this.optional_0_ &= 0xFFFFFEFF;
                if (this.crontimetable_ != null) {
                    this.crontimetable_.clear();
                }
                return this;
            }

            public Task setCronTimetable(TaskCronTimetable x) {
                if (x == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 0x100;
                this.crontimetable_ = x;
                return this;
            }

            public TaskCronTimetable getMutableCronTimetable() {
                this.optional_0_ |= 0x100;
                if (this.crontimetable_ == null) {
                    this.crontimetable_ = new TaskCronTimetable();
                }
                return this.crontimetable_;
            }

            public final TaskRunLog getRunLog() {
                if (this.runlog_ == null) {
                    return TaskRunLog.IMMUTABLE_DEFAULT_INSTANCE;
                }
                return this.runlog_;
            }

            public final boolean hasRunLog() {
                return (this.optional_0_ & 0x200) != 0;
            }

            public Task clearRunLog() {
                this.optional_0_ &= 0xFFFFFDFF;
                if (this.runlog_ != null) {
                    this.runlog_.clear();
                }
                return this;
            }

            public Task setRunLog(TaskRunLog x) {
                if (x == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 0x200;
                this.runlog_ = x;
                return this;
            }

            public TaskRunLog getMutableRunLog() {
                this.optional_0_ |= 0x200;
                if (this.runlog_ == null) {
                    this.runlog_ = new TaskRunLog();
                }
                return this.runlog_;
            }

            public final byte[] getDescriptionAsBytes() {
                return this.description_;
            }

            public final boolean hasDescription() {
                return (this.optional_0_ & 0x400) != 0;
            }

            public Task clearDescription() {
                this.optional_0_ &= 0xFFFFFBFF;
                this.description_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
                return this;
            }

            public Task setDescriptionAsBytes(byte[] x) {
                this.optional_0_ |= 0x400;
                this.description_ = x;
                return this;
            }

            public final String getDescription() {
                return ProtocolSupport.toStringUtf8((byte[])this.description_);
            }

            public Task setDescription(String v) {
                if (v == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 0x400;
                this.description_ = ProtocolSupport.toBytesUtf8((String)v);
                return this;
            }

            public final String getDescription(Charset cs) {
                return ProtocolSupport.toString((byte[])this.description_, (Charset)cs);
            }

            public Task setDescription(String v, Charset cs) {
                if (v == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 0x400;
                this.description_ = ProtocolSupport.toBytes((String)v, (Charset)cs);
                return this;
            }

            public final MessageSet getPayload() {
                if (this.payload_ == null) {
                    return MessageSet.IMMUTABLE_DEFAULT_INSTANCE;
                }
                return this.payload_;
            }

            public final boolean hasPayload() {
                return (this.optional_0_ & 0x800) != 0;
            }

            public Task clearPayload() {
                this.optional_0_ &= 0xFFFFF7FF;
                if (this.payload_ != null) {
                    this.payload_.clear();
                }
                return this;
            }

            public Task setPayload(MessageSet x) {
                if (x == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 0x800;
                this.payload_ = x;
                return this;
            }

            public MessageSet getMutablePayload() {
                this.optional_0_ |= 0x800;
                if (this.payload_ == null) {
                    this.payload_ = new MessageSet();
                }
                return this.payload_;
            }

            public Task mergeFrom(Task that) {
                ProtocolMessage v;
                assert (that != this);
                int this_t0 = this.optional_0_;
                int that_t0 = that.optional_0_;
                if ((that_t0 & 1) != 0) {
                    this_t0 |= 1;
                    this.task_name_ = that.task_name_;
                }
                if ((that_t0 & 2) != 0) {
                    this_t0 |= 2;
                    this.eta_usec_ = that.eta_usec_;
                }
                if ((that_t0 & 4) != 0) {
                    this_t0 |= 4;
                    this.url_ = that.url_;
                }
                if ((that_t0 & 8) != 0) {
                    this_t0 |= 8;
                    this.method_ = that.method_;
                }
                if ((that_t0 & 0x10) != 0) {
                    this_t0 |= 0x10;
                    this.retry_count_ = that.retry_count_;
                }
                if (that.header_ != null) {
                    for (TaskHeader v2 : that.header_) {
                        this.addHeader().mergeFrom(v2);
                    }
                }
                if ((that_t0 & 0x20) != 0) {
                    this_t0 |= 0x20;
                    this.body_size_ = that.body_size_;
                }
                if ((that_t0 & 0x40) != 0) {
                    this_t0 |= 0x40;
                    this.body_ = that.body_;
                }
                if ((that_t0 & 0x80) != 0) {
                    this_t0 |= 0x80;
                    this.creation_time_usec_ = that.creation_time_usec_;
                }
                if ((that_t0 & 0x100) != 0) {
                    this_t0 |= 0x100;
                    v = this.crontimetable_;
                    if (v == null) {
                        v = new TaskCronTimetable();
                        this.crontimetable_ = v;
                    }
                    v.mergeFrom(that.crontimetable_);
                }
                if ((that_t0 & 0x200) != 0) {
                    this_t0 |= 0x200;
                    v = this.runlog_;
                    if (v == null) {
                        v = new TaskRunLog();
                        this.runlog_ = v;
                    }
                    v.mergeFrom(that.runlog_);
                }
                if ((that_t0 & 0x400) != 0) {
                    this_t0 |= 0x400;
                    this.description_ = that.description_;
                }
                if ((that_t0 & 0x800) != 0) {
                    this_t0 |= 0x800;
                    v = this.payload_;
                    if (v == null) {
                        v = new MessageSet();
                        this.payload_ = v;
                    }
                    v.mergeFrom(that.payload_);
                }
                if (that.uninterpreted != null) {
                    if (this.uninterpreted == null) {
                        this.uninterpreted = new UninterpretedTags();
                    }
                    this.uninterpreted.putAll((Multimap)that.uninterpreted);
                }
                this.optional_0_ = this_t0;
                return this;
            }

            public boolean equalsIgnoreUninterpreted(Task that) {
                return this.equals(that, true);
            }

            public boolean equals(Task that) {
                return this.equals(that, false);
            }

            public boolean equals(Task that, boolean ignoreUninterpreted) {
                if (that == null) {
                    return false;
                }
                if (that == this) {
                    return true;
                }
                int this_t0 = this.optional_0_;
                int that_t0 = that.optional_0_;
                if (this_t0 != that_t0) {
                    return false;
                }
                if ((this_t0 & 1) != 0 && !Arrays.equals(this.task_name_, that.task_name_)) {
                    return false;
                }
                if ((this_t0 & 2) != 0 && this.eta_usec_ != that.eta_usec_) {
                    return false;
                }
                if ((this_t0 & 4) != 0 && !Arrays.equals(this.url_, that.url_)) {
                    return false;
                }
                if ((this_t0 & 8) != 0 && this.method_ != that.method_) {
                    return false;
                }
                if ((this_t0 & 0x10) != 0 && this.retry_count_ != that.retry_count_) {
                    return false;
                }
                int n = this.header_ != null ? this.header_.size() : 0;
                if (n != (that.header_ != null ? that.header_.size() : 0)) {
                    return false;
                }
                for (int i = 0; i < n; ++i) {
                    if (this.header_.get(i).equals(that.header_.get(i), ignoreUninterpreted)) continue;
                    return false;
                }
                if ((this_t0 & 0x20) != 0 && this.body_size_ != that.body_size_) {
                    return false;
                }
                if ((this_t0 & 0x40) != 0 && !Arrays.equals(this.body_, that.body_)) {
                    return false;
                }
                if ((this_t0 & 0x80) != 0 && this.creation_time_usec_ != that.creation_time_usec_) {
                    return false;
                }
                if ((this_t0 & 0x100) != 0 && !this.crontimetable_.equals(that.crontimetable_, ignoreUninterpreted)) {
                    return false;
                }
                if ((this_t0 & 0x200) != 0 && !this.runlog_.equals(that.runlog_, ignoreUninterpreted)) {
                    return false;
                }
                if ((this_t0 & 0x400) != 0 && !Arrays.equals(this.description_, that.description_)) {
                    return false;
                }
                if ((this_t0 & 0x800) != 0 && !this.payload_.equals(that.payload_, ignoreUninterpreted)) {
                    return false;
                }
                return ignoreUninterpreted || UninterpretedTags.equivalent((UninterpretedTags)this.uninterpreted, (UninterpretedTags)that.uninterpreted);
            }

            public boolean equals(Object that) {
                return that instanceof Task && this.equals((Task)((Object)that));
            }

            public int hashCode() {
                int n;
                int hash = 200106419;
                int this_t0 = this.optional_0_;
                hash = hash * 31 + ((this_t0 & 1) != 0 ? Arrays.hashCode(this.task_name_) : -113);
                hash = hash * 31 + ((this_t0 & 2) != 0 ? ProtocolSupport.hashCode((long)this.eta_usec_) : -113);
                hash = hash * 31 + ((this_t0 & 4) != 0 ? Arrays.hashCode(this.url_) : -113);
                hash = hash * 31 + ((this_t0 & 8) != 0 ? this.method_ : -113);
                hash = hash * 31 + ((this_t0 & 0x10) != 0 ? this.retry_count_ : -113);
                hash *= 31;
                int n2 = n = this.header_ != null ? this.header_.size() : 0;
                for (int i = 0; i < n; ++i) {
                    hash = hash * 31 + this.header_.get(i).hashCode();
                }
                hash = hash * 31 + ((this_t0 & 0x20) != 0 ? this.body_size_ : -113);
                hash = hash * 31 + ((this_t0 & 0x40) != 0 ? Arrays.hashCode(this.body_) : -113);
                hash = hash * 31 + ((this_t0 & 0x80) != 0 ? ProtocolSupport.hashCode((long)this.creation_time_usec_) : -113);
                hash = hash * 31 + ((this_t0 & 0x100) != 0 ? this.crontimetable_.hashCode() : -113);
                hash = hash * 31 + ((this_t0 & 0x200) != 0 ? this.runlog_.hashCode() : -113);
                hash = hash * 31 + ((this_t0 & 0x400) != 0 ? Arrays.hashCode(this.description_) : -113);
                hash = hash * 31 + ((this_t0 & 0x800) != 0 ? this.payload_.hashCode() : -113);
                if (this.uninterpreted != null && !this.uninterpreted.isEmpty()) {
                    hash = hash * 31 + this.uninterpreted.hashCode();
                }
                return hash;
            }

            public boolean isInitialized() {
                int this_t0 = this.optional_0_;
                if ((this_t0 & 0x8B) != 139) {
                    if ((this_t0 & 1) == 0) {
                        return false;
                    }
                    if ((this_t0 & 2) == 0) {
                        return false;
                    }
                    if ((this_t0 & 8) == 0) {
                        return false;
                    }
                    return false;
                }
                if (this.header_ != null) {
                    for (TaskHeader v : this.header_) {
                        if (v.isInitialized()) continue;
                        return false;
                    }
                }
                if ((this_t0 & 0x100) != 0 && !this.crontimetable_.isInitialized()) {
                    return false;
                }
                if ((this_t0 & 0x200) != 0 && !this.runlog_.isInitialized()) {
                    return false;
                }
                return (this_t0 & 0x800) == 0 || this.payload_.isInitialized();
            }

            public int encodingSize() {
                int n = 5 + Protocol.stringSize((int)this.task_name_.length) + Protocol.varLongSize((long)this.eta_usec_) + Protocol.varLongSize((long)this.method_) + Protocol.varLongSize((long)this.creation_time_usec_);
                int m = this.header_ != null ? this.header_.size() : 0;
                n += m;
                for (int i = 0; i < m; ++i) {
                    n += this.header_.get(i).encodingSize();
                }
                int this_t0 = this.optional_0_;
                if ((this_t0 & 0xF74) != 0) {
                    if ((this_t0 & 4) != 0) {
                        n += 1 + Protocol.stringSize((int)this.url_.length);
                    }
                    if ((this_t0 & 0x10) != 0) {
                        n += 1 + Protocol.varLongSize((long)this.retry_count_);
                    }
                    if ((this_t0 & 0x20) != 0) {
                        n += 1 + Protocol.varLongSize((long)this.body_size_);
                    }
                    if ((this_t0 & 0x40) != 0) {
                        n += 1 + Protocol.stringSize((int)this.body_.length);
                    }
                    if ((this_t0 & 0x100) != 0) {
                        n += 1 + this.crontimetable_.encodingSize();
                    }
                    if ((this_t0 & 0x200) != 0) {
                        n += 2 + this.runlog_.encodingSize();
                    }
                    if ((this_t0 & 0x400) != 0) {
                        n += 2 + Protocol.stringSize((int)this.description_.length);
                    }
                    if ((this_t0 & 0x800) != 0) {
                        n += 2 + Protocol.stringSize((int)this.payload_.encodingSize());
                    }
                }
                return this.uninterpreted != null ? n + this.uninterpreted.encodingSize() : n;
            }

            public int maxEncodingSize() {
                int n = 62 + this.task_name_.length;
                int m = this.header_ != null ? this.header_.size() : 0;
                n += m;
                for (int i = 0; i < m; ++i) {
                    n += this.header_.get(i).maxEncodingSize();
                }
                int this_t0 = this.optional_0_;
                if ((this_t0 & 0xF44) != 0) {
                    if ((this_t0 & 4) != 0) {
                        n += 6 + this.url_.length;
                    }
                    if ((this_t0 & 0x40) != 0) {
                        n += 6 + this.body_.length;
                    }
                    if ((this_t0 & 0x100) != 0) {
                        n += 1 + this.crontimetable_.maxEncodingSize();
                    }
                    if ((this_t0 & 0x200) != 0) {
                        n += 2 + this.runlog_.maxEncodingSize();
                    }
                    if ((this_t0 & 0x400) != 0) {
                        n += 7 + this.description_.length;
                    }
                    if ((this_t0 & 0x800) != 0) {
                        n += 7 + this.payload_.maxEncodingSize();
                    }
                }
                return this.uninterpreted != null ? n + this.uninterpreted.maxEncodingSize() : n;
            }

            public MessageAppender getMessageAppender() {
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                return this.uninterpreted;
            }

            public void clear() {
                this.optional_0_ = 0;
                this.task_name_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
                this.eta_usec_ = 0L;
                this.url_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
                this.method_ = 0;
                this.retry_count_ = 0;
                if (this.header_ != null) {
                    this.header_.clear();
                }
                this.body_size_ = 0;
                this.body_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
                this.creation_time_usec_ = 0L;
                if (this.crontimetable_ != null) {
                    this.crontimetable_.clear();
                }
                if (this.runlog_ != null) {
                    this.runlog_.clear();
                }
                this.description_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
                if (this.payload_ != null) {
                    this.payload_.clear();
                }
                this.uninterpreted = null;
            }

            public Task newInstance() {
                return new Task();
            }

            public ProtocolType getProtocolType() {
                return StaticHolder.protocolType;
            }

            public void outputTo(ProtocolSink sink) {
                int m;
                sink.putByte((byte)18);
                sink.putPrefixedData(this.task_name_);
                sink.putByte((byte)24);
                sink.putVarLong(this.eta_usec_);
                int this_t0 = this.optional_0_;
                if ((this_t0 & 4) != 0) {
                    sink.putByte((byte)34);
                    sink.putPrefixedData(this.url_);
                }
                sink.putByte((byte)40);
                sink.putVarLong(this.method_);
                if ((this_t0 & 0x10) != 0) {
                    sink.putByte((byte)48);
                    sink.putVarLong(this.retry_count_);
                }
                int n = m = this.header_ != null ? this.header_.size() : 0;
                for (int i = 0; i < m; ++i) {
                    TaskHeader v = this.header_.get(i);
                    sink.putByte((byte)59);
                    v.outputTo(sink);
                }
                if ((this_t0 & 0x20) != 0) {
                    sink.putByte((byte)80);
                    sink.putVarLong(this.body_size_);
                }
                if ((this_t0 & 0x40) != 0) {
                    sink.putByte((byte)90);
                    sink.putPrefixedData(this.body_);
                }
                sink.putByte((byte)96);
                sink.putVarLong(this.creation_time_usec_);
                if ((this_t0 & 0x100) != 0) {
                    sink.putByte((byte)107);
                    this.crontimetable_.outputTo(sink);
                }
                if ((this_t0 & 0x200) != 0) {
                    sink.putByte((byte)-125);
                    sink.putByte((byte)1);
                    this.runlog_.outputTo(sink);
                }
                if ((this_t0 & 0x400) != 0) {
                    sink.putByte((byte)-86);
                    sink.putByte((byte)1);
                    sink.putPrefixedData(this.description_);
                }
                if ((this_t0 & 0x800) != 0) {
                    sink.putByte((byte)-78);
                    sink.putByte((byte)1);
                    sink.putForeign((ProtocolMessage)this.payload_);
                }
                if (this.uninterpreted != null) {
                    this.uninterpreted.put(sink);
                }
                sink.putByte((byte)12);
            }

            public boolean merge(ProtocolSource source) {
                boolean result = true;
                int this_t0 = this.optional_0_;
                block17: while (true) {
                    int tt = source.getVarInt();
                    switch (tt) {
                        case 12: {
                            break block17;
                        }
                        case 0: {
                            result = false;
                            break block17;
                        }
                        case 18: {
                            this.task_name_ = source.getPrefixedData();
                            this_t0 |= 1;
                            continue block17;
                        }
                        case 24: {
                            this.eta_usec_ = source.getVarLong();
                            this_t0 |= 2;
                            continue block17;
                        }
                        case 34: {
                            this.url_ = source.getPrefixedData();
                            this_t0 |= 4;
                            continue block17;
                        }
                        case 40: {
                            this.method_ = source.getVarInt();
                            this_t0 |= 8;
                            continue block17;
                        }
                        case 48: {
                            this.retry_count_ = source.getVarInt();
                            this_t0 |= 0x10;
                            continue block17;
                        }
                        case 59: {
                            if (this.addHeader().merge(source)) continue block17;
                            result = false;
                            break block17;
                        }
                        case 80: {
                            this.body_size_ = source.getVarInt();
                            this_t0 |= 0x20;
                            continue block17;
                        }
                        case 90: {
                            this.body_ = source.getPrefixedData();
                            this_t0 |= 0x40;
                            continue block17;
                        }
                        case 96: {
                            this.creation_time_usec_ = source.getVarLong();
                            this_t0 |= 0x80;
                            continue block17;
                        }
                        case 107: {
                            TaskCronTimetable v13 = this.crontimetable_;
                            if (v13 == null) {
                                this.crontimetable_ = v13 = new TaskCronTimetable();
                            }
                            if (!v13.merge(source)) {
                                result = false;
                                break block17;
                            }
                            this_t0 |= 0x100;
                            continue block17;
                        }
                        case 131: {
                            TaskRunLog v16 = this.runlog_;
                            if (v16 == null) {
                                this.runlog_ = v16 = new TaskRunLog();
                            }
                            if (!v16.merge(source)) {
                                result = false;
                                break block17;
                            }
                            this_t0 |= 0x200;
                            continue block17;
                        }
                        case 170: {
                            this.description_ = source.getPrefixedData();
                            this_t0 |= 0x400;
                            continue block17;
                        }
                        case 178: {
                            source.push(source.getVarInt());
                            MessageSet v22 = this.payload_;
                            if (v22 == null) {
                                this.payload_ = v22 = new MessageSet();
                            }
                            if (!v22.merge(source)) {
                                result = false;
                                break block17;
                            }
                            source.pop();
                            this_t0 |= 0x800;
                            continue block17;
                        }
                        default: {
                            if (this.uninterpreted == null) {
                                this.uninterpreted = new UninterpretedTags();
                            }
                            this.uninterpreted.put((Object)tt, (Object)source.getUninterpreted(tt));
                            continue block17;
                        }
                    }
                    break;
                }
                this.optional_0_ = this_t0;
                return result;
            }

            public Task getDefaultInstanceForType() {
                return IMMUTABLE_DEFAULT_INSTANCE;
            }

            public static final Task getDefaultInstance() {
                return IMMUTABLE_DEFAULT_INSTANCE;
            }

            public Task freeze() {
                this.task_name_ = ProtocolSupport.freezeString((byte[])this.task_name_);
                this.url_ = ProtocolSupport.freezeString((byte[])this.url_);
                this.header_ = ProtocolSupport.freezeMessages(this.header_);
                this.body_ = ProtocolSupport.freezeString((byte[])this.body_);
                if (this.crontimetable_ != null) {
                    this.crontimetable_.freeze();
                }
                if (this.runlog_ != null) {
                    this.runlog_.freeze();
                }
                this.description_ = ProtocolSupport.freezeString((byte[])this.description_);
                if (this.payload_ != null) {
                    this.payload_.freeze();
                }
                return this;
            }

            public Task unfreeze() {
                this.header_ = ProtocolSupport.unfreezeMessages(this.header_);
                if (this.crontimetable_ != null) {
                    this.crontimetable_.unfreeze();
                }
                if (this.runlog_ != null) {
                    this.runlog_.unfreeze();
                }
                if (this.payload_ != null) {
                    this.payload_.unfreeze();
                }
                return this;
            }

            public boolean isFrozen() {
                return ProtocolSupport.isFrozenMessages(this.header_) || this.crontimetable_ != null && this.crontimetable_.isFrozen() || this.runlog_ != null && this.runlog_.isFrozen() || this.payload_ != null && this.payload_.isFrozen();
            }

            private static class StaticHolder {
                private static final ProtocolType protocolType = new ProtocolType(Task.class, null, new ProtocolType.FieldType[]{new ProtocolType.FieldType("task_name", "task_name", 2, 0, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("eta_usec", "eta_usec", 3, 1, ProtocolType.FieldBaseType.INT64, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("url", "url", 4, 2, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("method", "method", 5, 3, ProtocolType.Presence.REQUIRED, RequestMethod.class), new ProtocolType.FieldType("retry_count", "retry_count", 6, 4, ProtocolType.FieldBaseType.INT32, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("Header", "header", 7, -1, ProtocolType.FieldBaseType.GROUP, ProtocolType.Presence.REPEATED, TaskHeader.class), new ProtocolType.FieldType("body_size", "body_size", 10, 5, ProtocolType.FieldBaseType.INT32, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("body", "body", 11, 6, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("creation_time_usec", "creation_time_usec", 12, 7, ProtocolType.FieldBaseType.INT64, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("CronTimetable", "crontimetable", 13, 8, ProtocolType.FieldBaseType.GROUP, ProtocolType.Presence.OPTIONAL, TaskCronTimetable.class), new ProtocolType.FieldType("RunLog", "runlog", 16, 9, ProtocolType.FieldBaseType.GROUP, ProtocolType.Presence.OPTIONAL, TaskRunLog.class), new ProtocolType.FieldType("description", "description", 21, 10, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("payload", "payload", 22, 11, ProtocolType.FieldBaseType.FOREIGN, ProtocolType.Presence.OPTIONAL, MessageSet.class)});

                private StaticHolder() {
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum RequestMethod implements ProtocolMessageEnum
            {
                GET(1),
                POST(2),
                HEAD(3),
                PUT(4),
                DELETE(5);

                public static final RequestMethod RequestMethod_MIN;
                public static final RequestMethod RequestMethod_MAX;
                private final int value;

                public int getValue() {
                    return this.value;
                }

                public static RequestMethod valueOf(int value) {
                    switch (value) {
                        case 1: {
                            return GET;
                        }
                        case 2: {
                            return POST;
                        }
                        case 3: {
                            return HEAD;
                        }
                        case 4: {
                            return PUT;
                        }
                        case 5: {
                            return DELETE;
                        }
                    }
                    return null;
                }

                private RequestMethod(int v) {
                    this.value = v;
                }

                static {
                    RequestMethod_MIN = GET;
                    RequestMethod_MAX = DELETE;
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class TaskRunLog
        extends ProtocolMessage<TaskRunLog> {
            private static final long serialVersionUID = 1L;
            private long dispatched_usec_ = 0L;
            private long lag_usec_ = 0L;
            private long elapsed_usec_ = 0L;
            private long response_code_ = 0L;
            private UninterpretedTags uninterpreted;
            private int optional_0_;
            public static final TaskRunLog IMMUTABLE_DEFAULT_INSTANCE = new TaskRunLog(){
                private static final long serialVersionUID = 1L;

                public TaskRunLog clearDispatchedUsec() {
                    return this;
                }

                public TaskRunLog setDispatchedUsec(long x) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public TaskRunLog clearLagUsec() {
                    return this;
                }

                public TaskRunLog setLagUsec(long x) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public TaskRunLog clearElapsedUsec() {
                    return this;
                }

                public TaskRunLog setElapsedUsec(long x) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public TaskRunLog clearResponseCode() {
                    return this;
                }

                public TaskRunLog setResponseCode(long x) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public TaskRunLog mergeFrom(TaskRunLog that) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public boolean merge(ProtocolSource source) {
                    ProtocolSupport.unsupportedOperation();
                    return false;
                }

                public TaskRunLog freeze() {
                    return this;
                }

                public TaskRunLog unfreeze() {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public boolean isFrozen() {
                    return true;
                }
            };

            public final long getDispatchedUsec() {
                return this.dispatched_usec_;
            }

            public final boolean hasDispatchedUsec() {
                return (this.optional_0_ & 1) != 0;
            }

            public TaskRunLog clearDispatchedUsec() {
                this.optional_0_ &= 0xFFFFFFFE;
                this.dispatched_usec_ = 0L;
                return this;
            }

            public TaskRunLog setDispatchedUsec(long x) {
                this.optional_0_ |= 1;
                this.dispatched_usec_ = x;
                return this;
            }

            public final long getLagUsec() {
                return this.lag_usec_;
            }

            public final boolean hasLagUsec() {
                return (this.optional_0_ & 2) != 0;
            }

            public TaskRunLog clearLagUsec() {
                this.optional_0_ &= 0xFFFFFFFD;
                this.lag_usec_ = 0L;
                return this;
            }

            public TaskRunLog setLagUsec(long x) {
                this.optional_0_ |= 2;
                this.lag_usec_ = x;
                return this;
            }

            public final long getElapsedUsec() {
                return this.elapsed_usec_;
            }

            public final boolean hasElapsedUsec() {
                return (this.optional_0_ & 4) != 0;
            }

            public TaskRunLog clearElapsedUsec() {
                this.optional_0_ &= 0xFFFFFFFB;
                this.elapsed_usec_ = 0L;
                return this;
            }

            public TaskRunLog setElapsedUsec(long x) {
                this.optional_0_ |= 4;
                this.elapsed_usec_ = x;
                return this;
            }

            public final long getResponseCode() {
                return this.response_code_;
            }

            public final boolean hasResponseCode() {
                return (this.optional_0_ & 8) != 0;
            }

            public TaskRunLog clearResponseCode() {
                this.optional_0_ &= 0xFFFFFFF7;
                this.response_code_ = 0L;
                return this;
            }

            public TaskRunLog setResponseCode(long x) {
                this.optional_0_ |= 8;
                this.response_code_ = x;
                return this;
            }

            public TaskRunLog mergeFrom(TaskRunLog that) {
                assert (that != this);
                int this_t0 = this.optional_0_;
                int that_t0 = that.optional_0_;
                if ((that_t0 & 1) != 0) {
                    this_t0 |= 1;
                    this.dispatched_usec_ = that.dispatched_usec_;
                }
                if ((that_t0 & 2) != 0) {
                    this_t0 |= 2;
                    this.lag_usec_ = that.lag_usec_;
                }
                if ((that_t0 & 4) != 0) {
                    this_t0 |= 4;
                    this.elapsed_usec_ = that.elapsed_usec_;
                }
                if ((that_t0 & 8) != 0) {
                    this_t0 |= 8;
                    this.response_code_ = that.response_code_;
                }
                if (that.uninterpreted != null) {
                    if (this.uninterpreted == null) {
                        this.uninterpreted = new UninterpretedTags();
                    }
                    this.uninterpreted.putAll((Multimap)that.uninterpreted);
                }
                this.optional_0_ = this_t0;
                return this;
            }

            public boolean equalsIgnoreUninterpreted(TaskRunLog that) {
                return this.equals(that, true);
            }

            public boolean equals(TaskRunLog that) {
                return this.equals(that, false);
            }

            public boolean equals(TaskRunLog that, boolean ignoreUninterpreted) {
                if (that == null) {
                    return false;
                }
                if (that == this) {
                    return true;
                }
                int this_t0 = this.optional_0_;
                int that_t0 = that.optional_0_;
                if (this_t0 != that_t0) {
                    return false;
                }
                if ((this_t0 & 1) != 0 && this.dispatched_usec_ != that.dispatched_usec_) {
                    return false;
                }
                if ((this_t0 & 2) != 0 && this.lag_usec_ != that.lag_usec_) {
                    return false;
                }
                if ((this_t0 & 4) != 0 && this.elapsed_usec_ != that.elapsed_usec_) {
                    return false;
                }
                if ((this_t0 & 8) != 0 && this.response_code_ != that.response_code_) {
                    return false;
                }
                return ignoreUninterpreted || UninterpretedTags.equivalent((UninterpretedTags)this.uninterpreted, (UninterpretedTags)that.uninterpreted);
            }

            public boolean equals(Object that) {
                return that instanceof TaskRunLog && this.equals((TaskRunLog)((Object)that));
            }

            public int hashCode() {
                int hash = 149994214;
                int this_t0 = this.optional_0_;
                hash = hash * 31 + ((this_t0 & 1) != 0 ? ProtocolSupport.hashCode((long)this.dispatched_usec_) : -113);
                hash = hash * 31 + ((this_t0 & 2) != 0 ? ProtocolSupport.hashCode((long)this.lag_usec_) : -113);
                hash = hash * 31 + ((this_t0 & 4) != 0 ? ProtocolSupport.hashCode((long)this.elapsed_usec_) : -113);
                hash = hash * 31 + ((this_t0 & 8) != 0 ? ProtocolSupport.hashCode((long)this.response_code_) : -113);
                if (this.uninterpreted != null && !this.uninterpreted.isEmpty()) {
                    hash = hash * 31 + this.uninterpreted.hashCode();
                }
                return hash;
            }

            public boolean isInitialized() {
                int this_t0 = this.optional_0_;
                if ((this_t0 & 7) != 7) {
                    if ((this_t0 & 1) == 0) {
                        return false;
                    }
                    if ((this_t0 & 2) == 0) {
                        return false;
                    }
                    return false;
                }
                return true;
            }

            public int encodingSize() {
                int n = 8 + Protocol.varLongSize((long)this.dispatched_usec_) + Protocol.varLongSize((long)this.lag_usec_) + Protocol.varLongSize((long)this.elapsed_usec_);
                int this_t0 = this.optional_0_;
                if ((this_t0 & 8) != 0) {
                    n += 2 + Protocol.varLongSize((long)this.response_code_);
                }
                return this.uninterpreted != null ? n + this.uninterpreted.encodingSize() : n;
            }

            public int maxEncodingSize() {
                int n = 50;
                return this.uninterpreted != null ? n + this.uninterpreted.maxEncodingSize() : n;
            }

            public MessageAppender getMessageAppender() {
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                return this.uninterpreted;
            }

            public void clear() {
                this.optional_0_ = 0;
                this.dispatched_usec_ = 0L;
                this.lag_usec_ = 0L;
                this.elapsed_usec_ = 0L;
                this.response_code_ = 0L;
                this.uninterpreted = null;
            }

            public TaskRunLog newInstance() {
                return new TaskRunLog();
            }

            public ProtocolType getProtocolType() {
                return StaticHolder.protocolType;
            }

            public void outputTo(ProtocolSink sink) {
                sink.putByte((byte)-120);
                sink.putByte((byte)1);
                sink.putVarLong(this.dispatched_usec_);
                sink.putByte((byte)-112);
                sink.putByte((byte)1);
                sink.putVarLong(this.lag_usec_);
                sink.putByte((byte)-104);
                sink.putByte((byte)1);
                sink.putVarLong(this.elapsed_usec_);
                int this_t0 = this.optional_0_;
                if ((this_t0 & 8) != 0) {
                    sink.putByte((byte)-96);
                    sink.putByte((byte)1);
                    sink.putVarLong(this.response_code_);
                }
                if (this.uninterpreted != null) {
                    this.uninterpreted.put(sink);
                }
                sink.putByte((byte)-124);
                sink.putByte((byte)1);
            }

            public boolean merge(ProtocolSource source) {
                boolean result = true;
                int this_t0 = this.optional_0_;
                block8: while (true) {
                    int tt = source.getVarInt();
                    switch (tt) {
                        case 132: {
                            break block8;
                        }
                        case 0: {
                            result = false;
                            break block8;
                        }
                        case 136: {
                            this.dispatched_usec_ = source.getVarLong();
                            this_t0 |= 1;
                            continue block8;
                        }
                        case 144: {
                            this.lag_usec_ = source.getVarLong();
                            this_t0 |= 2;
                            continue block8;
                        }
                        case 152: {
                            this.elapsed_usec_ = source.getVarLong();
                            this_t0 |= 4;
                            continue block8;
                        }
                        case 160: {
                            this.response_code_ = source.getVarLong();
                            this_t0 |= 8;
                            continue block8;
                        }
                        default: {
                            if (this.uninterpreted == null) {
                                this.uninterpreted = new UninterpretedTags();
                            }
                            this.uninterpreted.put((Object)tt, (Object)source.getUninterpreted(tt));
                            continue block8;
                        }
                    }
                    break;
                }
                this.optional_0_ = this_t0;
                return result;
            }

            public TaskRunLog getDefaultInstanceForType() {
                return IMMUTABLE_DEFAULT_INSTANCE;
            }

            public static final TaskRunLog getDefaultInstance() {
                return IMMUTABLE_DEFAULT_INSTANCE;
            }

            private static class StaticHolder {
                private static final ProtocolType protocolType = new ProtocolType(TaskRunLog.class, null, new ProtocolType.FieldType[]{new ProtocolType.FieldType("dispatched_usec", "dispatched_usec", 17, 0, ProtocolType.FieldBaseType.INT64, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("lag_usec", "lag_usec", 18, 1, ProtocolType.FieldBaseType.INT64, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("elapsed_usec", "elapsed_usec", 19, 2, ProtocolType.FieldBaseType.INT64, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("response_code", "response_code", 20, 3, ProtocolType.FieldBaseType.INT64, ProtocolType.Presence.OPTIONAL)});

                private StaticHolder() {
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class TaskCronTimetable
        extends ProtocolMessage<TaskCronTimetable> {
            private static final long serialVersionUID = 1L;
            private byte[] schedule_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            private byte[] timezone_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            private UninterpretedTags uninterpreted;
            private int optional_0_;
            public static final TaskCronTimetable IMMUTABLE_DEFAULT_INSTANCE = new TaskCronTimetable(){
                private static final long serialVersionUID = 1L;

                public TaskCronTimetable clearSchedule() {
                    return this;
                }

                public TaskCronTimetable setScheduleAsBytes(byte[] x) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public TaskCronTimetable setSchedule(String v) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public TaskCronTimetable setSchedule(String v, Charset cs) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public TaskCronTimetable clearTimezone() {
                    return this;
                }

                public TaskCronTimetable setTimezoneAsBytes(byte[] x) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public TaskCronTimetable setTimezone(String v) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public TaskCronTimetable setTimezone(String v, Charset cs) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public TaskCronTimetable mergeFrom(TaskCronTimetable that) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public boolean merge(ProtocolSource source) {
                    ProtocolSupport.unsupportedOperation();
                    return false;
                }

                public TaskCronTimetable freeze() {
                    return this;
                }

                public TaskCronTimetable unfreeze() {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public boolean isFrozen() {
                    return true;
                }
            };

            public final byte[] getScheduleAsBytes() {
                return this.schedule_;
            }

            public final boolean hasSchedule() {
                return (this.optional_0_ & 1) != 0;
            }

            public TaskCronTimetable clearSchedule() {
                this.optional_0_ &= 0xFFFFFFFE;
                this.schedule_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
                return this;
            }

            public TaskCronTimetable setScheduleAsBytes(byte[] x) {
                this.optional_0_ |= 1;
                this.schedule_ = x;
                return this;
            }

            public final String getSchedule() {
                return ProtocolSupport.toStringUtf8((byte[])this.schedule_);
            }

            public TaskCronTimetable setSchedule(String v) {
                if (v == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 1;
                this.schedule_ = ProtocolSupport.toBytesUtf8((String)v);
                return this;
            }

            public final String getSchedule(Charset cs) {
                return ProtocolSupport.toString((byte[])this.schedule_, (Charset)cs);
            }

            public TaskCronTimetable setSchedule(String v, Charset cs) {
                if (v == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 1;
                this.schedule_ = ProtocolSupport.toBytes((String)v, (Charset)cs);
                return this;
            }

            public final byte[] getTimezoneAsBytes() {
                return this.timezone_;
            }

            public final boolean hasTimezone() {
                return (this.optional_0_ & 2) != 0;
            }

            public TaskCronTimetable clearTimezone() {
                this.optional_0_ &= 0xFFFFFFFD;
                this.timezone_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
                return this;
            }

            public TaskCronTimetable setTimezoneAsBytes(byte[] x) {
                this.optional_0_ |= 2;
                this.timezone_ = x;
                return this;
            }

            public final String getTimezone() {
                return ProtocolSupport.toStringUtf8((byte[])this.timezone_);
            }

            public TaskCronTimetable setTimezone(String v) {
                if (v == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 2;
                this.timezone_ = ProtocolSupport.toBytesUtf8((String)v);
                return this;
            }

            public final String getTimezone(Charset cs) {
                return ProtocolSupport.toString((byte[])this.timezone_, (Charset)cs);
            }

            public TaskCronTimetable setTimezone(String v, Charset cs) {
                if (v == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 2;
                this.timezone_ = ProtocolSupport.toBytes((String)v, (Charset)cs);
                return this;
            }

            public TaskCronTimetable mergeFrom(TaskCronTimetable that) {
                assert (that != this);
                int this_t0 = this.optional_0_;
                int that_t0 = that.optional_0_;
                if ((that_t0 & 1) != 0) {
                    this_t0 |= 1;
                    this.schedule_ = that.schedule_;
                }
                if ((that_t0 & 2) != 0) {
                    this_t0 |= 2;
                    this.timezone_ = that.timezone_;
                }
                if (that.uninterpreted != null) {
                    if (this.uninterpreted == null) {
                        this.uninterpreted = new UninterpretedTags();
                    }
                    this.uninterpreted.putAll((Multimap)that.uninterpreted);
                }
                this.optional_0_ = this_t0;
                return this;
            }

            public boolean equalsIgnoreUninterpreted(TaskCronTimetable that) {
                return this.equals(that, true);
            }

            public boolean equals(TaskCronTimetable that) {
                return this.equals(that, false);
            }

            public boolean equals(TaskCronTimetable that, boolean ignoreUninterpreted) {
                if (that == null) {
                    return false;
                }
                if (that == this) {
                    return true;
                }
                int this_t0 = this.optional_0_;
                int that_t0 = that.optional_0_;
                if (this_t0 != that_t0) {
                    return false;
                }
                if ((this_t0 & 1) != 0 && !Arrays.equals(this.schedule_, that.schedule_)) {
                    return false;
                }
                if ((this_t0 & 2) != 0 && !Arrays.equals(this.timezone_, that.timezone_)) {
                    return false;
                }
                return ignoreUninterpreted || UninterpretedTags.equivalent((UninterpretedTags)this.uninterpreted, (UninterpretedTags)that.uninterpreted);
            }

            public boolean equals(Object that) {
                return that instanceof TaskCronTimetable && this.equals((TaskCronTimetable)((Object)that));
            }

            public int hashCode() {
                int hash = -901650356;
                int this_t0 = this.optional_0_;
                hash = hash * 31 + ((this_t0 & 1) != 0 ? Arrays.hashCode(this.schedule_) : -113);
                hash = hash * 31 + ((this_t0 & 2) != 0 ? Arrays.hashCode(this.timezone_) : -113);
                if (this.uninterpreted != null && !this.uninterpreted.isEmpty()) {
                    hash = hash * 31 + this.uninterpreted.hashCode();
                }
                return hash;
            }

            public boolean isInitialized() {
                int this_t0 = this.optional_0_;
                if ((this_t0 & 3) != 3) {
                    if ((this_t0 & 1) == 0) {
                        return false;
                    }
                    return false;
                }
                return true;
            }

            public int encodingSize() {
                int n = 3 + Protocol.stringSize((int)this.schedule_.length) + Protocol.stringSize((int)this.timezone_.length);
                return this.uninterpreted != null ? n + this.uninterpreted.encodingSize() : n;
            }

            public int maxEncodingSize() {
                int n = 13 + this.schedule_.length + this.timezone_.length;
                return this.uninterpreted != null ? n + this.uninterpreted.maxEncodingSize() : n;
            }

            public MessageAppender getMessageAppender() {
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                return this.uninterpreted;
            }

            public void clear() {
                this.optional_0_ = 0;
                this.schedule_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
                this.timezone_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
                this.uninterpreted = null;
            }

            public TaskCronTimetable newInstance() {
                return new TaskCronTimetable();
            }

            public ProtocolType getProtocolType() {
                return StaticHolder.protocolType;
            }

            public void outputTo(ProtocolSink sink) {
                sink.putByte((byte)114);
                sink.putPrefixedData(this.schedule_);
                sink.putByte((byte)122);
                sink.putPrefixedData(this.timezone_);
                if (this.uninterpreted != null) {
                    this.uninterpreted.put(sink);
                }
                sink.putByte((byte)108);
            }

            public boolean merge(ProtocolSource source) {
                boolean result = true;
                int this_t0 = this.optional_0_;
                block6: while (true) {
                    int tt = source.getVarInt();
                    switch (tt) {
                        case 108: {
                            break block6;
                        }
                        case 0: {
                            result = false;
                            break block6;
                        }
                        case 114: {
                            this.schedule_ = source.getPrefixedData();
                            this_t0 |= 1;
                            continue block6;
                        }
                        case 122: {
                            this.timezone_ = source.getPrefixedData();
                            this_t0 |= 2;
                            continue block6;
                        }
                        default: {
                            if (this.uninterpreted == null) {
                                this.uninterpreted = new UninterpretedTags();
                            }
                            this.uninterpreted.put((Object)tt, (Object)source.getUninterpreted(tt));
                            continue block6;
                        }
                    }
                    break;
                }
                this.optional_0_ = this_t0;
                return result;
            }

            public TaskCronTimetable getDefaultInstanceForType() {
                return IMMUTABLE_DEFAULT_INSTANCE;
            }

            public static final TaskCronTimetable getDefaultInstance() {
                return IMMUTABLE_DEFAULT_INSTANCE;
            }

            public TaskCronTimetable freeze() {
                this.schedule_ = ProtocolSupport.freezeString((byte[])this.schedule_);
                this.timezone_ = ProtocolSupport.freezeString((byte[])this.timezone_);
                return this;
            }

            private static class StaticHolder {
                private static final ProtocolType protocolType = new ProtocolType(TaskCronTimetable.class, null, new ProtocolType.FieldType[]{new ProtocolType.FieldType("schedule", "schedule", 14, 0, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("timezone", "timezone", 15, 1, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED)});

                private StaticHolder() {
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class TaskHeader
        extends ProtocolMessage<TaskHeader> {
            private static final long serialVersionUID = 1L;
            private byte[] key_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            private byte[] value_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            private UninterpretedTags uninterpreted;
            private int optional_0_;
            public static final TaskHeader IMMUTABLE_DEFAULT_INSTANCE = new TaskHeader(){
                private static final long serialVersionUID = 1L;

                public TaskHeader clearKey() {
                    return this;
                }

                public TaskHeader setKeyAsBytes(byte[] x) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public TaskHeader setKey(String v) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public TaskHeader setKey(String v, Charset cs) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public TaskHeader clearValue() {
                    return this;
                }

                public TaskHeader setValueAsBytes(byte[] x) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public TaskHeader setValue(String v) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public TaskHeader setValue(String v, Charset cs) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public TaskHeader mergeFrom(TaskHeader that) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public boolean merge(ProtocolSource source) {
                    ProtocolSupport.unsupportedOperation();
                    return false;
                }

                public TaskHeader freeze() {
                    return this;
                }

                public TaskHeader unfreeze() {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public boolean isFrozen() {
                    return true;
                }
            };

            public final byte[] getKeyAsBytes() {
                return this.key_;
            }

            public final boolean hasKey() {
                return (this.optional_0_ & 1) != 0;
            }

            public TaskHeader clearKey() {
                this.optional_0_ &= 0xFFFFFFFE;
                this.key_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
                return this;
            }

            public TaskHeader setKeyAsBytes(byte[] x) {
                this.optional_0_ |= 1;
                this.key_ = x;
                return this;
            }

            public final String getKey() {
                return ProtocolSupport.toStringUtf8((byte[])this.key_);
            }

            public TaskHeader setKey(String v) {
                if (v == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 1;
                this.key_ = ProtocolSupport.toBytesUtf8((String)v);
                return this;
            }

            public final String getKey(Charset cs) {
                return ProtocolSupport.toString((byte[])this.key_, (Charset)cs);
            }

            public TaskHeader setKey(String v, Charset cs) {
                if (v == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 1;
                this.key_ = ProtocolSupport.toBytes((String)v, (Charset)cs);
                return this;
            }

            public final byte[] getValueAsBytes() {
                return this.value_;
            }

            public final boolean hasValue() {
                return (this.optional_0_ & 2) != 0;
            }

            public TaskHeader clearValue() {
                this.optional_0_ &= 0xFFFFFFFD;
                this.value_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
                return this;
            }

            public TaskHeader setValueAsBytes(byte[] x) {
                this.optional_0_ |= 2;
                this.value_ = x;
                return this;
            }

            public final String getValue() {
                return ProtocolSupport.toStringUtf8((byte[])this.value_);
            }

            public TaskHeader setValue(String v) {
                if (v == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 2;
                this.value_ = ProtocolSupport.toBytesUtf8((String)v);
                return this;
            }

            public final String getValue(Charset cs) {
                return ProtocolSupport.toString((byte[])this.value_, (Charset)cs);
            }

            public TaskHeader setValue(String v, Charset cs) {
                if (v == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 2;
                this.value_ = ProtocolSupport.toBytes((String)v, (Charset)cs);
                return this;
            }

            public TaskHeader mergeFrom(TaskHeader that) {
                assert (that != this);
                int this_t0 = this.optional_0_;
                int that_t0 = that.optional_0_;
                if ((that_t0 & 1) != 0) {
                    this_t0 |= 1;
                    this.key_ = that.key_;
                }
                if ((that_t0 & 2) != 0) {
                    this_t0 |= 2;
                    this.value_ = that.value_;
                }
                if (that.uninterpreted != null) {
                    if (this.uninterpreted == null) {
                        this.uninterpreted = new UninterpretedTags();
                    }
                    this.uninterpreted.putAll((Multimap)that.uninterpreted);
                }
                this.optional_0_ = this_t0;
                return this;
            }

            public boolean equalsIgnoreUninterpreted(TaskHeader that) {
                return this.equals(that, true);
            }

            public boolean equals(TaskHeader that) {
                return this.equals(that, false);
            }

            public boolean equals(TaskHeader that, boolean ignoreUninterpreted) {
                if (that == null) {
                    return false;
                }
                if (that == this) {
                    return true;
                }
                int this_t0 = this.optional_0_;
                int that_t0 = that.optional_0_;
                if (this_t0 != that_t0) {
                    return false;
                }
                if ((this_t0 & 1) != 0 && !Arrays.equals(this.key_, that.key_)) {
                    return false;
                }
                if ((this_t0 & 2) != 0 && !Arrays.equals(this.value_, that.value_)) {
                    return false;
                }
                return ignoreUninterpreted || UninterpretedTags.equivalent((UninterpretedTags)this.uninterpreted, (UninterpretedTags)that.uninterpreted);
            }

            public boolean equals(Object that) {
                return that instanceof TaskHeader && this.equals((TaskHeader)((Object)that));
            }

            public int hashCode() {
                int hash = 1840909783;
                int this_t0 = this.optional_0_;
                hash = hash * 31 + ((this_t0 & 1) != 0 ? Arrays.hashCode(this.key_) : -113);
                hash = hash * 31 + ((this_t0 & 2) != 0 ? Arrays.hashCode(this.value_) : -113);
                if (this.uninterpreted != null && !this.uninterpreted.isEmpty()) {
                    hash = hash * 31 + this.uninterpreted.hashCode();
                }
                return hash;
            }

            public boolean isInitialized() {
                int this_t0 = this.optional_0_;
                if ((this_t0 & 3) != 3) {
                    if ((this_t0 & 1) == 0) {
                        return false;
                    }
                    return false;
                }
                return true;
            }

            public int encodingSize() {
                int n = 3 + Protocol.stringSize((int)this.key_.length) + Protocol.stringSize((int)this.value_.length);
                return this.uninterpreted != null ? n + this.uninterpreted.encodingSize() : n;
            }

            public int maxEncodingSize() {
                int n = 13 + this.key_.length + this.value_.length;
                return this.uninterpreted != null ? n + this.uninterpreted.maxEncodingSize() : n;
            }

            public MessageAppender getMessageAppender() {
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                return this.uninterpreted;
            }

            public void clear() {
                this.optional_0_ = 0;
                this.key_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
                this.value_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
                this.uninterpreted = null;
            }

            public TaskHeader newInstance() {
                return new TaskHeader();
            }

            public ProtocolType getProtocolType() {
                return StaticHolder.protocolType;
            }

            public void outputTo(ProtocolSink sink) {
                sink.putByte((byte)66);
                sink.putPrefixedData(this.key_);
                sink.putByte((byte)74);
                sink.putPrefixedData(this.value_);
                if (this.uninterpreted != null) {
                    this.uninterpreted.put(sink);
                }
                sink.putByte((byte)60);
            }

            public boolean merge(ProtocolSource source) {
                boolean result = true;
                int this_t0 = this.optional_0_;
                block6: while (true) {
                    int tt = source.getVarInt();
                    switch (tt) {
                        case 60: {
                            break block6;
                        }
                        case 0: {
                            result = false;
                            break block6;
                        }
                        case 66: {
                            this.key_ = source.getPrefixedData();
                            this_t0 |= 1;
                            continue block6;
                        }
                        case 74: {
                            this.value_ = source.getPrefixedData();
                            this_t0 |= 2;
                            continue block6;
                        }
                        default: {
                            if (this.uninterpreted == null) {
                                this.uninterpreted = new UninterpretedTags();
                            }
                            this.uninterpreted.put((Object)tt, (Object)source.getUninterpreted(tt));
                            continue block6;
                        }
                    }
                    break;
                }
                this.optional_0_ = this_t0;
                return result;
            }

            public TaskHeader getDefaultInstanceForType() {
                return IMMUTABLE_DEFAULT_INSTANCE;
            }

            public static final TaskHeader getDefaultInstance() {
                return IMMUTABLE_DEFAULT_INSTANCE;
            }

            public TaskHeader freeze() {
                this.key_ = ProtocolSupport.freezeString((byte[])this.key_);
                this.value_ = ProtocolSupport.freezeString((byte[])this.value_);
                return this;
            }

            private static class StaticHolder {
                private static final ProtocolType protocolType = new ProtocolType(TaskHeader.class, null, new ProtocolType.FieldType[]{new ProtocolType.FieldType("key", "key", 8, 0, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("value", "value", 9, 1, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED)});

                private StaticHolder() {
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TaskQueueQueryTasksRequest
    extends ProtocolMessage<TaskQueueQueryTasksRequest> {
        private static final long serialVersionUID = 1L;
        private byte[] app_id_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private byte[] queue_name_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private byte[] start_task_name_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private long start_eta_usec_ = 0L;
        private int max_rows_ = 1;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final TaskQueueQueryTasksRequest IMMUTABLE_DEFAULT_INSTANCE = new TaskQueueQueryTasksRequest(){
            private static final long serialVersionUID = 1L;

            public TaskQueueQueryTasksRequest clearAppId() {
                return this;
            }

            public TaskQueueQueryTasksRequest setAppIdAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueQueryTasksRequest setAppId(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueQueryTasksRequest setAppId(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueQueryTasksRequest clearQueueName() {
                return this;
            }

            public TaskQueueQueryTasksRequest setQueueNameAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueQueryTasksRequest setQueueName(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueQueryTasksRequest setQueueName(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueQueryTasksRequest clearStartTaskName() {
                return this;
            }

            public TaskQueueQueryTasksRequest setStartTaskNameAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueQueryTasksRequest setStartTaskName(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueQueryTasksRequest setStartTaskName(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueQueryTasksRequest clearStartEtaUsec() {
                return this;
            }

            public TaskQueueQueryTasksRequest setStartEtaUsec(long x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueQueryTasksRequest clearMaxRows() {
                return this;
            }

            public TaskQueueQueryTasksRequest setMaxRows(int x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueQueryTasksRequest mergeFrom(TaskQueueQueryTasksRequest that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public TaskQueueQueryTasksRequest freeze() {
                return this;
            }

            public TaskQueueQueryTasksRequest unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kapp_id = 1;
        public static final int kqueue_name = 2;
        public static final int kstart_task_name = 3;
        public static final int kstart_eta_usec = 4;
        public static final int kmax_rows = 5;
        public static final String[] text = new String[6];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final byte[] getAppIdAsBytes() {
            return this.app_id_;
        }

        public final boolean hasAppId() {
            return (this.optional_0_ & 1) != 0;
        }

        public TaskQueueQueryTasksRequest clearAppId() {
            this.optional_0_ &= 0xFFFFFFFE;
            this.app_id_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public TaskQueueQueryTasksRequest setAppIdAsBytes(byte[] x) {
            this.optional_0_ |= 1;
            this.app_id_ = x;
            return this;
        }

        public final String getAppId() {
            return ProtocolSupport.toStringUtf8((byte[])this.app_id_);
        }

        public TaskQueueQueryTasksRequest setAppId(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.app_id_ = ProtocolSupport.toBytesUtf8((String)v);
            return this;
        }

        public final String getAppId(Charset cs) {
            return ProtocolSupport.toString((byte[])this.app_id_, (Charset)cs);
        }

        public TaskQueueQueryTasksRequest setAppId(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.app_id_ = ProtocolSupport.toBytes((String)v, (Charset)cs);
            return this;
        }

        public final byte[] getQueueNameAsBytes() {
            return this.queue_name_;
        }

        public final boolean hasQueueName() {
            return (this.optional_0_ & 2) != 0;
        }

        public TaskQueueQueryTasksRequest clearQueueName() {
            this.optional_0_ &= 0xFFFFFFFD;
            this.queue_name_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public TaskQueueQueryTasksRequest setQueueNameAsBytes(byte[] x) {
            this.optional_0_ |= 2;
            this.queue_name_ = x;
            return this;
        }

        public final String getQueueName() {
            return ProtocolSupport.toStringUtf8((byte[])this.queue_name_);
        }

        public TaskQueueQueryTasksRequest setQueueName(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 2;
            this.queue_name_ = ProtocolSupport.toBytesUtf8((String)v);
            return this;
        }

        public final String getQueueName(Charset cs) {
            return ProtocolSupport.toString((byte[])this.queue_name_, (Charset)cs);
        }

        public TaskQueueQueryTasksRequest setQueueName(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 2;
            this.queue_name_ = ProtocolSupport.toBytes((String)v, (Charset)cs);
            return this;
        }

        public final byte[] getStartTaskNameAsBytes() {
            return this.start_task_name_;
        }

        public final boolean hasStartTaskName() {
            return (this.optional_0_ & 4) != 0;
        }

        public TaskQueueQueryTasksRequest clearStartTaskName() {
            this.optional_0_ &= 0xFFFFFFFB;
            this.start_task_name_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public TaskQueueQueryTasksRequest setStartTaskNameAsBytes(byte[] x) {
            this.optional_0_ |= 4;
            this.start_task_name_ = x;
            return this;
        }

        public final String getStartTaskName() {
            return ProtocolSupport.toStringUtf8((byte[])this.start_task_name_);
        }

        public TaskQueueQueryTasksRequest setStartTaskName(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 4;
            this.start_task_name_ = ProtocolSupport.toBytesUtf8((String)v);
            return this;
        }

        public final String getStartTaskName(Charset cs) {
            return ProtocolSupport.toString((byte[])this.start_task_name_, (Charset)cs);
        }

        public TaskQueueQueryTasksRequest setStartTaskName(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 4;
            this.start_task_name_ = ProtocolSupport.toBytes((String)v, (Charset)cs);
            return this;
        }

        public final long getStartEtaUsec() {
            return this.start_eta_usec_;
        }

        public final boolean hasStartEtaUsec() {
            return (this.optional_0_ & 8) != 0;
        }

        public TaskQueueQueryTasksRequest clearStartEtaUsec() {
            this.optional_0_ &= 0xFFFFFFF7;
            this.start_eta_usec_ = 0L;
            return this;
        }

        public TaskQueueQueryTasksRequest setStartEtaUsec(long x) {
            this.optional_0_ |= 8;
            this.start_eta_usec_ = x;
            return this;
        }

        public final int getMaxRows() {
            return this.max_rows_;
        }

        public final boolean hasMaxRows() {
            return (this.optional_0_ & 0x10) != 0;
        }

        public TaskQueueQueryTasksRequest clearMaxRows() {
            this.optional_0_ &= 0xFFFFFFEF;
            this.max_rows_ = 1;
            return this;
        }

        public TaskQueueQueryTasksRequest setMaxRows(int x) {
            this.optional_0_ |= 0x10;
            this.max_rows_ = x;
            return this;
        }

        public TaskQueueQueryTasksRequest mergeFrom(TaskQueueQueryTasksRequest that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                this.app_id_ = that.app_id_;
            }
            if ((that_t0 & 2) != 0) {
                this_t0 |= 2;
                this.queue_name_ = that.queue_name_;
            }
            if ((that_t0 & 4) != 0) {
                this_t0 |= 4;
                this.start_task_name_ = that.start_task_name_;
            }
            if ((that_t0 & 8) != 0) {
                this_t0 |= 8;
                this.start_eta_usec_ = that.start_eta_usec_;
            }
            if ((that_t0 & 0x10) != 0) {
                this_t0 |= 0x10;
                this.max_rows_ = that.max_rows_;
            }
            if (that.uninterpreted != null) {
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll((Multimap)that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        public boolean equalsIgnoreUninterpreted(TaskQueueQueryTasksRequest that) {
            return this.equals(that, true);
        }

        public boolean equals(TaskQueueQueryTasksRequest that) {
            return this.equals(that, false);
        }

        public boolean equals(TaskQueueQueryTasksRequest that, boolean ignoreUninterpreted) {
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (this_t0 != that_t0) {
                return false;
            }
            if ((this_t0 & 1) != 0 && !Arrays.equals(this.app_id_, that.app_id_)) {
                return false;
            }
            if ((this_t0 & 2) != 0 && !Arrays.equals(this.queue_name_, that.queue_name_)) {
                return false;
            }
            if ((this_t0 & 4) != 0 && !Arrays.equals(this.start_task_name_, that.start_task_name_)) {
                return false;
            }
            if ((this_t0 & 8) != 0 && this.start_eta_usec_ != that.start_eta_usec_) {
                return false;
            }
            if ((this_t0 & 0x10) != 0 && this.max_rows_ != that.max_rows_) {
                return false;
            }
            return ignoreUninterpreted || UninterpretedTags.equivalent((UninterpretedTags)this.uninterpreted, (UninterpretedTags)that.uninterpreted);
        }

        public boolean equals(Object that) {
            return that instanceof TaskQueueQueryTasksRequest && this.equals((TaskQueueQueryTasksRequest)((Object)that));
        }

        public int hashCode() {
            int hash = 824741228;
            int this_t0 = this.optional_0_;
            hash = hash * 31 + ((this_t0 & 1) != 0 ? Arrays.hashCode(this.app_id_) : -113);
            hash = hash * 31 + ((this_t0 & 2) != 0 ? Arrays.hashCode(this.queue_name_) : -113);
            hash = hash * 31 + ((this_t0 & 4) != 0 ? Arrays.hashCode(this.start_task_name_) : -113);
            hash = hash * 31 + ((this_t0 & 8) != 0 ? ProtocolSupport.hashCode((long)this.start_eta_usec_) : -113);
            hash = hash * 31 + ((this_t0 & 0x10) != 0 ? this.max_rows_ : -113);
            if (this.uninterpreted != null && !this.uninterpreted.isEmpty()) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        public boolean isInitialized() {
            int this_t0 = this.optional_0_;
            if ((this_t0 & 3) != 3) {
                if ((this_t0 & 1) == 0) {
                    return false;
                }
                return false;
            }
            return true;
        }

        public int encodingSize() {
            int n = 2 + Protocol.stringSize((int)this.app_id_.length) + Protocol.stringSize((int)this.queue_name_.length);
            int this_t0 = this.optional_0_;
            if ((this_t0 & 0x1C) != 0) {
                if ((this_t0 & 4) != 0) {
                    n += 1 + Protocol.stringSize((int)this.start_task_name_.length);
                }
                if ((this_t0 & 8) != 0) {
                    n += 1 + Protocol.varLongSize((long)this.start_eta_usec_);
                }
                if ((this_t0 & 0x10) != 0) {
                    n += 1 + Protocol.varLongSize((long)this.max_rows_);
                }
            }
            return this.uninterpreted != null ? n + this.uninterpreted.encodingSize() : n;
        }

        public int maxEncodingSize() {
            int n = 34 + this.app_id_.length + this.queue_name_.length;
            int this_t0 = this.optional_0_;
            if ((this_t0 & 4) != 0) {
                n += 6 + this.start_task_name_.length;
            }
            return this.uninterpreted != null ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        public void clear() {
            this.optional_0_ = 0;
            this.app_id_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.queue_name_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.start_task_name_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.start_eta_usec_ = 0L;
            this.max_rows_ = 1;
            this.uninterpreted = null;
        }

        public TaskQueueQueryTasksRequest newInstance() {
            return new TaskQueueQueryTasksRequest();
        }

        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        public void outputTo(ProtocolSink sink) {
            sink.putByte((byte)10);
            sink.putPrefixedData(this.app_id_);
            sink.putByte((byte)18);
            sink.putPrefixedData(this.queue_name_);
            int this_t0 = this.optional_0_;
            if ((this_t0 & 4) != 0) {
                sink.putByte((byte)26);
                sink.putPrefixedData(this.start_task_name_);
            }
            if ((this_t0 & 8) != 0) {
                sink.putByte((byte)32);
                sink.putVarLong(this.start_eta_usec_);
            }
            if ((this_t0 & 0x10) != 0) {
                sink.putByte((byte)40);
                sink.putVarLong(this.max_rows_);
            }
            if (this.uninterpreted != null) {
                this.uninterpreted.put(sink);
            }
        }

        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block8: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block8;
                    }
                    case 10: {
                        this.app_id_ = source.getPrefixedData();
                        this_t0 |= 1;
                        continue block8;
                    }
                    case 18: {
                        this.queue_name_ = source.getPrefixedData();
                        this_t0 |= 2;
                        continue block8;
                    }
                    case 26: {
                        this.start_task_name_ = source.getPrefixedData();
                        this_t0 |= 4;
                        continue block8;
                    }
                    case 32: {
                        this.start_eta_usec_ = source.getVarLong();
                        this_t0 |= 8;
                        continue block8;
                    }
                    case 40: {
                        this.max_rows_ = source.getVarInt();
                        this_t0 |= 0x10;
                        continue block8;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put((Object)tt, (Object)source.getUninterpreted(tt));
                        continue block8;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        public TaskQueueQueryTasksRequest getDefaultInstanceForType() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public static final TaskQueueQueryTasksRequest getDefaultInstance() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public TaskQueueQueryTasksRequest freeze() {
            this.app_id_ = ProtocolSupport.freezeString((byte[])this.app_id_);
            this.queue_name_ = ProtocolSupport.freezeString((byte[])this.queue_name_);
            this.start_task_name_ = ProtocolSupport.freezeString((byte[])this.start_task_name_);
            return this;
        }

        static {
            TaskQueueQueryTasksRequest.text[0] = "ErrorCode";
            TaskQueueQueryTasksRequest.text[1] = "app_id";
            TaskQueueQueryTasksRequest.text[2] = "queue_name";
            TaskQueueQueryTasksRequest.text[3] = "start_task_name";
            TaskQueueQueryTasksRequest.text[4] = "start_eta_usec";
            TaskQueueQueryTasksRequest.text[5] = "max_rows";
            types = new int[6];
            Arrays.fill(types, 6);
            TaskQueueQueryTasksRequest.types[0] = 0;
            TaskQueueQueryTasksRequest.types[1] = 2;
            TaskQueueQueryTasksRequest.types[2] = 2;
            TaskQueueQueryTasksRequest.types[3] = 2;
            TaskQueueQueryTasksRequest.types[4] = 0;
            TaskQueueQueryTasksRequest.types[5] = 0;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(TaskQueueQueryTasksRequest.class, "Z0apphosting/api/taskqueue/taskqueue_service.proto\n%apphosting.TaskQueueQueryTasksRequest\u0013\u001a\u0006app_id \u0001(\u00020\t8\u0002\u0014\u0013\u001a\nqueue_name \u0002(\u00020\t8\u0002\u0014\u0013\u001a\u000fstart_task_name \u0003(\u00020\t8\u0001\u0014\u0013\u001a\u000estart_eta_usec \u0004(\u00000\u00038\u0001\u0014\u0013\u001a\bmax_rows \u0005(\u00000\u00058\u0001B\u00011\u00a3\u0001\u00aa\u0001\u0007default\u00b2\u0001\u00011\u00a4\u0001\u0014", new ProtocolType.FieldType[]{new ProtocolType.FieldType("app_id", "app_id", 1, 0, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("queue_name", "queue_name", 2, 1, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("start_task_name", "start_task_name", 3, 2, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("start_eta_usec", "start_eta_usec", 4, 3, ProtocolType.FieldBaseType.INT64, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("max_rows", "max_rows", 5, 4, ProtocolType.FieldBaseType.INT32, ProtocolType.Presence.OPTIONAL)});

            private StaticHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TaskQueueDeleteQueueResponse
    extends ProtocolMessage<TaskQueueDeleteQueueResponse> {
        private static final long serialVersionUID = 1L;
        private UninterpretedTags uninterpreted;
        public static final TaskQueueDeleteQueueResponse IMMUTABLE_DEFAULT_INSTANCE = new TaskQueueDeleteQueueResponse(){
            private static final long serialVersionUID = 1L;

            public TaskQueueDeleteQueueResponse mergeFrom(TaskQueueDeleteQueueResponse that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public TaskQueueDeleteQueueResponse freeze() {
                return this;
            }

            public TaskQueueDeleteQueueResponse unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final String[] text = new String[1];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public TaskQueueDeleteQueueResponse mergeFrom(TaskQueueDeleteQueueResponse that) {
            assert (that != this);
            if (that.uninterpreted != null) {
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll((Multimap)that.uninterpreted);
            }
            return this;
        }

        public boolean equalsIgnoreUninterpreted(TaskQueueDeleteQueueResponse that) {
            return this.equals(that, true);
        }

        public boolean equals(TaskQueueDeleteQueueResponse that) {
            return this.equals(that, false);
        }

        public boolean equals(TaskQueueDeleteQueueResponse that, boolean ignoreUninterpreted) {
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            return ignoreUninterpreted || UninterpretedTags.equivalent((UninterpretedTags)this.uninterpreted, (UninterpretedTags)that.uninterpreted);
        }

        public boolean equals(Object that) {
            return that instanceof TaskQueueDeleteQueueResponse && this.equals((TaskQueueDeleteQueueResponse)((Object)that));
        }

        public int hashCode() {
            int hash = -2052941793;
            if (this.uninterpreted != null && !this.uninterpreted.isEmpty()) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        public boolean isInitialized() {
            return true;
        }

        public int encodingSize() {
            int n = 0;
            return this.uninterpreted != null ? n + this.uninterpreted.encodingSize() : n;
        }

        public int maxEncodingSize() {
            int n = 0;
            return this.uninterpreted != null ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        public void clear() {
            this.uninterpreted = null;
        }

        public TaskQueueDeleteQueueResponse newInstance() {
            return new TaskQueueDeleteQueueResponse();
        }

        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        public void outputTo(ProtocolSink sink) {
            if (this.uninterpreted != null) {
                this.uninterpreted.put(sink);
            }
        }

        public boolean merge(ProtocolSource source) {
            boolean result = true;
            block3: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block3;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put((Object)tt, (Object)source.getUninterpreted(tt));
                        continue block3;
                    }
                }
            }
            return result;
        }

        public TaskQueueDeleteQueueResponse getDefaultInstanceForType() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public static final TaskQueueDeleteQueueResponse getDefaultInstance() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        static {
            TaskQueueDeleteQueueResponse.text[0] = "ErrorCode";
            types = new int[1];
            Arrays.fill(types, 6);
            TaskQueueDeleteQueueResponse.types[0] = 0;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(TaskQueueDeleteQueueResponse.class, "Z0apphosting/api/taskqueue/taskqueue_service.proto\n'apphosting.TaskQueueDeleteQueueResponse", new ProtocolType.FieldType[0]);

            private StaticHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TaskQueueDeleteQueueRequest
    extends ProtocolMessage<TaskQueueDeleteQueueRequest> {
        private static final long serialVersionUID = 1L;
        private byte[] app_id_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private byte[] queue_name_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final TaskQueueDeleteQueueRequest IMMUTABLE_DEFAULT_INSTANCE = new TaskQueueDeleteQueueRequest(){
            private static final long serialVersionUID = 1L;

            public TaskQueueDeleteQueueRequest clearAppId() {
                return this;
            }

            public TaskQueueDeleteQueueRequest setAppIdAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueDeleteQueueRequest setAppId(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueDeleteQueueRequest setAppId(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueDeleteQueueRequest clearQueueName() {
                return this;
            }

            public TaskQueueDeleteQueueRequest setQueueNameAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueDeleteQueueRequest setQueueName(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueDeleteQueueRequest setQueueName(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueDeleteQueueRequest mergeFrom(TaskQueueDeleteQueueRequest that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public TaskQueueDeleteQueueRequest freeze() {
                return this;
            }

            public TaskQueueDeleteQueueRequest unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kapp_id = 1;
        public static final int kqueue_name = 2;
        public static final String[] text = new String[3];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final byte[] getAppIdAsBytes() {
            return this.app_id_;
        }

        public final boolean hasAppId() {
            return (this.optional_0_ & 1) != 0;
        }

        public TaskQueueDeleteQueueRequest clearAppId() {
            this.optional_0_ &= 0xFFFFFFFE;
            this.app_id_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public TaskQueueDeleteQueueRequest setAppIdAsBytes(byte[] x) {
            this.optional_0_ |= 1;
            this.app_id_ = x;
            return this;
        }

        public final String getAppId() {
            return ProtocolSupport.toStringUtf8((byte[])this.app_id_);
        }

        public TaskQueueDeleteQueueRequest setAppId(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.app_id_ = ProtocolSupport.toBytesUtf8((String)v);
            return this;
        }

        public final String getAppId(Charset cs) {
            return ProtocolSupport.toString((byte[])this.app_id_, (Charset)cs);
        }

        public TaskQueueDeleteQueueRequest setAppId(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.app_id_ = ProtocolSupport.toBytes((String)v, (Charset)cs);
            return this;
        }

        public final byte[] getQueueNameAsBytes() {
            return this.queue_name_;
        }

        public final boolean hasQueueName() {
            return (this.optional_0_ & 2) != 0;
        }

        public TaskQueueDeleteQueueRequest clearQueueName() {
            this.optional_0_ &= 0xFFFFFFFD;
            this.queue_name_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public TaskQueueDeleteQueueRequest setQueueNameAsBytes(byte[] x) {
            this.optional_0_ |= 2;
            this.queue_name_ = x;
            return this;
        }

        public final String getQueueName() {
            return ProtocolSupport.toStringUtf8((byte[])this.queue_name_);
        }

        public TaskQueueDeleteQueueRequest setQueueName(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 2;
            this.queue_name_ = ProtocolSupport.toBytesUtf8((String)v);
            return this;
        }

        public final String getQueueName(Charset cs) {
            return ProtocolSupport.toString((byte[])this.queue_name_, (Charset)cs);
        }

        public TaskQueueDeleteQueueRequest setQueueName(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 2;
            this.queue_name_ = ProtocolSupport.toBytes((String)v, (Charset)cs);
            return this;
        }

        public TaskQueueDeleteQueueRequest mergeFrom(TaskQueueDeleteQueueRequest that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                this.app_id_ = that.app_id_;
            }
            if ((that_t0 & 2) != 0) {
                this_t0 |= 2;
                this.queue_name_ = that.queue_name_;
            }
            if (that.uninterpreted != null) {
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll((Multimap)that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        public boolean equalsIgnoreUninterpreted(TaskQueueDeleteQueueRequest that) {
            return this.equals(that, true);
        }

        public boolean equals(TaskQueueDeleteQueueRequest that) {
            return this.equals(that, false);
        }

        public boolean equals(TaskQueueDeleteQueueRequest that, boolean ignoreUninterpreted) {
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (this_t0 != that_t0) {
                return false;
            }
            if ((this_t0 & 1) != 0 && !Arrays.equals(this.app_id_, that.app_id_)) {
                return false;
            }
            if ((this_t0 & 2) != 0 && !Arrays.equals(this.queue_name_, that.queue_name_)) {
                return false;
            }
            return ignoreUninterpreted || UninterpretedTags.equivalent((UninterpretedTags)this.uninterpreted, (UninterpretedTags)that.uninterpreted);
        }

        public boolean equals(Object that) {
            return that instanceof TaskQueueDeleteQueueRequest && this.equals((TaskQueueDeleteQueueRequest)((Object)that));
        }

        public int hashCode() {
            int hash = 1275335545;
            int this_t0 = this.optional_0_;
            hash = hash * 31 + ((this_t0 & 1) != 0 ? Arrays.hashCode(this.app_id_) : -113);
            hash = hash * 31 + ((this_t0 & 2) != 0 ? Arrays.hashCode(this.queue_name_) : -113);
            if (this.uninterpreted != null && !this.uninterpreted.isEmpty()) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        public boolean isInitialized() {
            int this_t0 = this.optional_0_;
            if ((this_t0 & 3) != 3) {
                if ((this_t0 & 1) == 0) {
                    return false;
                }
                return false;
            }
            return true;
        }

        public int encodingSize() {
            int n = 2 + Protocol.stringSize((int)this.app_id_.length) + Protocol.stringSize((int)this.queue_name_.length);
            return this.uninterpreted != null ? n + this.uninterpreted.encodingSize() : n;
        }

        public int maxEncodingSize() {
            int n = 12 + this.app_id_.length + this.queue_name_.length;
            return this.uninterpreted != null ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        public void clear() {
            this.optional_0_ = 0;
            this.app_id_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.queue_name_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.uninterpreted = null;
        }

        public TaskQueueDeleteQueueRequest newInstance() {
            return new TaskQueueDeleteQueueRequest();
        }

        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        public void outputTo(ProtocolSink sink) {
            sink.putByte((byte)10);
            sink.putPrefixedData(this.app_id_);
            sink.putByte((byte)18);
            sink.putPrefixedData(this.queue_name_);
            if (this.uninterpreted != null) {
                this.uninterpreted.put(sink);
            }
        }

        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block5: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block5;
                    }
                    case 10: {
                        this.app_id_ = source.getPrefixedData();
                        this_t0 |= 1;
                        continue block5;
                    }
                    case 18: {
                        this.queue_name_ = source.getPrefixedData();
                        this_t0 |= 2;
                        continue block5;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put((Object)tt, (Object)source.getUninterpreted(tt));
                        continue block5;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        public TaskQueueDeleteQueueRequest getDefaultInstanceForType() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public static final TaskQueueDeleteQueueRequest getDefaultInstance() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public TaskQueueDeleteQueueRequest freeze() {
            this.app_id_ = ProtocolSupport.freezeString((byte[])this.app_id_);
            this.queue_name_ = ProtocolSupport.freezeString((byte[])this.queue_name_);
            return this;
        }

        static {
            TaskQueueDeleteQueueRequest.text[0] = "ErrorCode";
            TaskQueueDeleteQueueRequest.text[1] = "app_id";
            TaskQueueDeleteQueueRequest.text[2] = "queue_name";
            types = new int[3];
            Arrays.fill(types, 6);
            TaskQueueDeleteQueueRequest.types[0] = 0;
            TaskQueueDeleteQueueRequest.types[1] = 2;
            TaskQueueDeleteQueueRequest.types[2] = 2;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(TaskQueueDeleteQueueRequest.class, "Z0apphosting/api/taskqueue/taskqueue_service.proto\n&apphosting.TaskQueueDeleteQueueRequest\u0013\u001a\u0006app_id \u0001(\u00020\t8\u0002\u0014\u0013\u001a\nqueue_name \u0002(\u00020\t8\u0002\u0014", new ProtocolType.FieldType[]{new ProtocolType.FieldType("app_id", "app_id", 1, 0, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("queue_name", "queue_name", 2, 1, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED)});

            private StaticHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TaskQueuePurgeQueueResponse
    extends ProtocolMessage<TaskQueuePurgeQueueResponse> {
        private static final long serialVersionUID = 1L;
        private UninterpretedTags uninterpreted;
        public static final TaskQueuePurgeQueueResponse IMMUTABLE_DEFAULT_INSTANCE = new TaskQueuePurgeQueueResponse(){
            private static final long serialVersionUID = 1L;

            public TaskQueuePurgeQueueResponse mergeFrom(TaskQueuePurgeQueueResponse that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public TaskQueuePurgeQueueResponse freeze() {
                return this;
            }

            public TaskQueuePurgeQueueResponse unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final String[] text = new String[1];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public TaskQueuePurgeQueueResponse mergeFrom(TaskQueuePurgeQueueResponse that) {
            assert (that != this);
            if (that.uninterpreted != null) {
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll((Multimap)that.uninterpreted);
            }
            return this;
        }

        public boolean equalsIgnoreUninterpreted(TaskQueuePurgeQueueResponse that) {
            return this.equals(that, true);
        }

        public boolean equals(TaskQueuePurgeQueueResponse that) {
            return this.equals(that, false);
        }

        public boolean equals(TaskQueuePurgeQueueResponse that, boolean ignoreUninterpreted) {
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            return ignoreUninterpreted || UninterpretedTags.equivalent((UninterpretedTags)this.uninterpreted, (UninterpretedTags)that.uninterpreted);
        }

        public boolean equals(Object that) {
            return that instanceof TaskQueuePurgeQueueResponse && this.equals((TaskQueuePurgeQueueResponse)((Object)that));
        }

        public int hashCode() {
            int hash = 1326733039;
            if (this.uninterpreted != null && !this.uninterpreted.isEmpty()) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        public boolean isInitialized() {
            return true;
        }

        public int encodingSize() {
            int n = 0;
            return this.uninterpreted != null ? n + this.uninterpreted.encodingSize() : n;
        }

        public int maxEncodingSize() {
            int n = 0;
            return this.uninterpreted != null ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        public void clear() {
            this.uninterpreted = null;
        }

        public TaskQueuePurgeQueueResponse newInstance() {
            return new TaskQueuePurgeQueueResponse();
        }

        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        public void outputTo(ProtocolSink sink) {
            if (this.uninterpreted != null) {
                this.uninterpreted.put(sink);
            }
        }

        public boolean merge(ProtocolSource source) {
            boolean result = true;
            block3: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block3;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put((Object)tt, (Object)source.getUninterpreted(tt));
                        continue block3;
                    }
                }
            }
            return result;
        }

        public TaskQueuePurgeQueueResponse getDefaultInstanceForType() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public static final TaskQueuePurgeQueueResponse getDefaultInstance() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        static {
            TaskQueuePurgeQueueResponse.text[0] = "ErrorCode";
            types = new int[1];
            Arrays.fill(types, 6);
            TaskQueuePurgeQueueResponse.types[0] = 0;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(TaskQueuePurgeQueueResponse.class, "Z0apphosting/api/taskqueue/taskqueue_service.proto\n&apphosting.TaskQueuePurgeQueueResponse", new ProtocolType.FieldType[0]);

            private StaticHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TaskQueuePurgeQueueRequest
    extends ProtocolMessage<TaskQueuePurgeQueueRequest> {
        private static final long serialVersionUID = 1L;
        private byte[] app_id_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private byte[] queue_name_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final TaskQueuePurgeQueueRequest IMMUTABLE_DEFAULT_INSTANCE = new TaskQueuePurgeQueueRequest(){
            private static final long serialVersionUID = 1L;

            public TaskQueuePurgeQueueRequest clearAppId() {
                return this;
            }

            public TaskQueuePurgeQueueRequest setAppIdAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueuePurgeQueueRequest setAppId(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueuePurgeQueueRequest setAppId(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueuePurgeQueueRequest clearQueueName() {
                return this;
            }

            public TaskQueuePurgeQueueRequest setQueueNameAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueuePurgeQueueRequest setQueueName(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueuePurgeQueueRequest setQueueName(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueuePurgeQueueRequest mergeFrom(TaskQueuePurgeQueueRequest that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public TaskQueuePurgeQueueRequest freeze() {
                return this;
            }

            public TaskQueuePurgeQueueRequest unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kapp_id = 1;
        public static final int kqueue_name = 2;
        public static final String[] text = new String[3];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final byte[] getAppIdAsBytes() {
            return this.app_id_;
        }

        public final boolean hasAppId() {
            return (this.optional_0_ & 1) != 0;
        }

        public TaskQueuePurgeQueueRequest clearAppId() {
            this.optional_0_ &= 0xFFFFFFFE;
            this.app_id_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public TaskQueuePurgeQueueRequest setAppIdAsBytes(byte[] x) {
            this.optional_0_ |= 1;
            this.app_id_ = x;
            return this;
        }

        public final String getAppId() {
            return ProtocolSupport.toStringUtf8((byte[])this.app_id_);
        }

        public TaskQueuePurgeQueueRequest setAppId(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.app_id_ = ProtocolSupport.toBytesUtf8((String)v);
            return this;
        }

        public final String getAppId(Charset cs) {
            return ProtocolSupport.toString((byte[])this.app_id_, (Charset)cs);
        }

        public TaskQueuePurgeQueueRequest setAppId(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.app_id_ = ProtocolSupport.toBytes((String)v, (Charset)cs);
            return this;
        }

        public final byte[] getQueueNameAsBytes() {
            return this.queue_name_;
        }

        public final boolean hasQueueName() {
            return (this.optional_0_ & 2) != 0;
        }

        public TaskQueuePurgeQueueRequest clearQueueName() {
            this.optional_0_ &= 0xFFFFFFFD;
            this.queue_name_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public TaskQueuePurgeQueueRequest setQueueNameAsBytes(byte[] x) {
            this.optional_0_ |= 2;
            this.queue_name_ = x;
            return this;
        }

        public final String getQueueName() {
            return ProtocolSupport.toStringUtf8((byte[])this.queue_name_);
        }

        public TaskQueuePurgeQueueRequest setQueueName(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 2;
            this.queue_name_ = ProtocolSupport.toBytesUtf8((String)v);
            return this;
        }

        public final String getQueueName(Charset cs) {
            return ProtocolSupport.toString((byte[])this.queue_name_, (Charset)cs);
        }

        public TaskQueuePurgeQueueRequest setQueueName(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 2;
            this.queue_name_ = ProtocolSupport.toBytes((String)v, (Charset)cs);
            return this;
        }

        public TaskQueuePurgeQueueRequest mergeFrom(TaskQueuePurgeQueueRequest that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                this.app_id_ = that.app_id_;
            }
            if ((that_t0 & 2) != 0) {
                this_t0 |= 2;
                this.queue_name_ = that.queue_name_;
            }
            if (that.uninterpreted != null) {
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll((Multimap)that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        public boolean equalsIgnoreUninterpreted(TaskQueuePurgeQueueRequest that) {
            return this.equals(that, true);
        }

        public boolean equals(TaskQueuePurgeQueueRequest that) {
            return this.equals(that, false);
        }

        public boolean equals(TaskQueuePurgeQueueRequest that, boolean ignoreUninterpreted) {
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (this_t0 != that_t0) {
                return false;
            }
            if ((this_t0 & 1) != 0 && !Arrays.equals(this.app_id_, that.app_id_)) {
                return false;
            }
            if ((this_t0 & 2) != 0 && !Arrays.equals(this.queue_name_, that.queue_name_)) {
                return false;
            }
            return ignoreUninterpreted || UninterpretedTags.equivalent((UninterpretedTags)this.uninterpreted, (UninterpretedTags)that.uninterpreted);
        }

        public boolean equals(Object that) {
            return that instanceof TaskQueuePurgeQueueRequest && this.equals((TaskQueuePurgeQueueRequest)((Object)that));
        }

        public int hashCode() {
            int hash = 0xBB8800B;
            int this_t0 = this.optional_0_;
            hash = hash * 31 + ((this_t0 & 1) != 0 ? Arrays.hashCode(this.app_id_) : -113);
            hash = hash * 31 + ((this_t0 & 2) != 0 ? Arrays.hashCode(this.queue_name_) : -113);
            if (this.uninterpreted != null && !this.uninterpreted.isEmpty()) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        public boolean isInitialized() {
            int this_t0 = this.optional_0_;
            if ((this_t0 & 3) != 3) {
                if ((this_t0 & 1) == 0) {
                    return false;
                }
                return false;
            }
            return true;
        }

        public int encodingSize() {
            int n = 2 + Protocol.stringSize((int)this.app_id_.length) + Protocol.stringSize((int)this.queue_name_.length);
            return this.uninterpreted != null ? n + this.uninterpreted.encodingSize() : n;
        }

        public int maxEncodingSize() {
            int n = 12 + this.app_id_.length + this.queue_name_.length;
            return this.uninterpreted != null ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        public void clear() {
            this.optional_0_ = 0;
            this.app_id_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.queue_name_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.uninterpreted = null;
        }

        public TaskQueuePurgeQueueRequest newInstance() {
            return new TaskQueuePurgeQueueRequest();
        }

        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        public void outputTo(ProtocolSink sink) {
            sink.putByte((byte)10);
            sink.putPrefixedData(this.app_id_);
            sink.putByte((byte)18);
            sink.putPrefixedData(this.queue_name_);
            if (this.uninterpreted != null) {
                this.uninterpreted.put(sink);
            }
        }

        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block5: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block5;
                    }
                    case 10: {
                        this.app_id_ = source.getPrefixedData();
                        this_t0 |= 1;
                        continue block5;
                    }
                    case 18: {
                        this.queue_name_ = source.getPrefixedData();
                        this_t0 |= 2;
                        continue block5;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put((Object)tt, (Object)source.getUninterpreted(tt));
                        continue block5;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        public TaskQueuePurgeQueueRequest getDefaultInstanceForType() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public static final TaskQueuePurgeQueueRequest getDefaultInstance() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public TaskQueuePurgeQueueRequest freeze() {
            this.app_id_ = ProtocolSupport.freezeString((byte[])this.app_id_);
            this.queue_name_ = ProtocolSupport.freezeString((byte[])this.queue_name_);
            return this;
        }

        static {
            TaskQueuePurgeQueueRequest.text[0] = "ErrorCode";
            TaskQueuePurgeQueueRequest.text[1] = "app_id";
            TaskQueuePurgeQueueRequest.text[2] = "queue_name";
            types = new int[3];
            Arrays.fill(types, 6);
            TaskQueuePurgeQueueRequest.types[0] = 0;
            TaskQueuePurgeQueueRequest.types[1] = 2;
            TaskQueuePurgeQueueRequest.types[2] = 2;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(TaskQueuePurgeQueueRequest.class, "Z0apphosting/api/taskqueue/taskqueue_service.proto\n%apphosting.TaskQueuePurgeQueueRequest\u0013\u001a\u0006app_id \u0001(\u00020\t8\u0002\u0014\u0013\u001a\nqueue_name \u0002(\u00020\t8\u0002\u0014", new ProtocolType.FieldType[]{new ProtocolType.FieldType("app_id", "app_id", 1, 0, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("queue_name", "queue_name", 2, 1, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED)});

            private StaticHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TaskQueuePauseQueueResponse
    extends ProtocolMessage<TaskQueuePauseQueueResponse> {
        private static final long serialVersionUID = 1L;
        private UninterpretedTags uninterpreted;
        public static final TaskQueuePauseQueueResponse IMMUTABLE_DEFAULT_INSTANCE = new TaskQueuePauseQueueResponse(){
            private static final long serialVersionUID = 1L;

            public TaskQueuePauseQueueResponse mergeFrom(TaskQueuePauseQueueResponse that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public TaskQueuePauseQueueResponse freeze() {
                return this;
            }

            public TaskQueuePauseQueueResponse unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final String[] text = new String[1];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public TaskQueuePauseQueueResponse mergeFrom(TaskQueuePauseQueueResponse that) {
            assert (that != this);
            if (that.uninterpreted != null) {
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll((Multimap)that.uninterpreted);
            }
            return this;
        }

        public boolean equalsIgnoreUninterpreted(TaskQueuePauseQueueResponse that) {
            return this.equals(that, true);
        }

        public boolean equals(TaskQueuePauseQueueResponse that) {
            return this.equals(that, false);
        }

        public boolean equals(TaskQueuePauseQueueResponse that, boolean ignoreUninterpreted) {
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            return ignoreUninterpreted || UninterpretedTags.equivalent((UninterpretedTags)this.uninterpreted, (UninterpretedTags)that.uninterpreted);
        }

        public boolean equals(Object that) {
            return that instanceof TaskQueuePauseQueueResponse && this.equals((TaskQueuePauseQueueResponse)((Object)that));
        }

        public int hashCode() {
            int hash = -1858093407;
            if (this.uninterpreted != null && !this.uninterpreted.isEmpty()) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        public boolean isInitialized() {
            return true;
        }

        public int encodingSize() {
            int n = 0;
            return this.uninterpreted != null ? n + this.uninterpreted.encodingSize() : n;
        }

        public int maxEncodingSize() {
            int n = 0;
            return this.uninterpreted != null ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        public void clear() {
            this.uninterpreted = null;
        }

        public TaskQueuePauseQueueResponse newInstance() {
            return new TaskQueuePauseQueueResponse();
        }

        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        public void outputTo(ProtocolSink sink) {
            if (this.uninterpreted != null) {
                this.uninterpreted.put(sink);
            }
        }

        public boolean merge(ProtocolSource source) {
            boolean result = true;
            block3: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block3;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put((Object)tt, (Object)source.getUninterpreted(tt));
                        continue block3;
                    }
                }
            }
            return result;
        }

        public TaskQueuePauseQueueResponse getDefaultInstanceForType() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public static final TaskQueuePauseQueueResponse getDefaultInstance() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        static {
            TaskQueuePauseQueueResponse.text[0] = "ErrorCode";
            types = new int[1];
            Arrays.fill(types, 6);
            TaskQueuePauseQueueResponse.types[0] = 0;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(TaskQueuePauseQueueResponse.class, "Z0apphosting/api/taskqueue/taskqueue_service.proto\n&apphosting.TaskQueuePauseQueueResponse", new ProtocolType.FieldType[0]);

            private StaticHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TaskQueuePauseQueueRequest
    extends ProtocolMessage<TaskQueuePauseQueueRequest> {
        private static final long serialVersionUID = 1L;
        private byte[] app_id_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private byte[] queue_name_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private boolean pause_ = false;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final TaskQueuePauseQueueRequest IMMUTABLE_DEFAULT_INSTANCE = new TaskQueuePauseQueueRequest(){
            private static final long serialVersionUID = 1L;

            public TaskQueuePauseQueueRequest clearAppId() {
                return this;
            }

            public TaskQueuePauseQueueRequest setAppIdAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueuePauseQueueRequest setAppId(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueuePauseQueueRequest setAppId(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueuePauseQueueRequest clearQueueName() {
                return this;
            }

            public TaskQueuePauseQueueRequest setQueueNameAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueuePauseQueueRequest setQueueName(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueuePauseQueueRequest setQueueName(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueuePauseQueueRequest clearPause() {
                return this;
            }

            public TaskQueuePauseQueueRequest setPause(boolean x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueuePauseQueueRequest mergeFrom(TaskQueuePauseQueueRequest that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public TaskQueuePauseQueueRequest freeze() {
                return this;
            }

            public TaskQueuePauseQueueRequest unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kapp_id = 1;
        public static final int kqueue_name = 2;
        public static final int kpause = 3;
        public static final String[] text = new String[4];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final byte[] getAppIdAsBytes() {
            return this.app_id_;
        }

        public final boolean hasAppId() {
            return (this.optional_0_ & 1) != 0;
        }

        public TaskQueuePauseQueueRequest clearAppId() {
            this.optional_0_ &= 0xFFFFFFFE;
            this.app_id_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public TaskQueuePauseQueueRequest setAppIdAsBytes(byte[] x) {
            this.optional_0_ |= 1;
            this.app_id_ = x;
            return this;
        }

        public final String getAppId() {
            return ProtocolSupport.toStringUtf8((byte[])this.app_id_);
        }

        public TaskQueuePauseQueueRequest setAppId(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.app_id_ = ProtocolSupport.toBytesUtf8((String)v);
            return this;
        }

        public final String getAppId(Charset cs) {
            return ProtocolSupport.toString((byte[])this.app_id_, (Charset)cs);
        }

        public TaskQueuePauseQueueRequest setAppId(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.app_id_ = ProtocolSupport.toBytes((String)v, (Charset)cs);
            return this;
        }

        public final byte[] getQueueNameAsBytes() {
            return this.queue_name_;
        }

        public final boolean hasQueueName() {
            return (this.optional_0_ & 2) != 0;
        }

        public TaskQueuePauseQueueRequest clearQueueName() {
            this.optional_0_ &= 0xFFFFFFFD;
            this.queue_name_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public TaskQueuePauseQueueRequest setQueueNameAsBytes(byte[] x) {
            this.optional_0_ |= 2;
            this.queue_name_ = x;
            return this;
        }

        public final String getQueueName() {
            return ProtocolSupport.toStringUtf8((byte[])this.queue_name_);
        }

        public TaskQueuePauseQueueRequest setQueueName(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 2;
            this.queue_name_ = ProtocolSupport.toBytesUtf8((String)v);
            return this;
        }

        public final String getQueueName(Charset cs) {
            return ProtocolSupport.toString((byte[])this.queue_name_, (Charset)cs);
        }

        public TaskQueuePauseQueueRequest setQueueName(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 2;
            this.queue_name_ = ProtocolSupport.toBytes((String)v, (Charset)cs);
            return this;
        }

        public final boolean isPause() {
            return this.pause_;
        }

        public final boolean hasPause() {
            return (this.optional_0_ & 4) != 0;
        }

        public TaskQueuePauseQueueRequest clearPause() {
            this.optional_0_ &= 0xFFFFFFFB;
            this.pause_ = false;
            return this;
        }

        public TaskQueuePauseQueueRequest setPause(boolean x) {
            this.optional_0_ |= 4;
            this.pause_ = x;
            return this;
        }

        public TaskQueuePauseQueueRequest mergeFrom(TaskQueuePauseQueueRequest that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                this.app_id_ = that.app_id_;
            }
            if ((that_t0 & 2) != 0) {
                this_t0 |= 2;
                this.queue_name_ = that.queue_name_;
            }
            if ((that_t0 & 4) != 0) {
                this_t0 |= 4;
                this.pause_ = that.pause_;
            }
            if (that.uninterpreted != null) {
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll((Multimap)that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        public boolean equalsIgnoreUninterpreted(TaskQueuePauseQueueRequest that) {
            return this.equals(that, true);
        }

        public boolean equals(TaskQueuePauseQueueRequest that) {
            return this.equals(that, false);
        }

        public boolean equals(TaskQueuePauseQueueRequest that, boolean ignoreUninterpreted) {
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (this_t0 != that_t0) {
                return false;
            }
            if ((this_t0 & 1) != 0 && !Arrays.equals(this.app_id_, that.app_id_)) {
                return false;
            }
            if ((this_t0 & 2) != 0 && !Arrays.equals(this.queue_name_, that.queue_name_)) {
                return false;
            }
            if ((this_t0 & 4) != 0 && this.pause_ != that.pause_) {
                return false;
            }
            return ignoreUninterpreted || UninterpretedTags.equivalent((UninterpretedTags)this.uninterpreted, (UninterpretedTags)that.uninterpreted);
        }

        public boolean equals(Object that) {
            return that instanceof TaskQueuePauseQueueRequest && this.equals((TaskQueuePauseQueueRequest)((Object)that));
        }

        public int hashCode() {
            int hash = -1069186645;
            int this_t0 = this.optional_0_;
            hash = hash * 31 + ((this_t0 & 1) != 0 ? Arrays.hashCode(this.app_id_) : -113);
            hash = hash * 31 + ((this_t0 & 2) != 0 ? Arrays.hashCode(this.queue_name_) : -113);
            hash = hash * 31 + ((this_t0 & 4) != 0 ? (this.pause_ ? 1231 : 1237) : -113);
            if (this.uninterpreted != null && !this.uninterpreted.isEmpty()) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        public boolean isInitialized() {
            int this_t0 = this.optional_0_;
            if ((this_t0 & 7) != 7) {
                if ((this_t0 & 1) == 0) {
                    return false;
                }
                if ((this_t0 & 2) == 0) {
                    return false;
                }
                return false;
            }
            return true;
        }

        public int encodingSize() {
            int n = 4 + Protocol.stringSize((int)this.app_id_.length) + Protocol.stringSize((int)this.queue_name_.length);
            return this.uninterpreted != null ? n + this.uninterpreted.encodingSize() : n;
        }

        public int maxEncodingSize() {
            int n = 14 + this.app_id_.length + this.queue_name_.length;
            return this.uninterpreted != null ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        public void clear() {
            this.optional_0_ = 0;
            this.app_id_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.queue_name_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.pause_ = false;
            this.uninterpreted = null;
        }

        public TaskQueuePauseQueueRequest newInstance() {
            return new TaskQueuePauseQueueRequest();
        }

        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        public void outputTo(ProtocolSink sink) {
            sink.putByte((byte)10);
            sink.putPrefixedData(this.app_id_);
            sink.putByte((byte)18);
            sink.putPrefixedData(this.queue_name_);
            sink.putByte((byte)24);
            sink.putBoolean(this.pause_);
            if (this.uninterpreted != null) {
                this.uninterpreted.put(sink);
            }
        }

        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block6: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block6;
                    }
                    case 10: {
                        this.app_id_ = source.getPrefixedData();
                        this_t0 |= 1;
                        continue block6;
                    }
                    case 18: {
                        this.queue_name_ = source.getPrefixedData();
                        this_t0 |= 2;
                        continue block6;
                    }
                    case 24: {
                        this.pause_ = source.getBoolean();
                        this_t0 |= 4;
                        continue block6;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put((Object)tt, (Object)source.getUninterpreted(tt));
                        continue block6;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        public TaskQueuePauseQueueRequest getDefaultInstanceForType() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public static final TaskQueuePauseQueueRequest getDefaultInstance() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public TaskQueuePauseQueueRequest freeze() {
            this.app_id_ = ProtocolSupport.freezeString((byte[])this.app_id_);
            this.queue_name_ = ProtocolSupport.freezeString((byte[])this.queue_name_);
            return this;
        }

        static {
            TaskQueuePauseQueueRequest.text[0] = "ErrorCode";
            TaskQueuePauseQueueRequest.text[1] = "app_id";
            TaskQueuePauseQueueRequest.text[2] = "queue_name";
            TaskQueuePauseQueueRequest.text[3] = "pause";
            types = new int[4];
            Arrays.fill(types, 6);
            TaskQueuePauseQueueRequest.types[0] = 0;
            TaskQueuePauseQueueRequest.types[1] = 2;
            TaskQueuePauseQueueRequest.types[2] = 2;
            TaskQueuePauseQueueRequest.types[3] = 0;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(TaskQueuePauseQueueRequest.class, "Z0apphosting/api/taskqueue/taskqueue_service.proto\n%apphosting.TaskQueuePauseQueueRequest\u0013\u001a\u0006app_id \u0001(\u00020\t8\u0002\u0014\u0013\u001a\nqueue_name \u0002(\u00020\t8\u0002\u0014\u0013\u001a\u0005pause \u0003(\u00000\b8\u0002\u0014", new ProtocolType.FieldType[]{new ProtocolType.FieldType("app_id", "app_id", 1, 0, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("queue_name", "queue_name", 2, 1, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("pause", "pause", 3, 2, ProtocolType.FieldBaseType.BOOL, ProtocolType.Presence.REQUIRED)});

            private StaticHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TaskQueueFetchQueueStatsResponse
    extends ProtocolMessage<TaskQueueFetchQueueStatsResponse> {
        private static final long serialVersionUID = 1L;
        private List<QueueStats> queuestats_ = null;
        private UninterpretedTags uninterpreted;
        public static final TaskQueueFetchQueueStatsResponse IMMUTABLE_DEFAULT_INSTANCE = new TaskQueueFetchQueueStatsResponse(){
            private static final long serialVersionUID = 1L;

            public TaskQueueFetchQueueStatsResponse clearQueueStats() {
                return this;
            }

            public QueueStats getMutableQueueStats(int i) {
                return (QueueStats)((Object)ProtocolSupport.unsupportedOperation());
            }

            public QueueStats addQueueStats() {
                return (QueueStats)((Object)ProtocolSupport.unsupportedOperation());
            }

            public QueueStats addQueueStats(QueueStats v) {
                return (QueueStats)((Object)ProtocolSupport.unsupportedOperation());
            }

            public QueueStats insertQueueStats(int i, QueueStats v) {
                return (QueueStats)((Object)ProtocolSupport.unsupportedOperation());
            }

            public QueueStats removeQueueStats(int i) {
                return (QueueStats)((Object)ProtocolSupport.unsupportedOperation());
            }

            public TaskQueueFetchQueueStatsResponse mergeFrom(TaskQueueFetchQueueStatsResponse that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public TaskQueueFetchQueueStatsResponse freeze() {
                return this;
            }

            public TaskQueueFetchQueueStatsResponse unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kQueueStatsGroup = 1;
        public static final int kQueueStatsnum_tasks = 2;
        public static final int kQueueStatsoldest_eta_usec = 3;
        public static final int kQueueStatsscanner_info = 4;
        public static final String[] text = new String[5];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final int queueStatsSize() {
            return this.queuestats_ != null ? this.queuestats_.size() : 0;
        }

        public final QueueStats getQueueStats(int i) {
            assert (i >= 0 && i < (this.queuestats_ != null ? this.queuestats_.size() : 0));
            return this.queuestats_.get(i);
        }

        public TaskQueueFetchQueueStatsResponse clearQueueStats() {
            if (this.queuestats_ != null) {
                this.queuestats_.clear();
            }
            return this;
        }

        public QueueStats getMutableQueueStats(int i) {
            assert (i >= 0 && this.queuestats_ != null && i < this.queuestats_.size());
            return this.queuestats_.get(i);
        }

        public QueueStats addQueueStats() {
            QueueStats v = new QueueStats();
            if (this.queuestats_ == null) {
                this.queuestats_ = new ArrayList<QueueStats>(4);
            }
            this.queuestats_.add(v);
            return v;
        }

        public QueueStats addQueueStats(QueueStats v) {
            if (this.queuestats_ == null) {
                this.queuestats_ = new ArrayList<QueueStats>(4);
            }
            this.queuestats_.add(v);
            return v;
        }

        public QueueStats insertQueueStats(int i, QueueStats v) {
            if (this.queuestats_ == null) {
                this.queuestats_ = new ArrayList<QueueStats>(4);
            }
            this.queuestats_.add(i, v);
            return v;
        }

        public QueueStats removeQueueStats(int i) {
            return this.queuestats_.remove(i);
        }

        public final Iterator<QueueStats> queueStatsIterator() {
            if (this.queuestats_ == null) {
                return ProtocolSupport.emptyIterator();
            }
            return this.queuestats_.iterator();
        }

        public final List<QueueStats> queueStatss() {
            return ProtocolSupport.unmodifiableList(this.queuestats_);
        }

        public final List<QueueStats> mutableQueueStatss() {
            if (this.queuestats_ == null) {
                this.queuestats_ = new ArrayList<QueueStats>(4);
            }
            return this.queuestats_;
        }

        public TaskQueueFetchQueueStatsResponse mergeFrom(TaskQueueFetchQueueStatsResponse that) {
            assert (that != this);
            if (that.queuestats_ != null) {
                for (QueueStats v : that.queuestats_) {
                    this.addQueueStats().mergeFrom(v);
                }
            }
            if (that.uninterpreted != null) {
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll((Multimap)that.uninterpreted);
            }
            return this;
        }

        public boolean equalsIgnoreUninterpreted(TaskQueueFetchQueueStatsResponse that) {
            return this.equals(that, true);
        }

        public boolean equals(TaskQueueFetchQueueStatsResponse that) {
            return this.equals(that, false);
        }

        public boolean equals(TaskQueueFetchQueueStatsResponse that, boolean ignoreUninterpreted) {
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            int n = this.queuestats_ != null ? this.queuestats_.size() : 0;
            if (n != (that.queuestats_ != null ? that.queuestats_.size() : 0)) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (this.queuestats_.get(i).equals(that.queuestats_.get(i), ignoreUninterpreted)) continue;
                return false;
            }
            return ignoreUninterpreted || UninterpretedTags.equivalent((UninterpretedTags)this.uninterpreted, (UninterpretedTags)that.uninterpreted);
        }

        public boolean equals(Object that) {
            return that instanceof TaskQueueFetchQueueStatsResponse && this.equals((TaskQueueFetchQueueStatsResponse)((Object)that));
        }

        public int hashCode() {
            int n;
            int hash = 997359661;
            hash *= 31;
            int n2 = n = this.queuestats_ != null ? this.queuestats_.size() : 0;
            for (int i = 0; i < n; ++i) {
                hash = hash * 31 + this.queuestats_.get(i).hashCode();
            }
            if (this.uninterpreted != null && !this.uninterpreted.isEmpty()) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        public boolean isInitialized() {
            if (this.queuestats_ != null) {
                for (QueueStats v : this.queuestats_) {
                    if (v.isInitialized()) continue;
                    return false;
                }
            }
            return true;
        }

        public int encodingSize() {
            int n = 0;
            int m = this.queuestats_ != null ? this.queuestats_.size() : 0;
            n += m;
            for (int i = 0; i < m; ++i) {
                n += this.queuestats_.get(i).encodingSize();
            }
            return this.uninterpreted != null ? n + this.uninterpreted.encodingSize() : n;
        }

        public int maxEncodingSize() {
            int n = 0;
            int m = this.queuestats_ != null ? this.queuestats_.size() : 0;
            n += m;
            for (int i = 0; i < m; ++i) {
                n += this.queuestats_.get(i).maxEncodingSize();
            }
            return this.uninterpreted != null ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        public void clear() {
            if (this.queuestats_ != null) {
                this.queuestats_.clear();
            }
            this.uninterpreted = null;
        }

        public TaskQueueFetchQueueStatsResponse newInstance() {
            return new TaskQueueFetchQueueStatsResponse();
        }

        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        public void outputTo(ProtocolSink sink) {
            int m;
            int n = m = this.queuestats_ != null ? this.queuestats_.size() : 0;
            for (int i = 0; i < m; ++i) {
                QueueStats v = this.queuestats_.get(i);
                sink.putByte((byte)11);
                v.outputTo(sink);
            }
            if (this.uninterpreted != null) {
                this.uninterpreted.put(sink);
            }
        }

        public boolean merge(ProtocolSource source) {
            boolean result = true;
            block4: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block4;
                    }
                    case 11: {
                        if (this.addQueueStats().merge(source)) continue block4;
                        result = false;
                        break block4;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put((Object)tt, (Object)source.getUninterpreted(tt));
                        continue block4;
                    }
                }
            }
            return result;
        }

        public TaskQueueFetchQueueStatsResponse getDefaultInstanceForType() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public static final TaskQueueFetchQueueStatsResponse getDefaultInstance() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public TaskQueueFetchQueueStatsResponse freeze() {
            this.queuestats_ = ProtocolSupport.freezeMessages(this.queuestats_);
            return this;
        }

        public TaskQueueFetchQueueStatsResponse unfreeze() {
            this.queuestats_ = ProtocolSupport.unfreezeMessages(this.queuestats_);
            return this;
        }

        public boolean isFrozen() {
            return ProtocolSupport.isFrozenMessages(this.queuestats_);
        }

        static {
            TaskQueueFetchQueueStatsResponse.text[0] = "ErrorCode";
            TaskQueueFetchQueueStatsResponse.text[1] = "QueueStats";
            TaskQueueFetchQueueStatsResponse.text[2] = "num_tasks";
            TaskQueueFetchQueueStatsResponse.text[3] = "oldest_eta_usec";
            TaskQueueFetchQueueStatsResponse.text[4] = "scanner_info";
            types = new int[5];
            Arrays.fill(types, 6);
            TaskQueueFetchQueueStatsResponse.types[0] = 0;
            TaskQueueFetchQueueStatsResponse.types[1] = 3;
            TaskQueueFetchQueueStatsResponse.types[2] = 0;
            TaskQueueFetchQueueStatsResponse.types[3] = 0;
            TaskQueueFetchQueueStatsResponse.types[4] = 2;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(TaskQueueFetchQueueStatsResponse.class, "Z0apphosting/api/taskqueue/taskqueue_service.proto\n+apphosting.TaskQueueFetchQueueStatsResponse\u0013\u001a\nQueueStats \u0001(\u00030\n8\u0003\u0014\u0013\u001a\u0014QueueStats.num_tasks \u0002(\u00000\u00058\u0002`\u0000\u0014\u0013\u001a\u001aQueueStats.oldest_eta_usec \u0003(\u00000\u00038\u0002`\u0000\u0014\u0013\u001a\u0017QueueStats.scanner_info \u0004(\u00020\u000b8\u0001J$apphosting.TaskQueueScannerQueueInfo`\u0000\u0014", new ProtocolType.FieldType[]{new ProtocolType.FieldType("QueueStats", "queuestats", 1, -1, ProtocolType.FieldBaseType.GROUP, ProtocolType.Presence.REPEATED, QueueStats.class)});

            private StaticHolder() {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class QueueStats
        extends ProtocolMessage<QueueStats> {
            private static final long serialVersionUID = 1L;
            private int num_tasks_ = 0;
            private long oldest_eta_usec_ = 0L;
            private TaskQueueScannerQueueInfo scanner_info_ = null;
            private UninterpretedTags uninterpreted;
            private int optional_0_;
            public static final QueueStats IMMUTABLE_DEFAULT_INSTANCE = new QueueStats(){
                private static final long serialVersionUID = 1L;

                public QueueStats clearNumTasks() {
                    return this;
                }

                public QueueStats setNumTasks(int x) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public QueueStats clearOldestEtaUsec() {
                    return this;
                }

                public QueueStats setOldestEtaUsec(long x) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public QueueStats clearScannerInfo() {
                    return this;
                }

                public QueueStats setScannerInfo(TaskQueueScannerQueueInfo x) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public TaskQueueScannerQueueInfo getMutableScannerInfo() {
                    return (TaskQueueScannerQueueInfo)((Object)ProtocolSupport.unsupportedOperation());
                }

                public QueueStats mergeFrom(QueueStats that) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public boolean merge(ProtocolSource source) {
                    ProtocolSupport.unsupportedOperation();
                    return false;
                }

                public QueueStats freeze() {
                    return this;
                }

                public QueueStats unfreeze() {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public boolean isFrozen() {
                    return true;
                }
            };

            public final int getNumTasks() {
                return this.num_tasks_;
            }

            public final boolean hasNumTasks() {
                return (this.optional_0_ & 1) != 0;
            }

            public QueueStats clearNumTasks() {
                this.optional_0_ &= 0xFFFFFFFE;
                this.num_tasks_ = 0;
                return this;
            }

            public QueueStats setNumTasks(int x) {
                this.optional_0_ |= 1;
                this.num_tasks_ = x;
                return this;
            }

            public final long getOldestEtaUsec() {
                return this.oldest_eta_usec_;
            }

            public final boolean hasOldestEtaUsec() {
                return (this.optional_0_ & 2) != 0;
            }

            public QueueStats clearOldestEtaUsec() {
                this.optional_0_ &= 0xFFFFFFFD;
                this.oldest_eta_usec_ = 0L;
                return this;
            }

            public QueueStats setOldestEtaUsec(long x) {
                this.optional_0_ |= 2;
                this.oldest_eta_usec_ = x;
                return this;
            }

            public final TaskQueueScannerQueueInfo getScannerInfo() {
                if (this.scanner_info_ == null) {
                    return TaskQueueScannerQueueInfo.IMMUTABLE_DEFAULT_INSTANCE;
                }
                return this.scanner_info_;
            }

            public final boolean hasScannerInfo() {
                return (this.optional_0_ & 4) != 0;
            }

            public QueueStats clearScannerInfo() {
                this.optional_0_ &= 0xFFFFFFFB;
                if (this.scanner_info_ != null) {
                    this.scanner_info_.clear();
                }
                return this;
            }

            public QueueStats setScannerInfo(TaskQueueScannerQueueInfo x) {
                if (x == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 4;
                this.scanner_info_ = x;
                return this;
            }

            public TaskQueueScannerQueueInfo getMutableScannerInfo() {
                this.optional_0_ |= 4;
                if (this.scanner_info_ == null) {
                    this.scanner_info_ = new TaskQueueScannerQueueInfo();
                }
                return this.scanner_info_;
            }

            public QueueStats mergeFrom(QueueStats that) {
                assert (that != this);
                int this_t0 = this.optional_0_;
                int that_t0 = that.optional_0_;
                if ((that_t0 & 1) != 0) {
                    this_t0 |= 1;
                    this.num_tasks_ = that.num_tasks_;
                }
                if ((that_t0 & 2) != 0) {
                    this_t0 |= 2;
                    this.oldest_eta_usec_ = that.oldest_eta_usec_;
                }
                if ((that_t0 & 4) != 0) {
                    this_t0 |= 4;
                    TaskQueueScannerQueueInfo v = this.scanner_info_;
                    if (v == null) {
                        this.scanner_info_ = v = new TaskQueueScannerQueueInfo();
                    }
                    v.mergeFrom(that.scanner_info_);
                }
                if (that.uninterpreted != null) {
                    if (this.uninterpreted == null) {
                        this.uninterpreted = new UninterpretedTags();
                    }
                    this.uninterpreted.putAll((Multimap)that.uninterpreted);
                }
                this.optional_0_ = this_t0;
                return this;
            }

            public boolean equalsIgnoreUninterpreted(QueueStats that) {
                return this.equals(that, true);
            }

            public boolean equals(QueueStats that) {
                return this.equals(that, false);
            }

            public boolean equals(QueueStats that, boolean ignoreUninterpreted) {
                if (that == null) {
                    return false;
                }
                if (that == this) {
                    return true;
                }
                int this_t0 = this.optional_0_;
                int that_t0 = that.optional_0_;
                if (this_t0 != that_t0) {
                    return false;
                }
                if ((this_t0 & 1) != 0 && this.num_tasks_ != that.num_tasks_) {
                    return false;
                }
                if ((this_t0 & 2) != 0 && this.oldest_eta_usec_ != that.oldest_eta_usec_) {
                    return false;
                }
                if ((this_t0 & 4) != 0 && !this.scanner_info_.equals(that.scanner_info_, ignoreUninterpreted)) {
                    return false;
                }
                return ignoreUninterpreted || UninterpretedTags.equivalent((UninterpretedTags)this.uninterpreted, (UninterpretedTags)that.uninterpreted);
            }

            public boolean equals(Object that) {
                return that instanceof QueueStats && this.equals((QueueStats)((Object)that));
            }

            public int hashCode() {
                int hash = 2027595889;
                int this_t0 = this.optional_0_;
                hash = hash * 31 + ((this_t0 & 1) != 0 ? this.num_tasks_ : -113);
                hash = hash * 31 + ((this_t0 & 2) != 0 ? ProtocolSupport.hashCode((long)this.oldest_eta_usec_) : -113);
                hash = hash * 31 + ((this_t0 & 4) != 0 ? this.scanner_info_.hashCode() : -113);
                if (this.uninterpreted != null && !this.uninterpreted.isEmpty()) {
                    hash = hash * 31 + this.uninterpreted.hashCode();
                }
                return hash;
            }

            public boolean isInitialized() {
                int this_t0 = this.optional_0_;
                if ((this_t0 & 3) != 3) {
                    if ((this_t0 & 1) == 0) {
                        return false;
                    }
                    return false;
                }
                return (this_t0 & 4) == 0 || this.scanner_info_.isInitialized();
            }

            public int encodingSize() {
                int n = 3 + Protocol.varLongSize((long)this.num_tasks_) + Protocol.varLongSize((long)this.oldest_eta_usec_);
                int this_t0 = this.optional_0_;
                if ((this_t0 & 4) != 0) {
                    n += 1 + Protocol.stringSize((int)this.scanner_info_.encodingSize());
                }
                return this.uninterpreted != null ? n + this.uninterpreted.encodingSize() : n;
            }

            public int maxEncodingSize() {
                int n = 23;
                int this_t0 = this.optional_0_;
                if ((this_t0 & 4) != 0) {
                    n += 6 + this.scanner_info_.maxEncodingSize();
                }
                return this.uninterpreted != null ? n + this.uninterpreted.maxEncodingSize() : n;
            }

            public MessageAppender getMessageAppender() {
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                return this.uninterpreted;
            }

            public void clear() {
                this.optional_0_ = 0;
                this.num_tasks_ = 0;
                this.oldest_eta_usec_ = 0L;
                if (this.scanner_info_ != null) {
                    this.scanner_info_.clear();
                }
                this.uninterpreted = null;
            }

            public QueueStats newInstance() {
                return new QueueStats();
            }

            public ProtocolType getProtocolType() {
                return StaticHolder.protocolType;
            }

            public void outputTo(ProtocolSink sink) {
                sink.putByte((byte)16);
                sink.putVarLong(this.num_tasks_);
                sink.putByte((byte)24);
                sink.putVarLong(this.oldest_eta_usec_);
                int this_t0 = this.optional_0_;
                if ((this_t0 & 4) != 0) {
                    sink.putByte((byte)34);
                    sink.putForeign((ProtocolMessage)this.scanner_info_);
                }
                if (this.uninterpreted != null) {
                    this.uninterpreted.put(sink);
                }
                sink.putByte((byte)12);
            }

            public boolean merge(ProtocolSource source) {
                boolean result = true;
                int this_t0 = this.optional_0_;
                block7: while (true) {
                    int tt = source.getVarInt();
                    switch (tt) {
                        case 12: {
                            break block7;
                        }
                        case 0: {
                            result = false;
                            break block7;
                        }
                        case 16: {
                            this.num_tasks_ = source.getVarInt();
                            this_t0 |= 1;
                            continue block7;
                        }
                        case 24: {
                            this.oldest_eta_usec_ = source.getVarLong();
                            this_t0 |= 2;
                            continue block7;
                        }
                        case 34: {
                            source.push(source.getVarInt());
                            TaskQueueScannerQueueInfo v4 = this.scanner_info_;
                            if (v4 == null) {
                                this.scanner_info_ = v4 = new TaskQueueScannerQueueInfo();
                            }
                            if (!v4.merge(source)) {
                                result = false;
                                break block7;
                            }
                            source.pop();
                            this_t0 |= 4;
                            continue block7;
                        }
                        default: {
                            if (this.uninterpreted == null) {
                                this.uninterpreted = new UninterpretedTags();
                            }
                            this.uninterpreted.put((Object)tt, (Object)source.getUninterpreted(tt));
                            continue block7;
                        }
                    }
                    break;
                }
                this.optional_0_ = this_t0;
                return result;
            }

            public QueueStats getDefaultInstanceForType() {
                return IMMUTABLE_DEFAULT_INSTANCE;
            }

            public static final QueueStats getDefaultInstance() {
                return IMMUTABLE_DEFAULT_INSTANCE;
            }

            public QueueStats freeze() {
                if (this.scanner_info_ != null) {
                    this.scanner_info_.freeze();
                }
                return this;
            }

            public QueueStats unfreeze() {
                if (this.scanner_info_ != null) {
                    this.scanner_info_.unfreeze();
                }
                return this;
            }

            public boolean isFrozen() {
                return this.scanner_info_ != null && this.scanner_info_.isFrozen();
            }

            private static class StaticHolder {
                private static final ProtocolType protocolType = new ProtocolType(QueueStats.class, null, new ProtocolType.FieldType[]{new ProtocolType.FieldType("num_tasks", "num_tasks", 2, 0, ProtocolType.FieldBaseType.INT32, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("oldest_eta_usec", "oldest_eta_usec", 3, 1, ProtocolType.FieldBaseType.INT64, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("scanner_info", "scanner_info", 4, 2, ProtocolType.FieldBaseType.FOREIGN, ProtocolType.Presence.OPTIONAL, TaskQueueScannerQueueInfo.class)});

                private StaticHolder() {
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TaskQueueScannerQueueInfo
    extends ProtocolMessage<TaskQueueScannerQueueInfo> {
        private static final long serialVersionUID = 1L;
        private long executed_last_minute_ = 0L;
        private long executed_last_hour_ = 0L;
        private double sampling_duration_seconds_ = 0.0;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final TaskQueueScannerQueueInfo IMMUTABLE_DEFAULT_INSTANCE = new TaskQueueScannerQueueInfo(){
            private static final long serialVersionUID = 1L;

            public TaskQueueScannerQueueInfo clearExecutedLastMinute() {
                return this;
            }

            public TaskQueueScannerQueueInfo setExecutedLastMinute(long x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueScannerQueueInfo clearExecutedLastHour() {
                return this;
            }

            public TaskQueueScannerQueueInfo setExecutedLastHour(long x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueScannerQueueInfo clearSamplingDurationSeconds() {
                return this;
            }

            public TaskQueueScannerQueueInfo setSamplingDurationSeconds(double x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueScannerQueueInfo mergeFrom(TaskQueueScannerQueueInfo that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public TaskQueueScannerQueueInfo freeze() {
                return this;
            }

            public TaskQueueScannerQueueInfo unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kexecuted_last_minute = 1;
        public static final int kexecuted_last_hour = 2;
        public static final int ksampling_duration_seconds = 3;
        public static final String[] text = new String[4];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final long getExecutedLastMinute() {
            return this.executed_last_minute_;
        }

        public final boolean hasExecutedLastMinute() {
            return (this.optional_0_ & 1) != 0;
        }

        public TaskQueueScannerQueueInfo clearExecutedLastMinute() {
            this.optional_0_ &= 0xFFFFFFFE;
            this.executed_last_minute_ = 0L;
            return this;
        }

        public TaskQueueScannerQueueInfo setExecutedLastMinute(long x) {
            this.optional_0_ |= 1;
            this.executed_last_minute_ = x;
            return this;
        }

        public final long getExecutedLastHour() {
            return this.executed_last_hour_;
        }

        public final boolean hasExecutedLastHour() {
            return (this.optional_0_ & 2) != 0;
        }

        public TaskQueueScannerQueueInfo clearExecutedLastHour() {
            this.optional_0_ &= 0xFFFFFFFD;
            this.executed_last_hour_ = 0L;
            return this;
        }

        public TaskQueueScannerQueueInfo setExecutedLastHour(long x) {
            this.optional_0_ |= 2;
            this.executed_last_hour_ = x;
            return this;
        }

        public final double getSamplingDurationSeconds() {
            return this.sampling_duration_seconds_;
        }

        public final boolean hasSamplingDurationSeconds() {
            return (this.optional_0_ & 4) != 0;
        }

        public TaskQueueScannerQueueInfo clearSamplingDurationSeconds() {
            this.optional_0_ &= 0xFFFFFFFB;
            this.sampling_duration_seconds_ = 0.0;
            return this;
        }

        public TaskQueueScannerQueueInfo setSamplingDurationSeconds(double x) {
            this.optional_0_ |= 4;
            this.sampling_duration_seconds_ = x;
            return this;
        }

        public TaskQueueScannerQueueInfo mergeFrom(TaskQueueScannerQueueInfo that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                this.executed_last_minute_ = that.executed_last_minute_;
            }
            if ((that_t0 & 2) != 0) {
                this_t0 |= 2;
                this.executed_last_hour_ = that.executed_last_hour_;
            }
            if ((that_t0 & 4) != 0) {
                this_t0 |= 4;
                this.sampling_duration_seconds_ = that.sampling_duration_seconds_;
            }
            if (that.uninterpreted != null) {
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll((Multimap)that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        public boolean equalsIgnoreUninterpreted(TaskQueueScannerQueueInfo that) {
            return this.equals(that, true);
        }

        public boolean equals(TaskQueueScannerQueueInfo that) {
            return this.equals(that, false);
        }

        public boolean equals(TaskQueueScannerQueueInfo that, boolean ignoreUninterpreted) {
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (this_t0 != that_t0) {
                return false;
            }
            if ((this_t0 & 1) != 0 && this.executed_last_minute_ != that.executed_last_minute_) {
                return false;
            }
            if ((this_t0 & 2) != 0 && this.executed_last_hour_ != that.executed_last_hour_) {
                return false;
            }
            if ((this_t0 & 4) != 0 && this.sampling_duration_seconds_ != that.sampling_duration_seconds_) {
                return false;
            }
            return ignoreUninterpreted || UninterpretedTags.equivalent((UninterpretedTags)this.uninterpreted, (UninterpretedTags)that.uninterpreted);
        }

        public boolean equals(Object that) {
            return that instanceof TaskQueueScannerQueueInfo && this.equals((TaskQueueScannerQueueInfo)((Object)that));
        }

        public int hashCode() {
            int hash = 1033369091;
            int this_t0 = this.optional_0_;
            hash = hash * 31 + ((this_t0 & 1) != 0 ? ProtocolSupport.hashCode((long)this.executed_last_minute_) : -113);
            hash = hash * 31 + ((this_t0 & 2) != 0 ? ProtocolSupport.hashCode((long)this.executed_last_hour_) : -113);
            hash = hash * 31 + ((this_t0 & 4) != 0 ? ProtocolSupport.hashCode((double)this.sampling_duration_seconds_) : -113);
            if (this.uninterpreted != null && !this.uninterpreted.isEmpty()) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        public boolean isInitialized() {
            int this_t0 = this.optional_0_;
            if ((this_t0 & 7) != 7) {
                if ((this_t0 & 1) == 0) {
                    return false;
                }
                if ((this_t0 & 2) == 0) {
                    return false;
                }
                return false;
            }
            return true;
        }

        public int encodingSize() {
            int n = 11 + Protocol.varLongSize((long)this.executed_last_minute_) + Protocol.varLongSize((long)this.executed_last_hour_);
            return this.uninterpreted != null ? n + this.uninterpreted.encodingSize() : n;
        }

        public int maxEncodingSize() {
            int n = 31;
            return this.uninterpreted != null ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        public void clear() {
            this.optional_0_ = 0;
            this.executed_last_minute_ = 0L;
            this.executed_last_hour_ = 0L;
            this.sampling_duration_seconds_ = 0.0;
            this.uninterpreted = null;
        }

        public TaskQueueScannerQueueInfo newInstance() {
            return new TaskQueueScannerQueueInfo();
        }

        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        public void outputTo(ProtocolSink sink) {
            sink.putByte((byte)8);
            sink.putVarLong(this.executed_last_minute_);
            sink.putByte((byte)16);
            sink.putVarLong(this.executed_last_hour_);
            sink.putByte((byte)25);
            sink.putDouble(this.sampling_duration_seconds_);
            if (this.uninterpreted != null) {
                this.uninterpreted.put(sink);
            }
        }

        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block6: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block6;
                    }
                    case 8: {
                        this.executed_last_minute_ = source.getVarLong();
                        this_t0 |= 1;
                        continue block6;
                    }
                    case 16: {
                        this.executed_last_hour_ = source.getVarLong();
                        this_t0 |= 2;
                        continue block6;
                    }
                    case 25: {
                        this.sampling_duration_seconds_ = source.getDouble();
                        this_t0 |= 4;
                        continue block6;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put((Object)tt, (Object)source.getUninterpreted(tt));
                        continue block6;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        public TaskQueueScannerQueueInfo getDefaultInstanceForType() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public static final TaskQueueScannerQueueInfo getDefaultInstance() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        static {
            TaskQueueScannerQueueInfo.text[0] = "ErrorCode";
            TaskQueueScannerQueueInfo.text[1] = "executed_last_minute";
            TaskQueueScannerQueueInfo.text[2] = "executed_last_hour";
            TaskQueueScannerQueueInfo.text[3] = "sampling_duration_seconds";
            types = new int[4];
            Arrays.fill(types, 6);
            TaskQueueScannerQueueInfo.types[0] = 0;
            TaskQueueScannerQueueInfo.types[1] = 0;
            TaskQueueScannerQueueInfo.types[2] = 0;
            TaskQueueScannerQueueInfo.types[3] = 1;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(TaskQueueScannerQueueInfo.class, "Z0apphosting/api/taskqueue/taskqueue_service.proto\n$apphosting.TaskQueueScannerQueueInfo\u0013\u001a\u0014executed_last_minute \u0001(\u00000\u00038\u0002\u0014\u0013\u001a\u0012executed_last_hour \u0002(\u00000\u00038\u0002\u0014\u0013\u001a\u0019sampling_duration_seconds \u0003(\u00010\u00018\u0002\u0014", new ProtocolType.FieldType[]{new ProtocolType.FieldType("executed_last_minute", "executed_last_minute", 1, 0, ProtocolType.FieldBaseType.INT64, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("executed_last_hour", "executed_last_hour", 2, 1, ProtocolType.FieldBaseType.INT64, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("sampling_duration_seconds", "sampling_duration_seconds", 3, 2, ProtocolType.FieldBaseType.DOUBLE, ProtocolType.Presence.REQUIRED)});

            private StaticHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TaskQueueFetchQueueStatsRequest
    extends ProtocolMessage<TaskQueueFetchQueueStatsRequest> {
        private static final long serialVersionUID = 1L;
        private byte[] app_id_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private List<byte[]> queue_name_ = null;
        private int max_num_tasks_ = 0;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final TaskQueueFetchQueueStatsRequest IMMUTABLE_DEFAULT_INSTANCE = new TaskQueueFetchQueueStatsRequest(){
            private static final long serialVersionUID = 1L;

            public TaskQueueFetchQueueStatsRequest clearAppId() {
                return this;
            }

            public TaskQueueFetchQueueStatsRequest setAppIdAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueFetchQueueStatsRequest setAppId(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueFetchQueueStatsRequest setAppId(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueFetchQueueStatsRequest clearQueueName() {
                return this;
            }

            public TaskQueueFetchQueueStatsRequest setQueueNameAsBytes(int i, byte[] v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueFetchQueueStatsRequest setQueueName(int i, String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueFetchQueueStatsRequest addQueueNameAsBytes(byte[] v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueFetchQueueStatsRequest addQueueName(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueFetchQueueStatsRequest setQueueName(int i, String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueFetchQueueStatsRequest addQueueName(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueFetchQueueStatsRequest clearMaxNumTasks() {
                return this;
            }

            public TaskQueueFetchQueueStatsRequest setMaxNumTasks(int x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueFetchQueueStatsRequest mergeFrom(TaskQueueFetchQueueStatsRequest that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public TaskQueueFetchQueueStatsRequest freeze() {
                return this;
            }

            public TaskQueueFetchQueueStatsRequest unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kapp_id = 1;
        public static final int kqueue_name = 2;
        public static final int kmax_num_tasks = 3;
        public static final String[] text = new String[4];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final byte[] getAppIdAsBytes() {
            return this.app_id_;
        }

        public final boolean hasAppId() {
            return (this.optional_0_ & 1) != 0;
        }

        public TaskQueueFetchQueueStatsRequest clearAppId() {
            this.optional_0_ &= 0xFFFFFFFE;
            this.app_id_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public TaskQueueFetchQueueStatsRequest setAppIdAsBytes(byte[] x) {
            this.optional_0_ |= 1;
            this.app_id_ = x;
            return this;
        }

        public final String getAppId() {
            return ProtocolSupport.toStringUtf8((byte[])this.app_id_);
        }

        public TaskQueueFetchQueueStatsRequest setAppId(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.app_id_ = ProtocolSupport.toBytesUtf8((String)v);
            return this;
        }

        public final String getAppId(Charset cs) {
            return ProtocolSupport.toString((byte[])this.app_id_, (Charset)cs);
        }

        public TaskQueueFetchQueueStatsRequest setAppId(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.app_id_ = ProtocolSupport.toBytes((String)v, (Charset)cs);
            return this;
        }

        public final int queueNameSize() {
            return this.queue_name_ != null ? this.queue_name_.size() : 0;
        }

        public final byte[] getQueueNameAsBytes(int i) {
            assert (i >= 0 && i < (this.queue_name_ != null ? this.queue_name_.size() : 0));
            return this.queue_name_.get(i);
        }

        public TaskQueueFetchQueueStatsRequest clearQueueName() {
            if (this.queue_name_ != null) {
                this.queue_name_.clear();
            }
            return this;
        }

        public final String getQueueName(int i) {
            return ProtocolSupport.toStringUtf8((byte[])this.queue_name_.get(i));
        }

        public TaskQueueFetchQueueStatsRequest setQueueNameAsBytes(int i, byte[] v) {
            this.queue_name_.set(i, v);
            return this;
        }

        public TaskQueueFetchQueueStatsRequest setQueueName(int i, String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.queue_name_.set(i, ProtocolSupport.toBytesUtf8((String)v));
            return this;
        }

        public TaskQueueFetchQueueStatsRequest addQueueNameAsBytes(byte[] v) {
            if (this.queue_name_ == null) {
                this.queue_name_ = new ArrayList<byte[]>(4);
            }
            this.queue_name_.add(v);
            return this;
        }

        public TaskQueueFetchQueueStatsRequest addQueueName(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            if (this.queue_name_ == null) {
                this.queue_name_ = new ArrayList<byte[]>(4);
            }
            this.queue_name_.add(ProtocolSupport.toBytesUtf8((String)v));
            return this;
        }

        public final Iterator<String> queueNameIterator() {
            return ProtocolSupport.byteArrayToUnicodeIterator(this.queue_name_);
        }

        public final List<String> queueNames() {
            return ProtocolSupport.byteArrayToUnicodeList(this.queue_name_);
        }

        public final Iterator<byte[]> queueNameAsBytesIterator() {
            return this.queue_name_ == null ? ProtocolSupport.emptyIterator() : this.queue_name_.iterator();
        }

        public final List<byte[]> queueNamesAsBytes() {
            return ProtocolSupport.unmodifiableList(this.queue_name_);
        }

        public final List<byte[]> mutableQueueNamesAsBytes() {
            if (this.queue_name_ == null) {
                this.queue_name_ = new ArrayList<byte[]>(4);
            }
            return this.queue_name_;
        }

        public final String getQueueName(int i, Charset cs) {
            return ProtocolSupport.toString((byte[])this.queue_name_.get(i), (Charset)cs);
        }

        public TaskQueueFetchQueueStatsRequest setQueueName(int i, String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.queue_name_.set(i, ProtocolSupport.toBytes((String)v, (Charset)cs));
            return this;
        }

        public TaskQueueFetchQueueStatsRequest addQueueName(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            if (this.queue_name_ == null) {
                this.queue_name_ = new ArrayList<byte[]>(4);
            }
            this.queue_name_.add(ProtocolSupport.toBytes((String)v, (Charset)cs));
            return this;
        }

        public final Iterator<String> queueNameIterator(Charset cs) {
            return ProtocolSupport.byteArrayToUnicodeIterator(this.queue_name_, (Charset)cs);
        }

        public final List<String> queueNames(Charset cs) {
            return ProtocolSupport.byteArrayToUnicodeList(this.queue_name_, (Charset)cs);
        }

        public final int getMaxNumTasks() {
            return this.max_num_tasks_;
        }

        public final boolean hasMaxNumTasks() {
            return (this.optional_0_ & 2) != 0;
        }

        public TaskQueueFetchQueueStatsRequest clearMaxNumTasks() {
            this.optional_0_ &= 0xFFFFFFFD;
            this.max_num_tasks_ = 0;
            return this;
        }

        public TaskQueueFetchQueueStatsRequest setMaxNumTasks(int x) {
            this.optional_0_ |= 2;
            this.max_num_tasks_ = x;
            return this;
        }

        public TaskQueueFetchQueueStatsRequest mergeFrom(TaskQueueFetchQueueStatsRequest that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                this.app_id_ = that.app_id_;
            }
            if (that.queue_name_ != null && that.queue_name_.size() > 0) {
                if (this.queue_name_ == null) {
                    this.queue_name_ = new ArrayList<byte[]>(that.queue_name_);
                } else {
                    this.queue_name_.addAll(that.queue_name_);
                }
            }
            if ((that_t0 & 2) != 0) {
                this_t0 |= 2;
                this.max_num_tasks_ = that.max_num_tasks_;
            }
            if (that.uninterpreted != null) {
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll((Multimap)that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        public boolean equalsIgnoreUninterpreted(TaskQueueFetchQueueStatsRequest that) {
            return this.equals(that, true);
        }

        public boolean equals(TaskQueueFetchQueueStatsRequest that) {
            return this.equals(that, false);
        }

        public boolean equals(TaskQueueFetchQueueStatsRequest that, boolean ignoreUninterpreted) {
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (this_t0 != that_t0) {
                return false;
            }
            if ((this_t0 & 1) != 0 && !Arrays.equals(this.app_id_, that.app_id_)) {
                return false;
            }
            int n = this.queue_name_ != null ? this.queue_name_.size() : 0;
            if (n != (that.queue_name_ != null ? that.queue_name_.size() : 0)) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (Arrays.equals(this.queue_name_.get(i), that.queue_name_.get(i))) continue;
                return false;
            }
            if ((this_t0 & 2) != 0 && this.max_num_tasks_ != that.max_num_tasks_) {
                return false;
            }
            return ignoreUninterpreted || UninterpretedTags.equivalent((UninterpretedTags)this.uninterpreted, (UninterpretedTags)that.uninterpreted);
        }

        public boolean equals(Object that) {
            return that instanceof TaskQueueFetchQueueStatsRequest && this.equals((TaskQueueFetchQueueStatsRequest)((Object)that));
        }

        public int hashCode() {
            int n;
            int hash = -1143658581;
            int this_t0 = this.optional_0_;
            hash = hash * 31 + ((this_t0 & 1) != 0 ? Arrays.hashCode(this.app_id_) : -113);
            hash *= 31;
            int n2 = n = this.queue_name_ != null ? this.queue_name_.size() : 0;
            for (int i = 0; i < n; ++i) {
                hash = hash * 31 + Arrays.hashCode(this.queue_name_.get(i));
            }
            hash = hash * 31 + ((this_t0 & 2) != 0 ? this.max_num_tasks_ : -113);
            if (this.uninterpreted != null && !this.uninterpreted.isEmpty()) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        public boolean isInitialized() {
            int this_t0 = this.optional_0_;
            if ((this_t0 & 3) != 3) {
                if ((this_t0 & 1) == 0) {
                    return false;
                }
                return false;
            }
            return true;
        }

        public int encodingSize() {
            int n = 2 + Protocol.stringSize((int)this.app_id_.length) + Protocol.varLongSize((long)this.max_num_tasks_);
            int m = this.queue_name_ != null ? this.queue_name_.size() : 0;
            n += m;
            for (int i = 0; i < m; ++i) {
                n += Protocol.stringSize((int)this.queue_name_.get(i).length);
            }
            return this.uninterpreted != null ? n + this.uninterpreted.encodingSize() : n;
        }

        public int maxEncodingSize() {
            int n = 17 + this.app_id_.length;
            int m = this.queue_name_ != null ? this.queue_name_.size() : 0;
            n += 6 * m;
            for (int i = 0; i < m; ++i) {
                n += this.queue_name_.get(i).length;
            }
            return this.uninterpreted != null ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        public void clear() {
            this.optional_0_ = 0;
            this.app_id_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            if (this.queue_name_ != null) {
                this.queue_name_.clear();
            }
            this.max_num_tasks_ = 0;
            this.uninterpreted = null;
        }

        public TaskQueueFetchQueueStatsRequest newInstance() {
            return new TaskQueueFetchQueueStatsRequest();
        }

        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        public void outputTo(ProtocolSink sink) {
            int m;
            sink.putByte((byte)10);
            sink.putPrefixedData(this.app_id_);
            int n = m = this.queue_name_ != null ? this.queue_name_.size() : 0;
            for (int i = 0; i < m; ++i) {
                byte[] v = this.queue_name_.get(i);
                sink.putByte((byte)18);
                sink.putPrefixedData(v);
            }
            sink.putByte((byte)24);
            sink.putVarLong(this.max_num_tasks_);
            if (this.uninterpreted != null) {
                this.uninterpreted.put(sink);
            }
        }

        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block6: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block6;
                    }
                    case 10: {
                        this.app_id_ = source.getPrefixedData();
                        this_t0 |= 1;
                        continue block6;
                    }
                    case 18: {
                        this.addQueueNameAsBytes(source.getPrefixedData());
                        continue block6;
                    }
                    case 24: {
                        this.max_num_tasks_ = source.getVarInt();
                        this_t0 |= 2;
                        continue block6;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put((Object)tt, (Object)source.getUninterpreted(tt));
                        continue block6;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        public TaskQueueFetchQueueStatsRequest getDefaultInstanceForType() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public static final TaskQueueFetchQueueStatsRequest getDefaultInstance() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public TaskQueueFetchQueueStatsRequest freeze() {
            this.app_id_ = ProtocolSupport.freezeString((byte[])this.app_id_);
            this.queue_name_ = ProtocolSupport.freezeStrings(this.queue_name_);
            return this;
        }

        public TaskQueueFetchQueueStatsRequest unfreeze() {
            this.queue_name_ = ProtocolSupport.unfreezeStrings(this.queue_name_);
            return this;
        }

        public boolean isFrozen() {
            return ProtocolSupport.isFrozenStrings(this.queue_name_);
        }

        static {
            TaskQueueFetchQueueStatsRequest.text[0] = "ErrorCode";
            TaskQueueFetchQueueStatsRequest.text[1] = "app_id";
            TaskQueueFetchQueueStatsRequest.text[2] = "queue_name";
            TaskQueueFetchQueueStatsRequest.text[3] = "max_num_tasks";
            types = new int[4];
            Arrays.fill(types, 6);
            TaskQueueFetchQueueStatsRequest.types[0] = 0;
            TaskQueueFetchQueueStatsRequest.types[1] = 2;
            TaskQueueFetchQueueStatsRequest.types[2] = 2;
            TaskQueueFetchQueueStatsRequest.types[3] = 0;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(TaskQueueFetchQueueStatsRequest.class, "Z0apphosting/api/taskqueue/taskqueue_service.proto\n*apphosting.TaskQueueFetchQueueStatsRequest\u0013\u001a\u0006app_id \u0001(\u00020\t8\u0002\u0014\u0013\u001a\nqueue_name \u0002(\u00020\t8\u0003\u0014\u0013\u001a\rmax_num_tasks \u0003(\u00000\u00058\u0002\u0014", new ProtocolType.FieldType[]{new ProtocolType.FieldType("app_id", "app_id", 1, 0, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("queue_name", "queue_name", 2, -1, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REPEATED), new ProtocolType.FieldType("max_num_tasks", "max_num_tasks", 3, 1, ProtocolType.FieldBaseType.INT32, ProtocolType.Presence.REQUIRED)});

            private StaticHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TaskQueueFetchQueuesResponse
    extends ProtocolMessage<TaskQueueFetchQueuesResponse> {
        private static final long serialVersionUID = 1L;
        private List<Queue> queue_ = null;
        private UninterpretedTags uninterpreted;
        public static final TaskQueueFetchQueuesResponse IMMUTABLE_DEFAULT_INSTANCE = new TaskQueueFetchQueuesResponse(){
            private static final long serialVersionUID = 1L;

            public TaskQueueFetchQueuesResponse clearQueue() {
                return this;
            }

            public Queue getMutableQueue(int i) {
                return (Queue)((Object)ProtocolSupport.unsupportedOperation());
            }

            public Queue addQueue() {
                return (Queue)((Object)ProtocolSupport.unsupportedOperation());
            }

            public Queue addQueue(Queue v) {
                return (Queue)((Object)ProtocolSupport.unsupportedOperation());
            }

            public Queue insertQueue(int i, Queue v) {
                return (Queue)((Object)ProtocolSupport.unsupportedOperation());
            }

            public Queue removeQueue(int i) {
                return (Queue)((Object)ProtocolSupport.unsupportedOperation());
            }

            public TaskQueueFetchQueuesResponse mergeFrom(TaskQueueFetchQueuesResponse that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public TaskQueueFetchQueuesResponse freeze() {
                return this;
            }

            public TaskQueueFetchQueuesResponse unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kQueueGroup = 1;
        public static final int kQueuequeue_name = 2;
        public static final int kQueuebucket_refill_per_second = 3;
        public static final int kQueuebucket_capacity = 4;
        public static final int kQueueuser_specified_rate = 5;
        public static final int kQueuepaused = 6;
        public static final String[] text = new String[7];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final int queueSize() {
            return this.queue_ != null ? this.queue_.size() : 0;
        }

        public final Queue getQueue(int i) {
            assert (i >= 0 && i < (this.queue_ != null ? this.queue_.size() : 0));
            return this.queue_.get(i);
        }

        public TaskQueueFetchQueuesResponse clearQueue() {
            if (this.queue_ != null) {
                this.queue_.clear();
            }
            return this;
        }

        public Queue getMutableQueue(int i) {
            assert (i >= 0 && this.queue_ != null && i < this.queue_.size());
            return this.queue_.get(i);
        }

        public Queue addQueue() {
            Queue v = new Queue();
            if (this.queue_ == null) {
                this.queue_ = new ArrayList<Queue>(4);
            }
            this.queue_.add(v);
            return v;
        }

        public Queue addQueue(Queue v) {
            if (this.queue_ == null) {
                this.queue_ = new ArrayList<Queue>(4);
            }
            this.queue_.add(v);
            return v;
        }

        public Queue insertQueue(int i, Queue v) {
            if (this.queue_ == null) {
                this.queue_ = new ArrayList<Queue>(4);
            }
            this.queue_.add(i, v);
            return v;
        }

        public Queue removeQueue(int i) {
            return this.queue_.remove(i);
        }

        public final Iterator<Queue> queueIterator() {
            if (this.queue_ == null) {
                return ProtocolSupport.emptyIterator();
            }
            return this.queue_.iterator();
        }

        public final List<Queue> queues() {
            return ProtocolSupport.unmodifiableList(this.queue_);
        }

        public final List<Queue> mutableQueues() {
            if (this.queue_ == null) {
                this.queue_ = new ArrayList<Queue>(4);
            }
            return this.queue_;
        }

        public TaskQueueFetchQueuesResponse mergeFrom(TaskQueueFetchQueuesResponse that) {
            assert (that != this);
            if (that.queue_ != null) {
                for (Queue v : that.queue_) {
                    this.addQueue().mergeFrom(v);
                }
            }
            if (that.uninterpreted != null) {
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll((Multimap)that.uninterpreted);
            }
            return this;
        }

        public boolean equalsIgnoreUninterpreted(TaskQueueFetchQueuesResponse that) {
            return this.equals(that, true);
        }

        public boolean equals(TaskQueueFetchQueuesResponse that) {
            return this.equals(that, false);
        }

        public boolean equals(TaskQueueFetchQueuesResponse that, boolean ignoreUninterpreted) {
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            int n = this.queue_ != null ? this.queue_.size() : 0;
            if (n != (that.queue_ != null ? that.queue_.size() : 0)) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (this.queue_.get(i).equals(that.queue_.get(i), ignoreUninterpreted)) continue;
                return false;
            }
            return ignoreUninterpreted || UninterpretedTags.equivalent((UninterpretedTags)this.uninterpreted, (UninterpretedTags)that.uninterpreted);
        }

        public boolean equals(Object that) {
            return that instanceof TaskQueueFetchQueuesResponse && this.equals((TaskQueueFetchQueuesResponse)((Object)that));
        }

        public int hashCode() {
            int n;
            int hash = -1870976603;
            hash *= 31;
            int n2 = n = this.queue_ != null ? this.queue_.size() : 0;
            for (int i = 0; i < n; ++i) {
                hash = hash * 31 + this.queue_.get(i).hashCode();
            }
            if (this.uninterpreted != null && !this.uninterpreted.isEmpty()) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        public boolean isInitialized() {
            if (this.queue_ != null) {
                for (Queue v : this.queue_) {
                    if (v.isInitialized()) continue;
                    return false;
                }
            }
            return true;
        }

        public int encodingSize() {
            int n = 0;
            int m = this.queue_ != null ? this.queue_.size() : 0;
            n += m;
            for (int i = 0; i < m; ++i) {
                n += this.queue_.get(i).encodingSize();
            }
            return this.uninterpreted != null ? n + this.uninterpreted.encodingSize() : n;
        }

        public int maxEncodingSize() {
            int n = 0;
            int m = this.queue_ != null ? this.queue_.size() : 0;
            n += m;
            for (int i = 0; i < m; ++i) {
                n += this.queue_.get(i).maxEncodingSize();
            }
            return this.uninterpreted != null ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        public void clear() {
            if (this.queue_ != null) {
                this.queue_.clear();
            }
            this.uninterpreted = null;
        }

        public TaskQueueFetchQueuesResponse newInstance() {
            return new TaskQueueFetchQueuesResponse();
        }

        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        public void outputTo(ProtocolSink sink) {
            int m;
            int n = m = this.queue_ != null ? this.queue_.size() : 0;
            for (int i = 0; i < m; ++i) {
                Queue v = this.queue_.get(i);
                sink.putByte((byte)11);
                v.outputTo(sink);
            }
            if (this.uninterpreted != null) {
                this.uninterpreted.put(sink);
            }
        }

        public boolean merge(ProtocolSource source) {
            boolean result = true;
            block4: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block4;
                    }
                    case 11: {
                        if (this.addQueue().merge(source)) continue block4;
                        result = false;
                        break block4;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put((Object)tt, (Object)source.getUninterpreted(tt));
                        continue block4;
                    }
                }
            }
            return result;
        }

        public TaskQueueFetchQueuesResponse getDefaultInstanceForType() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public static final TaskQueueFetchQueuesResponse getDefaultInstance() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public TaskQueueFetchQueuesResponse freeze() {
            this.queue_ = ProtocolSupport.freezeMessages(this.queue_);
            return this;
        }

        public TaskQueueFetchQueuesResponse unfreeze() {
            this.queue_ = ProtocolSupport.unfreezeMessages(this.queue_);
            return this;
        }

        public boolean isFrozen() {
            return ProtocolSupport.isFrozenMessages(this.queue_);
        }

        static {
            TaskQueueFetchQueuesResponse.text[0] = "ErrorCode";
            TaskQueueFetchQueuesResponse.text[1] = "Queue";
            TaskQueueFetchQueuesResponse.text[2] = "queue_name";
            TaskQueueFetchQueuesResponse.text[3] = "bucket_refill_per_second";
            TaskQueueFetchQueuesResponse.text[4] = "bucket_capacity";
            TaskQueueFetchQueuesResponse.text[5] = "user_specified_rate";
            TaskQueueFetchQueuesResponse.text[6] = "paused";
            types = new int[7];
            Arrays.fill(types, 6);
            TaskQueueFetchQueuesResponse.types[0] = 0;
            TaskQueueFetchQueuesResponse.types[1] = 3;
            TaskQueueFetchQueuesResponse.types[2] = 2;
            TaskQueueFetchQueuesResponse.types[3] = 1;
            TaskQueueFetchQueuesResponse.types[4] = 1;
            TaskQueueFetchQueuesResponse.types[5] = 2;
            TaskQueueFetchQueuesResponse.types[6] = 0;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(TaskQueueFetchQueuesResponse.class, "Z0apphosting/api/taskqueue/taskqueue_service.proto\n'apphosting.TaskQueueFetchQueuesResponse\u0013\u001a\u0005Queue \u0001(\u00030\n8\u0003\u0014\u0013\u001a\u0010Queue.queue_name \u0002(\u00020\t8\u0002`\u0000\u0014\u0013\u001a\u001eQueue.bucket_refill_per_second \u0003(\u00010\u00018\u0002`\u0000\u0014\u0013\u001a\u0015Queue.bucket_capacity \u0004(\u00010\u00018\u0002`\u0000\u0014\u0013\u001a\u0019Queue.user_specified_rate \u0005(\u00020\t8\u0001`\u0000\u0014\u0013\u001a\fQueue.paused \u0006(\u00000\b8\u0002B\u0005false`\u0000\u00a3\u0001\u00aa\u0001\u0007default\u00b2\u0001\u0005false\u00a4\u0001\u0014", new ProtocolType.FieldType[]{new ProtocolType.FieldType("Queue", "queue", 1, -1, ProtocolType.FieldBaseType.GROUP, ProtocolType.Presence.REPEATED, Queue.class)});

            private StaticHolder() {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Queue
        extends ProtocolMessage<Queue> {
            private static final long serialVersionUID = 1L;
            private byte[] queue_name_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            private double bucket_refill_per_second_ = 0.0;
            private double bucket_capacity_ = 0.0;
            private byte[] user_specified_rate_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            private boolean paused_ = false;
            private UninterpretedTags uninterpreted;
            private int optional_0_;
            public static final Queue IMMUTABLE_DEFAULT_INSTANCE = new Queue(){
                private static final long serialVersionUID = 1L;

                public Queue clearQueueName() {
                    return this;
                }

                public Queue setQueueNameAsBytes(byte[] x) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Queue setQueueName(String v) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Queue setQueueName(String v, Charset cs) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Queue clearBucketRefillPerSecond() {
                    return this;
                }

                public Queue setBucketRefillPerSecond(double x) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Queue clearBucketCapacity() {
                    return this;
                }

                public Queue setBucketCapacity(double x) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Queue clearUserSpecifiedRate() {
                    return this;
                }

                public Queue setUserSpecifiedRateAsBytes(byte[] x) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Queue setUserSpecifiedRate(String v) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Queue setUserSpecifiedRate(String v, Charset cs) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Queue clearPaused() {
                    return this;
                }

                public Queue setPaused(boolean x) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Queue mergeFrom(Queue that) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public boolean merge(ProtocolSource source) {
                    ProtocolSupport.unsupportedOperation();
                    return false;
                }

                public Queue freeze() {
                    return this;
                }

                public Queue unfreeze() {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public boolean isFrozen() {
                    return true;
                }
            };

            public final byte[] getQueueNameAsBytes() {
                return this.queue_name_;
            }

            public final boolean hasQueueName() {
                return (this.optional_0_ & 1) != 0;
            }

            public Queue clearQueueName() {
                this.optional_0_ &= 0xFFFFFFFE;
                this.queue_name_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
                return this;
            }

            public Queue setQueueNameAsBytes(byte[] x) {
                this.optional_0_ |= 1;
                this.queue_name_ = x;
                return this;
            }

            public final String getQueueName() {
                return ProtocolSupport.toStringUtf8((byte[])this.queue_name_);
            }

            public Queue setQueueName(String v) {
                if (v == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 1;
                this.queue_name_ = ProtocolSupport.toBytesUtf8((String)v);
                return this;
            }

            public final String getQueueName(Charset cs) {
                return ProtocolSupport.toString((byte[])this.queue_name_, (Charset)cs);
            }

            public Queue setQueueName(String v, Charset cs) {
                if (v == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 1;
                this.queue_name_ = ProtocolSupport.toBytes((String)v, (Charset)cs);
                return this;
            }

            public final double getBucketRefillPerSecond() {
                return this.bucket_refill_per_second_;
            }

            public final boolean hasBucketRefillPerSecond() {
                return (this.optional_0_ & 2) != 0;
            }

            public Queue clearBucketRefillPerSecond() {
                this.optional_0_ &= 0xFFFFFFFD;
                this.bucket_refill_per_second_ = 0.0;
                return this;
            }

            public Queue setBucketRefillPerSecond(double x) {
                this.optional_0_ |= 2;
                this.bucket_refill_per_second_ = x;
                return this;
            }

            public final double getBucketCapacity() {
                return this.bucket_capacity_;
            }

            public final boolean hasBucketCapacity() {
                return (this.optional_0_ & 4) != 0;
            }

            public Queue clearBucketCapacity() {
                this.optional_0_ &= 0xFFFFFFFB;
                this.bucket_capacity_ = 0.0;
                return this;
            }

            public Queue setBucketCapacity(double x) {
                this.optional_0_ |= 4;
                this.bucket_capacity_ = x;
                return this;
            }

            public final byte[] getUserSpecifiedRateAsBytes() {
                return this.user_specified_rate_;
            }

            public final boolean hasUserSpecifiedRate() {
                return (this.optional_0_ & 8) != 0;
            }

            public Queue clearUserSpecifiedRate() {
                this.optional_0_ &= 0xFFFFFFF7;
                this.user_specified_rate_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
                return this;
            }

            public Queue setUserSpecifiedRateAsBytes(byte[] x) {
                this.optional_0_ |= 8;
                this.user_specified_rate_ = x;
                return this;
            }

            public final String getUserSpecifiedRate() {
                return ProtocolSupport.toStringUtf8((byte[])this.user_specified_rate_);
            }

            public Queue setUserSpecifiedRate(String v) {
                if (v == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 8;
                this.user_specified_rate_ = ProtocolSupport.toBytesUtf8((String)v);
                return this;
            }

            public final String getUserSpecifiedRate(Charset cs) {
                return ProtocolSupport.toString((byte[])this.user_specified_rate_, (Charset)cs);
            }

            public Queue setUserSpecifiedRate(String v, Charset cs) {
                if (v == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 8;
                this.user_specified_rate_ = ProtocolSupport.toBytes((String)v, (Charset)cs);
                return this;
            }

            public final boolean isPaused() {
                return this.paused_;
            }

            public final boolean hasPaused() {
                return (this.optional_0_ & 0x10) != 0;
            }

            public Queue clearPaused() {
                this.optional_0_ &= 0xFFFFFFEF;
                this.paused_ = false;
                return this;
            }

            public Queue setPaused(boolean x) {
                this.optional_0_ |= 0x10;
                this.paused_ = x;
                return this;
            }

            public Queue mergeFrom(Queue that) {
                assert (that != this);
                int this_t0 = this.optional_0_;
                int that_t0 = that.optional_0_;
                if ((that_t0 & 1) != 0) {
                    this_t0 |= 1;
                    this.queue_name_ = that.queue_name_;
                }
                if ((that_t0 & 2) != 0) {
                    this_t0 |= 2;
                    this.bucket_refill_per_second_ = that.bucket_refill_per_second_;
                }
                if ((that_t0 & 4) != 0) {
                    this_t0 |= 4;
                    this.bucket_capacity_ = that.bucket_capacity_;
                }
                if ((that_t0 & 8) != 0) {
                    this_t0 |= 8;
                    this.user_specified_rate_ = that.user_specified_rate_;
                }
                if ((that_t0 & 0x10) != 0) {
                    this_t0 |= 0x10;
                    this.paused_ = that.paused_;
                }
                if (that.uninterpreted != null) {
                    if (this.uninterpreted == null) {
                        this.uninterpreted = new UninterpretedTags();
                    }
                    this.uninterpreted.putAll((Multimap)that.uninterpreted);
                }
                this.optional_0_ = this_t0;
                return this;
            }

            public boolean equalsIgnoreUninterpreted(Queue that) {
                return this.equals(that, true);
            }

            public boolean equals(Queue that) {
                return this.equals(that, false);
            }

            public boolean equals(Queue that, boolean ignoreUninterpreted) {
                if (that == null) {
                    return false;
                }
                if (that == this) {
                    return true;
                }
                int this_t0 = this.optional_0_;
                int that_t0 = that.optional_0_;
                if (this_t0 != that_t0) {
                    return false;
                }
                if ((this_t0 & 1) != 0 && !Arrays.equals(this.queue_name_, that.queue_name_)) {
                    return false;
                }
                if ((this_t0 & 2) != 0 && this.bucket_refill_per_second_ != that.bucket_refill_per_second_) {
                    return false;
                }
                if ((this_t0 & 4) != 0 && this.bucket_capacity_ != that.bucket_capacity_) {
                    return false;
                }
                if ((this_t0 & 8) != 0 && !Arrays.equals(this.user_specified_rate_, that.user_specified_rate_)) {
                    return false;
                }
                if ((this_t0 & 0x10) != 0 && this.paused_ != that.paused_) {
                    return false;
                }
                return ignoreUninterpreted || UninterpretedTags.equivalent((UninterpretedTags)this.uninterpreted, (UninterpretedTags)that.uninterpreted);
            }

            public boolean equals(Object that) {
                return that instanceof Queue && this.equals((Queue)((Object)that));
            }

            public int hashCode() {
                int hash = -742449327;
                int this_t0 = this.optional_0_;
                hash = hash * 31 + ((this_t0 & 1) != 0 ? Arrays.hashCode(this.queue_name_) : -113);
                hash = hash * 31 + ((this_t0 & 2) != 0 ? ProtocolSupport.hashCode((double)this.bucket_refill_per_second_) : -113);
                hash = hash * 31 + ((this_t0 & 4) != 0 ? ProtocolSupport.hashCode((double)this.bucket_capacity_) : -113);
                hash = hash * 31 + ((this_t0 & 8) != 0 ? Arrays.hashCode(this.user_specified_rate_) : -113);
                hash = hash * 31 + ((this_t0 & 0x10) != 0 ? (this.paused_ ? 1231 : 1237) : -113);
                if (this.uninterpreted != null && !this.uninterpreted.isEmpty()) {
                    hash = hash * 31 + this.uninterpreted.hashCode();
                }
                return hash;
            }

            public boolean isInitialized() {
                int this_t0 = this.optional_0_;
                if ((this_t0 & 0x17) != 23) {
                    if ((this_t0 & 1) == 0) {
                        return false;
                    }
                    if ((this_t0 & 2) == 0) {
                        return false;
                    }
                    if ((this_t0 & 4) == 0) {
                        return false;
                    }
                    return false;
                }
                return true;
            }

            public int encodingSize() {
                int n = 22 + Protocol.stringSize((int)this.queue_name_.length);
                int this_t0 = this.optional_0_;
                if ((this_t0 & 8) != 0) {
                    n += 1 + Protocol.stringSize((int)this.user_specified_rate_.length);
                }
                return this.uninterpreted != null ? n + this.uninterpreted.encodingSize() : n;
            }

            public int maxEncodingSize() {
                int n = 27 + this.queue_name_.length;
                int this_t0 = this.optional_0_;
                if ((this_t0 & 8) != 0) {
                    n += 6 + this.user_specified_rate_.length;
                }
                return this.uninterpreted != null ? n + this.uninterpreted.maxEncodingSize() : n;
            }

            public MessageAppender getMessageAppender() {
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                return this.uninterpreted;
            }

            public void clear() {
                this.optional_0_ = 0;
                this.queue_name_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
                this.bucket_refill_per_second_ = 0.0;
                this.bucket_capacity_ = 0.0;
                this.user_specified_rate_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
                this.paused_ = false;
                this.uninterpreted = null;
            }

            public Queue newInstance() {
                return new Queue();
            }

            public ProtocolType getProtocolType() {
                return StaticHolder.protocolType;
            }

            public void outputTo(ProtocolSink sink) {
                sink.putByte((byte)18);
                sink.putPrefixedData(this.queue_name_);
                sink.putByte((byte)25);
                sink.putDouble(this.bucket_refill_per_second_);
                sink.putByte((byte)33);
                sink.putDouble(this.bucket_capacity_);
                int this_t0 = this.optional_0_;
                if ((this_t0 & 8) != 0) {
                    sink.putByte((byte)42);
                    sink.putPrefixedData(this.user_specified_rate_);
                }
                sink.putByte((byte)48);
                sink.putBoolean(this.paused_);
                if (this.uninterpreted != null) {
                    this.uninterpreted.put(sink);
                }
                sink.putByte((byte)12);
            }

            public boolean merge(ProtocolSource source) {
                boolean result = true;
                int this_t0 = this.optional_0_;
                block9: while (true) {
                    int tt = source.getVarInt();
                    switch (tt) {
                        case 12: {
                            break block9;
                        }
                        case 0: {
                            result = false;
                            break block9;
                        }
                        case 18: {
                            this.queue_name_ = source.getPrefixedData();
                            this_t0 |= 1;
                            continue block9;
                        }
                        case 25: {
                            this.bucket_refill_per_second_ = source.getDouble();
                            this_t0 |= 2;
                            continue block9;
                        }
                        case 33: {
                            this.bucket_capacity_ = source.getDouble();
                            this_t0 |= 4;
                            continue block9;
                        }
                        case 42: {
                            this.user_specified_rate_ = source.getPrefixedData();
                            this_t0 |= 8;
                            continue block9;
                        }
                        case 48: {
                            this.paused_ = source.getBoolean();
                            this_t0 |= 0x10;
                            continue block9;
                        }
                        default: {
                            if (this.uninterpreted == null) {
                                this.uninterpreted = new UninterpretedTags();
                            }
                            this.uninterpreted.put((Object)tt, (Object)source.getUninterpreted(tt));
                            continue block9;
                        }
                    }
                    break;
                }
                this.optional_0_ = this_t0;
                return result;
            }

            public Queue getDefaultInstanceForType() {
                return IMMUTABLE_DEFAULT_INSTANCE;
            }

            public static final Queue getDefaultInstance() {
                return IMMUTABLE_DEFAULT_INSTANCE;
            }

            public Queue freeze() {
                this.queue_name_ = ProtocolSupport.freezeString((byte[])this.queue_name_);
                this.user_specified_rate_ = ProtocolSupport.freezeString((byte[])this.user_specified_rate_);
                return this;
            }

            private static class StaticHolder {
                private static final ProtocolType protocolType = new ProtocolType(Queue.class, null, new ProtocolType.FieldType[]{new ProtocolType.FieldType("queue_name", "queue_name", 2, 0, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("bucket_refill_per_second", "bucket_refill_per_second", 3, 1, ProtocolType.FieldBaseType.DOUBLE, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("bucket_capacity", "bucket_capacity", 4, 2, ProtocolType.FieldBaseType.DOUBLE, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("user_specified_rate", "user_specified_rate", 5, 3, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("paused", "paused", 6, 4, ProtocolType.FieldBaseType.BOOL, ProtocolType.Presence.REQUIRED)});

                private StaticHolder() {
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TaskQueueFetchQueuesRequest
    extends ProtocolMessage<TaskQueueFetchQueuesRequest> {
        private static final long serialVersionUID = 1L;
        private byte[] app_id_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private int max_rows_ = 0;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final TaskQueueFetchQueuesRequest IMMUTABLE_DEFAULT_INSTANCE = new TaskQueueFetchQueuesRequest(){
            private static final long serialVersionUID = 1L;

            public TaskQueueFetchQueuesRequest clearAppId() {
                return this;
            }

            public TaskQueueFetchQueuesRequest setAppIdAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueFetchQueuesRequest setAppId(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueFetchQueuesRequest setAppId(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueFetchQueuesRequest clearMaxRows() {
                return this;
            }

            public TaskQueueFetchQueuesRequest setMaxRows(int x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueFetchQueuesRequest mergeFrom(TaskQueueFetchQueuesRequest that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public TaskQueueFetchQueuesRequest freeze() {
                return this;
            }

            public TaskQueueFetchQueuesRequest unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kapp_id = 1;
        public static final int kmax_rows = 2;
        public static final String[] text = new String[3];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final byte[] getAppIdAsBytes() {
            return this.app_id_;
        }

        public final boolean hasAppId() {
            return (this.optional_0_ & 1) != 0;
        }

        public TaskQueueFetchQueuesRequest clearAppId() {
            this.optional_0_ &= 0xFFFFFFFE;
            this.app_id_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public TaskQueueFetchQueuesRequest setAppIdAsBytes(byte[] x) {
            this.optional_0_ |= 1;
            this.app_id_ = x;
            return this;
        }

        public final String getAppId() {
            return ProtocolSupport.toStringUtf8((byte[])this.app_id_);
        }

        public TaskQueueFetchQueuesRequest setAppId(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.app_id_ = ProtocolSupport.toBytesUtf8((String)v);
            return this;
        }

        public final String getAppId(Charset cs) {
            return ProtocolSupport.toString((byte[])this.app_id_, (Charset)cs);
        }

        public TaskQueueFetchQueuesRequest setAppId(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.app_id_ = ProtocolSupport.toBytes((String)v, (Charset)cs);
            return this;
        }

        public final int getMaxRows() {
            return this.max_rows_;
        }

        public final boolean hasMaxRows() {
            return (this.optional_0_ & 2) != 0;
        }

        public TaskQueueFetchQueuesRequest clearMaxRows() {
            this.optional_0_ &= 0xFFFFFFFD;
            this.max_rows_ = 0;
            return this;
        }

        public TaskQueueFetchQueuesRequest setMaxRows(int x) {
            this.optional_0_ |= 2;
            this.max_rows_ = x;
            return this;
        }

        public TaskQueueFetchQueuesRequest mergeFrom(TaskQueueFetchQueuesRequest that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                this.app_id_ = that.app_id_;
            }
            if ((that_t0 & 2) != 0) {
                this_t0 |= 2;
                this.max_rows_ = that.max_rows_;
            }
            if (that.uninterpreted != null) {
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll((Multimap)that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        public boolean equalsIgnoreUninterpreted(TaskQueueFetchQueuesRequest that) {
            return this.equals(that, true);
        }

        public boolean equals(TaskQueueFetchQueuesRequest that) {
            return this.equals(that, false);
        }

        public boolean equals(TaskQueueFetchQueuesRequest that, boolean ignoreUninterpreted) {
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (this_t0 != that_t0) {
                return false;
            }
            if ((this_t0 & 1) != 0 && !Arrays.equals(this.app_id_, that.app_id_)) {
                return false;
            }
            if ((this_t0 & 2) != 0 && this.max_rows_ != that.max_rows_) {
                return false;
            }
            return ignoreUninterpreted || UninterpretedTags.equivalent((UninterpretedTags)this.uninterpreted, (UninterpretedTags)that.uninterpreted);
        }

        public boolean equals(Object that) {
            return that instanceof TaskQueueFetchQueuesRequest && this.equals((TaskQueueFetchQueuesRequest)((Object)that));
        }

        public int hashCode() {
            int hash = -1691066624;
            int this_t0 = this.optional_0_;
            hash = hash * 31 + ((this_t0 & 1) != 0 ? Arrays.hashCode(this.app_id_) : -113);
            hash = hash * 31 + ((this_t0 & 2) != 0 ? this.max_rows_ : -113);
            if (this.uninterpreted != null && !this.uninterpreted.isEmpty()) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        public boolean isInitialized() {
            int this_t0 = this.optional_0_;
            if ((this_t0 & 3) != 3) {
                if ((this_t0 & 1) == 0) {
                    return false;
                }
                return false;
            }
            return true;
        }

        public int encodingSize() {
            int n = 2 + Protocol.stringSize((int)this.app_id_.length) + Protocol.varLongSize((long)this.max_rows_);
            return this.uninterpreted != null ? n + this.uninterpreted.encodingSize() : n;
        }

        public int maxEncodingSize() {
            int n = 17 + this.app_id_.length;
            return this.uninterpreted != null ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        public void clear() {
            this.optional_0_ = 0;
            this.app_id_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.max_rows_ = 0;
            this.uninterpreted = null;
        }

        public TaskQueueFetchQueuesRequest newInstance() {
            return new TaskQueueFetchQueuesRequest();
        }

        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        public void outputTo(ProtocolSink sink) {
            sink.putByte((byte)10);
            sink.putPrefixedData(this.app_id_);
            sink.putByte((byte)16);
            sink.putVarLong(this.max_rows_);
            if (this.uninterpreted != null) {
                this.uninterpreted.put(sink);
            }
        }

        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block5: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block5;
                    }
                    case 10: {
                        this.app_id_ = source.getPrefixedData();
                        this_t0 |= 1;
                        continue block5;
                    }
                    case 16: {
                        this.max_rows_ = source.getVarInt();
                        this_t0 |= 2;
                        continue block5;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put((Object)tt, (Object)source.getUninterpreted(tt));
                        continue block5;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        public TaskQueueFetchQueuesRequest getDefaultInstanceForType() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public static final TaskQueueFetchQueuesRequest getDefaultInstance() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public TaskQueueFetchQueuesRequest freeze() {
            this.app_id_ = ProtocolSupport.freezeString((byte[])this.app_id_);
            return this;
        }

        static {
            TaskQueueFetchQueuesRequest.text[0] = "ErrorCode";
            TaskQueueFetchQueuesRequest.text[1] = "app_id";
            TaskQueueFetchQueuesRequest.text[2] = "max_rows";
            types = new int[3];
            Arrays.fill(types, 6);
            TaskQueueFetchQueuesRequest.types[0] = 0;
            TaskQueueFetchQueuesRequest.types[1] = 2;
            TaskQueueFetchQueuesRequest.types[2] = 0;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(TaskQueueFetchQueuesRequest.class, "Z0apphosting/api/taskqueue/taskqueue_service.proto\n&apphosting.TaskQueueFetchQueuesRequest\u0013\u001a\u0006app_id \u0001(\u00020\t8\u0002\u0014\u0013\u001a\bmax_rows \u0002(\u00000\u00058\u0002\u0014", new ProtocolType.FieldType[]{new ProtocolType.FieldType("app_id", "app_id", 1, 0, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("max_rows", "max_rows", 2, 1, ProtocolType.FieldBaseType.INT32, ProtocolType.Presence.REQUIRED)});

            private StaticHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TaskQueueUpdateQueueResponse
    extends ProtocolMessage<TaskQueueUpdateQueueResponse> {
        private static final long serialVersionUID = 1L;
        private UninterpretedTags uninterpreted;
        public static final TaskQueueUpdateQueueResponse IMMUTABLE_DEFAULT_INSTANCE = new TaskQueueUpdateQueueResponse(){
            private static final long serialVersionUID = 1L;

            public TaskQueueUpdateQueueResponse mergeFrom(TaskQueueUpdateQueueResponse that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public TaskQueueUpdateQueueResponse freeze() {
                return this;
            }

            public TaskQueueUpdateQueueResponse unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final String[] text = new String[1];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public TaskQueueUpdateQueueResponse mergeFrom(TaskQueueUpdateQueueResponse that) {
            assert (that != this);
            if (that.uninterpreted != null) {
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll((Multimap)that.uninterpreted);
            }
            return this;
        }

        public boolean equalsIgnoreUninterpreted(TaskQueueUpdateQueueResponse that) {
            return this.equals(that, true);
        }

        public boolean equals(TaskQueueUpdateQueueResponse that) {
            return this.equals(that, false);
        }

        public boolean equals(TaskQueueUpdateQueueResponse that, boolean ignoreUninterpreted) {
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            return ignoreUninterpreted || UninterpretedTags.equivalent((UninterpretedTags)this.uninterpreted, (UninterpretedTags)that.uninterpreted);
        }

        public boolean equals(Object that) {
            return that instanceof TaskQueueUpdateQueueResponse && this.equals((TaskQueueUpdateQueueResponse)((Object)that));
        }

        public int hashCode() {
            int hash = 90204515;
            if (this.uninterpreted != null && !this.uninterpreted.isEmpty()) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        public boolean isInitialized() {
            return true;
        }

        public int encodingSize() {
            int n = 0;
            return this.uninterpreted != null ? n + this.uninterpreted.encodingSize() : n;
        }

        public int maxEncodingSize() {
            int n = 0;
            return this.uninterpreted != null ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        public void clear() {
            this.uninterpreted = null;
        }

        public TaskQueueUpdateQueueResponse newInstance() {
            return new TaskQueueUpdateQueueResponse();
        }

        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        public void outputTo(ProtocolSink sink) {
            if (this.uninterpreted != null) {
                this.uninterpreted.put(sink);
            }
        }

        public boolean merge(ProtocolSource source) {
            boolean result = true;
            block3: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block3;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put((Object)tt, (Object)source.getUninterpreted(tt));
                        continue block3;
                    }
                }
            }
            return result;
        }

        public TaskQueueUpdateQueueResponse getDefaultInstanceForType() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public static final TaskQueueUpdateQueueResponse getDefaultInstance() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        static {
            TaskQueueUpdateQueueResponse.text[0] = "ErrorCode";
            types = new int[1];
            Arrays.fill(types, 6);
            TaskQueueUpdateQueueResponse.types[0] = 0;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(TaskQueueUpdateQueueResponse.class, "Z0apphosting/api/taskqueue/taskqueue_service.proto\n'apphosting.TaskQueueUpdateQueueResponse", new ProtocolType.FieldType[0]);

            private StaticHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TaskQueueUpdateQueueRequest
    extends ProtocolMessage<TaskQueueUpdateQueueRequest> {
        private static final long serialVersionUID = 1L;
        private byte[] app_id_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private byte[] queue_name_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private double bucket_refill_per_second_ = 0.0;
        private int bucket_capacity_ = 0;
        private byte[] user_specified_rate_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final TaskQueueUpdateQueueRequest IMMUTABLE_DEFAULT_INSTANCE = new TaskQueueUpdateQueueRequest(){
            private static final long serialVersionUID = 1L;

            public TaskQueueUpdateQueueRequest clearAppId() {
                return this;
            }

            public TaskQueueUpdateQueueRequest setAppIdAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueUpdateQueueRequest setAppId(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueUpdateQueueRequest setAppId(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueUpdateQueueRequest clearQueueName() {
                return this;
            }

            public TaskQueueUpdateQueueRequest setQueueNameAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueUpdateQueueRequest setQueueName(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueUpdateQueueRequest setQueueName(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueUpdateQueueRequest clearBucketRefillPerSecond() {
                return this;
            }

            public TaskQueueUpdateQueueRequest setBucketRefillPerSecond(double x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueUpdateQueueRequest clearBucketCapacity() {
                return this;
            }

            public TaskQueueUpdateQueueRequest setBucketCapacity(int x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueUpdateQueueRequest clearUserSpecifiedRate() {
                return this;
            }

            public TaskQueueUpdateQueueRequest setUserSpecifiedRateAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueUpdateQueueRequest setUserSpecifiedRate(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueUpdateQueueRequest setUserSpecifiedRate(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueUpdateQueueRequest mergeFrom(TaskQueueUpdateQueueRequest that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public TaskQueueUpdateQueueRequest freeze() {
                return this;
            }

            public TaskQueueUpdateQueueRequest unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kapp_id = 1;
        public static final int kqueue_name = 2;
        public static final int kbucket_refill_per_second = 3;
        public static final int kbucket_capacity = 4;
        public static final int kuser_specified_rate = 5;
        public static final String[] text = new String[6];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final byte[] getAppIdAsBytes() {
            return this.app_id_;
        }

        public final boolean hasAppId() {
            return (this.optional_0_ & 1) != 0;
        }

        public TaskQueueUpdateQueueRequest clearAppId() {
            this.optional_0_ &= 0xFFFFFFFE;
            this.app_id_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public TaskQueueUpdateQueueRequest setAppIdAsBytes(byte[] x) {
            this.optional_0_ |= 1;
            this.app_id_ = x;
            return this;
        }

        public final String getAppId() {
            return ProtocolSupport.toStringUtf8((byte[])this.app_id_);
        }

        public TaskQueueUpdateQueueRequest setAppId(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.app_id_ = ProtocolSupport.toBytesUtf8((String)v);
            return this;
        }

        public final String getAppId(Charset cs) {
            return ProtocolSupport.toString((byte[])this.app_id_, (Charset)cs);
        }

        public TaskQueueUpdateQueueRequest setAppId(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.app_id_ = ProtocolSupport.toBytes((String)v, (Charset)cs);
            return this;
        }

        public final byte[] getQueueNameAsBytes() {
            return this.queue_name_;
        }

        public final boolean hasQueueName() {
            return (this.optional_0_ & 2) != 0;
        }

        public TaskQueueUpdateQueueRequest clearQueueName() {
            this.optional_0_ &= 0xFFFFFFFD;
            this.queue_name_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public TaskQueueUpdateQueueRequest setQueueNameAsBytes(byte[] x) {
            this.optional_0_ |= 2;
            this.queue_name_ = x;
            return this;
        }

        public final String getQueueName() {
            return ProtocolSupport.toStringUtf8((byte[])this.queue_name_);
        }

        public TaskQueueUpdateQueueRequest setQueueName(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 2;
            this.queue_name_ = ProtocolSupport.toBytesUtf8((String)v);
            return this;
        }

        public final String getQueueName(Charset cs) {
            return ProtocolSupport.toString((byte[])this.queue_name_, (Charset)cs);
        }

        public TaskQueueUpdateQueueRequest setQueueName(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 2;
            this.queue_name_ = ProtocolSupport.toBytes((String)v, (Charset)cs);
            return this;
        }

        public final double getBucketRefillPerSecond() {
            return this.bucket_refill_per_second_;
        }

        public final boolean hasBucketRefillPerSecond() {
            return (this.optional_0_ & 4) != 0;
        }

        public TaskQueueUpdateQueueRequest clearBucketRefillPerSecond() {
            this.optional_0_ &= 0xFFFFFFFB;
            this.bucket_refill_per_second_ = 0.0;
            return this;
        }

        public TaskQueueUpdateQueueRequest setBucketRefillPerSecond(double x) {
            this.optional_0_ |= 4;
            this.bucket_refill_per_second_ = x;
            return this;
        }

        public final int getBucketCapacity() {
            return this.bucket_capacity_;
        }

        public final boolean hasBucketCapacity() {
            return (this.optional_0_ & 8) != 0;
        }

        public TaskQueueUpdateQueueRequest clearBucketCapacity() {
            this.optional_0_ &= 0xFFFFFFF7;
            this.bucket_capacity_ = 0;
            return this;
        }

        public TaskQueueUpdateQueueRequest setBucketCapacity(int x) {
            this.optional_0_ |= 8;
            this.bucket_capacity_ = x;
            return this;
        }

        public final byte[] getUserSpecifiedRateAsBytes() {
            return this.user_specified_rate_;
        }

        public final boolean hasUserSpecifiedRate() {
            return (this.optional_0_ & 0x10) != 0;
        }

        public TaskQueueUpdateQueueRequest clearUserSpecifiedRate() {
            this.optional_0_ &= 0xFFFFFFEF;
            this.user_specified_rate_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public TaskQueueUpdateQueueRequest setUserSpecifiedRateAsBytes(byte[] x) {
            this.optional_0_ |= 0x10;
            this.user_specified_rate_ = x;
            return this;
        }

        public final String getUserSpecifiedRate() {
            return ProtocolSupport.toStringUtf8((byte[])this.user_specified_rate_);
        }

        public TaskQueueUpdateQueueRequest setUserSpecifiedRate(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 0x10;
            this.user_specified_rate_ = ProtocolSupport.toBytesUtf8((String)v);
            return this;
        }

        public final String getUserSpecifiedRate(Charset cs) {
            return ProtocolSupport.toString((byte[])this.user_specified_rate_, (Charset)cs);
        }

        public TaskQueueUpdateQueueRequest setUserSpecifiedRate(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 0x10;
            this.user_specified_rate_ = ProtocolSupport.toBytes((String)v, (Charset)cs);
            return this;
        }

        public TaskQueueUpdateQueueRequest mergeFrom(TaskQueueUpdateQueueRequest that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                this.app_id_ = that.app_id_;
            }
            if ((that_t0 & 2) != 0) {
                this_t0 |= 2;
                this.queue_name_ = that.queue_name_;
            }
            if ((that_t0 & 4) != 0) {
                this_t0 |= 4;
                this.bucket_refill_per_second_ = that.bucket_refill_per_second_;
            }
            if ((that_t0 & 8) != 0) {
                this_t0 |= 8;
                this.bucket_capacity_ = that.bucket_capacity_;
            }
            if ((that_t0 & 0x10) != 0) {
                this_t0 |= 0x10;
                this.user_specified_rate_ = that.user_specified_rate_;
            }
            if (that.uninterpreted != null) {
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll((Multimap)that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        public boolean equalsIgnoreUninterpreted(TaskQueueUpdateQueueRequest that) {
            return this.equals(that, true);
        }

        public boolean equals(TaskQueueUpdateQueueRequest that) {
            return this.equals(that, false);
        }

        public boolean equals(TaskQueueUpdateQueueRequest that, boolean ignoreUninterpreted) {
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (this_t0 != that_t0) {
                return false;
            }
            if ((this_t0 & 1) != 0 && !Arrays.equals(this.app_id_, that.app_id_)) {
                return false;
            }
            if ((this_t0 & 2) != 0 && !Arrays.equals(this.queue_name_, that.queue_name_)) {
                return false;
            }
            if ((this_t0 & 4) != 0 && this.bucket_refill_per_second_ != that.bucket_refill_per_second_) {
                return false;
            }
            if ((this_t0 & 8) != 0 && this.bucket_capacity_ != that.bucket_capacity_) {
                return false;
            }
            if ((this_t0 & 0x10) != 0 && !Arrays.equals(this.user_specified_rate_, that.user_specified_rate_)) {
                return false;
            }
            return ignoreUninterpreted || UninterpretedTags.equivalent((UninterpretedTags)this.uninterpreted, (UninterpretedTags)that.uninterpreted);
        }

        public boolean equals(Object that) {
            return that instanceof TaskQueueUpdateQueueRequest && this.equals((TaskQueueUpdateQueueRequest)((Object)that));
        }

        public int hashCode() {
            int hash = -1613945153;
            int this_t0 = this.optional_0_;
            hash = hash * 31 + ((this_t0 & 1) != 0 ? Arrays.hashCode(this.app_id_) : -113);
            hash = hash * 31 + ((this_t0 & 2) != 0 ? Arrays.hashCode(this.queue_name_) : -113);
            hash = hash * 31 + ((this_t0 & 4) != 0 ? ProtocolSupport.hashCode((double)this.bucket_refill_per_second_) : -113);
            hash = hash * 31 + ((this_t0 & 8) != 0 ? this.bucket_capacity_ : -113);
            hash = hash * 31 + ((this_t0 & 0x10) != 0 ? Arrays.hashCode(this.user_specified_rate_) : -113);
            if (this.uninterpreted != null && !this.uninterpreted.isEmpty()) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        public boolean isInitialized() {
            int this_t0 = this.optional_0_;
            if ((this_t0 & 0xF) != 15) {
                if ((this_t0 & 1) == 0) {
                    return false;
                }
                if ((this_t0 & 2) == 0) {
                    return false;
                }
                if ((this_t0 & 4) == 0) {
                    return false;
                }
                return false;
            }
            return true;
        }

        public int encodingSize() {
            int n = 12 + Protocol.stringSize((int)this.app_id_.length) + Protocol.stringSize((int)this.queue_name_.length) + Protocol.varLongSize((long)this.bucket_capacity_);
            int this_t0 = this.optional_0_;
            if ((this_t0 & 0x10) != 0) {
                n += 1 + Protocol.stringSize((int)this.user_specified_rate_.length);
            }
            return this.uninterpreted != null ? n + this.uninterpreted.encodingSize() : n;
        }

        public int maxEncodingSize() {
            int n = 32 + this.app_id_.length + this.queue_name_.length;
            int this_t0 = this.optional_0_;
            if ((this_t0 & 0x10) != 0) {
                n += 6 + this.user_specified_rate_.length;
            }
            return this.uninterpreted != null ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        public void clear() {
            this.optional_0_ = 0;
            this.app_id_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.queue_name_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.bucket_refill_per_second_ = 0.0;
            this.bucket_capacity_ = 0;
            this.user_specified_rate_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.uninterpreted = null;
        }

        public TaskQueueUpdateQueueRequest newInstance() {
            return new TaskQueueUpdateQueueRequest();
        }

        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        public void outputTo(ProtocolSink sink) {
            sink.putByte((byte)10);
            sink.putPrefixedData(this.app_id_);
            sink.putByte((byte)18);
            sink.putPrefixedData(this.queue_name_);
            sink.putByte((byte)25);
            sink.putDouble(this.bucket_refill_per_second_);
            sink.putByte((byte)32);
            sink.putVarLong(this.bucket_capacity_);
            int this_t0 = this.optional_0_;
            if ((this_t0 & 0x10) != 0) {
                sink.putByte((byte)42);
                sink.putPrefixedData(this.user_specified_rate_);
            }
            if (this.uninterpreted != null) {
                this.uninterpreted.put(sink);
            }
        }

        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block8: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block8;
                    }
                    case 10: {
                        this.app_id_ = source.getPrefixedData();
                        this_t0 |= 1;
                        continue block8;
                    }
                    case 18: {
                        this.queue_name_ = source.getPrefixedData();
                        this_t0 |= 2;
                        continue block8;
                    }
                    case 25: {
                        this.bucket_refill_per_second_ = source.getDouble();
                        this_t0 |= 4;
                        continue block8;
                    }
                    case 32: {
                        this.bucket_capacity_ = source.getVarInt();
                        this_t0 |= 8;
                        continue block8;
                    }
                    case 42: {
                        this.user_specified_rate_ = source.getPrefixedData();
                        this_t0 |= 0x10;
                        continue block8;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put((Object)tt, (Object)source.getUninterpreted(tt));
                        continue block8;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        public TaskQueueUpdateQueueRequest getDefaultInstanceForType() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public static final TaskQueueUpdateQueueRequest getDefaultInstance() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public TaskQueueUpdateQueueRequest freeze() {
            this.app_id_ = ProtocolSupport.freezeString((byte[])this.app_id_);
            this.queue_name_ = ProtocolSupport.freezeString((byte[])this.queue_name_);
            this.user_specified_rate_ = ProtocolSupport.freezeString((byte[])this.user_specified_rate_);
            return this;
        }

        static {
            TaskQueueUpdateQueueRequest.text[0] = "ErrorCode";
            TaskQueueUpdateQueueRequest.text[1] = "app_id";
            TaskQueueUpdateQueueRequest.text[2] = "queue_name";
            TaskQueueUpdateQueueRequest.text[3] = "bucket_refill_per_second";
            TaskQueueUpdateQueueRequest.text[4] = "bucket_capacity";
            TaskQueueUpdateQueueRequest.text[5] = "user_specified_rate";
            types = new int[6];
            Arrays.fill(types, 6);
            TaskQueueUpdateQueueRequest.types[0] = 0;
            TaskQueueUpdateQueueRequest.types[1] = 2;
            TaskQueueUpdateQueueRequest.types[2] = 2;
            TaskQueueUpdateQueueRequest.types[3] = 1;
            TaskQueueUpdateQueueRequest.types[4] = 0;
            TaskQueueUpdateQueueRequest.types[5] = 2;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(TaskQueueUpdateQueueRequest.class, "Z0apphosting/api/taskqueue/taskqueue_service.proto\n&apphosting.TaskQueueUpdateQueueRequest\u0013\u001a\u0006app_id \u0001(\u00020\t8\u0002\u0014\u0013\u001a\nqueue_name \u0002(\u00020\t8\u0002\u0014\u0013\u001a\u0018bucket_refill_per_second \u0003(\u00010\u00018\u0002\u0014\u0013\u001a\u000fbucket_capacity \u0004(\u00000\u00058\u0002\u0014\u0013\u001a\u0013user_specified_rate \u0005(\u00020\t8\u0001\u0014", new ProtocolType.FieldType[]{new ProtocolType.FieldType("app_id", "app_id", 1, 0, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("queue_name", "queue_name", 2, 1, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("bucket_refill_per_second", "bucket_refill_per_second", 3, 2, ProtocolType.FieldBaseType.DOUBLE, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("bucket_capacity", "bucket_capacity", 4, 3, ProtocolType.FieldBaseType.INT32, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("user_specified_rate", "user_specified_rate", 5, 4, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.OPTIONAL)});

            private StaticHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TaskQueueDeleteResponse
    extends ProtocolMessage<TaskQueueDeleteResponse> {
        private static final long serialVersionUID = 1L;
        private int[] result_ = ProtocolSupport.EMPTY_INT_ARRAY;
        private int result_elts_;
        private UninterpretedTags uninterpreted;
        public static final TaskQueueDeleteResponse IMMUTABLE_DEFAULT_INSTANCE = new TaskQueueDeleteResponse(){
            private static final long serialVersionUID = 1L;

            public TaskQueueDeleteResponse clearResult() {
                return this;
            }

            public TaskQueueDeleteResponse setResult(int i, int v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueDeleteResponse addResult(int v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueDeleteResponse mergeFrom(TaskQueueDeleteResponse that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public TaskQueueDeleteResponse freeze() {
                return this;
            }

            public TaskQueueDeleteResponse unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kresult = 3;
        public static final String[] text = new String[4];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final int resultSize() {
            return this.result_elts_;
        }

        public final int getResult(int i) {
            assert (i >= 0 && i < this.result_elts_);
            return this.result_[i];
        }

        public TaskQueueDeleteResponse clearResult() {
            this.result_elts_ = 0;
            this.result_ = ProtocolSupport.EMPTY_INT_ARRAY;
            return this;
        }

        public TaskQueueDeleteResponse setResult(int i, int v) {
            assert (i >= 0 && i < this.result_elts_);
            this.result_[i] = v;
            return this;
        }

        public TaskQueueDeleteResponse addResult(int v) {
            if (this.result_elts_ == this.result_.length) {
                this.result_ = ProtocolSupport.growArray((int[])this.result_);
            }
            this.result_[this.result_elts_++] = v;
            return this;
        }

        public final Iterator<Integer> resultIterator() {
            return ProtocolSupport.asList((int[])this.result_, (int)0, (int)this.result_elts_).iterator();
        }

        public final List<Integer> results() {
            return ProtocolSupport.asList((int[])this.result_, (int)0, (int)this.result_elts_);
        }

        public final List<Integer> mutableResults() {
            return new AbstractList<Integer>(){

                @Override
                public int size() {
                    return TaskQueueDeleteResponse.this.result_elts_;
                }

                @Override
                public Integer get(int i) {
                    if (i < 0 || i >= this.size()) {
                        throw new ArrayIndexOutOfBoundsException();
                    }
                    return TaskQueueDeleteResponse.this.result_[i];
                }

                @Override
                public Integer set(int i, Integer elt) {
                    Integer result = this.get(i);
                    TaskQueueDeleteResponse.this.setResult(i, elt);
                    return result;
                }

                @Override
                public boolean add(Integer elt) {
                    TaskQueueDeleteResponse.this.addResult(elt);
                    return true;
                }

                @Override
                public Integer remove(int i) {
                    if (i < 0 || i >= this.size()) {
                        throw new ArrayIndexOutOfBoundsException();
                    }
                    Integer result = this.get(i);
                    for (int j = i + 1; j < this.size(); ++j) {
                        ((TaskQueueDeleteResponse)TaskQueueDeleteResponse.this).result_[j - 1] = TaskQueueDeleteResponse.this.result_[j];
                    }
                    TaskQueueDeleteResponse.this.result_elts_--;
                    return result;
                }

                @Override
                public void clear() {
                    TaskQueueDeleteResponse.this.result_elts_ = 0;
                }
            };
        }

        public TaskQueueDeleteResponse mergeFrom(TaskQueueDeleteResponse that) {
            assert (that != this);
            if (that.result_elts_ > 0) {
                this.result_ = ProtocolSupport.ensureCapacity((int[])this.result_, (int)(this.result_elts_ + that.result_elts_));
                System.arraycopy(that.result_, 0, this.result_, this.result_elts_, that.result_elts_);
                this.result_elts_ += that.result_elts_;
            }
            if (that.uninterpreted != null) {
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll((Multimap)that.uninterpreted);
            }
            return this;
        }

        public boolean equalsIgnoreUninterpreted(TaskQueueDeleteResponse that) {
            return this.equals(that, true);
        }

        public boolean equals(TaskQueueDeleteResponse that) {
            return this.equals(that, false);
        }

        public boolean equals(TaskQueueDeleteResponse that, boolean ignoreUninterpreted) {
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            int n = this.result_elts_;
            if (n != that.result_elts_) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (this.result_[i] == that.result_[i]) continue;
                return false;
            }
            return ignoreUninterpreted || UninterpretedTags.equivalent((UninterpretedTags)this.uninterpreted, (UninterpretedTags)that.uninterpreted);
        }

        public boolean equals(Object that) {
            return that instanceof TaskQueueDeleteResponse && this.equals((TaskQueueDeleteResponse)((Object)that));
        }

        public int hashCode() {
            int hash = -1768622149;
            hash *= 31;
            int n = this.result_elts_;
            for (int i = 0; i < n; ++i) {
                hash = hash * 31 + this.result_[i];
            }
            if (this.uninterpreted != null && !this.uninterpreted.isEmpty()) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        public boolean isInitialized() {
            return true;
        }

        public int encodingSize() {
            int n = 0;
            int m = this.result_elts_;
            n += m;
            for (int i = 0; i < m; ++i) {
                n += Protocol.varLongSize((long)this.result_[i]);
            }
            return this.uninterpreted != null ? n + this.uninterpreted.encodingSize() : n;
        }

        public int maxEncodingSize() {
            int n = 0;
            return this.uninterpreted != null ? n + this.uninterpreted.maxEncodingSize() : (n += 11 * this.result_elts_);
        }

        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        public void clear() {
            this.result_elts_ = 0;
            this.result_ = ProtocolSupport.EMPTY_INT_ARRAY;
            this.uninterpreted = null;
        }

        public TaskQueueDeleteResponse newInstance() {
            return new TaskQueueDeleteResponse();
        }

        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        public void outputTo(ProtocolSink sink) {
            int m = this.result_elts_;
            for (int i = 0; i < m; ++i) {
                int v = this.result_[i];
                sink.putByte((byte)24);
                sink.putVarLong(v);
            }
            if (this.uninterpreted != null) {
                this.uninterpreted.put(sink);
            }
        }

        public boolean merge(ProtocolSource source) {
            boolean result = true;
            block4: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block4;
                    }
                    case 24: {
                        this.addResult(source.getVarInt());
                        continue block4;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put((Object)tt, (Object)source.getUninterpreted(tt));
                        continue block4;
                    }
                }
            }
            return result;
        }

        public TaskQueueDeleteResponse getDefaultInstanceForType() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public static final TaskQueueDeleteResponse getDefaultInstance() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public TaskQueueDeleteResponse freeze() {
            this.result_ = ProtocolSupport.freezeArray((int[])this.result_, (int)this.result_elts_);
            return this;
        }

        static {
            TaskQueueDeleteResponse.text[0] = "ErrorCode";
            TaskQueueDeleteResponse.text[3] = "result";
            types = new int[4];
            Arrays.fill(types, 6);
            TaskQueueDeleteResponse.types[0] = 0;
            TaskQueueDeleteResponse.types[3] = 0;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(TaskQueueDeleteResponse.class, "Z0apphosting/api/taskqueue/taskqueue_service.proto\n\"apphosting.TaskQueueDeleteResponse\u0013\u001a\u0006result \u0003(\u00000\u00058\u0003\u0014", new ProtocolType.FieldType[]{new ProtocolType.FieldType("result", "result", 3, -1, ProtocolType.FieldBaseType.INT32, ProtocolType.Presence.REPEATED)});

            private StaticHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TaskQueueDeleteRequest
    extends ProtocolMessage<TaskQueueDeleteRequest> {
        private static final long serialVersionUID = 1L;
        private byte[] queue_name_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private List<byte[]> task_name_ = null;
        private byte[] app_id_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final TaskQueueDeleteRequest IMMUTABLE_DEFAULT_INSTANCE = new TaskQueueDeleteRequest(){
            private static final long serialVersionUID = 1L;

            public TaskQueueDeleteRequest clearQueueName() {
                return this;
            }

            public TaskQueueDeleteRequest setQueueNameAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueDeleteRequest setQueueName(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueDeleteRequest setQueueName(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueDeleteRequest clearTaskName() {
                return this;
            }

            public TaskQueueDeleteRequest setTaskNameAsBytes(int i, byte[] v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueDeleteRequest setTaskName(int i, String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueDeleteRequest addTaskNameAsBytes(byte[] v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueDeleteRequest addTaskName(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueDeleteRequest setTaskName(int i, String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueDeleteRequest addTaskName(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueDeleteRequest clearAppId() {
                return this;
            }

            public TaskQueueDeleteRequest setAppIdAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueDeleteRequest setAppId(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueDeleteRequest setAppId(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueDeleteRequest mergeFrom(TaskQueueDeleteRequest that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public TaskQueueDeleteRequest freeze() {
                return this;
            }

            public TaskQueueDeleteRequest unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kqueue_name = 1;
        public static final int ktask_name = 2;
        public static final int kapp_id = 3;
        public static final String[] text = new String[4];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final byte[] getQueueNameAsBytes() {
            return this.queue_name_;
        }

        public final boolean hasQueueName() {
            return (this.optional_0_ & 1) != 0;
        }

        public TaskQueueDeleteRequest clearQueueName() {
            this.optional_0_ &= 0xFFFFFFFE;
            this.queue_name_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public TaskQueueDeleteRequest setQueueNameAsBytes(byte[] x) {
            this.optional_0_ |= 1;
            this.queue_name_ = x;
            return this;
        }

        public final String getQueueName() {
            return ProtocolSupport.toStringUtf8((byte[])this.queue_name_);
        }

        public TaskQueueDeleteRequest setQueueName(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.queue_name_ = ProtocolSupport.toBytesUtf8((String)v);
            return this;
        }

        public final String getQueueName(Charset cs) {
            return ProtocolSupport.toString((byte[])this.queue_name_, (Charset)cs);
        }

        public TaskQueueDeleteRequest setQueueName(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.queue_name_ = ProtocolSupport.toBytes((String)v, (Charset)cs);
            return this;
        }

        public final int taskNameSize() {
            return this.task_name_ != null ? this.task_name_.size() : 0;
        }

        public final byte[] getTaskNameAsBytes(int i) {
            assert (i >= 0 && i < (this.task_name_ != null ? this.task_name_.size() : 0));
            return this.task_name_.get(i);
        }

        public TaskQueueDeleteRequest clearTaskName() {
            if (this.task_name_ != null) {
                this.task_name_.clear();
            }
            return this;
        }

        public final String getTaskName(int i) {
            return ProtocolSupport.toStringUtf8((byte[])this.task_name_.get(i));
        }

        public TaskQueueDeleteRequest setTaskNameAsBytes(int i, byte[] v) {
            this.task_name_.set(i, v);
            return this;
        }

        public TaskQueueDeleteRequest setTaskName(int i, String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.task_name_.set(i, ProtocolSupport.toBytesUtf8((String)v));
            return this;
        }

        public TaskQueueDeleteRequest addTaskNameAsBytes(byte[] v) {
            if (this.task_name_ == null) {
                this.task_name_ = new ArrayList<byte[]>(4);
            }
            this.task_name_.add(v);
            return this;
        }

        public TaskQueueDeleteRequest addTaskName(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            if (this.task_name_ == null) {
                this.task_name_ = new ArrayList<byte[]>(4);
            }
            this.task_name_.add(ProtocolSupport.toBytesUtf8((String)v));
            return this;
        }

        public final Iterator<String> taskNameIterator() {
            return ProtocolSupport.byteArrayToUnicodeIterator(this.task_name_);
        }

        public final List<String> taskNames() {
            return ProtocolSupport.byteArrayToUnicodeList(this.task_name_);
        }

        public final Iterator<byte[]> taskNameAsBytesIterator() {
            return this.task_name_ == null ? ProtocolSupport.emptyIterator() : this.task_name_.iterator();
        }

        public final List<byte[]> taskNamesAsBytes() {
            return ProtocolSupport.unmodifiableList(this.task_name_);
        }

        public final List<byte[]> mutableTaskNamesAsBytes() {
            if (this.task_name_ == null) {
                this.task_name_ = new ArrayList<byte[]>(4);
            }
            return this.task_name_;
        }

        public final String getTaskName(int i, Charset cs) {
            return ProtocolSupport.toString((byte[])this.task_name_.get(i), (Charset)cs);
        }

        public TaskQueueDeleteRequest setTaskName(int i, String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.task_name_.set(i, ProtocolSupport.toBytes((String)v, (Charset)cs));
            return this;
        }

        public TaskQueueDeleteRequest addTaskName(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            if (this.task_name_ == null) {
                this.task_name_ = new ArrayList<byte[]>(4);
            }
            this.task_name_.add(ProtocolSupport.toBytes((String)v, (Charset)cs));
            return this;
        }

        public final Iterator<String> taskNameIterator(Charset cs) {
            return ProtocolSupport.byteArrayToUnicodeIterator(this.task_name_, (Charset)cs);
        }

        public final List<String> taskNames(Charset cs) {
            return ProtocolSupport.byteArrayToUnicodeList(this.task_name_, (Charset)cs);
        }

        public final byte[] getAppIdAsBytes() {
            return this.app_id_;
        }

        public final boolean hasAppId() {
            return (this.optional_0_ & 2) != 0;
        }

        public TaskQueueDeleteRequest clearAppId() {
            this.optional_0_ &= 0xFFFFFFFD;
            this.app_id_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public TaskQueueDeleteRequest setAppIdAsBytes(byte[] x) {
            this.optional_0_ |= 2;
            this.app_id_ = x;
            return this;
        }

        public final String getAppId() {
            return ProtocolSupport.toStringUtf8((byte[])this.app_id_);
        }

        public TaskQueueDeleteRequest setAppId(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 2;
            this.app_id_ = ProtocolSupport.toBytesUtf8((String)v);
            return this;
        }

        public final String getAppId(Charset cs) {
            return ProtocolSupport.toString((byte[])this.app_id_, (Charset)cs);
        }

        public TaskQueueDeleteRequest setAppId(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 2;
            this.app_id_ = ProtocolSupport.toBytes((String)v, (Charset)cs);
            return this;
        }

        public TaskQueueDeleteRequest mergeFrom(TaskQueueDeleteRequest that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                this.queue_name_ = that.queue_name_;
            }
            if (that.task_name_ != null && that.task_name_.size() > 0) {
                if (this.task_name_ == null) {
                    this.task_name_ = new ArrayList<byte[]>(that.task_name_);
                } else {
                    this.task_name_.addAll(that.task_name_);
                }
            }
            if ((that_t0 & 2) != 0) {
                this_t0 |= 2;
                this.app_id_ = that.app_id_;
            }
            if (that.uninterpreted != null) {
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll((Multimap)that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        public boolean equalsIgnoreUninterpreted(TaskQueueDeleteRequest that) {
            return this.equals(that, true);
        }

        public boolean equals(TaskQueueDeleteRequest that) {
            return this.equals(that, false);
        }

        public boolean equals(TaskQueueDeleteRequest that, boolean ignoreUninterpreted) {
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (this_t0 != that_t0) {
                return false;
            }
            if ((this_t0 & 1) != 0 && !Arrays.equals(this.queue_name_, that.queue_name_)) {
                return false;
            }
            int n = this.task_name_ != null ? this.task_name_.size() : 0;
            if (n != (that.task_name_ != null ? that.task_name_.size() : 0)) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (Arrays.equals(this.task_name_.get(i), that.task_name_.get(i))) continue;
                return false;
            }
            if ((this_t0 & 2) != 0 && !Arrays.equals(this.app_id_, that.app_id_)) {
                return false;
            }
            return ignoreUninterpreted || UninterpretedTags.equivalent((UninterpretedTags)this.uninterpreted, (UninterpretedTags)that.uninterpreted);
        }

        public boolean equals(Object that) {
            return that instanceof TaskQueueDeleteRequest && this.equals((TaskQueueDeleteRequest)((Object)that));
        }

        public int hashCode() {
            int n;
            int hash = -981121076;
            int this_t0 = this.optional_0_;
            hash = hash * 31 + ((this_t0 & 1) != 0 ? Arrays.hashCode(this.queue_name_) : -113);
            hash *= 31;
            int n2 = n = this.task_name_ != null ? this.task_name_.size() : 0;
            for (int i = 0; i < n; ++i) {
                hash = hash * 31 + Arrays.hashCode(this.task_name_.get(i));
            }
            hash = hash * 31 + ((this_t0 & 2) != 0 ? Arrays.hashCode(this.app_id_) : -113);
            if (this.uninterpreted != null && !this.uninterpreted.isEmpty()) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        public boolean isInitialized() {
            int this_t0 = this.optional_0_;
            return (this_t0 & 1) == 1;
        }

        public int encodingSize() {
            int n = 1 + Protocol.stringSize((int)this.queue_name_.length);
            int m = this.task_name_ != null ? this.task_name_.size() : 0;
            n += m;
            for (int i = 0; i < m; ++i) {
                n += Protocol.stringSize((int)this.task_name_.get(i).length);
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 2) != 0) {
                n += 1 + Protocol.stringSize((int)this.app_id_.length);
            }
            return this.uninterpreted != null ? n + this.uninterpreted.encodingSize() : n;
        }

        public int maxEncodingSize() {
            int n = 6 + this.queue_name_.length;
            int m = this.task_name_ != null ? this.task_name_.size() : 0;
            n += 6 * m;
            for (int i = 0; i < m; ++i) {
                n += this.task_name_.get(i).length;
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 2) != 0) {
                n += 6 + this.app_id_.length;
            }
            return this.uninterpreted != null ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        public void clear() {
            this.optional_0_ = 0;
            this.queue_name_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            if (this.task_name_ != null) {
                this.task_name_.clear();
            }
            this.app_id_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.uninterpreted = null;
        }

        public TaskQueueDeleteRequest newInstance() {
            return new TaskQueueDeleteRequest();
        }

        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        public void outputTo(ProtocolSink sink) {
            int m;
            sink.putByte((byte)10);
            sink.putPrefixedData(this.queue_name_);
            int n = m = this.task_name_ != null ? this.task_name_.size() : 0;
            for (int i = 0; i < m; ++i) {
                byte[] v = this.task_name_.get(i);
                sink.putByte((byte)18);
                sink.putPrefixedData(v);
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 2) != 0) {
                sink.putByte((byte)26);
                sink.putPrefixedData(this.app_id_);
            }
            if (this.uninterpreted != null) {
                this.uninterpreted.put(sink);
            }
        }

        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block6: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block6;
                    }
                    case 10: {
                        this.queue_name_ = source.getPrefixedData();
                        this_t0 |= 1;
                        continue block6;
                    }
                    case 18: {
                        this.addTaskNameAsBytes(source.getPrefixedData());
                        continue block6;
                    }
                    case 26: {
                        this.app_id_ = source.getPrefixedData();
                        this_t0 |= 2;
                        continue block6;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put((Object)tt, (Object)source.getUninterpreted(tt));
                        continue block6;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        public TaskQueueDeleteRequest getDefaultInstanceForType() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public static final TaskQueueDeleteRequest getDefaultInstance() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public TaskQueueDeleteRequest freeze() {
            this.queue_name_ = ProtocolSupport.freezeString((byte[])this.queue_name_);
            this.task_name_ = ProtocolSupport.freezeStrings(this.task_name_);
            this.app_id_ = ProtocolSupport.freezeString((byte[])this.app_id_);
            return this;
        }

        public TaskQueueDeleteRequest unfreeze() {
            this.task_name_ = ProtocolSupport.unfreezeStrings(this.task_name_);
            return this;
        }

        public boolean isFrozen() {
            return ProtocolSupport.isFrozenStrings(this.task_name_);
        }

        static {
            TaskQueueDeleteRequest.text[0] = "ErrorCode";
            TaskQueueDeleteRequest.text[1] = "queue_name";
            TaskQueueDeleteRequest.text[2] = "task_name";
            TaskQueueDeleteRequest.text[3] = "app_id";
            types = new int[4];
            Arrays.fill(types, 6);
            TaskQueueDeleteRequest.types[0] = 0;
            TaskQueueDeleteRequest.types[1] = 2;
            TaskQueueDeleteRequest.types[2] = 2;
            TaskQueueDeleteRequest.types[3] = 2;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(TaskQueueDeleteRequest.class, "Z0apphosting/api/taskqueue/taskqueue_service.proto\n!apphosting.TaskQueueDeleteRequest\u0013\u001a\nqueue_name \u0001(\u00020\t8\u0002\u0014\u0013\u001a\ttask_name \u0002(\u00020\t8\u0003\u0014\u0013\u001a\u0006app_id \u0003(\u00020\t8\u0001\u0014", new ProtocolType.FieldType[]{new ProtocolType.FieldType("queue_name", "queue_name", 1, 0, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("task_name", "task_name", 2, -1, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REPEATED), new ProtocolType.FieldType("app_id", "app_id", 3, 1, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.OPTIONAL)});

            private StaticHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TaskQueueBulkAddResponse
    extends ProtocolMessage<TaskQueueBulkAddResponse> {
        private static final long serialVersionUID = 1L;
        private List<TaskResult> taskresult_ = null;
        private UninterpretedTags uninterpreted;
        public static final TaskQueueBulkAddResponse IMMUTABLE_DEFAULT_INSTANCE = new TaskQueueBulkAddResponse(){
            private static final long serialVersionUID = 1L;

            public TaskQueueBulkAddResponse clearTaskResult() {
                return this;
            }

            public TaskResult getMutableTaskResult(int i) {
                return (TaskResult)((Object)ProtocolSupport.unsupportedOperation());
            }

            public TaskResult addTaskResult() {
                return (TaskResult)((Object)ProtocolSupport.unsupportedOperation());
            }

            public TaskResult addTaskResult(TaskResult v) {
                return (TaskResult)((Object)ProtocolSupport.unsupportedOperation());
            }

            public TaskResult insertTaskResult(int i, TaskResult v) {
                return (TaskResult)((Object)ProtocolSupport.unsupportedOperation());
            }

            public TaskResult removeTaskResult(int i) {
                return (TaskResult)((Object)ProtocolSupport.unsupportedOperation());
            }

            public TaskQueueBulkAddResponse mergeFrom(TaskQueueBulkAddResponse that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public TaskQueueBulkAddResponse freeze() {
                return this;
            }

            public TaskQueueBulkAddResponse unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kTaskResultGroup = 1;
        public static final int kTaskResultresult = 2;
        public static final int kTaskResultchosen_task_name = 3;
        public static final String[] text = new String[4];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final int taskResultSize() {
            return this.taskresult_ != null ? this.taskresult_.size() : 0;
        }

        public final TaskResult getTaskResult(int i) {
            assert (i >= 0 && i < (this.taskresult_ != null ? this.taskresult_.size() : 0));
            return this.taskresult_.get(i);
        }

        public TaskQueueBulkAddResponse clearTaskResult() {
            if (this.taskresult_ != null) {
                this.taskresult_.clear();
            }
            return this;
        }

        public TaskResult getMutableTaskResult(int i) {
            assert (i >= 0 && this.taskresult_ != null && i < this.taskresult_.size());
            return this.taskresult_.get(i);
        }

        public TaskResult addTaskResult() {
            TaskResult v = new TaskResult();
            if (this.taskresult_ == null) {
                this.taskresult_ = new ArrayList<TaskResult>(4);
            }
            this.taskresult_.add(v);
            return v;
        }

        public TaskResult addTaskResult(TaskResult v) {
            if (this.taskresult_ == null) {
                this.taskresult_ = new ArrayList<TaskResult>(4);
            }
            this.taskresult_.add(v);
            return v;
        }

        public TaskResult insertTaskResult(int i, TaskResult v) {
            if (this.taskresult_ == null) {
                this.taskresult_ = new ArrayList<TaskResult>(4);
            }
            this.taskresult_.add(i, v);
            return v;
        }

        public TaskResult removeTaskResult(int i) {
            return this.taskresult_.remove(i);
        }

        public final Iterator<TaskResult> taskResultIterator() {
            if (this.taskresult_ == null) {
                return ProtocolSupport.emptyIterator();
            }
            return this.taskresult_.iterator();
        }

        public final List<TaskResult> taskResults() {
            return ProtocolSupport.unmodifiableList(this.taskresult_);
        }

        public final List<TaskResult> mutableTaskResults() {
            if (this.taskresult_ == null) {
                this.taskresult_ = new ArrayList<TaskResult>(4);
            }
            return this.taskresult_;
        }

        public TaskQueueBulkAddResponse mergeFrom(TaskQueueBulkAddResponse that) {
            assert (that != this);
            if (that.taskresult_ != null) {
                for (TaskResult v : that.taskresult_) {
                    this.addTaskResult().mergeFrom(v);
                }
            }
            if (that.uninterpreted != null) {
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll((Multimap)that.uninterpreted);
            }
            return this;
        }

        public boolean equalsIgnoreUninterpreted(TaskQueueBulkAddResponse that) {
            return this.equals(that, true);
        }

        public boolean equals(TaskQueueBulkAddResponse that) {
            return this.equals(that, false);
        }

        public boolean equals(TaskQueueBulkAddResponse that, boolean ignoreUninterpreted) {
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            int n = this.taskresult_ != null ? this.taskresult_.size() : 0;
            if (n != (that.taskresult_ != null ? that.taskresult_.size() : 0)) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (this.taskresult_.get(i).equals(that.taskresult_.get(i), ignoreUninterpreted)) continue;
                return false;
            }
            return ignoreUninterpreted || UninterpretedTags.equivalent((UninterpretedTags)this.uninterpreted, (UninterpretedTags)that.uninterpreted);
        }

        public boolean equals(Object that) {
            return that instanceof TaskQueueBulkAddResponse && this.equals((TaskQueueBulkAddResponse)((Object)that));
        }

        public int hashCode() {
            int n;
            int hash = -625678951;
            hash *= 31;
            int n2 = n = this.taskresult_ != null ? this.taskresult_.size() : 0;
            for (int i = 0; i < n; ++i) {
                hash = hash * 31 + this.taskresult_.get(i).hashCode();
            }
            if (this.uninterpreted != null && !this.uninterpreted.isEmpty()) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        public boolean isInitialized() {
            if (this.taskresult_ != null) {
                for (TaskResult v : this.taskresult_) {
                    if (v.isInitialized()) continue;
                    return false;
                }
            }
            return true;
        }

        public int encodingSize() {
            int n = 0;
            int m = this.taskresult_ != null ? this.taskresult_.size() : 0;
            n += m;
            for (int i = 0; i < m; ++i) {
                n += this.taskresult_.get(i).encodingSize();
            }
            return this.uninterpreted != null ? n + this.uninterpreted.encodingSize() : n;
        }

        public int maxEncodingSize() {
            int n = 0;
            int m = this.taskresult_ != null ? this.taskresult_.size() : 0;
            n += m;
            for (int i = 0; i < m; ++i) {
                n += this.taskresult_.get(i).maxEncodingSize();
            }
            return this.uninterpreted != null ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        public void clear() {
            if (this.taskresult_ != null) {
                this.taskresult_.clear();
            }
            this.uninterpreted = null;
        }

        public TaskQueueBulkAddResponse newInstance() {
            return new TaskQueueBulkAddResponse();
        }

        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        public void outputTo(ProtocolSink sink) {
            int m;
            int n = m = this.taskresult_ != null ? this.taskresult_.size() : 0;
            for (int i = 0; i < m; ++i) {
                TaskResult v = this.taskresult_.get(i);
                sink.putByte((byte)11);
                v.outputTo(sink);
            }
            if (this.uninterpreted != null) {
                this.uninterpreted.put(sink);
            }
        }

        public boolean merge(ProtocolSource source) {
            boolean result = true;
            block4: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block4;
                    }
                    case 11: {
                        if (this.addTaskResult().merge(source)) continue block4;
                        result = false;
                        break block4;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put((Object)tt, (Object)source.getUninterpreted(tt));
                        continue block4;
                    }
                }
            }
            return result;
        }

        public TaskQueueBulkAddResponse getDefaultInstanceForType() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public static final TaskQueueBulkAddResponse getDefaultInstance() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public TaskQueueBulkAddResponse freeze() {
            this.taskresult_ = ProtocolSupport.freezeMessages(this.taskresult_);
            return this;
        }

        public TaskQueueBulkAddResponse unfreeze() {
            this.taskresult_ = ProtocolSupport.unfreezeMessages(this.taskresult_);
            return this;
        }

        public boolean isFrozen() {
            return ProtocolSupport.isFrozenMessages(this.taskresult_);
        }

        static {
            TaskQueueBulkAddResponse.text[0] = "ErrorCode";
            TaskQueueBulkAddResponse.text[1] = "TaskResult";
            TaskQueueBulkAddResponse.text[2] = "result";
            TaskQueueBulkAddResponse.text[3] = "chosen_task_name";
            types = new int[4];
            Arrays.fill(types, 6);
            TaskQueueBulkAddResponse.types[0] = 0;
            TaskQueueBulkAddResponse.types[1] = 3;
            TaskQueueBulkAddResponse.types[2] = 0;
            TaskQueueBulkAddResponse.types[3] = 2;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(TaskQueueBulkAddResponse.class, "Z0apphosting/api/taskqueue/taskqueue_service.proto\n#apphosting.TaskQueueBulkAddResponse\u0013\u001a\nTaskResult \u0001(\u00030\n8\u0003\u0014\u0013\u001a\u0011TaskResult.result \u0002(\u00000\u00058\u0002`\u0000\u0014\u0013\u001a\u001bTaskResult.chosen_task_name \u0003(\u00020\t8\u0001`\u0000\u0014", new ProtocolType.FieldType[]{new ProtocolType.FieldType("TaskResult", "taskresult", 1, -1, ProtocolType.FieldBaseType.GROUP, ProtocolType.Presence.REPEATED, TaskResult.class)});

            private StaticHolder() {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class TaskResult
        extends ProtocolMessage<TaskResult> {
            private static final long serialVersionUID = 1L;
            private int result_ = 0;
            private byte[] chosen_task_name_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            private UninterpretedTags uninterpreted;
            private int optional_0_;
            public static final TaskResult IMMUTABLE_DEFAULT_INSTANCE = new TaskResult(){
                private static final long serialVersionUID = 1L;

                public TaskResult clearResult() {
                    return this;
                }

                public TaskResult setResult(int x) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public TaskResult clearChosenTaskName() {
                    return this;
                }

                public TaskResult setChosenTaskNameAsBytes(byte[] x) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public TaskResult setChosenTaskName(String v) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public TaskResult setChosenTaskName(String v, Charset cs) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public TaskResult mergeFrom(TaskResult that) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public boolean merge(ProtocolSource source) {
                    ProtocolSupport.unsupportedOperation();
                    return false;
                }

                public TaskResult freeze() {
                    return this;
                }

                public TaskResult unfreeze() {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public boolean isFrozen() {
                    return true;
                }
            };

            public final int getResult() {
                return this.result_;
            }

            public final boolean hasResult() {
                return (this.optional_0_ & 1) != 0;
            }

            public TaskResult clearResult() {
                this.optional_0_ &= 0xFFFFFFFE;
                this.result_ = 0;
                return this;
            }

            public TaskResult setResult(int x) {
                this.optional_0_ |= 1;
                this.result_ = x;
                return this;
            }

            public final byte[] getChosenTaskNameAsBytes() {
                return this.chosen_task_name_;
            }

            public final boolean hasChosenTaskName() {
                return (this.optional_0_ & 2) != 0;
            }

            public TaskResult clearChosenTaskName() {
                this.optional_0_ &= 0xFFFFFFFD;
                this.chosen_task_name_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
                return this;
            }

            public TaskResult setChosenTaskNameAsBytes(byte[] x) {
                this.optional_0_ |= 2;
                this.chosen_task_name_ = x;
                return this;
            }

            public final String getChosenTaskName() {
                return ProtocolSupport.toStringUtf8((byte[])this.chosen_task_name_);
            }

            public TaskResult setChosenTaskName(String v) {
                if (v == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 2;
                this.chosen_task_name_ = ProtocolSupport.toBytesUtf8((String)v);
                return this;
            }

            public final String getChosenTaskName(Charset cs) {
                return ProtocolSupport.toString((byte[])this.chosen_task_name_, (Charset)cs);
            }

            public TaskResult setChosenTaskName(String v, Charset cs) {
                if (v == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 2;
                this.chosen_task_name_ = ProtocolSupport.toBytes((String)v, (Charset)cs);
                return this;
            }

            public TaskResult mergeFrom(TaskResult that) {
                assert (that != this);
                int this_t0 = this.optional_0_;
                int that_t0 = that.optional_0_;
                if ((that_t0 & 1) != 0) {
                    this_t0 |= 1;
                    this.result_ = that.result_;
                }
                if ((that_t0 & 2) != 0) {
                    this_t0 |= 2;
                    this.chosen_task_name_ = that.chosen_task_name_;
                }
                if (that.uninterpreted != null) {
                    if (this.uninterpreted == null) {
                        this.uninterpreted = new UninterpretedTags();
                    }
                    this.uninterpreted.putAll((Multimap)that.uninterpreted);
                }
                this.optional_0_ = this_t0;
                return this;
            }

            public boolean equalsIgnoreUninterpreted(TaskResult that) {
                return this.equals(that, true);
            }

            public boolean equals(TaskResult that) {
                return this.equals(that, false);
            }

            public boolean equals(TaskResult that, boolean ignoreUninterpreted) {
                if (that == null) {
                    return false;
                }
                if (that == this) {
                    return true;
                }
                int this_t0 = this.optional_0_;
                int that_t0 = that.optional_0_;
                if (this_t0 != that_t0) {
                    return false;
                }
                if ((this_t0 & 1) != 0 && this.result_ != that.result_) {
                    return false;
                }
                if ((this_t0 & 2) != 0 && !Arrays.equals(this.chosen_task_name_, that.chosen_task_name_)) {
                    return false;
                }
                return ignoreUninterpreted || UninterpretedTags.equivalent((UninterpretedTags)this.uninterpreted, (UninterpretedTags)that.uninterpreted);
            }

            public boolean equals(Object that) {
                return that instanceof TaskResult && this.equals((TaskResult)((Object)that));
            }

            public int hashCode() {
                int hash = -155245953;
                int this_t0 = this.optional_0_;
                hash = hash * 31 + ((this_t0 & 1) != 0 ? this.result_ : -113);
                hash = hash * 31 + ((this_t0 & 2) != 0 ? Arrays.hashCode(this.chosen_task_name_) : -113);
                if (this.uninterpreted != null && !this.uninterpreted.isEmpty()) {
                    hash = hash * 31 + this.uninterpreted.hashCode();
                }
                return hash;
            }

            public boolean isInitialized() {
                int this_t0 = this.optional_0_;
                return (this_t0 & 1) == 1;
            }

            public int encodingSize() {
                int n = 2 + Protocol.varLongSize((long)this.result_);
                int this_t0 = this.optional_0_;
                if ((this_t0 & 2) != 0) {
                    n += 1 + Protocol.stringSize((int)this.chosen_task_name_.length);
                }
                return this.uninterpreted != null ? n + this.uninterpreted.encodingSize() : n;
            }

            public int maxEncodingSize() {
                int n = 12;
                int this_t0 = this.optional_0_;
                if ((this_t0 & 2) != 0) {
                    n += 6 + this.chosen_task_name_.length;
                }
                return this.uninterpreted != null ? n + this.uninterpreted.maxEncodingSize() : n;
            }

            public MessageAppender getMessageAppender() {
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                return this.uninterpreted;
            }

            public void clear() {
                this.optional_0_ = 0;
                this.result_ = 0;
                this.chosen_task_name_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
                this.uninterpreted = null;
            }

            public TaskResult newInstance() {
                return new TaskResult();
            }

            public ProtocolType getProtocolType() {
                return StaticHolder.protocolType;
            }

            public void outputTo(ProtocolSink sink) {
                sink.putByte((byte)16);
                sink.putVarLong(this.result_);
                int this_t0 = this.optional_0_;
                if ((this_t0 & 2) != 0) {
                    sink.putByte((byte)26);
                    sink.putPrefixedData(this.chosen_task_name_);
                }
                if (this.uninterpreted != null) {
                    this.uninterpreted.put(sink);
                }
                sink.putByte((byte)12);
            }

            public boolean merge(ProtocolSource source) {
                boolean result = true;
                int this_t0 = this.optional_0_;
                block6: while (true) {
                    int tt = source.getVarInt();
                    switch (tt) {
                        case 12: {
                            break block6;
                        }
                        case 0: {
                            result = false;
                            break block6;
                        }
                        case 16: {
                            this.result_ = source.getVarInt();
                            this_t0 |= 1;
                            continue block6;
                        }
                        case 26: {
                            this.chosen_task_name_ = source.getPrefixedData();
                            this_t0 |= 2;
                            continue block6;
                        }
                        default: {
                            if (this.uninterpreted == null) {
                                this.uninterpreted = new UninterpretedTags();
                            }
                            this.uninterpreted.put((Object)tt, (Object)source.getUninterpreted(tt));
                            continue block6;
                        }
                    }
                    break;
                }
                this.optional_0_ = this_t0;
                return result;
            }

            public TaskResult getDefaultInstanceForType() {
                return IMMUTABLE_DEFAULT_INSTANCE;
            }

            public static final TaskResult getDefaultInstance() {
                return IMMUTABLE_DEFAULT_INSTANCE;
            }

            public TaskResult freeze() {
                this.chosen_task_name_ = ProtocolSupport.freezeString((byte[])this.chosen_task_name_);
                return this;
            }

            private static class StaticHolder {
                private static final ProtocolType protocolType = new ProtocolType(TaskResult.class, null, new ProtocolType.FieldType[]{new ProtocolType.FieldType("result", "result", 2, 0, ProtocolType.FieldBaseType.INT32, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("chosen_task_name", "chosen_task_name", 3, 1, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.OPTIONAL)});

                private StaticHolder() {
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TaskQueueBulkAddRequest
    extends ProtocolMessage<TaskQueueBulkAddRequest> {
        private static final long serialVersionUID = 1L;
        private List<TaskQueueAddRequest> add_request_ = null;
        private UninterpretedTags uninterpreted;
        public static final TaskQueueBulkAddRequest IMMUTABLE_DEFAULT_INSTANCE = new TaskQueueBulkAddRequest(){
            private static final long serialVersionUID = 1L;

            public TaskQueueBulkAddRequest clearAddRequest() {
                return this;
            }

            public TaskQueueAddRequest getMutableAddRequest(int i) {
                return (TaskQueueAddRequest)((Object)ProtocolSupport.unsupportedOperation());
            }

            public TaskQueueAddRequest addAddRequest() {
                return (TaskQueueAddRequest)((Object)ProtocolSupport.unsupportedOperation());
            }

            public TaskQueueAddRequest addAddRequest(TaskQueueAddRequest v) {
                return (TaskQueueAddRequest)((Object)ProtocolSupport.unsupportedOperation());
            }

            public TaskQueueAddRequest insertAddRequest(int i, TaskQueueAddRequest v) {
                return (TaskQueueAddRequest)((Object)ProtocolSupport.unsupportedOperation());
            }

            public TaskQueueAddRequest removeAddRequest(int i) {
                return (TaskQueueAddRequest)((Object)ProtocolSupport.unsupportedOperation());
            }

            public TaskQueueBulkAddRequest mergeFrom(TaskQueueBulkAddRequest that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public TaskQueueBulkAddRequest freeze() {
                return this;
            }

            public TaskQueueBulkAddRequest unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kadd_request = 1;
        public static final String[] text = new String[2];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final int addRequestSize() {
            return this.add_request_ != null ? this.add_request_.size() : 0;
        }

        public final TaskQueueAddRequest getAddRequest(int i) {
            assert (i >= 0 && i < (this.add_request_ != null ? this.add_request_.size() : 0));
            return this.add_request_.get(i);
        }

        public TaskQueueBulkAddRequest clearAddRequest() {
            if (this.add_request_ != null) {
                this.add_request_.clear();
            }
            return this;
        }

        public TaskQueueAddRequest getMutableAddRequest(int i) {
            assert (i >= 0 && this.add_request_ != null && i < this.add_request_.size());
            return this.add_request_.get(i);
        }

        public TaskQueueAddRequest addAddRequest() {
            TaskQueueAddRequest v = new TaskQueueAddRequest();
            if (this.add_request_ == null) {
                this.add_request_ = new ArrayList<TaskQueueAddRequest>(4);
            }
            this.add_request_.add(v);
            return v;
        }

        public TaskQueueAddRequest addAddRequest(TaskQueueAddRequest v) {
            if (this.add_request_ == null) {
                this.add_request_ = new ArrayList<TaskQueueAddRequest>(4);
            }
            this.add_request_.add(v);
            return v;
        }

        public TaskQueueAddRequest insertAddRequest(int i, TaskQueueAddRequest v) {
            if (this.add_request_ == null) {
                this.add_request_ = new ArrayList<TaskQueueAddRequest>(4);
            }
            this.add_request_.add(i, v);
            return v;
        }

        public TaskQueueAddRequest removeAddRequest(int i) {
            return this.add_request_.remove(i);
        }

        public final Iterator<TaskQueueAddRequest> addRequestIterator() {
            if (this.add_request_ == null) {
                return ProtocolSupport.emptyIterator();
            }
            return this.add_request_.iterator();
        }

        public final List<TaskQueueAddRequest> addRequests() {
            return ProtocolSupport.unmodifiableList(this.add_request_);
        }

        public final List<TaskQueueAddRequest> mutableAddRequests() {
            if (this.add_request_ == null) {
                this.add_request_ = new ArrayList<TaskQueueAddRequest>(4);
            }
            return this.add_request_;
        }

        public TaskQueueBulkAddRequest mergeFrom(TaskQueueBulkAddRequest that) {
            assert (that != this);
            if (that.add_request_ != null) {
                for (TaskQueueAddRequest v : that.add_request_) {
                    this.addAddRequest().mergeFrom(v);
                }
            }
            if (that.uninterpreted != null) {
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll((Multimap)that.uninterpreted);
            }
            return this;
        }

        public boolean equalsIgnoreUninterpreted(TaskQueueBulkAddRequest that) {
            return this.equals(that, true);
        }

        public boolean equals(TaskQueueBulkAddRequest that) {
            return this.equals(that, false);
        }

        public boolean equals(TaskQueueBulkAddRequest that, boolean ignoreUninterpreted) {
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            int n = this.add_request_ != null ? this.add_request_.size() : 0;
            if (n != (that.add_request_ != null ? that.add_request_.size() : 0)) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (this.add_request_.get(i).equals(that.add_request_.get(i), ignoreUninterpreted)) continue;
                return false;
            }
            return ignoreUninterpreted || UninterpretedTags.equivalent((UninterpretedTags)this.uninterpreted, (UninterpretedTags)that.uninterpreted);
        }

        public boolean equals(Object that) {
            return that instanceof TaskQueueBulkAddRequest && this.equals((TaskQueueBulkAddRequest)((Object)that));
        }

        public int hashCode() {
            int n;
            int hash = 1281998108;
            hash *= 31;
            int n2 = n = this.add_request_ != null ? this.add_request_.size() : 0;
            for (int i = 0; i < n; ++i) {
                hash = hash * 31 + this.add_request_.get(i).hashCode();
            }
            if (this.uninterpreted != null && !this.uninterpreted.isEmpty()) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        public boolean isInitialized() {
            if (this.add_request_ != null) {
                for (TaskQueueAddRequest v : this.add_request_) {
                    if (v.isInitialized()) continue;
                    return false;
                }
            }
            return true;
        }

        public int encodingSize() {
            int n = 0;
            int m = this.add_request_ != null ? this.add_request_.size() : 0;
            n += m;
            for (int i = 0; i < m; ++i) {
                n += Protocol.stringSize((int)this.add_request_.get(i).encodingSize());
            }
            return this.uninterpreted != null ? n + this.uninterpreted.encodingSize() : n;
        }

        public int maxEncodingSize() {
            int n = 0;
            int m = this.add_request_ != null ? this.add_request_.size() : 0;
            n += 6 * m;
            for (int i = 0; i < m; ++i) {
                n += this.add_request_.get(i).maxEncodingSize();
            }
            return this.uninterpreted != null ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        public void clear() {
            if (this.add_request_ != null) {
                this.add_request_.clear();
            }
            this.uninterpreted = null;
        }

        public TaskQueueBulkAddRequest newInstance() {
            return new TaskQueueBulkAddRequest();
        }

        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        public void outputTo(ProtocolSink sink) {
            int m;
            int n = m = this.add_request_ != null ? this.add_request_.size() : 0;
            for (int i = 0; i < m; ++i) {
                TaskQueueAddRequest v = this.add_request_.get(i);
                sink.putByte((byte)10);
                sink.putForeign((ProtocolMessage)v);
            }
            if (this.uninterpreted != null) {
                this.uninterpreted.put(sink);
            }
        }

        public boolean merge(ProtocolSource source) {
            boolean result = true;
            block4: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block4;
                    }
                    case 10: {
                        source.push(source.getVarInt());
                        if (!this.addAddRequest().merge(source)) {
                            result = false;
                            break block4;
                        }
                        source.pop();
                        continue block4;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put((Object)tt, (Object)source.getUninterpreted(tt));
                        continue block4;
                    }
                }
            }
            return result;
        }

        public TaskQueueBulkAddRequest getDefaultInstanceForType() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public static final TaskQueueBulkAddRequest getDefaultInstance() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public TaskQueueBulkAddRequest freeze() {
            this.add_request_ = ProtocolSupport.freezeMessages(this.add_request_);
            return this;
        }

        public TaskQueueBulkAddRequest unfreeze() {
            this.add_request_ = ProtocolSupport.unfreezeMessages(this.add_request_);
            return this;
        }

        public boolean isFrozen() {
            return ProtocolSupport.isFrozenMessages(this.add_request_);
        }

        static {
            TaskQueueBulkAddRequest.text[0] = "ErrorCode";
            TaskQueueBulkAddRequest.text[1] = "add_request";
            types = new int[2];
            Arrays.fill(types, 6);
            TaskQueueBulkAddRequest.types[0] = 0;
            TaskQueueBulkAddRequest.types[1] = 2;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(TaskQueueBulkAddRequest.class, "Z0apphosting/api/taskqueue/taskqueue_service.proto\n\"apphosting.TaskQueueBulkAddRequest\u0013\u001a\u000badd_request \u0001(\u00020\u000b8\u0003J\u001eapphosting.TaskQueueAddRequest\u0014", new ProtocolType.FieldType[]{new ProtocolType.FieldType("add_request", "add_request", 1, -1, ProtocolType.FieldBaseType.FOREIGN, ProtocolType.Presence.REPEATED, TaskQueueAddRequest.class)});

            private StaticHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TaskQueueAddResponse
    extends ProtocolMessage<TaskQueueAddResponse> {
        private static final long serialVersionUID = 1L;
        private byte[] chosen_task_name_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final TaskQueueAddResponse IMMUTABLE_DEFAULT_INSTANCE = new TaskQueueAddResponse(){
            private static final long serialVersionUID = 1L;

            public TaskQueueAddResponse clearChosenTaskName() {
                return this;
            }

            public TaskQueueAddResponse setChosenTaskNameAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueAddResponse setChosenTaskName(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueAddResponse setChosenTaskName(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueAddResponse mergeFrom(TaskQueueAddResponse that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public TaskQueueAddResponse freeze() {
                return this;
            }

            public TaskQueueAddResponse unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kchosen_task_name = 1;
        public static final String[] text = new String[2];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final byte[] getChosenTaskNameAsBytes() {
            return this.chosen_task_name_;
        }

        public final boolean hasChosenTaskName() {
            return (this.optional_0_ & 1) != 0;
        }

        public TaskQueueAddResponse clearChosenTaskName() {
            this.optional_0_ &= 0xFFFFFFFE;
            this.chosen_task_name_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public TaskQueueAddResponse setChosenTaskNameAsBytes(byte[] x) {
            this.optional_0_ |= 1;
            this.chosen_task_name_ = x;
            return this;
        }

        public final String getChosenTaskName() {
            return ProtocolSupport.toStringUtf8((byte[])this.chosen_task_name_);
        }

        public TaskQueueAddResponse setChosenTaskName(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.chosen_task_name_ = ProtocolSupport.toBytesUtf8((String)v);
            return this;
        }

        public final String getChosenTaskName(Charset cs) {
            return ProtocolSupport.toString((byte[])this.chosen_task_name_, (Charset)cs);
        }

        public TaskQueueAddResponse setChosenTaskName(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.chosen_task_name_ = ProtocolSupport.toBytes((String)v, (Charset)cs);
            return this;
        }

        public TaskQueueAddResponse mergeFrom(TaskQueueAddResponse that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                this.chosen_task_name_ = that.chosen_task_name_;
            }
            if (that.uninterpreted != null) {
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll((Multimap)that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        public boolean equalsIgnoreUninterpreted(TaskQueueAddResponse that) {
            return this.equals(that, true);
        }

        public boolean equals(TaskQueueAddResponse that) {
            return this.equals(that, false);
        }

        public boolean equals(TaskQueueAddResponse that, boolean ignoreUninterpreted) {
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (this_t0 != that_t0) {
                return false;
            }
            if ((this_t0 & 1) != 0 && !Arrays.equals(this.chosen_task_name_, that.chosen_task_name_)) {
                return false;
            }
            return ignoreUninterpreted || UninterpretedTags.equivalent((UninterpretedTags)this.uninterpreted, (UninterpretedTags)that.uninterpreted);
        }

        public boolean equals(Object that) {
            return that instanceof TaskQueueAddResponse && this.equals((TaskQueueAddResponse)((Object)that));
        }

        public int hashCode() {
            int hash = 2077983836;
            int this_t0 = this.optional_0_;
            hash = hash * 31 + ((this_t0 & 1) != 0 ? Arrays.hashCode(this.chosen_task_name_) : -113);
            if (this.uninterpreted != null && !this.uninterpreted.isEmpty()) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        public boolean isInitialized() {
            return true;
        }

        public int encodingSize() {
            int n = 0;
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                n += 1 + Protocol.stringSize((int)this.chosen_task_name_.length);
            }
            return this.uninterpreted != null ? n + this.uninterpreted.encodingSize() : n;
        }

        public int maxEncodingSize() {
            int n = 0;
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                n += 6 + this.chosen_task_name_.length;
            }
            return this.uninterpreted != null ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        public void clear() {
            this.optional_0_ = 0;
            this.chosen_task_name_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.uninterpreted = null;
        }

        public TaskQueueAddResponse newInstance() {
            return new TaskQueueAddResponse();
        }

        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        public void outputTo(ProtocolSink sink) {
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                sink.putByte((byte)10);
                sink.putPrefixedData(this.chosen_task_name_);
            }
            if (this.uninterpreted != null) {
                this.uninterpreted.put(sink);
            }
        }

        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block4: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block4;
                    }
                    case 10: {
                        this.chosen_task_name_ = source.getPrefixedData();
                        this_t0 |= 1;
                        continue block4;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put((Object)tt, (Object)source.getUninterpreted(tt));
                        continue block4;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        public TaskQueueAddResponse getDefaultInstanceForType() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public static final TaskQueueAddResponse getDefaultInstance() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public TaskQueueAddResponse freeze() {
            this.chosen_task_name_ = ProtocolSupport.freezeString((byte[])this.chosen_task_name_);
            return this;
        }

        static {
            TaskQueueAddResponse.text[0] = "ErrorCode";
            TaskQueueAddResponse.text[1] = "chosen_task_name";
            types = new int[2];
            Arrays.fill(types, 6);
            TaskQueueAddResponse.types[0] = 0;
            TaskQueueAddResponse.types[1] = 2;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(TaskQueueAddResponse.class, "Z0apphosting/api/taskqueue/taskqueue_service.proto\n\u001fapphosting.TaskQueueAddResponse\u0013\u001a\u0010chosen_task_name \u0001(\u00020\t8\u0001\u0014", new ProtocolType.FieldType[]{new ProtocolType.FieldType("chosen_task_name", "chosen_task_name", 1, 0, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.OPTIONAL)});

            private StaticHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TaskQueueAddRequest
    extends ProtocolMessage<TaskQueueAddRequest> {
        private static final long serialVersionUID = 1L;
        private byte[] queue_name_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private byte[] task_name_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private long eta_usec_ = 0L;
        private int method_ = 2;
        private byte[] url_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private List<Header> header_ = null;
        private byte[] body_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private Transaction transaction_ = null;
        private byte[] app_id_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private CronTimetable crontimetable_ = null;
        private byte[] description_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private MessageSet payload_ = null;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final TaskQueueAddRequest IMMUTABLE_DEFAULT_INSTANCE = new TaskQueueAddRequest(){
            private static final long serialVersionUID = 1L;

            public TaskQueueAddRequest clearQueueName() {
                return this;
            }

            public TaskQueueAddRequest setQueueNameAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueAddRequest setQueueName(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueAddRequest setQueueName(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueAddRequest clearTaskName() {
                return this;
            }

            public TaskQueueAddRequest setTaskNameAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueAddRequest setTaskName(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueAddRequest setTaskName(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueAddRequest clearEtaUsec() {
                return this;
            }

            public TaskQueueAddRequest setEtaUsec(long x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueAddRequest clearMethod() {
                return this;
            }

            public TaskQueueAddRequest setMethod(int x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueAddRequest clearUrl() {
                return this;
            }

            public TaskQueueAddRequest setUrlAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueAddRequest setUrl(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueAddRequest setUrl(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueAddRequest clearHeader() {
                return this;
            }

            public Header getMutableHeader(int i) {
                return (Header)((Object)ProtocolSupport.unsupportedOperation());
            }

            public Header addHeader() {
                return (Header)((Object)ProtocolSupport.unsupportedOperation());
            }

            public Header addHeader(Header v) {
                return (Header)((Object)ProtocolSupport.unsupportedOperation());
            }

            public Header insertHeader(int i, Header v) {
                return (Header)((Object)ProtocolSupport.unsupportedOperation());
            }

            public Header removeHeader(int i) {
                return (Header)((Object)ProtocolSupport.unsupportedOperation());
            }

            public TaskQueueAddRequest clearBody() {
                return this;
            }

            public TaskQueueAddRequest setBodyAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueAddRequest setBody(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueAddRequest setBody(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueAddRequest clearTransaction() {
                return this;
            }

            public TaskQueueAddRequest setTransaction(Transaction x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Transaction getMutableTransaction() {
                return (Transaction)((Object)ProtocolSupport.unsupportedOperation());
            }

            public TaskQueueAddRequest clearAppId() {
                return this;
            }

            public TaskQueueAddRequest setAppIdAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueAddRequest setAppId(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueAddRequest setAppId(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueAddRequest clearCronTimetable() {
                return this;
            }

            public TaskQueueAddRequest setCronTimetable(CronTimetable x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public CronTimetable getMutableCronTimetable() {
                return (CronTimetable)((Object)ProtocolSupport.unsupportedOperation());
            }

            public TaskQueueAddRequest clearDescription() {
                return this;
            }

            public TaskQueueAddRequest setDescriptionAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueAddRequest setDescription(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueAddRequest setDescription(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public TaskQueueAddRequest clearPayload() {
                return this;
            }

            public TaskQueueAddRequest setPayload(MessageSet x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MessageSet getMutablePayload() {
                return (MessageSet)ProtocolSupport.unsupportedOperation();
            }

            public TaskQueueAddRequest mergeFrom(TaskQueueAddRequest that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public TaskQueueAddRequest freeze() {
                return this;
            }

            public TaskQueueAddRequest unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kqueue_name = 1;
        public static final int ktask_name = 2;
        public static final int keta_usec = 3;
        public static final int kmethod = 5;
        public static final int kurl = 4;
        public static final int kHeaderGroup = 6;
        public static final int kHeaderkey = 7;
        public static final int kHeadervalue = 8;
        public static final int kbody = 9;
        public static final int ktransaction = 10;
        public static final int kapp_id = 11;
        public static final int kCronTimetableGroup = 12;
        public static final int kCronTimetableschedule = 13;
        public static final int kCronTimetabletimezone = 14;
        public static final int kdescription = 15;
        public static final int kpayload = 16;
        public static final String[] text = new String[17];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final byte[] getQueueNameAsBytes() {
            return this.queue_name_;
        }

        public final boolean hasQueueName() {
            return (this.optional_0_ & 1) != 0;
        }

        public TaskQueueAddRequest clearQueueName() {
            this.optional_0_ &= 0xFFFFFFFE;
            this.queue_name_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public TaskQueueAddRequest setQueueNameAsBytes(byte[] x) {
            this.optional_0_ |= 1;
            this.queue_name_ = x;
            return this;
        }

        public final String getQueueName() {
            return ProtocolSupport.toStringUtf8((byte[])this.queue_name_);
        }

        public TaskQueueAddRequest setQueueName(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.queue_name_ = ProtocolSupport.toBytesUtf8((String)v);
            return this;
        }

        public final String getQueueName(Charset cs) {
            return ProtocolSupport.toString((byte[])this.queue_name_, (Charset)cs);
        }

        public TaskQueueAddRequest setQueueName(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.queue_name_ = ProtocolSupport.toBytes((String)v, (Charset)cs);
            return this;
        }

        public final byte[] getTaskNameAsBytes() {
            return this.task_name_;
        }

        public final boolean hasTaskName() {
            return (this.optional_0_ & 2) != 0;
        }

        public TaskQueueAddRequest clearTaskName() {
            this.optional_0_ &= 0xFFFFFFFD;
            this.task_name_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public TaskQueueAddRequest setTaskNameAsBytes(byte[] x) {
            this.optional_0_ |= 2;
            this.task_name_ = x;
            return this;
        }

        public final String getTaskName() {
            return ProtocolSupport.toStringUtf8((byte[])this.task_name_);
        }

        public TaskQueueAddRequest setTaskName(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 2;
            this.task_name_ = ProtocolSupport.toBytesUtf8((String)v);
            return this;
        }

        public final String getTaskName(Charset cs) {
            return ProtocolSupport.toString((byte[])this.task_name_, (Charset)cs);
        }

        public TaskQueueAddRequest setTaskName(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 2;
            this.task_name_ = ProtocolSupport.toBytes((String)v, (Charset)cs);
            return this;
        }

        public final long getEtaUsec() {
            return this.eta_usec_;
        }

        public final boolean hasEtaUsec() {
            return (this.optional_0_ & 4) != 0;
        }

        public TaskQueueAddRequest clearEtaUsec() {
            this.optional_0_ &= 0xFFFFFFFB;
            this.eta_usec_ = 0L;
            return this;
        }

        public TaskQueueAddRequest setEtaUsec(long x) {
            this.optional_0_ |= 4;
            this.eta_usec_ = x;
            return this;
        }

        public final int getMethod() {
            return this.method_;
        }

        public RequestMethod getMethodEnum() {
            return RequestMethod.valueOf(this.getMethod());
        }

        public final boolean hasMethod() {
            return (this.optional_0_ & 8) != 0;
        }

        public TaskQueueAddRequest clearMethod() {
            this.optional_0_ &= 0xFFFFFFF7;
            this.method_ = 2;
            return this;
        }

        public TaskQueueAddRequest setMethod(int x) {
            this.optional_0_ |= 8;
            this.method_ = x;
            return this;
        }

        public TaskQueueAddRequest setMethod(RequestMethod x) {
            if (x == null) {
                this.optional_0_ &= 0xFFFFFFF7;
                this.method_ = 2;
            } else {
                this.setMethod(x.getValue());
            }
            return this;
        }

        public final byte[] getUrlAsBytes() {
            return this.url_;
        }

        public final boolean hasUrl() {
            return (this.optional_0_ & 0x10) != 0;
        }

        public TaskQueueAddRequest clearUrl() {
            this.optional_0_ &= 0xFFFFFFEF;
            this.url_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public TaskQueueAddRequest setUrlAsBytes(byte[] x) {
            this.optional_0_ |= 0x10;
            this.url_ = x;
            return this;
        }

        public final String getUrl() {
            return ProtocolSupport.toStringUtf8((byte[])this.url_);
        }

        public TaskQueueAddRequest setUrl(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 0x10;
            this.url_ = ProtocolSupport.toBytesUtf8((String)v);
            return this;
        }

        public final String getUrl(Charset cs) {
            return ProtocolSupport.toString((byte[])this.url_, (Charset)cs);
        }

        public TaskQueueAddRequest setUrl(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 0x10;
            this.url_ = ProtocolSupport.toBytes((String)v, (Charset)cs);
            return this;
        }

        public final int headerSize() {
            return this.header_ != null ? this.header_.size() : 0;
        }

        public final Header getHeader(int i) {
            assert (i >= 0 && i < (this.header_ != null ? this.header_.size() : 0));
            return this.header_.get(i);
        }

        public TaskQueueAddRequest clearHeader() {
            if (this.header_ != null) {
                this.header_.clear();
            }
            return this;
        }

        public Header getMutableHeader(int i) {
            assert (i >= 0 && this.header_ != null && i < this.header_.size());
            return this.header_.get(i);
        }

        public Header addHeader() {
            Header v = new Header();
            if (this.header_ == null) {
                this.header_ = new ArrayList<Header>(4);
            }
            this.header_.add(v);
            return v;
        }

        public Header addHeader(Header v) {
            if (this.header_ == null) {
                this.header_ = new ArrayList<Header>(4);
            }
            this.header_.add(v);
            return v;
        }

        public Header insertHeader(int i, Header v) {
            if (this.header_ == null) {
                this.header_ = new ArrayList<Header>(4);
            }
            this.header_.add(i, v);
            return v;
        }

        public Header removeHeader(int i) {
            return this.header_.remove(i);
        }

        public final Iterator<Header> headerIterator() {
            if (this.header_ == null) {
                return ProtocolSupport.emptyIterator();
            }
            return this.header_.iterator();
        }

        public final List<Header> headers() {
            return ProtocolSupport.unmodifiableList(this.header_);
        }

        public final List<Header> mutableHeaders() {
            if (this.header_ == null) {
                this.header_ = new ArrayList<Header>(4);
            }
            return this.header_;
        }

        public final byte[] getBodyAsBytes() {
            return this.body_;
        }

        public final boolean hasBody() {
            return (this.optional_0_ & 0x20) != 0;
        }

        public TaskQueueAddRequest clearBody() {
            this.optional_0_ &= 0xFFFFFFDF;
            this.body_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public TaskQueueAddRequest setBodyAsBytes(byte[] x) {
            this.optional_0_ |= 0x20;
            this.body_ = x;
            return this;
        }

        public final String getBody() {
            return ProtocolSupport.toStringUtf8((byte[])this.body_);
        }

        public TaskQueueAddRequest setBody(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 0x20;
            this.body_ = ProtocolSupport.toBytesUtf8((String)v);
            return this;
        }

        public final String getBody(Charset cs) {
            return ProtocolSupport.toString((byte[])this.body_, (Charset)cs);
        }

        public TaskQueueAddRequest setBody(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 0x20;
            this.body_ = ProtocolSupport.toBytes((String)v, (Charset)cs);
            return this;
        }

        public final Transaction getTransaction() {
            if (this.transaction_ == null) {
                return Transaction.IMMUTABLE_DEFAULT_INSTANCE;
            }
            return this.transaction_;
        }

        public final boolean hasTransaction() {
            return (this.optional_0_ & 0x40) != 0;
        }

        public TaskQueueAddRequest clearTransaction() {
            this.optional_0_ &= 0xFFFFFFBF;
            if (this.transaction_ != null) {
                this.transaction_.clear();
            }
            return this;
        }

        public TaskQueueAddRequest setTransaction(Transaction x) {
            if (x == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 0x40;
            this.transaction_ = x;
            return this;
        }

        public Transaction getMutableTransaction() {
            this.optional_0_ |= 0x40;
            if (this.transaction_ == null) {
                this.transaction_ = new Transaction();
            }
            return this.transaction_;
        }

        public final byte[] getAppIdAsBytes() {
            return this.app_id_;
        }

        public final boolean hasAppId() {
            return (this.optional_0_ & 0x80) != 0;
        }

        public TaskQueueAddRequest clearAppId() {
            this.optional_0_ &= 0xFFFFFF7F;
            this.app_id_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public TaskQueueAddRequest setAppIdAsBytes(byte[] x) {
            this.optional_0_ |= 0x80;
            this.app_id_ = x;
            return this;
        }

        public final String getAppId() {
            return ProtocolSupport.toStringUtf8((byte[])this.app_id_);
        }

        public TaskQueueAddRequest setAppId(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 0x80;
            this.app_id_ = ProtocolSupport.toBytesUtf8((String)v);
            return this;
        }

        public final String getAppId(Charset cs) {
            return ProtocolSupport.toString((byte[])this.app_id_, (Charset)cs);
        }

        public TaskQueueAddRequest setAppId(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 0x80;
            this.app_id_ = ProtocolSupport.toBytes((String)v, (Charset)cs);
            return this;
        }

        public final CronTimetable getCronTimetable() {
            if (this.crontimetable_ == null) {
                return CronTimetable.IMMUTABLE_DEFAULT_INSTANCE;
            }
            return this.crontimetable_;
        }

        public final boolean hasCronTimetable() {
            return (this.optional_0_ & 0x100) != 0;
        }

        public TaskQueueAddRequest clearCronTimetable() {
            this.optional_0_ &= 0xFFFFFEFF;
            if (this.crontimetable_ != null) {
                this.crontimetable_.clear();
            }
            return this;
        }

        public TaskQueueAddRequest setCronTimetable(CronTimetable x) {
            if (x == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 0x100;
            this.crontimetable_ = x;
            return this;
        }

        public CronTimetable getMutableCronTimetable() {
            this.optional_0_ |= 0x100;
            if (this.crontimetable_ == null) {
                this.crontimetable_ = new CronTimetable();
            }
            return this.crontimetable_;
        }

        public final byte[] getDescriptionAsBytes() {
            return this.description_;
        }

        public final boolean hasDescription() {
            return (this.optional_0_ & 0x200) != 0;
        }

        public TaskQueueAddRequest clearDescription() {
            this.optional_0_ &= 0xFFFFFDFF;
            this.description_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public TaskQueueAddRequest setDescriptionAsBytes(byte[] x) {
            this.optional_0_ |= 0x200;
            this.description_ = x;
            return this;
        }

        public final String getDescription() {
            return ProtocolSupport.toStringUtf8((byte[])this.description_);
        }

        public TaskQueueAddRequest setDescription(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 0x200;
            this.description_ = ProtocolSupport.toBytesUtf8((String)v);
            return this;
        }

        public final String getDescription(Charset cs) {
            return ProtocolSupport.toString((byte[])this.description_, (Charset)cs);
        }

        public TaskQueueAddRequest setDescription(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 0x200;
            this.description_ = ProtocolSupport.toBytes((String)v, (Charset)cs);
            return this;
        }

        public final MessageSet getPayload() {
            if (this.payload_ == null) {
                return MessageSet.IMMUTABLE_DEFAULT_INSTANCE;
            }
            return this.payload_;
        }

        public final boolean hasPayload() {
            return (this.optional_0_ & 0x400) != 0;
        }

        public TaskQueueAddRequest clearPayload() {
            this.optional_0_ &= 0xFFFFFBFF;
            if (this.payload_ != null) {
                this.payload_.clear();
            }
            return this;
        }

        public TaskQueueAddRequest setPayload(MessageSet x) {
            if (x == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 0x400;
            this.payload_ = x;
            return this;
        }

        public MessageSet getMutablePayload() {
            this.optional_0_ |= 0x400;
            if (this.payload_ == null) {
                this.payload_ = new MessageSet();
            }
            return this.payload_;
        }

        public TaskQueueAddRequest mergeFrom(TaskQueueAddRequest that) {
            ProtocolMessage v;
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                this.queue_name_ = that.queue_name_;
            }
            if ((that_t0 & 2) != 0) {
                this_t0 |= 2;
                this.task_name_ = that.task_name_;
            }
            if ((that_t0 & 4) != 0) {
                this_t0 |= 4;
                this.eta_usec_ = that.eta_usec_;
            }
            if ((that_t0 & 8) != 0) {
                this_t0 |= 8;
                this.method_ = that.method_;
            }
            if ((that_t0 & 0x10) != 0) {
                this_t0 |= 0x10;
                this.url_ = that.url_;
            }
            if (that.header_ != null) {
                for (Header v2 : that.header_) {
                    this.addHeader().mergeFrom(v2);
                }
            }
            if ((that_t0 & 0x20) != 0) {
                this_t0 |= 0x20;
                this.body_ = that.body_;
            }
            if ((that_t0 & 0x40) != 0) {
                this_t0 |= 0x40;
                v = this.transaction_;
                if (v == null) {
                    v = new Transaction();
                    this.transaction_ = v;
                }
                v.mergeFrom(that.transaction_);
            }
            if ((that_t0 & 0x80) != 0) {
                this_t0 |= 0x80;
                this.app_id_ = that.app_id_;
            }
            if ((that_t0 & 0x100) != 0) {
                this_t0 |= 0x100;
                v = this.crontimetable_;
                if (v == null) {
                    v = new CronTimetable();
                    this.crontimetable_ = v;
                }
                v.mergeFrom(that.crontimetable_);
            }
            if ((that_t0 & 0x200) != 0) {
                this_t0 |= 0x200;
                this.description_ = that.description_;
            }
            if ((that_t0 & 0x400) != 0) {
                this_t0 |= 0x400;
                v = this.payload_;
                if (v == null) {
                    v = new MessageSet();
                    this.payload_ = v;
                }
                v.mergeFrom(that.payload_);
            }
            if (that.uninterpreted != null) {
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll((Multimap)that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        public boolean equalsIgnoreUninterpreted(TaskQueueAddRequest that) {
            return this.equals(that, true);
        }

        public boolean equals(TaskQueueAddRequest that) {
            return this.equals(that, false);
        }

        public boolean equals(TaskQueueAddRequest that, boolean ignoreUninterpreted) {
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (this_t0 != that_t0) {
                return false;
            }
            if ((this_t0 & 1) != 0 && !Arrays.equals(this.queue_name_, that.queue_name_)) {
                return false;
            }
            if ((this_t0 & 2) != 0 && !Arrays.equals(this.task_name_, that.task_name_)) {
                return false;
            }
            if ((this_t0 & 4) != 0 && this.eta_usec_ != that.eta_usec_) {
                return false;
            }
            if ((this_t0 & 8) != 0 && this.method_ != that.method_) {
                return false;
            }
            if ((this_t0 & 0x10) != 0 && !Arrays.equals(this.url_, that.url_)) {
                return false;
            }
            int n = this.header_ != null ? this.header_.size() : 0;
            if (n != (that.header_ != null ? that.header_.size() : 0)) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (this.header_.get(i).equals(that.header_.get(i), ignoreUninterpreted)) continue;
                return false;
            }
            if ((this_t0 & 0x20) != 0 && !Arrays.equals(this.body_, that.body_)) {
                return false;
            }
            if ((this_t0 & 0x40) != 0 && !this.transaction_.equals(that.transaction_, ignoreUninterpreted)) {
                return false;
            }
            if ((this_t0 & 0x80) != 0 && !Arrays.equals(this.app_id_, that.app_id_)) {
                return false;
            }
            if ((this_t0 & 0x100) != 0 && !this.crontimetable_.equals(that.crontimetable_, ignoreUninterpreted)) {
                return false;
            }
            if ((this_t0 & 0x200) != 0 && !Arrays.equals(this.description_, that.description_)) {
                return false;
            }
            if ((this_t0 & 0x400) != 0 && !this.payload_.equals(that.payload_, ignoreUninterpreted)) {
                return false;
            }
            return ignoreUninterpreted || UninterpretedTags.equivalent((UninterpretedTags)this.uninterpreted, (UninterpretedTags)that.uninterpreted);
        }

        public boolean equals(Object that) {
            return that instanceof TaskQueueAddRequest && this.equals((TaskQueueAddRequest)((Object)that));
        }

        public int hashCode() {
            int n;
            int hash = -1788216961;
            int this_t0 = this.optional_0_;
            hash = hash * 31 + ((this_t0 & 1) != 0 ? Arrays.hashCode(this.queue_name_) : -113);
            hash = hash * 31 + ((this_t0 & 2) != 0 ? Arrays.hashCode(this.task_name_) : -113);
            hash = hash * 31 + ((this_t0 & 4) != 0 ? ProtocolSupport.hashCode((long)this.eta_usec_) : -113);
            hash = hash * 31 + ((this_t0 & 0x10) != 0 ? Arrays.hashCode(this.url_) : -113);
            hash = hash * 31 + ((this_t0 & 8) != 0 ? this.method_ : -113);
            hash *= 31;
            int n2 = n = this.header_ != null ? this.header_.size() : 0;
            for (int i = 0; i < n; ++i) {
                hash = hash * 31 + this.header_.get(i).hashCode();
            }
            hash = hash * 31 + ((this_t0 & 0x20) != 0 ? Arrays.hashCode(this.body_) : -113);
            hash = hash * 31 + ((this_t0 & 0x40) != 0 ? this.transaction_.hashCode() : -113);
            hash = hash * 31 + ((this_t0 & 0x80) != 0 ? Arrays.hashCode(this.app_id_) : -113);
            hash = hash * 31 + ((this_t0 & 0x100) != 0 ? this.crontimetable_.hashCode() : -113);
            hash = hash * 31 + ((this_t0 & 0x200) != 0 ? Arrays.hashCode(this.description_) : -113);
            hash = hash * 31 + ((this_t0 & 0x400) != 0 ? this.payload_.hashCode() : -113);
            if (this.uninterpreted != null && !this.uninterpreted.isEmpty()) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        public boolean isInitialized() {
            int this_t0 = this.optional_0_;
            if ((this_t0 & 7) != 7) {
                if ((this_t0 & 1) == 0) {
                    return false;
                }
                if ((this_t0 & 2) == 0) {
                    return false;
                }
                return false;
            }
            if (this.header_ != null) {
                for (Header v : this.header_) {
                    if (v.isInitialized()) continue;
                    return false;
                }
            }
            if ((this_t0 & 0x40) != 0 && !this.transaction_.isInitialized()) {
                return false;
            }
            if ((this_t0 & 0x100) != 0 && !this.crontimetable_.isInitialized()) {
                return false;
            }
            return (this_t0 & 0x400) == 0 || this.payload_.isInitialized();
        }

        public int encodingSize() {
            int n = 3 + Protocol.stringSize((int)this.queue_name_.length) + Protocol.stringSize((int)this.task_name_.length) + Protocol.varLongSize((long)this.eta_usec_);
            int m = this.header_ != null ? this.header_.size() : 0;
            n += m;
            for (int i = 0; i < m; ++i) {
                n += this.header_.get(i).encodingSize();
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 0x7F8) != 0) {
                if ((this_t0 & 8) != 0) {
                    n += 1 + Protocol.varLongSize((long)this.method_);
                }
                if ((this_t0 & 0x10) != 0) {
                    n += 1 + Protocol.stringSize((int)this.url_.length);
                }
                if ((this_t0 & 0x20) != 0) {
                    n += 1 + Protocol.stringSize((int)this.body_.length);
                }
                if ((this_t0 & 0x40) != 0) {
                    n += 1 + Protocol.stringSize((int)this.transaction_.encodingSize());
                }
                if ((this_t0 & 0x80) != 0) {
                    n += 1 + Protocol.stringSize((int)this.app_id_.length);
                }
                if ((this_t0 & 0x100) != 0) {
                    n += 1 + this.crontimetable_.encodingSize();
                }
                if ((this_t0 & 0x200) != 0) {
                    n += 1 + Protocol.stringSize((int)this.description_.length);
                }
                if ((this_t0 & 0x400) != 0) {
                    n += 2 + Protocol.stringSize((int)this.payload_.encodingSize());
                }
            }
            return this.uninterpreted != null ? n + this.uninterpreted.encodingSize() : n;
        }

        public int maxEncodingSize() {
            int n = 34 + this.queue_name_.length + this.task_name_.length;
            int m = this.header_ != null ? this.header_.size() : 0;
            n += m;
            for (int i = 0; i < m; ++i) {
                n += this.header_.get(i).maxEncodingSize();
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 0x7F0) != 0) {
                if ((this_t0 & 0x10) != 0) {
                    n += 6 + this.url_.length;
                }
                if ((this_t0 & 0x20) != 0) {
                    n += 6 + this.body_.length;
                }
                if ((this_t0 & 0x40) != 0) {
                    n += 6 + this.transaction_.maxEncodingSize();
                }
                if ((this_t0 & 0x80) != 0) {
                    n += 6 + this.app_id_.length;
                }
                if ((this_t0 & 0x100) != 0) {
                    n += 1 + this.crontimetable_.maxEncodingSize();
                }
                if ((this_t0 & 0x200) != 0) {
                    n += 6 + this.description_.length;
                }
                if ((this_t0 & 0x400) != 0) {
                    n += 7 + this.payload_.maxEncodingSize();
                }
            }
            return this.uninterpreted != null ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        public void clear() {
            this.optional_0_ = 0;
            this.queue_name_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.task_name_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.eta_usec_ = 0L;
            this.method_ = 2;
            this.url_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            if (this.header_ != null) {
                this.header_.clear();
            }
            this.body_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            if (this.transaction_ != null) {
                this.transaction_.clear();
            }
            this.app_id_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            if (this.crontimetable_ != null) {
                this.crontimetable_.clear();
            }
            this.description_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            if (this.payload_ != null) {
                this.payload_.clear();
            }
            this.uninterpreted = null;
        }

        public TaskQueueAddRequest newInstance() {
            return new TaskQueueAddRequest();
        }

        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        public void outputTo(ProtocolSink sink) {
            int m;
            sink.putByte((byte)10);
            sink.putPrefixedData(this.queue_name_);
            sink.putByte((byte)18);
            sink.putPrefixedData(this.task_name_);
            sink.putByte((byte)24);
            sink.putVarLong(this.eta_usec_);
            int this_t0 = this.optional_0_;
            if ((this_t0 & 0x10) != 0) {
                sink.putByte((byte)34);
                sink.putPrefixedData(this.url_);
            }
            if ((this_t0 & 8) != 0) {
                sink.putByte((byte)40);
                sink.putVarLong(this.method_);
            }
            int n = m = this.header_ != null ? this.header_.size() : 0;
            for (int i = 0; i < m; ++i) {
                Header v = this.header_.get(i);
                sink.putByte((byte)51);
                v.outputTo(sink);
            }
            if ((this_t0 & 0x20) != 0) {
                sink.putByte((byte)74);
                sink.putPrefixedData(this.body_);
            }
            if ((this_t0 & 0x40) != 0) {
                sink.putByte((byte)82);
                sink.putForeign((ProtocolMessage)this.transaction_);
            }
            if ((this_t0 & 0x80) != 0) {
                sink.putByte((byte)90);
                sink.putPrefixedData(this.app_id_);
            }
            if ((this_t0 & 0x100) != 0) {
                sink.putByte((byte)99);
                this.crontimetable_.outputTo(sink);
            }
            if ((this_t0 & 0x200) != 0) {
                sink.putByte((byte)122);
                sink.putPrefixedData(this.description_);
            }
            if ((this_t0 & 0x400) != 0) {
                sink.putByte((byte)-126);
                sink.putByte((byte)1);
                sink.putForeign((ProtocolMessage)this.payload_);
            }
            if (this.uninterpreted != null) {
                this.uninterpreted.put(sink);
            }
        }

        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block15: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block15;
                    }
                    case 10: {
                        this.queue_name_ = source.getPrefixedData();
                        this_t0 |= 1;
                        continue block15;
                    }
                    case 18: {
                        this.task_name_ = source.getPrefixedData();
                        this_t0 |= 2;
                        continue block15;
                    }
                    case 24: {
                        this.eta_usec_ = source.getVarLong();
                        this_t0 |= 4;
                        continue block15;
                    }
                    case 34: {
                        this.url_ = source.getPrefixedData();
                        this_t0 |= 0x10;
                        continue block15;
                    }
                    case 40: {
                        this.method_ = source.getVarInt();
                        this_t0 |= 8;
                        continue block15;
                    }
                    case 51: {
                        if (this.addHeader().merge(source)) continue block15;
                        result = false;
                        break block15;
                    }
                    case 74: {
                        this.body_ = source.getPrefixedData();
                        this_t0 |= 0x20;
                        continue block15;
                    }
                    case 82: {
                        source.push(source.getVarInt());
                        Transaction v10 = this.transaction_;
                        if (v10 == null) {
                            this.transaction_ = v10 = new Transaction();
                        }
                        if (!v10.merge(source)) {
                            result = false;
                            break block15;
                        }
                        source.pop();
                        this_t0 |= 0x40;
                        continue block15;
                    }
                    case 90: {
                        this.app_id_ = source.getPrefixedData();
                        this_t0 |= 0x80;
                        continue block15;
                    }
                    case 99: {
                        CronTimetable v12 = this.crontimetable_;
                        if (v12 == null) {
                            this.crontimetable_ = v12 = new CronTimetable();
                        }
                        if (!v12.merge(source)) {
                            result = false;
                            break block15;
                        }
                        this_t0 |= 0x100;
                        continue block15;
                    }
                    case 122: {
                        this.description_ = source.getPrefixedData();
                        this_t0 |= 0x200;
                        continue block15;
                    }
                    case 130: {
                        source.push(source.getVarInt());
                        MessageSet v16 = this.payload_;
                        if (v16 == null) {
                            this.payload_ = v16 = new MessageSet();
                        }
                        if (!v16.merge(source)) {
                            result = false;
                            break block15;
                        }
                        source.pop();
                        this_t0 |= 0x400;
                        continue block15;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put((Object)tt, (Object)source.getUninterpreted(tt));
                        continue block15;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        public TaskQueueAddRequest getDefaultInstanceForType() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public static final TaskQueueAddRequest getDefaultInstance() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public TaskQueueAddRequest freeze() {
            this.queue_name_ = ProtocolSupport.freezeString((byte[])this.queue_name_);
            this.task_name_ = ProtocolSupport.freezeString((byte[])this.task_name_);
            this.url_ = ProtocolSupport.freezeString((byte[])this.url_);
            this.header_ = ProtocolSupport.freezeMessages(this.header_);
            this.body_ = ProtocolSupport.freezeString((byte[])this.body_);
            if (this.transaction_ != null) {
                this.transaction_.freeze();
            }
            this.app_id_ = ProtocolSupport.freezeString((byte[])this.app_id_);
            if (this.crontimetable_ != null) {
                this.crontimetable_.freeze();
            }
            this.description_ = ProtocolSupport.freezeString((byte[])this.description_);
            if (this.payload_ != null) {
                this.payload_.freeze();
            }
            return this;
        }

        public TaskQueueAddRequest unfreeze() {
            this.header_ = ProtocolSupport.unfreezeMessages(this.header_);
            if (this.transaction_ != null) {
                this.transaction_.unfreeze();
            }
            if (this.crontimetable_ != null) {
                this.crontimetable_.unfreeze();
            }
            if (this.payload_ != null) {
                this.payload_.unfreeze();
            }
            return this;
        }

        public boolean isFrozen() {
            return ProtocolSupport.isFrozenMessages(this.header_) || this.transaction_ != null && this.transaction_.isFrozen() || this.crontimetable_ != null && this.crontimetable_.isFrozen() || this.payload_ != null && this.payload_.isFrozen();
        }

        static {
            TaskQueueAddRequest.text[0] = "ErrorCode";
            TaskQueueAddRequest.text[1] = "queue_name";
            TaskQueueAddRequest.text[2] = "task_name";
            TaskQueueAddRequest.text[3] = "eta_usec";
            TaskQueueAddRequest.text[4] = "url";
            TaskQueueAddRequest.text[5] = "method";
            TaskQueueAddRequest.text[6] = "Header";
            TaskQueueAddRequest.text[7] = "key";
            TaskQueueAddRequest.text[8] = "value";
            TaskQueueAddRequest.text[9] = "body";
            TaskQueueAddRequest.text[10] = "transaction";
            TaskQueueAddRequest.text[11] = "app_id";
            TaskQueueAddRequest.text[12] = "CronTimetable";
            TaskQueueAddRequest.text[13] = "schedule";
            TaskQueueAddRequest.text[14] = "timezone";
            TaskQueueAddRequest.text[15] = "description";
            TaskQueueAddRequest.text[16] = "payload";
            types = new int[17];
            Arrays.fill(types, 6);
            TaskQueueAddRequest.types[0] = 0;
            TaskQueueAddRequest.types[1] = 2;
            TaskQueueAddRequest.types[2] = 2;
            TaskQueueAddRequest.types[3] = 0;
            TaskQueueAddRequest.types[4] = 2;
            TaskQueueAddRequest.types[5] = 0;
            TaskQueueAddRequest.types[6] = 3;
            TaskQueueAddRequest.types[7] = 2;
            TaskQueueAddRequest.types[8] = 2;
            TaskQueueAddRequest.types[9] = 2;
            TaskQueueAddRequest.types[10] = 2;
            TaskQueueAddRequest.types[11] = 2;
            TaskQueueAddRequest.types[12] = 3;
            TaskQueueAddRequest.types[13] = 2;
            TaskQueueAddRequest.types[14] = 2;
            TaskQueueAddRequest.types[15] = 2;
            TaskQueueAddRequest.types[16] = 2;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(TaskQueueAddRequest.class, "Z0apphosting/api/taskqueue/taskqueue_service.proto\n\u001eapphosting.TaskQueueAddRequest\u0013\u001a\nqueue_name \u0001(\u00020\t8\u0002\u0014\u0013\u001a\ttask_name \u0002(\u00020\t8\u0002\u0014\u0013\u001a\beta_usec \u0003(\u00000\u00038\u0002\u0014\u0013\u001a\u0006method \u0005(\u00000\u00058\u0001B\u00012h\u0000\u00a3\u0001\u00aa\u0001\u0007default\u00b2\u0001\u0004POST\u00a4\u0001\u0014\u0013\u001a\u0003url \u0004(\u00020\t8\u0001\u0014\u0013\u001a\u0006Header \u0006(\u00030\n8\u0003\u0014\u0013\u001a\nHeader.key \u0007(\u00020\t8\u0002`\u0005\u0014\u0013\u001a\fHeader.value \b(\u00020\t8\u0002`\u0005\u0014\u0013\u001a\u0004body \t(\u00020\t8\u0001\u00a3\u0001\u00aa\u0001\u0005ctype\u00b2\u0001\u0004Cord\u00a4\u0001\u0014\u0013\u001a\u000btransaction \n(\u00020\u000b8\u0001J.apphosting.apphosting_datastore_v3.Transaction\u0014\u0013\u001a\u0006app_id \u000b(\u00020\t8\u0001\u0014\u0013\u001a\rCronTimetable \f(\u00030\n8\u0001\u0014\u0013\u001a\u0016CronTimetable.schedule \r(\u00020\t8\u0002`\u000b\u0014\u0013\u001a\u0016CronTimetable.timezone \u000e(\u00020\t8\u0002`\u000b\u0014\u0013\u001a\u000bdescription \u000f(\u00020\t8\u0001\u0014\u0013\u001a\u0007payload \u0010(\u00020\u000b8\u0001J\nMessageSet\u0014sz\rRequestMethod\u008b\u0001\u0092\u0001\u0003GET\u0098\u0001\u0001\u008c\u0001\u008b\u0001\u0092\u0001\u0004POST\u0098\u0001\u0002\u008c\u0001\u008b\u0001\u0092\u0001\u0004HEAD\u0098\u0001\u0003\u008c\u0001\u008b\u0001\u0092\u0001\u0003PUT\u0098\u0001\u0004\u008c\u0001\u008b\u0001\u0092\u0001\u0006DELETE\u0098\u0001\u0005\u008c\u0001t", new ProtocolType.FieldType[]{new ProtocolType.FieldType("queue_name", "queue_name", 1, 0, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("task_name", "task_name", 2, 1, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("eta_usec", "eta_usec", 3, 2, ProtocolType.FieldBaseType.INT64, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("method", "method", 5, 3, ProtocolType.Presence.OPTIONAL, RequestMethod.class), new ProtocolType.FieldType("url", "url", 4, 4, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("Header", "header", 6, -1, ProtocolType.FieldBaseType.GROUP, ProtocolType.Presence.REPEATED, Header.class), new ProtocolType.FieldType("body", "body", 9, 5, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("transaction", "transaction", 10, 6, ProtocolType.FieldBaseType.FOREIGN, ProtocolType.Presence.OPTIONAL, Transaction.class), new ProtocolType.FieldType("app_id", "app_id", 11, 7, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("CronTimetable", "crontimetable", 12, 8, ProtocolType.FieldBaseType.GROUP, ProtocolType.Presence.OPTIONAL, CronTimetable.class), new ProtocolType.FieldType("description", "description", 15, 9, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("payload", "payload", 16, 10, ProtocolType.FieldBaseType.FOREIGN, ProtocolType.Presence.OPTIONAL, MessageSet.class)});

            private StaticHolder() {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum RequestMethod implements ProtocolMessageEnum
        {
            GET(1),
            POST(2),
            HEAD(3),
            PUT(4),
            DELETE(5);

            public static final RequestMethod RequestMethod_MIN;
            public static final RequestMethod RequestMethod_MAX;
            private final int value;

            public int getValue() {
                return this.value;
            }

            public static RequestMethod valueOf(int value) {
                switch (value) {
                    case 1: {
                        return GET;
                    }
                    case 2: {
                        return POST;
                    }
                    case 3: {
                        return HEAD;
                    }
                    case 4: {
                        return PUT;
                    }
                    case 5: {
                        return DELETE;
                    }
                }
                return null;
            }

            private RequestMethod(int v) {
                this.value = v;
            }

            static {
                RequestMethod_MIN = GET;
                RequestMethod_MAX = DELETE;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class CronTimetable
        extends ProtocolMessage<CronTimetable> {
            private static final long serialVersionUID = 1L;
            private byte[] schedule_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            private byte[] timezone_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            private UninterpretedTags uninterpreted;
            private int optional_0_;
            public static final CronTimetable IMMUTABLE_DEFAULT_INSTANCE = new CronTimetable(){
                private static final long serialVersionUID = 1L;

                public CronTimetable clearSchedule() {
                    return this;
                }

                public CronTimetable setScheduleAsBytes(byte[] x) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public CronTimetable setSchedule(String v) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public CronTimetable setSchedule(String v, Charset cs) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public CronTimetable clearTimezone() {
                    return this;
                }

                public CronTimetable setTimezoneAsBytes(byte[] x) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public CronTimetable setTimezone(String v) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public CronTimetable setTimezone(String v, Charset cs) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public CronTimetable mergeFrom(CronTimetable that) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public boolean merge(ProtocolSource source) {
                    ProtocolSupport.unsupportedOperation();
                    return false;
                }

                public CronTimetable freeze() {
                    return this;
                }

                public CronTimetable unfreeze() {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public boolean isFrozen() {
                    return true;
                }
            };

            public final byte[] getScheduleAsBytes() {
                return this.schedule_;
            }

            public final boolean hasSchedule() {
                return (this.optional_0_ & 1) != 0;
            }

            public CronTimetable clearSchedule() {
                this.optional_0_ &= 0xFFFFFFFE;
                this.schedule_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
                return this;
            }

            public CronTimetable setScheduleAsBytes(byte[] x) {
                this.optional_0_ |= 1;
                this.schedule_ = x;
                return this;
            }

            public final String getSchedule() {
                return ProtocolSupport.toStringUtf8((byte[])this.schedule_);
            }

            public CronTimetable setSchedule(String v) {
                if (v == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 1;
                this.schedule_ = ProtocolSupport.toBytesUtf8((String)v);
                return this;
            }

            public final String getSchedule(Charset cs) {
                return ProtocolSupport.toString((byte[])this.schedule_, (Charset)cs);
            }

            public CronTimetable setSchedule(String v, Charset cs) {
                if (v == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 1;
                this.schedule_ = ProtocolSupport.toBytes((String)v, (Charset)cs);
                return this;
            }

            public final byte[] getTimezoneAsBytes() {
                return this.timezone_;
            }

            public final boolean hasTimezone() {
                return (this.optional_0_ & 2) != 0;
            }

            public CronTimetable clearTimezone() {
                this.optional_0_ &= 0xFFFFFFFD;
                this.timezone_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
                return this;
            }

            public CronTimetable setTimezoneAsBytes(byte[] x) {
                this.optional_0_ |= 2;
                this.timezone_ = x;
                return this;
            }

            public final String getTimezone() {
                return ProtocolSupport.toStringUtf8((byte[])this.timezone_);
            }

            public CronTimetable setTimezone(String v) {
                if (v == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 2;
                this.timezone_ = ProtocolSupport.toBytesUtf8((String)v);
                return this;
            }

            public final String getTimezone(Charset cs) {
                return ProtocolSupport.toString((byte[])this.timezone_, (Charset)cs);
            }

            public CronTimetable setTimezone(String v, Charset cs) {
                if (v == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 2;
                this.timezone_ = ProtocolSupport.toBytes((String)v, (Charset)cs);
                return this;
            }

            public CronTimetable mergeFrom(CronTimetable that) {
                assert (that != this);
                int this_t0 = this.optional_0_;
                int that_t0 = that.optional_0_;
                if ((that_t0 & 1) != 0) {
                    this_t0 |= 1;
                    this.schedule_ = that.schedule_;
                }
                if ((that_t0 & 2) != 0) {
                    this_t0 |= 2;
                    this.timezone_ = that.timezone_;
                }
                if (that.uninterpreted != null) {
                    if (this.uninterpreted == null) {
                        this.uninterpreted = new UninterpretedTags();
                    }
                    this.uninterpreted.putAll((Multimap)that.uninterpreted);
                }
                this.optional_0_ = this_t0;
                return this;
            }

            public boolean equalsIgnoreUninterpreted(CronTimetable that) {
                return this.equals(that, true);
            }

            public boolean equals(CronTimetable that) {
                return this.equals(that, false);
            }

            public boolean equals(CronTimetable that, boolean ignoreUninterpreted) {
                if (that == null) {
                    return false;
                }
                if (that == this) {
                    return true;
                }
                int this_t0 = this.optional_0_;
                int that_t0 = that.optional_0_;
                if (this_t0 != that_t0) {
                    return false;
                }
                if ((this_t0 & 1) != 0 && !Arrays.equals(this.schedule_, that.schedule_)) {
                    return false;
                }
                if ((this_t0 & 2) != 0 && !Arrays.equals(this.timezone_, that.timezone_)) {
                    return false;
                }
                return ignoreUninterpreted || UninterpretedTags.equivalent((UninterpretedTags)this.uninterpreted, (UninterpretedTags)that.uninterpreted);
            }

            public boolean equals(Object that) {
                return that instanceof CronTimetable && this.equals((CronTimetable)((Object)that));
            }

            public int hashCode() {
                int hash = -115555888;
                int this_t0 = this.optional_0_;
                hash = hash * 31 + ((this_t0 & 1) != 0 ? Arrays.hashCode(this.schedule_) : -113);
                hash = hash * 31 + ((this_t0 & 2) != 0 ? Arrays.hashCode(this.timezone_) : -113);
                if (this.uninterpreted != null && !this.uninterpreted.isEmpty()) {
                    hash = hash * 31 + this.uninterpreted.hashCode();
                }
                return hash;
            }

            public boolean isInitialized() {
                int this_t0 = this.optional_0_;
                if ((this_t0 & 3) != 3) {
                    if ((this_t0 & 1) == 0) {
                        return false;
                    }
                    return false;
                }
                return true;
            }

            public int encodingSize() {
                int n = 3 + Protocol.stringSize((int)this.schedule_.length) + Protocol.stringSize((int)this.timezone_.length);
                return this.uninterpreted != null ? n + this.uninterpreted.encodingSize() : n;
            }

            public int maxEncodingSize() {
                int n = 13 + this.schedule_.length + this.timezone_.length;
                return this.uninterpreted != null ? n + this.uninterpreted.maxEncodingSize() : n;
            }

            public MessageAppender getMessageAppender() {
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                return this.uninterpreted;
            }

            public void clear() {
                this.optional_0_ = 0;
                this.schedule_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
                this.timezone_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
                this.uninterpreted = null;
            }

            public CronTimetable newInstance() {
                return new CronTimetable();
            }

            public ProtocolType getProtocolType() {
                return StaticHolder.protocolType;
            }

            public void outputTo(ProtocolSink sink) {
                sink.putByte((byte)106);
                sink.putPrefixedData(this.schedule_);
                sink.putByte((byte)114);
                sink.putPrefixedData(this.timezone_);
                if (this.uninterpreted != null) {
                    this.uninterpreted.put(sink);
                }
                sink.putByte((byte)100);
            }

            public boolean merge(ProtocolSource source) {
                boolean result = true;
                int this_t0 = this.optional_0_;
                block6: while (true) {
                    int tt = source.getVarInt();
                    switch (tt) {
                        case 100: {
                            break block6;
                        }
                        case 0: {
                            result = false;
                            break block6;
                        }
                        case 106: {
                            this.schedule_ = source.getPrefixedData();
                            this_t0 |= 1;
                            continue block6;
                        }
                        case 114: {
                            this.timezone_ = source.getPrefixedData();
                            this_t0 |= 2;
                            continue block6;
                        }
                        default: {
                            if (this.uninterpreted == null) {
                                this.uninterpreted = new UninterpretedTags();
                            }
                            this.uninterpreted.put((Object)tt, (Object)source.getUninterpreted(tt));
                            continue block6;
                        }
                    }
                    break;
                }
                this.optional_0_ = this_t0;
                return result;
            }

            public CronTimetable getDefaultInstanceForType() {
                return IMMUTABLE_DEFAULT_INSTANCE;
            }

            public static final CronTimetable getDefaultInstance() {
                return IMMUTABLE_DEFAULT_INSTANCE;
            }

            public CronTimetable freeze() {
                this.schedule_ = ProtocolSupport.freezeString((byte[])this.schedule_);
                this.timezone_ = ProtocolSupport.freezeString((byte[])this.timezone_);
                return this;
            }

            private static class StaticHolder {
                private static final ProtocolType protocolType = new ProtocolType(CronTimetable.class, null, new ProtocolType.FieldType[]{new ProtocolType.FieldType("schedule", "schedule", 13, 0, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("timezone", "timezone", 14, 1, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED)});

                private StaticHolder() {
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Header
        extends ProtocolMessage<Header> {
            private static final long serialVersionUID = 1L;
            private byte[] key_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            private byte[] value_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            private UninterpretedTags uninterpreted;
            private int optional_0_;
            public static final Header IMMUTABLE_DEFAULT_INSTANCE = new Header(){
                private static final long serialVersionUID = 1L;

                public Header clearKey() {
                    return this;
                }

                public Header setKeyAsBytes(byte[] x) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Header setKey(String v) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Header setKey(String v, Charset cs) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Header clearValue() {
                    return this;
                }

                public Header setValueAsBytes(byte[] x) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Header setValue(String v) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Header setValue(String v, Charset cs) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Header mergeFrom(Header that) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public boolean merge(ProtocolSource source) {
                    ProtocolSupport.unsupportedOperation();
                    return false;
                }

                public Header freeze() {
                    return this;
                }

                public Header unfreeze() {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public boolean isFrozen() {
                    return true;
                }
            };

            public final byte[] getKeyAsBytes() {
                return this.key_;
            }

            public final boolean hasKey() {
                return (this.optional_0_ & 1) != 0;
            }

            public Header clearKey() {
                this.optional_0_ &= 0xFFFFFFFE;
                this.key_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
                return this;
            }

            public Header setKeyAsBytes(byte[] x) {
                this.optional_0_ |= 1;
                this.key_ = x;
                return this;
            }

            public final String getKey() {
                return ProtocolSupport.toStringUtf8((byte[])this.key_);
            }

            public Header setKey(String v) {
                if (v == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 1;
                this.key_ = ProtocolSupport.toBytesUtf8((String)v);
                return this;
            }

            public final String getKey(Charset cs) {
                return ProtocolSupport.toString((byte[])this.key_, (Charset)cs);
            }

            public Header setKey(String v, Charset cs) {
                if (v == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 1;
                this.key_ = ProtocolSupport.toBytes((String)v, (Charset)cs);
                return this;
            }

            public final byte[] getValueAsBytes() {
                return this.value_;
            }

            public final boolean hasValue() {
                return (this.optional_0_ & 2) != 0;
            }

            public Header clearValue() {
                this.optional_0_ &= 0xFFFFFFFD;
                this.value_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
                return this;
            }

            public Header setValueAsBytes(byte[] x) {
                this.optional_0_ |= 2;
                this.value_ = x;
                return this;
            }

            public final String getValue() {
                return ProtocolSupport.toStringUtf8((byte[])this.value_);
            }

            public Header setValue(String v) {
                if (v == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 2;
                this.value_ = ProtocolSupport.toBytesUtf8((String)v);
                return this;
            }

            public final String getValue(Charset cs) {
                return ProtocolSupport.toString((byte[])this.value_, (Charset)cs);
            }

            public Header setValue(String v, Charset cs) {
                if (v == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 2;
                this.value_ = ProtocolSupport.toBytes((String)v, (Charset)cs);
                return this;
            }

            public Header mergeFrom(Header that) {
                assert (that != this);
                int this_t0 = this.optional_0_;
                int that_t0 = that.optional_0_;
                if ((that_t0 & 1) != 0) {
                    this_t0 |= 1;
                    this.key_ = that.key_;
                }
                if ((that_t0 & 2) != 0) {
                    this_t0 |= 2;
                    this.value_ = that.value_;
                }
                if (that.uninterpreted != null) {
                    if (this.uninterpreted == null) {
                        this.uninterpreted = new UninterpretedTags();
                    }
                    this.uninterpreted.putAll((Multimap)that.uninterpreted);
                }
                this.optional_0_ = this_t0;
                return this;
            }

            public boolean equalsIgnoreUninterpreted(Header that) {
                return this.equals(that, true);
            }

            public boolean equals(Header that) {
                return this.equals(that, false);
            }

            public boolean equals(Header that, boolean ignoreUninterpreted) {
                if (that == null) {
                    return false;
                }
                if (that == this) {
                    return true;
                }
                int this_t0 = this.optional_0_;
                int that_t0 = that.optional_0_;
                if (this_t0 != that_t0) {
                    return false;
                }
                if ((this_t0 & 1) != 0 && !Arrays.equals(this.key_, that.key_)) {
                    return false;
                }
                if ((this_t0 & 2) != 0 && !Arrays.equals(this.value_, that.value_)) {
                    return false;
                }
                return ignoreUninterpreted || UninterpretedTags.equivalent((UninterpretedTags)this.uninterpreted, (UninterpretedTags)that.uninterpreted);
            }

            public boolean equals(Object that) {
                return that instanceof Header && this.equals((Header)((Object)that));
            }

            public int hashCode() {
                int hash = -1829050250;
                int this_t0 = this.optional_0_;
                hash = hash * 31 + ((this_t0 & 1) != 0 ? Arrays.hashCode(this.key_) : -113);
                hash = hash * 31 + ((this_t0 & 2) != 0 ? Arrays.hashCode(this.value_) : -113);
                if (this.uninterpreted != null && !this.uninterpreted.isEmpty()) {
                    hash = hash * 31 + this.uninterpreted.hashCode();
                }
                return hash;
            }

            public boolean isInitialized() {
                int this_t0 = this.optional_0_;
                if ((this_t0 & 3) != 3) {
                    if ((this_t0 & 1) == 0) {
                        return false;
                    }
                    return false;
                }
                return true;
            }

            public int encodingSize() {
                int n = 3 + Protocol.stringSize((int)this.key_.length) + Protocol.stringSize((int)this.value_.length);
                return this.uninterpreted != null ? n + this.uninterpreted.encodingSize() : n;
            }

            public int maxEncodingSize() {
                int n = 13 + this.key_.length + this.value_.length;
                return this.uninterpreted != null ? n + this.uninterpreted.maxEncodingSize() : n;
            }

            public MessageAppender getMessageAppender() {
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                return this.uninterpreted;
            }

            public void clear() {
                this.optional_0_ = 0;
                this.key_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
                this.value_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
                this.uninterpreted = null;
            }

            public Header newInstance() {
                return new Header();
            }

            public ProtocolType getProtocolType() {
                return StaticHolder.protocolType;
            }

            public void outputTo(ProtocolSink sink) {
                sink.putByte((byte)58);
                sink.putPrefixedData(this.key_);
                sink.putByte((byte)66);
                sink.putPrefixedData(this.value_);
                if (this.uninterpreted != null) {
                    this.uninterpreted.put(sink);
                }
                sink.putByte((byte)52);
            }

            public boolean merge(ProtocolSource source) {
                boolean result = true;
                int this_t0 = this.optional_0_;
                block6: while (true) {
                    int tt = source.getVarInt();
                    switch (tt) {
                        case 52: {
                            break block6;
                        }
                        case 0: {
                            result = false;
                            break block6;
                        }
                        case 58: {
                            this.key_ = source.getPrefixedData();
                            this_t0 |= 1;
                            continue block6;
                        }
                        case 66: {
                            this.value_ = source.getPrefixedData();
                            this_t0 |= 2;
                            continue block6;
                        }
                        default: {
                            if (this.uninterpreted == null) {
                                this.uninterpreted = new UninterpretedTags();
                            }
                            this.uninterpreted.put((Object)tt, (Object)source.getUninterpreted(tt));
                            continue block6;
                        }
                    }
                    break;
                }
                this.optional_0_ = this_t0;
                return result;
            }

            public Header getDefaultInstanceForType() {
                return IMMUTABLE_DEFAULT_INSTANCE;
            }

            public static final Header getDefaultInstance() {
                return IMMUTABLE_DEFAULT_INSTANCE;
            }

            public Header freeze() {
                this.key_ = ProtocolSupport.freezeString((byte[])this.key_);
                this.value_ = ProtocolSupport.freezeString((byte[])this.value_);
                return this;
            }

            private static class StaticHolder {
                private static final ProtocolType protocolType = new ProtocolType(Header.class, null, new ProtocolType.FieldType[]{new ProtocolType.FieldType("key", "key", 7, 0, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("value", "value", 8, 1, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED)});

                private StaticHolder() {
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TaskQueueServiceError
    extends ProtocolMessage<TaskQueueServiceError> {
        private static final long serialVersionUID = 1L;
        private UninterpretedTags uninterpreted;
        public static final TaskQueueServiceError IMMUTABLE_DEFAULT_INSTANCE = new TaskQueueServiceError(){
            private static final long serialVersionUID = 1L;

            public TaskQueueServiceError mergeFrom(TaskQueueServiceError that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public TaskQueueServiceError freeze() {
                return this;
            }

            public TaskQueueServiceError unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final String[] text = new String[1];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public TaskQueueServiceError mergeFrom(TaskQueueServiceError that) {
            assert (that != this);
            if (that.uninterpreted != null) {
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll((Multimap)that.uninterpreted);
            }
            return this;
        }

        public boolean equalsIgnoreUninterpreted(TaskQueueServiceError that) {
            return this.equals(that, true);
        }

        public boolean equals(TaskQueueServiceError that) {
            return this.equals(that, false);
        }

        public boolean equals(TaskQueueServiceError that, boolean ignoreUninterpreted) {
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            return ignoreUninterpreted || UninterpretedTags.equivalent((UninterpretedTags)this.uninterpreted, (UninterpretedTags)that.uninterpreted);
        }

        public boolean equals(Object that) {
            return that instanceof TaskQueueServiceError && this.equals((TaskQueueServiceError)((Object)that));
        }

        public int hashCode() {
            int hash = -1198281591;
            if (this.uninterpreted != null && !this.uninterpreted.isEmpty()) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        public boolean isInitialized() {
            return true;
        }

        public int encodingSize() {
            int n = 0;
            return this.uninterpreted != null ? n + this.uninterpreted.encodingSize() : n;
        }

        public int maxEncodingSize() {
            int n = 0;
            return this.uninterpreted != null ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        public void clear() {
            this.uninterpreted = null;
        }

        public TaskQueueServiceError newInstance() {
            return new TaskQueueServiceError();
        }

        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        public void outputTo(ProtocolSink sink) {
            if (this.uninterpreted != null) {
                this.uninterpreted.put(sink);
            }
        }

        public boolean merge(ProtocolSource source) {
            boolean result = true;
            block3: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block3;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put((Object)tt, (Object)source.getUninterpreted(tt));
                        continue block3;
                    }
                }
            }
            return result;
        }

        public TaskQueueServiceError getDefaultInstanceForType() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public static final TaskQueueServiceError getDefaultInstance() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        static {
            TaskQueueServiceError.text[0] = "ErrorCode";
            types = new int[1];
            Arrays.fill(types, 6);
            TaskQueueServiceError.types[0] = 0;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(TaskQueueServiceError.class, "Z0apphosting/api/taskqueue/taskqueue_service.proto\n apphosting.TaskQueueServiceErrorsz\tErrorCode\u008b\u0001\u0092\u0001\u0002OK\u0098\u0001\u0000\u008c\u0001\u008b\u0001\u0092\u0001\rUNKNOWN_QUEUE\u0098\u0001\u0001\u008c\u0001\u008b\u0001\u0092\u0001\u000fTRANSIENT_ERROR\u0098\u0001\u0002\u008c\u0001\u008b\u0001\u0092\u0001\u000eINTERNAL_ERROR\u0098\u0001\u0003\u008c\u0001\u008b\u0001\u0092\u0001\u000eTASK_TOO_LARGE\u0098\u0001\u0004\u008c\u0001\u008b\u0001\u0092\u0001\u0011INVALID_TASK_NAME\u0098\u0001\u0005\u008c\u0001\u008b\u0001\u0092\u0001\u0012INVALID_QUEUE_NAME\u0098\u0001\u0006\u008c\u0001\u008b\u0001\u0092\u0001\u000bINVALID_URL\u0098\u0001\u0007\u008c\u0001\u008b\u0001\u0092\u0001\u0012INVALID_QUEUE_RATE\u0098\u0001\b\u008c\u0001\u008b\u0001\u0092\u0001\u0011PERMISSION_DENIED\u0098\u0001\t\u008c\u0001\u008b\u0001\u0092\u0001\u0013TASK_ALREADY_EXISTS\u0098\u0001\n\u008c\u0001\u008b\u0001\u0092\u0001\u000fTOMBSTONED_TASK\u0098\u0001\u000b\u008c\u0001\u008b\u0001\u0092\u0001\u000bINVALID_ETA\u0098\u0001\f\u008c\u0001\u008b\u0001\u0092\u0001\u000fINVALID_REQUEST\u0098\u0001\r\u008c\u0001\u008b\u0001\u0092\u0001\fUNKNOWN_TASK\u0098\u0001\u000e\u008c\u0001\u008b\u0001\u0092\u0001\u0010TOMBSTONED_QUEUE\u0098\u0001\u000f\u008c\u0001\u008b\u0001\u0092\u0001\u0013DUPLICATE_TASK_NAME\u0098\u0001\u0010\u008c\u0001\u008b\u0001\u0092\u0001\u0007SKIPPED\u0098\u0001\u0011\u008c\u0001\u008b\u0001\u0092\u0001\u000eTOO_MANY_TASKS\u0098\u0001\u0012\u008c\u0001\u008b\u0001\u0092\u0001\u000fINVALID_PAYLOAD\u0098\u0001\u0013\u008c\u0001\u008b\u0001\u0092\u0001\u000fDATASTORE_ERROR\u0098\u0001\u0090N\u008c\u0001t", new ProtocolType.FieldType[0]);

            private StaticHolder() {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ErrorCode implements ProtocolMessageEnum
        {
            OK(0),
            UNKNOWN_QUEUE(1),
            TRANSIENT_ERROR(2),
            INTERNAL_ERROR(3),
            TASK_TOO_LARGE(4),
            INVALID_TASK_NAME(5),
            INVALID_QUEUE_NAME(6),
            INVALID_URL(7),
            INVALID_QUEUE_RATE(8),
            PERMISSION_DENIED(9),
            TASK_ALREADY_EXISTS(10),
            TOMBSTONED_TASK(11),
            INVALID_ETA(12),
            INVALID_REQUEST(13),
            UNKNOWN_TASK(14),
            TOMBSTONED_QUEUE(15),
            DUPLICATE_TASK_NAME(16),
            SKIPPED(17),
            TOO_MANY_TASKS(18),
            INVALID_PAYLOAD(19),
            DATASTORE_ERROR(10000);

            public static final ErrorCode ErrorCode_MIN;
            public static final ErrorCode ErrorCode_MAX;
            private final int value;

            public int getValue() {
                return this.value;
            }

            public static ErrorCode valueOf(int value) {
                switch (value) {
                    case 0: {
                        return OK;
                    }
                    case 1: {
                        return UNKNOWN_QUEUE;
                    }
                    case 2: {
                        return TRANSIENT_ERROR;
                    }
                    case 3: {
                        return INTERNAL_ERROR;
                    }
                    case 4: {
                        return TASK_TOO_LARGE;
                    }
                    case 5: {
                        return INVALID_TASK_NAME;
                    }
                    case 6: {
                        return INVALID_QUEUE_NAME;
                    }
                    case 7: {
                        return INVALID_URL;
                    }
                    case 8: {
                        return INVALID_QUEUE_RATE;
                    }
                    case 9: {
                        return PERMISSION_DENIED;
                    }
                    case 10: {
                        return TASK_ALREADY_EXISTS;
                    }
                    case 11: {
                        return TOMBSTONED_TASK;
                    }
                    case 12: {
                        return INVALID_ETA;
                    }
                    case 13: {
                        return INVALID_REQUEST;
                    }
                    case 14: {
                        return UNKNOWN_TASK;
                    }
                    case 15: {
                        return TOMBSTONED_QUEUE;
                    }
                    case 16: {
                        return DUPLICATE_TASK_NAME;
                    }
                    case 17: {
                        return SKIPPED;
                    }
                    case 18: {
                        return TOO_MANY_TASKS;
                    }
                    case 19: {
                        return INVALID_PAYLOAD;
                    }
                    case 10000: {
                        return DATASTORE_ERROR;
                    }
                }
                return null;
            }

            private ErrorCode(int v) {
                this.value = v;
            }

            static {
                ErrorCode_MIN = OK;
                ErrorCode_MAX = DATASTORE_ERROR;
            }
        }
    }
}

