/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types;

import java.math.BigDecimal;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.types.ObjectStringConverter;

public class BigDecimalStringConverter
implements ObjectStringConverter {
    public Object toObject(String str) {
        if (str == null) {
            return null;
        }
        try {
            return new BigDecimal(str.trim());
        }
        catch (NumberFormatException nfe) {
            throw new NucleusDataStoreException(LOCALISER.msg("016002", (Object)str, (Object)BigDecimal.class.getName()), nfe);
        }
    }

    public String toString(Object obj) {
        String str = obj instanceof BigDecimal ? ((BigDecimal)obj).toString() : (String)obj;
        return str;
    }
}

