/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.jdbc;

import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.cloud.sql.jdbc.Connection;
import com.google.cloud.sql.jdbc.ResultSet;
import com.google.cloud.sql.jdbc.StreamingResultSet;
import com.google.cloud.sql.jdbc.internal.ConnectionOperationHelper;
import com.google.cloud.sql.jdbc.internal.DataTypeConverters;
import com.google.cloud.sql.jdbc.internal.Exceptions;
import com.google.cloud.sql.jdbc.internal.SimpleListResultSet;
import com.google.cloud.sql.jdbc.internal.SqlRpcOptions;
import com.google.cloud.sql.jdbc.internal.Url;
import com.google.cloud.sql.jdbc.internal.Util;
import com.google.cloud.sql.jdbc.internal.Wrapper;
import com.google.protos.cloud.sql.Client;
import com.google.protos.cloud.sql.ExecOpResponse;
import com.google.protos.cloud.sql.ExecResponse;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Statement
extends Wrapper
implements java.sql.Statement {
    protected static final int[] EMPTY_ROWS_UPDATED = new int[0];
    protected boolean open = true;
    protected boolean hasMoreResults;
    protected final SqlRpcOptions rpcOptions;
    protected final Map<Integer, Client.BindVariableProto> outParametersMap = Util.newTreeMap();
    protected final Map<String, Integer> parameterIndexMap = Util.newTreeMap();
    private final Connection conn;
    private final Url url;
    private ResultSet rs;
    private SQLWarning warnings;
    private long rowsUpdated = -1L;
    private List<Long> batchRowsUpdated = Collections.emptyList();
    private int queryTimeoutSeconds = 0;
    private List<BigDecimal> generatedKeys;
    private Long statementId;
    private List<String> batchSql;

    Statement(int resultSetType, int resultSetConcurrency, int resultSetHoldability, Connection conn, Url url) {
        this.conn = conn;
        this.url = url;
        this.rpcOptions = SqlRpcOptions.defaultOptions(url).setResultSetType(resultSetType).setResultSetConcurrency(resultSetConcurrency).setResultSetHoldability(resultSetHoldability).setIncludeExportedKeys(true);
        this.batchSql = Util.newArrayList();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.throwIfNotOpen();
        this.batchSql.add(sql);
    }

    @Override
    public void cancel() throws SQLException {
        this.throwIfNotOpen();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.throwIfNotOpen();
        this.batchSql.clear();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.throwIfNotOpen();
        this.warnings = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        try {
            if (this.statementId != null) {
                this.conn.executeOp(SqlRpcOptions.defaultOptions(this.url), ConnectionOperationHelper.closeStatement(this.statementId));
            }
        }
        finally {
            this.clearState();
            this.open = false;
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.setIncludeExportedKeys(true);
        return this.executeImpl(sql);
    }

    protected boolean executeImpl(String sql) throws SQLException {
        this.throwIfNotOpen();
        this.clearState();
        ExecResponse response = this.executeSqlImpl(this.rpcOptions, sql);
        if (response.hasResult()) {
            return this.processResultProto(response.getResult());
        }
        return false;
    }

    protected int[] executeBatchImpl(List<String> batchSql) throws SQLException {
        this.throwIfNotOpen();
        this.clearState();
        ExecResponse response = this.executeBatchSqlImpl(this.rpcOptions, batchSql);
        if (response.hasResult()) {
            if (this.processResultProto(response.getResult())) {
                return EMPTY_ROWS_UPDATED;
            }
            int[] rowsUpdatedIntArray = new int[this.batchRowsUpdated.size()];
            int currentRow = 0;
            for (Long updated : this.batchRowsUpdated) {
                rowsUpdatedIntArray[currentRow++] = updated.intValue();
            }
            return rowsUpdatedIntArray;
        }
        return EMPTY_ROWS_UPDATED;
    }

    private boolean processResultProto(Client.ResultProto resultProto) throws SQLException {
        this.warnings = Statement.createSqlWarnings(resultProto.getWarningsList());
        this.generatedKeys = Statement.getGeneratedKeysAsBigDecimal(resultProto);
        this.hasMoreResults = resultProto.getMoreResults();
        if (resultProto.hasStatementId()) {
            this.statementId = resultProto.getStatementId();
        }
        for (Client.BindVariableProto variable : resultProto.getOutputVariableList()) {
            this.outParametersMap.put(variable.getPosition(), variable);
        }
        int namedParameterIndex = 1;
        for (Client.ParameterMetadata param : resultProto.getParameterMetadataList()) {
            this.parameterIndexMap.put(param.getName(), namedParameterIndex++);
        }
        if (resultProto.hasRows()) {
            Client.RowSetProto rsp = resultProto.getRows();
            this.rs = this.statementId != null && resultProto.getMoreRows() ? new StreamingResultSet(this, resultProto, this.warnings, this.conn.getCatalog(), this.rpcOptions.clone(), this.statementId) : new ResultSet(this, rsp.getTuplesList(), rsp.getColumnsList(), this.warnings, this.conn.getCatalog(), this.rpcOptions.clone());
            return true;
        }
        this.rowsUpdated = resultProto.getRowsUpdated();
        this.batchRowsUpdated = resultProto.getBatchRowsUpdatedList();
        return false;
    }

    private static List<BigDecimal> getGeneratedKeysAsBigDecimal(Client.ResultProto result) throws SQLException {
        ArrayList<BigDecimal> generatedKeys = Util.newArrayList();
        for (ByteString keyString : result.getGeneratedKeysList()) {
            if (keyString.size() <= 0) continue;
            generatedKeys.add(DataTypeConverters.getConverter(BigDecimal.class).toObject(keyString));
        }
        return generatedKeys;
    }

    static SQLWarning createSqlWarnings(List<Client.SqlException> warningsList) {
        if (warningsList.size() == 0) {
            return null;
        }
        SQLWarning firstWarning = null;
        SQLWarning lastWarning = null;
        for (Client.SqlException w : warningsList) {
            SQLWarning current = new SQLWarning(w.getMessage(), w.getSqlState(), w.getCode());
            if (firstWarning == null) {
                firstWarning = current;
            }
            if (lastWarning != null) {
                lastWarning.setNextWarning(current);
            }
            lastWarning = current;
        }
        return firstWarning;
    }

    protected ExecResponse executeSqlImpl(SqlRpcOptions options, String sql) throws SQLException {
        this.throwIfNotOpen();
        return this.conn.executeSql(options, sql);
    }

    protected ExecResponse executeBatchSqlImpl(SqlRpcOptions options, List<String> batchSql) throws SQLException {
        this.throwIfNotOpen();
        return this.conn.executeBatchSql(options, batchSql);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.setIncludeExportedKeys(autoGeneratedKeys == 1);
        return this.executeImpl(sql);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.setGeneratedColumnIndices(columnIndexes);
        return this.executeImpl(sql);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.setGeneratedColumnNames(columnNames);
        return this.executeImpl(sql);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.throwIfNotOpen();
        if (this.batchSql.isEmpty()) {
            return EMPTY_ROWS_UPDATED;
        }
        return this.executeBatchImpl(Util.newArrayList(this.batchSql));
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.throwIfNotOpen();
        if (!this.executeImpl(sql)) {
            throw Exceptions.newStatementExecuteQueryNullResultSetException();
        }
        return this.rs;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return this.executeUpdateImpl(sql);
    }

    private int executeUpdateImpl(String sql) throws SQLException {
        this.throwIfNotOpen();
        if (this.executeImpl(sql)) {
            throw Exceptions.newStatementExecuteUpdateWithResultSetException();
        }
        return (int)this.rowsUpdated;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.setIncludeExportedKeys(autoGeneratedKeys == 1);
        return this.executeUpdateImpl(sql);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.setGeneratedColumnIndices(columnIndexes);
        return this.executeUpdateImpl(sql);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.setGeneratedColumnNames(columnNames);
        return this.executeUpdateImpl(sql);
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.throwIfNotOpen();
        return this.conn;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.throwIfNotOpen();
        return this.rpcOptions.getFetchDirection();
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.throwIfNotOpen();
        return this.rpcOptions.getFetchSize();
    }

    @Override
    public java.sql.ResultSet getGeneratedKeys() throws SQLException {
        this.throwIfNotOpen();
        ArrayList<String> keys = Util.newArrayList();
        for (BigDecimal key : this.generatedKeys) {
            keys.add(key.toPlainString());
        }
        return SimpleListResultSet.oneColumnResultSet(keys, "GENERATED_KEY");
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.throwIfNotOpen();
        return this.rpcOptions.getMaxFieldSize();
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.throwIfNotOpen();
        return this.rpcOptions.getMaxRows();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.throwIfNotOpen();
        Statement.validateGetMoreResultsArgument(current);
        if (this.rs != null) {
            this.rs.close();
        }
        if (!this.hasMoreResults) {
            return false;
        }
        Util.checkNotNull(this.statementId, "Encountered invalid statement handle when there are more results");
        long currentStatementId = this.statementId;
        this.clearState();
        this.statementId = currentStatementId;
        ExecOpResponse response = this.conn.getMoreResults(this.rpcOptions, this.statementId);
        if (response.hasResult()) {
            return this.processResultProto(response.getResult());
        }
        return false;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.throwIfNotOpen();
        return this.queryTimeoutSeconds;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.throwIfNotOpen();
        return this.rs;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.throwIfNotOpen();
        return this.rpcOptions.getResultSetConcurrency();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.throwIfNotOpen();
        return this.rpcOptions.getResultSetHoldability();
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.throwIfNotOpen();
        return this.rpcOptions.getResultSetType();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.throwIfNotOpen();
        int lastRowsUpdated = (int)this.rowsUpdated;
        this.rowsUpdated = -1L;
        return lastRowsUpdated;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.throwIfNotOpen();
        return this.warnings;
    }

    @Override
    public boolean isClosed() {
        return !this.open;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.throwIfNotOpen();
        return this.rpcOptions.isPoolable();
    }

    @Override
    public void setCursorName(String cursorName) throws SQLException {
        this.throwIfNotOpen();
        this.rpcOptions.setCursorName(cursorName);
    }

    @Override
    public void setEscapeProcessing(boolean escapeProcessing) throws SQLException {
        this.throwIfNotOpen();
        this.rpcOptions.setEscapeProcessing(escapeProcessing);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.throwIfNotOpen();
        this.rpcOptions.setFetchDirection(direction);
    }

    @Override
    public void setFetchSize(int fetchSize) throws SQLException {
        this.throwIfNotOpen();
        this.rpcOptions.setFetchSize(fetchSize);
    }

    @Override
    public void setMaxFieldSize(int maxFieldSize) throws SQLException {
        this.throwIfNotOpen();
        this.rpcOptions.setMaxFieldSize(maxFieldSize);
    }

    @Override
    public void setMaxRows(int maxRows) throws SQLException {
        this.throwIfNotOpen();
        this.rpcOptions.setMaxRows(maxRows);
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.throwIfNotOpen();
        this.rpcOptions.setPoolable(poolable);
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.throwIfNotOpen();
        if (seconds < 0) {
            throw Exceptions.newSqlException("Seconds must be >= 0.");
        }
        if (seconds == 0) {
            this.rpcOptions.clearQueryTimeOutMillis();
        } else {
            this.rpcOptions.setQueryTimeOutMillis(TimeUnit.SECONDS.toMillis(seconds));
        }
        this.queryTimeoutSeconds = seconds;
    }

    @Override
    public void closeOnCompletion() {
    }

    @Override
    public boolean isCloseOnCompletion() {
        return false;
    }

    void setIncludeExportedKeys(boolean includeExportedKeys) {
        this.rpcOptions.setIncludeExportedKeys(includeExportedKeys);
    }

    void setGeneratedColumnIndices(int ... generatedColumnIndices) {
        this.rpcOptions.setGeneratedColumnIndices(generatedColumnIndices);
    }

    void setGeneratedColumnNames(String ... generatedColumnNames) {
        this.rpcOptions.setGeneratedColumnNames(generatedColumnNames);
    }

    protected void throwIfNotOpen() throws SQLException {
        if (!this.open) {
            throw Exceptions.newStatementClosedException();
        }
    }

    void setWarnings(SQLWarning warnings) {
        this.warnings = warnings;
    }

    private static void validateGetMoreResultsArgument(int jdbcConstant) throws SQLException {
        switch (jdbcConstant) {
            case 1: {
                return;
            }
            case 2: 
            case 3: {
                throw Exceptions.newNotYetImplementedException("Multiple open results not supported.");
            }
        }
        throw Exceptions.newSqlException("Invalid JDBC constant for getMoreResults(): " + jdbcConstant);
    }

    private void clearState() {
        this.rs = null;
        this.warnings = null;
        this.rowsUpdated = -1L;
        this.batchRowsUpdated = Collections.emptyList();
        this.generatedKeys = null;
        this.statementId = null;
        this.hasMoreResults = false;
        this.outParametersMap.clear();
        this.parameterIndexMap.clear();
        this.batchSql.clear();
    }
}

