/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.OID;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.ColumnMetaDataContainer;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.ElementMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.IdentityStrategy;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.metadata.JoinMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.OrderMetaData;
import org.datanucleus.metadata.PrimaryKeyMetaData;
import org.datanucleus.metadata.PropertyMetaData;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.sco.SCOUtils;
import org.datanucleus.store.appengine.DatastoreFKMapping;
import org.datanucleus.store.appengine.DatastoreKind;
import org.datanucleus.store.appengine.DatastoreProperty;
import org.datanucleus.store.appengine.InsertMappingConsumer;
import org.datanucleus.store.appengine.Utils;
import org.datanucleus.store.exceptions.NoSuchPersistentFieldException;
import org.datanucleus.store.exceptions.NoTableManagedException;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.IdentifierFactory;
import org.datanucleus.store.mapped.IdentifierType;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.CorrespondentColumnsMapper;
import org.datanucleus.store.mapped.mapping.DatastoreMapping;
import org.datanucleus.store.mapped.mapping.IndexMapping;
import org.datanucleus.store.mapped.mapping.IntegerMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.LongMapping;
import org.datanucleus.store.mapped.mapping.MappingConsumer;
import org.datanucleus.store.mapped.mapping.OIDMapping;
import org.datanucleus.store.mapped.mapping.PersistenceCapableMapping;
import org.datanucleus.util.MultiMap;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatastoreTable
implements DatastoreClass {
    private static final MultiMap callbacks = new MultiMap();
    private final MappedStoreManager storeMgr;
    private final AbstractClassMetaData cmd;
    private final ClassLoaderResolver clr;
    private final DatastoreAdapter dba;
    protected final DatastoreIdentifier identifier;
    private final Map<String, AbstractClassMetaData> owningClassMetaData = Utils.newHashMap();
    private final Map<AbstractMemberMetaData, JavaTypeMapping> fieldMappingsMap = new LinkedHashMap<AbstractMemberMetaData, JavaTypeMapping>();
    private final List<DatastoreProperty> datastoreProperties = Utils.newArrayList(new Object[0]);
    protected Map<String, DatastoreProperty> datastorePropertiesByName = Utils.newHashMap();
    private JavaTypeMapping datastoreIDMapping;
    private JavaTypeMapping[] pkMappings;
    private JavaTypeMapping idMapping;
    private int highestFieldNumber = 0;
    private final List<AbstractMemberMetaData> sameEntityGroupMemberMetaData = Utils.newArrayList(new Object[0]);
    private final Map<AbstractMemberMetaData, JavaTypeMapping> externalFkMappings = Utils.newHashMap();
    private final Map<AbstractMemberMetaData, JavaTypeMapping> externalOrderMappings = Utils.newHashMap();
    private AbstractMemberMetaData parentMappingField;

    DatastoreTable(MappedStoreManager storeMgr, AbstractClassMetaData cmd, ClassLoaderResolver clr, DatastoreAdapter dba) {
        this.storeMgr = storeMgr;
        this.cmd = cmd;
        this.clr = clr;
        this.dba = dba;
        this.identifier = new DatastoreKind(cmd);
    }

    public String getType() {
        return this.cmd.getFullClassName();
    }

    public IdentityType getIdentityType() {
        return this.cmd.getIdentityType();
    }

    public boolean isObjectIDDatastoreAttributed() {
        return true;
    }

    public boolean isBaseDatastoreClass() {
        return true;
    }

    public DatastoreClass getBaseDatastoreClassWithMember(AbstractMemberMetaData fmd) {
        if (this.fieldMappingsMap.get(fmd) != null) {
            return this;
        }
        return null;
    }

    public DatastoreClass getSuperDatastoreClass() {
        return null;
    }

    public Collection getSecondaryDatastoreClasses() {
        return null;
    }

    public boolean managesClass(String className) {
        return this.cmd.getFullClassName().equals(className);
    }

    public JavaTypeMapping getDataStoreObjectIdMapping() {
        return this.datastoreIDMapping;
    }

    public JavaTypeMapping getMemberMapping(String fieldName) {
        AbstractMemberMetaData fmd = this.getFieldMetaData(fieldName);
        JavaTypeMapping m = this.getMemberMapping(fmd);
        if (m == null) {
            throw new NoSuchPersistentFieldException(this.cmd.getFullClassName(), fieldName);
        }
        return m;
    }

    private AbstractMemberMetaData getFieldMetaData(String fieldName) {
        return this.cmd.getMetaDataForMember(fieldName);
    }

    public JavaTypeMapping getMemberMapping(AbstractMemberMetaData mmd) {
        if (mmd == null) {
            return null;
        }
        return this.fieldMappingsMap.get(mmd);
    }

    public JavaTypeMapping getMemberMappingInDatastoreClass(AbstractMemberMetaData mmd) {
        return this.getMemberMapping(mmd);
    }

    public DatastoreProperty addDatastoreField(String storedJavaType, DatastoreIdentifier name, JavaTypeMapping mapping, MetaData colmd) {
        if (this.hasColumnName(name)) {
            throw new NucleusException("Duplicate property name: " + name);
        }
        DatastoreProperty prop = new DatastoreProperty(this, mapping.getJavaType().getName(), name, (ColumnMetaData)colmd);
        DatastoreIdentifier colName = prop.getIdentifier();
        this.datastoreProperties.add(prop);
        this.datastorePropertiesByName.put(colName.getIdentifierName(), prop);
        return prop;
    }

    protected boolean hasColumnName(DatastoreIdentifier colName) {
        return this.getDatastoreField(colName) != null;
    }

    public boolean hasDatastoreField(DatastoreIdentifier identifier) {
        return this.hasColumnName(identifier);
    }

    DatastoreField getDatastoreField(String colName) {
        return this.datastorePropertiesByName.get(colName);
    }

    public DatastoreField getDatastoreField(DatastoreIdentifier identifier) {
        return this.getDatastoreField(identifier.getIdentifierName());
    }

    public JavaTypeMapping getIDMapping() {
        return this.idMapping;
    }

    public MappedStoreManager getStoreManager() {
        return this.storeMgr;
    }

    public DatastoreIdentifier getIdentifier() {
        return this.identifier;
    }

    public boolean isSuperDatastoreClass(DatastoreClass datastoreClass) {
        return false;
    }

    public boolean managesMapping(JavaTypeMapping javaTypeMapping) {
        return true;
    }

    public DatastoreField[] getDatastoreFields() {
        return this.datastoreProperties.toArray(new DatastoreField[this.datastoreProperties.size()]);
    }

    public void buildMapping() {
        this.initializePK();
        this.initializeNonPK();
        this.runCallBacks();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initializeNonPK() {
        AbstractMemberMetaData[] fields;
        for (AbstractMemberMetaData fmd : fields = this.cmd.getManagedMembers()) {
            AbstractClassMetaData keyCmd;
            DatastoreTable dt;
            if (fmd.isPrimaryKey()) continue;
            if (this.managesField(fmd.getFullFieldName())) {
                if (fmd.getClassName(true).equals(this.cmd.getFullClassName())) continue;
                throw new UnsupportedOperationException("Overrides not currently supported.");
            }
            if (fmd.getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
                boolean isPrimary = true;
                if (fmd.getTable() != null && fmd.getJoinMetaData() == null) {
                    isPrimary = false;
                }
                if (!isPrimary) throw new UnsupportedOperationException("No support for secondary tables.");
                JavaTypeMapping mapping = this.dba.getMappingManager(this.storeMgr).getMapping((DatastoreContainerObject)this, fmd, this.dba, this.clr, 2);
                this.addFieldMapping(mapping);
            } else if (fmd.getPersistenceModifier() != FieldPersistenceModifier.TRANSACTIONAL) {
                throw new NucleusException("Invalid persistence-modifier for field ").setFatal();
            }
            boolean needsFKToContainerOwner = false;
            int relationType = fmd.getRelationType(this.clr);
            if (relationType == 4) {
                AbstractMemberMetaData[] relatedMmds = fmd.getRelatedMemberMetaData(this.clr);
                if (fmd.getJoinMetaData() == null && relatedMmds[0].getJoinMetaData() == null) {
                    needsFKToContainerOwner = true;
                }
            } else if (relationType == 3) {
                if (fmd.getJoinMetaData() == null) {
                    needsFKToContainerOwner = true;
                }
            } else if (relationType == 2) {
                if (fmd.getMappedBy() != null) {
                    dt = (DatastoreTable)this.storeMgr.getDatastoreClass(fmd.getAbstractClassMetaData().getFullClassName(), this.clr);
                    dt.runCallBacks();
                    dt.markFieldAsParentKeyProvider(fmd.getName());
                }
            } else if (relationType == 6) {
                dt = (DatastoreTable)this.storeMgr.getDatastoreClass(fmd.getAbstractClassMetaData().getFullClassName(), this.clr);
                AbstractClassMetaData abstractClassMetaData = this.storeMgr.getMetaDataManager().getMetaDataForClass(fmd.getType(), this.clr);
                dt.addOwningClassMetaData(fmd.getColumnMetaData()[0].getName(), abstractClassMetaData);
            }
            if (!needsFKToContainerOwner) continue;
            if (fmd.getCollection() != null && !SCOUtils.collectionHasSerialisedElements((AbstractMemberMetaData)fmd) || fmd.getArray() != null && !SCOUtils.arrayIsStoredInSingleColumn((AbstractMemberMetaData)fmd)) {
                void var9_14;
                AbstractClassMetaData elementCmd = fmd.hasCollection() ? this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(fmd.getCollection().getElementType(), this.clr) : this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(fmd.getType().getComponentType(), this.clr);
                if (elementCmd == null) continue;
                if (elementCmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.SUBCLASS_TABLE) {
                    AbstractClassMetaData[] abstractClassMetaDataArray = this.storeMgr.getClassesManagingTableForClass(elementCmd, this.clr);
                } else {
                    ClassMetaData[] classMetaDataArray = new ClassMetaData[]{elementCmd};
                }
                for (void elementCmd1 : var9_14) {
                    callbacks.put((Object)elementCmd1.getFullClassName(), (Object)new CallBack(fmd));
                    DatastoreTable dt2 = (DatastoreTable)this.storeMgr.getDatastoreClass(elementCmd1.getFullClassName(), this.clr);
                    dt2.runCallBacks();
                    if (fmd.getMappedBy() == null) continue;
                    dt2.markFieldAsParentKeyProvider(fmd.getMappedBy());
                }
                continue;
            }
            if (fmd.getMap() == null || SCOUtils.mapHasSerialisedKeysAndValues((AbstractMemberMetaData)fmd)) continue;
            if (fmd.getKeyMetaData() != null && fmd.getKeyMetaData().getMappedBy() != null) {
                AbstractClassMetaData valueCmd = this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(fmd.getMap().getValueType(), this.clr);
                if (valueCmd != null) continue;
            }
            if (fmd.getValueMetaData() != null && fmd.getValueMetaData().getMappedBy() != null && (keyCmd = this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(fmd.getMap().getKeyType(), this.clr)) != null) continue;
        }
    }

    private void markFieldAsParentKeyProvider(String mappedBy) {
        if (this.parentMappingField != null) {
            throw new NucleusException("App Engine ORM does not support multiple parent key provider fields.");
        }
        this.parentMappingField = this.getFieldMetaData(mappedBy);
    }

    protected void addFieldMapping(JavaTypeMapping fieldMapping) {
        AbstractMemberMetaData fmd = fieldMapping.getMemberMetaData();
        this.fieldMappingsMap.put(fmd, fieldMapping);
        int absoluteFieldNumber = fmd.getAbsoluteFieldNumber();
        if (absoluteFieldNumber > this.highestFieldNumber) {
            this.highestFieldNumber = absoluteFieldNumber;
        }
        if (this.isInSameEntityGroup(fmd)) {
            this.sameEntityGroupMemberMetaData.add(fmd);
        }
    }

    private boolean isInSameEntityGroup(AbstractMemberMetaData ammd) {
        return ammd.getRelationType(this.clr) != 0;
    }

    public boolean managesField(String fieldName) {
        return fieldName != null && this.getMappingForFieldName(fieldName) != null;
    }

    protected JavaTypeMapping getMappingForFieldName(String fieldName) {
        Set<AbstractMemberMetaData> fields = this.fieldMappingsMap.keySet();
        for (AbstractMemberMetaData field : fields) {
            AbstractMemberMetaData fmd = field;
            if (!fmd.getFullFieldName().equals(fieldName)) continue;
            return this.fieldMappingsMap.get(fmd);
        }
        return null;
    }

    void addDatastoreId(ColumnMetaDataContainer columnContainer, DatastoreClass refTable, AbstractClassMetaData cmd) {
        this.datastoreIDMapping = new OIDMapping();
        this.datastoreIDMapping.initialize(this.dba, cmd.getFullClassName());
        ColumnMetaData colmd = columnContainer == null ? new ColumnMetaData() : (columnContainer.getColumnMetaData().length < 1 ? new ColumnMetaData() : columnContainer.getColumnMetaData()[0]);
        if (colmd.getName() == null) {
            if (refTable != null) {
                colmd.setName(this.storeMgr.getIdentifierFactory().newDatastoreFieldIdentifier(refTable.getIdentifier().getIdentifierName(), this.storeMgr.getOMFContext().getTypeManager().isDefaultEmbeddedType(OID.class), 1).getIdentifierName());
            } else {
                colmd.setName(this.storeMgr.getIdentifierFactory().newDatastoreFieldIdentifier(this.identifier.getIdentifierName(), this.storeMgr.getOMFContext().getTypeManager().isDefaultEmbeddedType(OID.class), 0).getIdentifierName());
            }
        }
        DatastoreProperty idColumn = this.addDatastoreField(OID.class.getName(), this.storeMgr.getIdentifierFactory().newIdentifier(IdentifierType.COLUMN, colmd.getName()), this.datastoreIDMapping, (MetaData)colmd);
        idColumn.setAsPrimaryKey();
        String strategyName = cmd.getIdentityMetaData().getValueStrategy().toString();
        if (cmd.getIdentityMetaData().getValueStrategy().equals((Object)IdentityStrategy.CUSTOM)) {
            strategyName = cmd.getIdentityMetaData().getValueStrategy().getCustomName();
        }
        Class poidClass = Long.class;
        ConfigurationElement elem = this.storeMgr.getOMFContext().getPluginManager().getConfigurationElementForExtension("org.datanucleus.store_valuegenerator", new String[]{"name", "unique"}, new String[]{strategyName, "true"});
        if (elem == null) {
            elem = this.storeMgr.getOMFContext().getPluginManager().getConfigurationElementForExtension("org.datanucleus.store_valuegenerator", new String[]{"name", "datastore"}, new String[]{strategyName, this.storeMgr.getStoreManagerKey()});
        }
        if (elem != null) {
            String generatorClassName = elem.getAttribute("class-name");
            Class generatorClass = this.getStoreManager().getOMFContext().getClassLoaderResolver(null).classForName(generatorClassName);
            try {
                poidClass = (Class)generatorClass.getMethod("getStorageClass", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception e) {
                NucleusLogger.VALUEGENERATION.warn((Object)("Error retrieving storage class for POID generator " + generatorClassName + " " + e.getMessage()));
            }
        }
        this.dba.getMappingManager(this.storeMgr).createDatastoreMapping(this.datastoreIDMapping, (DatastoreField)idColumn, poidClass.getName());
        if (this.isObjectIDDatastoreAttributed()) {
            // empty if block
        }
    }

    private void initializePK() {
        AbstractMemberMetaData[] fieldsToAdd = new AbstractMemberMetaData[this.cmd.getNoOfPrimaryKeyMembers()];
        int pkFieldNum = 0;
        int fieldCount = this.cmd.getNoOfManagedMembers();
        boolean hasPrimaryKeyInThisClass = false;
        if (this.cmd.getNoOfPrimaryKeyMembers() > 0) {
            this.pkMappings = new JavaTypeMapping[this.cmd.getNoOfPrimaryKeyMembers()];
            if (this.cmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.COMPLETE_TABLE) {
                AbstractClassMetaData baseCmd = this.cmd.getBaseAbstractClassMetaData();
                fieldCount = baseCmd.getNoOfManagedMembers();
                for (int relFieldNum = 0; relFieldNum < fieldCount; ++relFieldNum) {
                    AbstractMemberMetaData mmd = baseCmd.getMetaDataForManagedMemberAtPosition(relFieldNum);
                    if (!mmd.isPrimaryKey()) continue;
                    if (mmd.getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
                        fieldsToAdd[pkFieldNum++] = mmd;
                        hasPrimaryKeyInThisClass = true;
                        continue;
                    }
                    if (mmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) continue;
                    throw new NucleusException("Invalid persistence-modifier for field " + mmd.getName()).setFatal();
                }
            } else {
                for (int relFieldNum = 0; relFieldNum < fieldCount; ++relFieldNum) {
                    AbstractMemberMetaData fmd = this.cmd.getMetaDataForManagedMemberAtPosition(relFieldNum);
                    if (!fmd.isPrimaryKey()) continue;
                    if (fmd.getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
                        fieldsToAdd[pkFieldNum++] = fmd;
                        hasPrimaryKeyInThisClass = true;
                        continue;
                    }
                    if (fmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) continue;
                    throw new NucleusException("Invalid persistence-modifier for field" + fmd.getName()).setFatal();
                }
            }
        }
        if (!hasPrimaryKeyInThisClass) {
            if (this.cmd.getIdentityType() == IdentityType.APPLICATION) {
                DatastoreClass elementCT = this.storeMgr.getDatastoreClass(this.cmd.getPersistenceCapableSuperclass(), this.clr);
                if (elementCT != null) {
                    JoinMetaData colContainer = null;
                    if (this.cmd.getInheritanceMetaData() != null) {
                        colContainer = this.cmd.getInheritanceMetaData().getJoinMetaData();
                    }
                    if (colContainer == null) {
                        colContainer = this.cmd.getPrimaryKeyMetaData();
                    }
                    this.addApplicationIdUsingClassTableId((ColumnMetaDataContainer)colContainer, elementCT, this.clr, this.cmd);
                } else {
                    AbstractClassMetaData pkCmd = this.storeMgr.getClassWithPrimaryKeyForClass(this.cmd.getSuperAbstractClassMetaData(), this.clr);
                    if (pkCmd != null) {
                        this.pkMappings = new JavaTypeMapping[pkCmd.getNoOfPrimaryKeyMembers()];
                        pkFieldNum = 0;
                        fieldCount = pkCmd.getNoOfInheritedManagedMembers() + pkCmd.getNoOfManagedMembers();
                        for (int absFieldNum = 0; absFieldNum < fieldCount; ++absFieldNum) {
                            AbstractMemberMetaData fmd = pkCmd.getMetaDataForManagedMemberAtAbsolutePosition(absFieldNum);
                            if (!fmd.isPrimaryKey()) continue;
                            AbstractMemberMetaData overriddenFmd = this.cmd.getOverriddenMember(fmd.getName());
                            if (overriddenFmd != null) {
                                fmd = overriddenFmd;
                            }
                            if (fmd.getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
                                fieldsToAdd[pkFieldNum++] = fmd;
                                continue;
                            }
                            if (fmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) continue;
                            throw new NucleusException("Invalid persistence-modifier for field " + fmd.getName()).setFatal();
                        }
                    }
                }
            } else if (this.cmd.getIdentityType() == IdentityType.DATASTORE) {
                PrimaryKeyMetaData colContainer = null;
                if (this.cmd.getIdentityMetaData() != null && this.cmd.getIdentityMetaData().getColumnMetaData() != null && this.cmd.getIdentityMetaData().getColumnMetaData().length > 0) {
                    colContainer = this.cmd.getIdentityMetaData();
                }
                if (colContainer == null) {
                    colContainer = this.cmd.getPrimaryKeyMetaData();
                }
                this.addDatastoreId((ColumnMetaDataContainer)colContainer, null, this.cmd);
            } else if (this.cmd.getIdentityType() == IdentityType.NONDURABLE) {
                // empty if block
            }
        }
        for (int i = 0; i < fieldsToAdd.length; ++i) {
            if (fieldsToAdd[i] == null) continue;
            try {
                DatastoreClass datastoreClass = this.getStoreManager().getDatastoreClass(fieldsToAdd[i].getType().getName(), this.clr);
                if (datastoreClass.getIDMapping() == null) {
                    throw new NucleusException("Unsupported relationship with field " + fieldsToAdd[i].getFullFieldName()).setFatal();
                }
            }
            catch (NoTableManagedException ex) {
                // empty catch block
            }
            JavaTypeMapping fieldMapping = this.dba.getMappingManager(this.storeMgr).getMapping((DatastoreContainerObject)this, fieldsToAdd[i], this.dba, this.clr, 2);
            this.addFieldMapping(fieldMapping);
            this.pkMappings[i] = fieldMapping;
        }
        this.initializeIDMapping();
    }

    private void initializeIDMapping() {
        if (this.idMapping != null) {
            return;
        }
        PersistenceCapableMapping mapping = new PersistenceCapableMapping();
        mapping.initialize(this.getStoreManager().getDatastoreAdapter(), this.cmd.getFullClassName());
        if (this.getIdentityType() == IdentityType.DATASTORE) {
            mapping.addJavaTypeMapping(this.datastoreIDMapping);
        } else if (this.getIdentityType() == IdentityType.APPLICATION) {
            for (JavaTypeMapping pkMapping : this.pkMappings) {
                mapping.addJavaTypeMapping(pkMapping);
            }
        }
        this.idMapping = mapping;
    }

    final void addApplicationIdUsingClassTableId(ColumnMetaDataContainer columnContainer, DatastoreClass refTable, ClassLoaderResolver clr, AbstractClassMetaData cmd) {
        ColumnMetaData[] userdefinedCols = null;
        int nextUserdefinedCol = 0;
        if (columnContainer != null) {
            userdefinedCols = columnContainer.getColumnMetaData();
        }
        this.pkMappings = new JavaTypeMapping[cmd.getPKMemberPositions().length];
        for (int i = 0; i < cmd.getPKMemberPositions().length; ++i) {
            AbstractMemberMetaData fmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(cmd.getPKMemberPositions()[i]);
            JavaTypeMapping mapping = refTable.getMemberMapping(fmd);
            if (mapping == null) {
                throw new NucleusUserException("Cannot find mapping for field " + fmd.getFullFieldName() + " in table " + refTable.toString() + " " + StringUtils.objectArrayToString((Object[])refTable.getDatastoreFields()));
            }
            JavaTypeMapping masterMapping = this.storeMgr.getMappingManager().getMapping(clr.classForName(mapping.getType()));
            masterMapping.setMemberMetaData(fmd);
            this.pkMappings[i] = masterMapping;
            for (int j = 0; j < mapping.getNumberOfDatastoreFields(); ++j) {
                JavaTypeMapping m = masterMapping;
                DatastoreField refColumn = mapping.getDataStoreMapping(j).getDatastoreField();
                if (mapping instanceof PersistenceCapableMapping) {
                    m = this.storeMgr.getMappingManager().getMapping(clr.classForName(refColumn.getJavaTypeMapping().getType()));
                    ((PersistenceCapableMapping)masterMapping).addJavaTypeMapping(m);
                }
                ColumnMetaData userdefinedColumn = null;
                if (userdefinedCols != null) {
                    for (ColumnMetaData userdefinedCol : userdefinedCols) {
                        if (!refColumn.getIdentifier().toString().equals(userdefinedCol.getTarget())) continue;
                        userdefinedColumn = userdefinedCol;
                        break;
                    }
                    if (userdefinedColumn == null && nextUserdefinedCol < userdefinedCols.length) {
                        userdefinedColumn = userdefinedCols[nextUserdefinedCol++];
                    }
                }
                DatastoreProperty idColumn = userdefinedColumn != null ? this.addDatastoreField(refColumn.getStoredJavaType(), this.storeMgr.getIdentifierFactory().newIdentifier(IdentifierType.COLUMN, userdefinedColumn.getName()), m, (MetaData)refColumn.getColumnMetaData()) : this.addDatastoreField(refColumn.getStoredJavaType(), refColumn.getIdentifier(), m, (MetaData)refColumn.getColumnMetaData());
                if (mapping != null && mapping.getDataStoreMapping(j).getDatastoreField().getColumnMetaData() != null) {
                    refColumn.copyConfigurationTo((DatastoreField)idColumn);
                }
                idColumn.setAsPrimaryKey();
                this.getStoreManager().getMappingManager().createDatastoreMapping(m, (DatastoreField)idColumn, refColumn.getJavaTypeMapping().getType());
            }
            int absoluteFieldNumber = fmd.getAbsoluteFieldNumber();
            if (absoluteFieldNumber <= this.highestFieldNumber) continue;
            this.highestFieldNumber = absoluteFieldNumber;
        }
    }

    public void provideDatastoreIdMappings(MappingConsumer consumer) {
        consumer.preConsumeMapping(this.highestFieldNumber + 1);
        if (this.getIdentityType() == IdentityType.DATASTORE) {
            consumer.consumeMapping(this.getDataStoreObjectIdMapping(), 2);
        }
    }

    public void providePrimaryKeyMappings(MappingConsumer consumer) {
        consumer.preConsumeMapping(this.highestFieldNumber + 1);
        if (this.pkMappings != null) {
            int[] primaryKeyFieldNumbers = this.cmd.getPKMemberPositions();
            for (int i = 0; i < this.pkMappings.length; ++i) {
                AbstractMemberMetaData fmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(primaryKeyFieldNumbers[i]);
                consumer.consumeMapping(this.pkMappings[i], fmd);
            }
        } else {
            int[] primaryKeyFieldNumbers = this.cmd.getPKMemberPositions();
            int countPkFields = this.cmd.getNoOfPrimaryKeyMembers();
            for (int i = 0; i < countPkFields; ++i) {
                AbstractMemberMetaData pkfmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(primaryKeyFieldNumbers[i]);
                consumer.consumeMapping(this.getMemberMapping(pkfmd), pkfmd);
            }
        }
    }

    public void provideNonPrimaryKeyMappings(MappingConsumer consumer) {
        consumer.preConsumeMapping(this.highestFieldNumber + 1);
        Set<AbstractMemberMetaData> fieldNumbersSet = this.fieldMappingsMap.keySet();
        for (AbstractMemberMetaData aFieldNumbersSet : fieldNumbersSet) {
            AbstractMemberMetaData fmd = aFieldNumbersSet;
            JavaTypeMapping fieldMapping = this.fieldMappingsMap.get(fmd);
            if (fieldMapping == null || fmd.isPrimaryKey()) continue;
            consumer.consumeMapping(fieldMapping, fmd);
        }
    }

    public void provideMappingsForMembers(MappingConsumer consumer, AbstractMemberMetaData[] mmds, boolean includeSecondaryTables) {
        for (AbstractMemberMetaData aFieldMetaData : mmds) {
            JavaTypeMapping fieldMapping = this.fieldMappingsMap.get(aFieldMetaData);
            if (fieldMapping == null || aFieldMetaData.isPrimaryKey()) continue;
            consumer.consumeMapping(fieldMapping, aFieldMetaData);
        }
    }

    public void provideVersionMappings(MappingConsumer consumer) {
    }

    public void provideDiscriminatorMappings(MappingConsumer consumer) {
    }

    public void provideUnmappedDatastoreFields(MappingConsumer consumer) {
    }

    public void provideExternalMappings(MappingConsumer consumer, int mappingType) {
        block3: {
            block2: {
                if (mappingType != 5) break block2;
                for (AbstractMemberMetaData fmd : this.externalFkMappings.keySet()) {
                    JavaTypeMapping fieldMapping = this.externalFkMappings.get(fmd);
                    if (fieldMapping == null) continue;
                    consumer.consumeMapping(fieldMapping, 5);
                }
                break block3;
            }
            if (mappingType != 4) break block3;
            for (AbstractMemberMetaData fmd : this.externalOrderMappings.keySet()) {
                JavaTypeMapping fieldMapping = this.externalOrderMappings.get(fmd);
                if (fieldMapping == null) continue;
                consumer.consumeMapping(fieldMapping, 4);
            }
        }
    }

    public JavaTypeMapping getExternalMapping(AbstractMemberMetaData fmd, int mappingType) {
        if (mappingType == 5) {
            return this.getExternalFkMappings().get(fmd);
        }
        if (mappingType == 6) {
            return null;
        }
        if (mappingType == 4) {
            return this.getExternalOrderMappings().get(fmd);
        }
        return null;
    }

    public AbstractMemberMetaData getMetaDataForExternalMapping(JavaTypeMapping mapping, int mappingType) {
        if (mappingType == 5) {
            Set<Map.Entry<AbstractMemberMetaData, JavaTypeMapping>> entries = this.getExternalFkMappings().entrySet();
            for (Map.Entry<AbstractMemberMetaData, JavaTypeMapping> entry1 : entries) {
                Map.Entry<AbstractMemberMetaData, JavaTypeMapping> entry = entry1;
                if (entry.getValue() != mapping) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public DiscriminatorMetaData getDiscriminatorMetaData() {
        return null;
    }

    public JavaTypeMapping getDiscriminatorMapping(boolean allowSuperclasses) {
        return null;
    }

    public VersionMetaData getVersionMetaData() {
        return null;
    }

    public JavaTypeMapping getVersionMapping(boolean allowSuperclasses) {
        return null;
    }

    public List<AbstractMemberMetaData> getSameEntityGroupMemberMetaData() {
        return this.sameEntityGroupMemberMetaData;
    }

    private Map<AbstractMemberMetaData, JavaTypeMapping> getExternalFkMappings() {
        return this.externalFkMappings;
    }

    private Map<AbstractMemberMetaData, JavaTypeMapping> getExternalOrderMappings() {
        return this.externalOrderMappings;
    }

    private void runCallBacks() {
        Collection c = (Collection)callbacks.remove((Object)this.cmd.getFullClassName());
        if (c == null) {
            return;
        }
        for (Object aC : c) {
            CallBack callback = (CallBack)aC;
            if (callback.fmd.getJoinMetaData() != null) continue;
            AbstractMemberMetaData ownerFmd = callback.fmd;
            if (ownerFmd.getMappedBy() != null) {
                AbstractMemberMetaData fmd = this.cmd.getMetaDataForMember(ownerFmd.getMappedBy());
                if (fmd == null) {
                    throw new NucleusUserException(String.format("Unable to find the field \"{0}\" in the class \"{1}\" with a relationship to the field \"{2}\"", ownerFmd.getMappedBy(), this.cmd.getFullClassName(), ownerFmd.getFullFieldName()));
                }
                this.addOrderMapping(ownerFmd, null);
                continue;
            }
            String ownerClassName = ownerFmd.getAbstractClassMetaData().getFullClassName();
            PersistenceCapableMapping fkMapping = new PersistenceCapableMapping();
            fkMapping.initialize(this.dba, ownerClassName);
            JavaTypeMapping orderMapping = null;
            JavaTypeMapping ownerIdMapping = this.storeMgr.getDatastoreClass(ownerClassName, this.clr).getIDMapping();
            ElementMetaData colmdContainer = null;
            if (ownerFmd.hasCollection() || ownerFmd.hasArray()) {
                colmdContainer = ownerFmd.getElementMetaData();
            } else if (ownerFmd.hasMap() && ownerFmd.getKeyMetaData() != null && ownerFmd.getKeyMetaData().getMappedBy() != null) {
                colmdContainer = ownerFmd.getValueMetaData();
            } else if (ownerFmd.hasMap() && ownerFmd.getValueMetaData() != null && ownerFmd.getValueMetaData().getMappedBy() != null) {
                colmdContainer = ownerFmd.getKeyMetaData();
            }
            CorrespondentColumnsMapper correspondentColumnsMapping = new CorrespondentColumnsMapper((ColumnMetaDataContainer)colmdContainer, ownerIdMapping, true);
            int countIdFields = ownerIdMapping.getNumberOfDatastoreFields();
            for (int i = 0; i < countIdFields; ++i) {
                DatastoreMapping refDatastoreMapping = ownerIdMapping.getDataStoreMapping(i);
                JavaTypeMapping mapping = this.storeMgr.getMappingManager().getMapping(refDatastoreMapping.getJavaTypeMapping().getJavaType());
                ColumnMetaData colmd = correspondentColumnsMapping.getColumnMetaDataByIdentifier(refDatastoreMapping.getDatastoreField().getIdentifier());
                if (colmd == null) {
                    throw new NucleusUserException(String.format("Primary Key column \"%s\" for table \"%s\" is not mapped.", refDatastoreMapping.getDatastoreField().getIdentifier(), this.toString())).setFatal();
                }
                IdentifierFactory idFactory = this.storeMgr.getIdentifierFactory();
                DatastoreIdentifier identifier = colmd.getName() == null || colmd.getName().length() < 1 ? idFactory.newForeignKeyFieldIdentifier(ownerFmd, null, refDatastoreMapping.getDatastoreField().getIdentifier(), this.storeMgr.getOMFContext().getTypeManager().isDefaultEmbeddedType(mapping.getJavaType()), 1) : idFactory.newDatastoreFieldIdentifier(colmd.getName());
                DatastoreProperty refColumn = this.addDatastoreField(mapping.getJavaType().getName(), identifier, mapping, (MetaData)colmd);
                refDatastoreMapping.getDatastoreField().copyConfigurationTo((DatastoreField)refColumn);
                if (colmd.getAllowsNull() == null || colmd.getAllowsNull() != null && colmd.isAllowsNull()) {
                    refColumn.setNullable();
                }
                AbstractClassMetaData acmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(ownerIdMapping.getType(), this.clr);
                this.addOwningClassMetaData(colmd.getName(), acmd);
                fkMapping.addDataStoreMapping(this.getStoreManager().getMappingManager().createDatastoreMapping(mapping, (DatastoreField)refColumn, refDatastoreMapping.getJavaTypeMapping().getJavaType().getName()));
                fkMapping.addJavaTypeMapping(mapping);
            }
            this.getExternalFkMappings().put(ownerFmd, (JavaTypeMapping)fkMapping);
            this.addOrderMapping(ownerFmd, orderMapping);
        }
    }

    private JavaTypeMapping addOrderMapping(AbstractMemberMetaData fmd, JavaTypeMapping orderMapping) {
        boolean needsOrderMapping = false;
        OrderMetaData omd = fmd.getOrderMetaData();
        if (fmd.hasArray()) {
            needsOrderMapping = true;
        } else if (List.class.isAssignableFrom(fmd.getType())) {
            needsOrderMapping = omd == null || omd.isIndexedList();
        } else if (Collection.class.isAssignableFrom(fmd.getType()) && omd != null && omd.isIndexedList() && omd.getMappedBy() == null) {
            needsOrderMapping = true;
        }
        if (needsOrderMapping) {
            if (orderMapping == null) {
                orderMapping = this.addOrderColumn(fmd);
            }
            this.getExternalOrderMappings().put(fmd, orderMapping);
        }
        return orderMapping;
    }

    private JavaTypeMapping addOrderColumn(AbstractMemberMetaData fmd) {
        Class<Integer> indexType = Integer.class;
        IndexMapping indexMapping = new IndexMapping();
        indexMapping.initialize(this.dba, indexType.getName());
        IdentifierFactory idFactory = this.storeMgr.getIdentifierFactory();
        DatastoreIdentifier indexColumnName = null;
        ColumnMetaData colmd = null;
        OrderMetaData omd = fmd.getOrderMetaData();
        if (omd != null) {
            ColumnMetaData columnMetaData = colmd = omd.getColumnMetaData() != null && omd.getColumnMetaData().length > 0 ? omd.getColumnMetaData()[0] : null;
            if (omd.getMappedBy() != null) {
                JavaTypeMapping orderMapping = this.getMemberMapping(omd.getMappedBy());
                if (orderMapping == null) {
                    throw new NucleusUserException(String.format("Field \"{0}\" has an <order> defined to be persisted into the columns in the element table for element field \"{1}\". This field is not found in the element class.", fmd.getFullFieldName(), omd.getMappedBy()));
                }
                if (!(orderMapping instanceof IntegerMapping) && !(orderMapping instanceof LongMapping)) {
                    throw new NucleusUserException(String.format("Field \"{0}\" has an <order> defined to be persisted into the column of field \"{1}\". This field is of an invalid type. Must be an int/Integer.", fmd.getFullFieldName(), omd.getMappedBy()));
                }
                return orderMapping;
            }
            if (omd.getColumnMetaData() != null && omd.getColumnMetaData().length > 0 && omd.getColumnMetaData()[0].getName() != null) {
                String colName = omd.getColumnMetaData()[0].getName();
                indexColumnName = idFactory.newDatastoreFieldIdentifier(colName);
            }
        }
        if (indexColumnName == null) {
            indexColumnName = idFactory.newForeignKeyFieldIdentifier(fmd, null, null, this.storeMgr.getOMFContext().getTypeManager().isDefaultEmbeddedType(indexType), 7);
        }
        DatastoreProperty column = this.addDatastoreField(indexType.getName(), indexColumnName, (JavaTypeMapping)indexMapping, (MetaData)colmd);
        if (colmd == null || colmd.getAllowsNull() == null || colmd.getAllowsNull() != null && colmd.isAllowsNull()) {
            column.setNullable();
        }
        DatastoreFKMapping fkMapping = (DatastoreFKMapping)this.storeMgr.getMappingManager().createDatastoreMapping((JavaTypeMapping)indexMapping, (DatastoreField)column, indexType.getName());
        DatastoreProperty field = fkMapping.getDatastoreField();
        DatastoreTable elementTable = field.getDatastoreContainerObject();
        PropertyMetaData pmd = new PropertyMetaData((MetaData)elementTable.getClassMetaData(), indexColumnName.getIdentifierName());
        field.setMemberMetaData((AbstractMemberMetaData)pmd);
        return indexMapping;
    }

    public boolean isParentKeyProvider(AbstractMemberMetaData ammd) {
        return ammd.equals(this.parentMappingField);
    }

    void provideParentMappingField(InsertMappingConsumer consumer) {
        if (this.parentMappingField != null) {
            consumer.setParentMappingField(this.parentMappingField);
        }
    }

    public String toString() {
        return this.cmd.toString();
    }

    public AbstractClassMetaData getClassMetaData() {
        return this.cmd;
    }

    void addOwningClassMetaData(String columnName, AbstractClassMetaData acmd) {
        this.owningClassMetaData.put(columnName, acmd);
    }

    AbstractClassMetaData getOwningClassMetaDataForColumn(String col) {
        return this.owningClassMetaData.get(col);
    }

    private static class CallBack {
        final AbstractMemberMetaData fmd;

        public CallBack(AbstractMemberMetaData fmd) {
            this.fmd = fmd;
        }
    }
}

