from . import nn


WEIGHTS = [
([[0.3365386128425598, -0.25452667474746704, 0.1178569421172142, 0.24521318078041077, 0.051488831639289856, -0.0009707086137495935, 0.48397549986839294, 0.21483078598976135, -0.24352586269378662, 0.11327408254146576, 0.5437442064285278, -0.10973714292049408, 0.2254875898361206, 0.4143846333026886, 0.06489989906549454, -0.5767644643783569, 0.20853519439697266, 0.5876624584197998, -0.1625496745109558, 0.009906512685120106, 0.6155973076820374, 0.0705476775765419, -0.5013723969459534, 0.23169352114200592, 0.5529645681381226, -0.10346787422895432, 0.11267539113759995, 0.6239157319068909], [0.41825127601623535, -0.18596957623958588, 0.18775875866413116, 0.416545033454895, 0.20506417751312256, 0.26596957445144653, -0.09652767330408096, -0.04102542623877525, -0.40922823548316956, 0.13911987841129303, 0.5233977437019348, 0.0084950877353549, 0.3485763967037201, 0.1062212884426117, -0.007444996386766434, -0.583013653755188, 0.3691176474094391, 0.4369165003299713, 0.03144034743309021, 0.622658371925354, -0.10697545111179352, 0.058149538934230804, -0.32298043370246887, 0.45553722977638245, 0.29958364367485046, -0.3335312008857727, 0.8743146061897278, 0.07713835686445236], [0.17612236738204956, 0.38806113600730896, 0.5885047912597656, 0.09747201949357986, -0.10626138001680374, 0.34947651624679565, -0.06085006520152092, 0.46468743681907654, 0.40737098455429077, 0.35185906291007996, 0.26356348395347595, -0.020596161484718323, -0.004087569657713175, 0.08718883246183395, 0.45516613125801086, 0.697160542011261, 0.39381250739097595, 0.3107127547264099, -0.12294483929872513, 0.13725146651268005, 0.10389050096273422, 0.23522770404815674, 0.6885982155799866, 0.36207807064056396, 0.4481832981109619, 0.19768944382667542, -0.04325840249657631, -0.05712064728140831], [0.11501868814229965, -0.20528191328048706, -0.08771439641714096, 0.31305405497550964, -0.02501494064927101, -0.27762889862060547, 0.5240283012390137, 0.06729058176279068, -0.23237140476703644, -0.03268531337380409, 0.3164955973625183, 0.1486758589744568, -0.20853455364704132, 0.5563527941703796, -0.022773563861846924, -0.15980172157287598, -0.07417125254869461, 0.10444056242704391, -0.11351670324802399, -0.16733354330062866, 0.6811292171478271, 0.3054760992527008, -0.3934164047241211, 0.1377531886100769, 0.009427638724446297, -0.01659269630908966, 0.035016708076000214, 0.31817907094955444], [0.10980775952339172, -0.30918481945991516, -0.026605939492583275, -0.09795139729976654, 0.10702446848154068, -0.002046292182058096, 0.09274354577064514, 0.3941989243030548, -0.19148530066013336, 0.10028459876775742, -0.25269538164138794, -0.09323830157518387, 0.31378060579299927, 0.015276381745934486, 0.09837719798088074, -0.3458816409111023, 0.1276949793100357, -0.2756154537200928, 0.18876831233501434, 0.08661780506372452, 0.156244695186615, 0.1482289731502533, -0.14133982360363007, 0.21636082231998444, -0.09982626140117645, -0.06899473071098328, 0.06413441151380539, -0.10835511237382889], [0.07916826009750366, -0.03322213143110275, -0.023406153544783592, 0.1728215217590332, 0.20875853300094604, 0.195273295044899, -0.03801499679684639, 0.17293211817741394, -0.30578166246414185, -0.12433535605669022, 0.06820879131555557, 0.10893209278583527, 0.1373797059059143, -0.07844702899456024, 0.05217557027935982, -0.5250006318092346, 0.20991608500480652, 0.22674934566020966, 0.06446121633052826, 0.3160902261734009, -0.16591902077198029, 0.29463282227516174, -0.4357188045978546, 0.2693236470222473, 0.2238888442516327, 0.07132857292890549, 0.7327232360839844, 0.11373110860586166], [0.5032402276992798, 0.15036073327064514, 0.056578390300273895, -0.31170347332954407, 0.03806397318840027, 0.11978171765804291, 0.12439731508493423, 0.3456485867500305, 0.040708497166633606, 0.2785942256450653, -0.31208693981170654, 0.029919849708676338, 0.04565741866827011, 0.059960417449474335, 0.4390542805194855, -0.28597506880760193, 0.01832461729645729, -0.14081625640392303, -0.05084190145134926, 0.07051662355661392, 0.06822775304317474, 0.25092801451683044, -0.3392323851585388, -0.03659543767571449, -0.30306896567344666, -0.07445868849754333, 0.12086895853281021, -0.10484049469232559], [-0.2005404531955719, 0.02430238574743271, -0.17728035151958466, 0.2547401487827301, 0.13510280847549438, -0.09725183248519897, -0.3216817080974579, -0.23469938337802887, -0.09717893600463867, 0.06986032426357269, 0.26376020908355713, 0.3085866868495941, -0.04330218955874443, -0.34234148263931274, 0.003499539103358984, -0.05953417718410492, 0.002738801995292306, 0.35827696323394775, 0.2433660328388214, -0.08015912026166916, -0.3261255919933319, -0.2302374690771103, 0.08953337371349335, 0.1939476728439331, 0.3617388904094696, -0.17898677289485931, -0.0025881731417030096, -0.21389879286289215], [0.2622033655643463, -0.3761916160583496, 0.17303678393363953, 0.3686636686325073, 0.0295136459171772, 0.285216748714447, 0.1522441804409027, 0.08468899875879288, -0.24254143238067627, 0.28468796610832214, 0.3222973048686981, 0.1716509610414505, 0.031056677922606468, 0.1155165433883667, 0.3847197890281677, -0.4019199311733246, 0.15523205697536469, 0.2058730572462082, -0.029129546135663986, -0.030692338943481445, 0.003213503398001194, 0.19470451772212982, -0.4859194755554199, 0.05117058753967285, 0.3693830966949463, 0.005652144551277161, 0.036869753152132034, -0.1298590749502182], [0.35722923278808594, -0.017309417948126793, 0.1492595374584198, 0.10978695005178452, -0.21750104427337646, 0.2341005951166153, 0.17904193699359894, 0.2988360822200775, -0.3098992705345154, 0.07114870846271515, 0.1098838597536087, -0.23544004559516907, 0.21334651112556458, -0.07109267264604568, 0.10383040457963943, -0.27122002840042114, 0.15366734564304352, -0.207123264670372, -0.21757711470127106, 0.45006299018859863, -0.103389210999012, 0.1532927304506302, -0.5887556672096252, -0.08840432018041611, 0.04388345777988434, 0.003899229923263192, 0.4838937222957611, 0.012188565917313099], [0.29198384284973145, 0.1451384574174881, 0.05433227866888046, -0.15047094225883484, 0.122083880007267, 0.18035267293453217, -0.11860287189483643, 0.30686718225479126, 0.1496473252773285, 0.11924027651548386, -0.21261674165725708, 0.043724425137043, 0.1463870257139206, -0.3326881527900696, 0.5011445879936218, 0.08961618691682816, 0.17205147445201874, -0.3594588339328766, -0.08076255023479462, 0.17170123755931854, -0.46866512298583984, 0.5754375457763672, 0.06811179965734482, -0.10231046378612518, -0.06593377888202667, -0.18514014780521393, 0.18441234529018402, -0.4264182448387146], [0.11143361032009125, -0.06264474987983704, 0.03106597810983658, -0.1465887874364853, -0.06025874987244606, -0.14546599984169006, -0.0072129350155591965, -0.19576247036457062, -0.07417470216751099, -0.16021624207496643, 0.11027012020349503, 0.13081200420856476, 0.06344391405582428, -0.12627024948596954, -0.11184775829315186, -0.08411257714033127, 0.03488237038254738, -0.11140580475330353, 0.156212717294693, -0.047153037041425705, 0.1609112024307251, -0.0324859693646431, 0.053650759160518646, 0.1184195950627327, 0.03519632667303085, -0.08251854032278061, 0.13359461724758148, -0.014945480972528458], [-0.13854926824569702, 0.4037461280822754, 0.17212150990962982, 0.32822179794311523, -0.08867407590150833, -0.1211894229054451, -0.021899040788412094, -0.2434326708316803, 0.400563508272171, -0.13641025125980377, 0.3844478726387024, 0.07123313844203949, -0.0857381671667099, 0.04843246564269066, -0.3935616910457611, 0.2047812044620514, 0.037000637501478195, 0.4000289738178253, -0.12643711268901825, 0.05290353298187256, -0.06698320806026459, -0.17784255743026733, 0.32515835762023926, 0.26593950390815735, 0.5950039029121399, -0.10247515887022018, -0.0832880288362503, -0.09656162559986115], [-0.11665236204862595, 0.5306445360183716, 0.36429885029792786, 0.22618471086025238, -0.14580048620700836, 0.30522871017456055, -0.03489033132791519, -0.240075945854187, 0.5670740008354187, 0.18540877103805542, 0.37362876534461975, -0.4281139075756073, 0.0843750387430191, -0.009302985854446888, 0.06408756226301193, 0.6021404266357422, 0.10337983071804047, 0.5408146381378174, -0.4949992597103119, -0.23651736974716187, 0.1043165773153305, 0.06590647250413895, 0.7744032144546509, 0.1664978712797165, 0.3337870240211487, -0.47952648997306824, -0.2745892405509949, 0.19282309710979462], [0.18590812385082245, 0.6854860186576843, 0.5403477549552917, 0.4044780433177948, -0.13337329030036926, -0.026910891756415367, 0.38103678822517395, 0.1879308670759201, 0.3725220561027527, 0.3269183039665222, 0.5576868653297424, -0.4188593626022339, -0.1930166631937027, 0.3685108721256256, 0.2660031318664551, 0.5199733376502991, 0.4156920909881592, 0.38950568437576294, -0.4507310390472412, 0.10246159881353378, 0.47698667645454407, 0.1511969417333603, 0.6384664177894592, 0.5905948281288147, 0.3771566152572632, -0.47858625650405884, -0.023255402222275734, 0.48096486926078796], [0.32559558749198914, 0.33350417017936707, 0.19198006391525269, -0.012471860274672508, -0.313782274723053, -0.034542515873909, 0.0010519640054553747, 0.3489457070827484, 0.22871793806552887, 0.2168542444705963, -0.33976298570632935, -0.13266173005104065, -0.17241549491882324, -0.1796426773071289, 0.473287433385849, 0.12933313846588135, 0.046575453132390976, -0.3194543421268463, -0.4085323214530945, -0.3046485483646393, -0.2640041410923004, 0.44527092576026917, 0.3331068456172943, 0.23750421404838562, -0.06412232667207718, -0.28362342715263367, -0.3893778920173645, -0.26656195521354675], [0.03418087586760521, -0.2188832312822342, 0.05578669160604477, 0.023047631606459618, 0.008974922820925713, 0.11982329189777374, -0.0745963528752327, -0.02661716938018799, -0.1372399628162384, 0.05933518707752228, 0.04677684232592583, 0.19514261186122894, 0.3077560067176819, -0.048168979585170746, -0.0878436416387558, -0.08458387106657028, 0.07145480066537857, -0.028443513438105583, 0.2120378315448761, 0.5164246559143066, -0.11651286482810974, 0.16225497424602509, -0.20211923122406006, 0.23048865795135498, 0.056393060833215714, -0.013010360300540924, 0.5123412013053894, 0.19885499775409698], [0.7058250308036804, 0.21011194586753845, 0.28926366567611694, -0.23453107476234436, -0.2694464921951294, -0.2725962996482849, -0.027689596638083458, 0.5279973745346069, 0.4355294704437256, 0.14478637278079987, -0.29693734645843506, -0.11302447319030762, -0.2582399845123291, -0.03135134279727936, 0.7841838002204895, 0.24965651333332062, 0.2522657513618469, -0.22443655133247375, -0.09980906546115875, -0.4209269881248474, 0.15878082811832428, 0.5332844257354736, 0.20593293011188507, 0.10664281994104385, -0.45410817861557007, -0.07572764158248901, -0.3393193483352661, -0.03469190374016762], [0.3952185809612274, 0.2294153869152069, 0.24185435473918915, 0.11905322223901749, 0.17475451529026031, 0.28244104981422424, 0.17769132554531097, 0.2599668800830841, 0.245887890458107, 0.30908700823783875, -0.06683855503797531, 0.025317128747701645, 0.18972787261009216, 0.3860943615436554, 0.2920815348625183, 0.3126358091831207, 0.15314964950084686, 0.03934599086642265, 0.16718710958957672, 0.36178725957870483, 0.08093169331550598, 0.09984974563121796, 0.45549336075782776, 0.22525495290756226, 0.18643002212047577, 0.07335150986909866, 0.1728791892528534, 0.09586617350578308], [-0.16617968678474426, -0.27152466773986816, 0.12433131039142609, 0.41228869557380676, 0.12116755545139313, 0.23695313930511475, 0.007478618063032627, 0.08964112401008606, -0.12152134627103806, 0.023914935067296028, 0.36910951137542725, 0.04448031261563301, 0.28430894017219543, 0.22712816298007965, -0.052096616476774216, -0.4642567038536072, 0.10796624422073364, 0.4057352542877197, 0.2207196056842804, 0.2279973179101944, 0.30675604939460754, 0.15450701117515564, -0.5286017060279846, 0.1250268667936325, 0.2755231559276581, 0.09182539582252502, 0.2912401854991913, 0.0715678408741951]], [[0.7033746242523193, 0.9434632062911987, -0.40413931012153625, 0.6279094219207764, 0.1745762676000595, 0.9096519351005554, 0.37591588497161865, 0.6591343879699707, 0.1707695573568344, 0.5205366015434265, 0.22830215096473694, -0.155758336186409, 0.10962078720331192, -0.29535698890686035, 0.63606196641922, 0.257159560918808, 0.7055010199546814, 0.7361194491386414, 0.39075472950935364, 0.680811882019043]]),
([[-0.010518630966544151, -0.15557187795639038, -0.5092333555221558, 0.04357820004224777, -0.14313320815563202, -0.08850971609354019, 0.22710150480270386, 0.05766455829143524, -0.02575652115046978, 0.015090357512235641, -0.17660601437091827, 0.17229269444942474, 0.0012419970007613301, 0.28676584362983704, -0.28436923027038574, 0.0734902173280716, -0.12250504642724991, 0.05935968458652496, -0.07256115972995758, 0.14431880414485931], [0.38383352756500244, 0.3086051046848297, -0.7501294612884521, 0.12121357023715973, 0.46666258573532104, 0.4658176302909851, 0.4335106611251831, 0.11963394284248352, 0.5425214767456055, 0.7046931385993958, 0.29249098896980286, -0.07110556960105896, -0.33901533484458923, -0.6155950427055359, -0.13346850872039795, 0.023541849106550217, 0.3436160683631897, 0.15236443281173706, -0.24935857951641083, 0.24555295705795288], [0.08185451477766037, 0.17747385799884796, -1.1694390773773193, 0.1529049575328827, -0.18054957687854767, 0.25375786423683167, -0.0843994989991188, -0.10374952852725983, -0.4755125343799591, 0.1093088835477829, -0.024957014247775078, -0.11853229999542236, 0.29386818408966064, -0.523307204246521, -0.08230239152908325, -0.015489103272557259, 0.1222115159034729, 0.14111554622650146, 0.37351539731025696, -0.0700128823518753], [-0.10272867232561111, -0.013624311424791813, -0.3247055113315582, 0.09553784132003784, 0.46671417355537415, 0.0674499124288559, 0.36679166555404663, 0.22147147357463837, -0.13729852437973022, 0.09691701084375381, 0.48909851908683777, -0.17425033450126648, -0.374805212020874, -0.33161717653274536, 0.286513090133667, 0.6067029237747192, 0.2296762466430664, 1.0045726299285889, -0.09905479103326797, 0.028462829068303108]], [[0.31249481439590454, 0.06846972554922104, 0.4347860515117645, 0.31823664903640747]]),
]


def forward(vals):
    x = nn.linear(vals, WEIGHTS[0])
    nn.relu(x)
    x = nn.linear(x, WEIGHTS[1])
    nn.tanh(x)
    return x


def l1():
    v = [[0.0]]*28
#    x = nn.linear(v, WEIGHTS[0])
    a = nn.matmul(WEIGHTS[0][0], v)
    print("int: (%d, %d)" % (len(a), len(a[0])))
    nn.matadd_t(a, WEIGHTS[0][1])
    print("out: (%d, %d)" % (len(a), len(a[0])))
    return a



def show():
    for idx, (w, b) in enumerate(WEIGHTS):
        print("Layer %d:" % (idx+1))
        print("W: (%d, %d), B: (%d, %d)" % (len(w), len(w[0]), len(b), len(b[0])))


if __name__ == "__main__":
    x = [0.0] * 28
    y = forward(x)
    print(y.shape)
    print(y)
