from . import nn

WEIGHTS = [
([[0.0795864388346672, 0.6220458745956421, 0.16459907591342926, 0.48789817094802856, -0.2514527440071106, 0.41005340218544006, -0.007596954703330994, -0.03288897126913071, 0.7055543661117554, 0.19488954544067383, 0.4491203725337982, -0.09710922837257385, 0.0662911981344223, -0.027570486068725586, -0.376819908618927, 0.6167910695075989, 0.2373562604188919, 0.47621795535087585, -0.33827242255210876, -0.15099173784255981, 0.07477889955043793, -0.5267210006713867, 0.4488089084625244, 0.3263770639896393, 0.46579188108444214, -0.25400063395500183, -0.09988318383693695, 0.16664503514766693], [0.31498652696609497, -0.3235093355178833, 0.09763272106647491, 0.24767063558101654, -0.01522316224873066, -0.2302473485469818, 0.004309728741645813, 0.10305731743574142, -0.14307178556919098, 0.4094468057155609, -0.042085498571395874, 0.08789858222007751, -0.11958332359790802, -0.04631122946739197, 0.3224699795246124, -0.6287879347801208, 0.09189949929714203, 0.2015620619058609, 0.12980873882770538, 0.12635751068592072, 0.11869363486766815, 0.4285820424556732, -0.7736364603042603, 0.20051026344299316, -0.07987309992313385, 0.25081315636634827, 0.037187036126852036, -0.08822496980428696], [0.3053126037120819, 0.2638111710548401, 0.5373770594596863, 0.7034116983413696, 0.021708771586418152, -0.40985071659088135, -0.056958019733428955, 0.20617756247520447, 0.03994019702076912, 0.31823647022247314, 0.730002760887146, 0.37115785479545593, -0.009194375947117805, -0.07080264389514923, 0.4038635194301605, 0.04702833667397499, 0.5582652688026428, 0.582360565662384, 0.04175356402993202, 0.7577227354049683, -0.03696456551551819, 0.5383423566818237, -0.36359331011772156, 0.3273000419139862, 0.6388891339302063, -0.14476457238197327, 0.921776294708252, -0.11835681647062302], [-0.060517311096191406, 0.40522655844688416, 0.3084459900856018, -0.33782684803009033, -0.2559860348701477, 0.15606023371219635, -0.07493890821933746, -0.026330996304750443, 0.5698626637458801, 0.14125749468803406, -0.3111238479614258, -0.24434106051921844, -0.15256983041763306, 0.10613323748111725, -0.055369339883327484, 0.7392929196357727, 0.16254642605781555, -0.13292422890663147, -0.2947504222393036, -0.7537380456924438, -0.14674341678619385, -0.306328684091568, 0.6435878276824951, -0.0467350147664547, -0.335282564163208, 0.03673601150512695, -1.0972613096237183, -0.08363623917102814], [0.6004171967506409, 0.2483183890581131, -0.04082616791129112, 0.33524852991104126, 0.30383408069610596, -0.05079421401023865, -0.18023112416267395, 0.5845444202423096, 0.13768361508846283, 0.16646762192249298, 0.6553613543510437, 0.3373264968395233, -0.39919212460517883, 0.04816064238548279, 0.7567908763885498, 0.5850582122802734, 0.25414979457855225, 0.7041230797767639, 0.2987029254436493, -0.2837292551994324, -0.10315773636102676, 0.6287373304367065, 0.9642311930656433, 0.015851838514208794, 0.7134129405021667, 0.5671366453170776, -0.48965007066726685, -0.13810822367668152], [0.057632140815258026, 0.5078854560852051, 0.42328718304634094, -0.11146080493927002, -0.046563245356082916, 0.020299851894378662, -0.17059177160263062, 0.12097615748643875, 0.35973459482192993, 0.39673763513565063, -0.26576247811317444, -0.28996047377586365, -0.15810881555080414, 0.03868512809276581, -0.0015129833482205868, 0.5721495151519775, 0.19083799421787262, -0.1107289269566536, 0.021212631836533546, -0.8358098864555359, 0.09443129599094391, -0.13633009791374207, 0.7196343541145325, 0.08875413239002228, -0.36689212918281555, -0.10087832063436508, -1.0833368301391602, -0.06461264193058014], [0.38336822390556335, 0.04082649201154709, 0.262453556060791, 0.8287098407745361, -0.035090770572423935, -0.15043650567531586, -0.06847216933965683, 0.48442307114601135, 0.058172132819890976, 0.38246282935142517, 0.78963303565979, 0.25626739859580994, 0.16508819162845612, -0.17207662761211395, 0.5506955981254578, -0.2597743570804596, 0.5130721926689148, 0.6636102199554443, 0.25006765127182007, 0.6545578241348267, 0.13088612258434296, 0.8130273818969727, -0.056654348969459534, 0.3900440037250519, 0.7657056450843811, -0.01661035604774952, 0.9088466167449951, 0.003918781876564026], [0.29860720038414, -0.071216881275177, 0.3418969511985779, -0.185587540268898, 0.11573567241430283, -0.2577245831489563, -0.04535961151123047, 0.13764312863349915, -0.05311749875545502, 0.4750259816646576, -0.12775687873363495, 0.4021986424922943, -0.26158392429351807, -0.06338348984718323, 0.3121364414691925, -0.17570629715919495, 0.49143466353416443, -0.47283637523651123, 0.49724075198173523, -0.5660260319709778, -0.1554899513721466, 0.3560648560523987, -0.20380240678787231, 0.1715783327817917, -0.29460880160331726, 0.774624764919281, -0.9249067902565002, -0.015496999025344849], [-0.08719806373119354, 0.20775045454502106, 0.13558806478977203, 0.008371253497898579, -0.3336522579193115, 0.1314706653356552, 0.0013502687215805054, -0.03270426020026207, 0.4979735016822815, 0.009797604754567146, -0.0060788230039179325, -0.5065374374389648, -0.07028940320014954, 0.058293119072914124, 0.0796317532658577, 0.9412975907325745, 0.13961613178253174, 0.02362648770213127, -0.28224870562553406, -0.8950240612030029, 0.13441120088100433, -0.1163375973701477, 0.6851327419281006, 0.204332172870636, -0.007908846251666546, -0.18260473012924194, -1.2202973365783691, 0.17076490819454193], [-0.2728287875652313, 0.5264778733253479, 0.3011745512485504, -0.11219605803489685, -0.4351641833782196, 0.1927759349346161, -0.18317145109176636, -0.07322698831558228, 0.4922437071800232, 0.4444698691368103, 0.1440735161304474, -0.1657448261976242, -0.09166447818279266, 0.016683146357536316, -0.3250236511230469, 1.0558286905288696, 0.3631677031517029, -0.041763029992580414, -0.20319333672523499, -0.7634598612785339, 0.11281745135784149, -0.1445278823375702, 1.1717102527618408, 0.2966689169406891, 0.2970125675201416, -0.09679537266492844, -1.1552503108978271, 0.13483722507953644], [-0.17451907694339752, 0.34340861439704895, 0.6770063638687134, 0.25085940957069397, -0.5023239254951477, 0.5458947420120239, 0.09442101418972015, -0.11040636897087097, 0.8294175267219543, 0.2899402678012848, 0.08632153272628784, -0.2938114404678345, -0.11623216420412064, -0.03311707079410553, -0.2391219586133957, 0.8716988563537598, 0.5426673889160156, 0.47864049673080444, -0.1415175348520279, -0.5177613496780396, 0.110467329621315, -0.2876891791820526, 0.8565915822982788, 0.38436850905418396, 0.596584677696228, -0.05855275318026543, -0.7303112745285034, 0.07455818355083466], [0.12897883355617523, 0.19144080579280853, 0.276524156332016, -0.23115219175815582, 0.3021802604198456, -0.5967273712158203, 0.09764645993709564, -0.009297945536673069, 0.15126392245292664, 0.48555684089660645, -0.24645934998989105, 0.18392053246498108, -0.5514062643051147, 0.1736975759267807, 0.3270495533943176, -0.4129987359046936, 0.3456943929195404, -0.4832666516304016, 0.0952548235654831, -0.32046008110046387, 0.1653233915567398, 0.1564076840877533, -0.6698357462882996, 0.5474430918693542, -0.40592852234840393, -0.12147996574640274, -0.36332279443740845, 0.1673494130373001], [0.36855271458625793, 0.4164904057979584, 0.43400198221206665, -0.5900910496711731, 0.10503070056438446, -0.7802550196647644, 0.1101917177438736, 0.27600371837615967, 0.2990362048149109, 0.00881485641002655, -0.6046234965324402, 0.009357825852930546, -0.7840020060539246, -0.16577841341495514, 0.03360820934176445, -0.0905204638838768, 0.1514107882976532, -0.6775038838386536, 0.13068212568759918, -0.8493186235427856, -0.08528230339288712, 0.22474122047424316, -0.14281921088695526, 0.12388913333415985, -0.6446372866630554, 0.11654640734195709, -0.9653835296630859, -0.003991767764091492], [0.2973892390727997, -0.014082410372793674, 0.07609871029853821, 0.043492697179317474, 0.12375259399414062, -0.7023582458496094, 0.010507121682167053, -0.06361579149961472, -0.14089830219745636, 0.2398725003004074, -0.11761868745088577, -0.03600797802209854, -0.42898374795913696, -0.08989623934030533, 0.16945675015449524, -0.4929197132587433, 0.10384847223758698, -0.19749552011489868, -0.24602706730365753, 0.22175495326519012, 0.0783299058675766, 0.032325759530067444, -0.744479775428772, 0.27307218313217163, -0.44306308031082153, -0.4377702474594116, 0.27628183364868164, 0.17075885832309723], [-0.4356793463230133, 0.4241751730442047, 0.474990576505661, 0.11049920320510864, 0.47223612666130066, 0.10238243639469147, 0.09632395207881927, -0.5011909008026123, 0.1900816410779953, 0.2677564322948456, 0.20426809787750244, 0.4377695620059967, -0.3803710341453552, -0.0973762646317482, -0.45979607105255127, 0.1322331726551056, 0.31577855348587036, -0.1333141028881073, 0.6076257824897766, -0.8032331466674805, -0.11613254249095917, -0.28611066937446594, -0.25491321086883545, 0.26548895239830017, 0.04568847268819809, 0.6510814428329468, -1.1084585189819336, 0.09146995842456818], [0.6910329461097717, 0.35316768288612366, 0.11655674129724503, 0.4864392876625061, 0.1308748424053192, -0.22648853063583374, 0.018927395343780518, 0.8109742999076843, 0.5645789504051208, 0.3690880537033081, 0.5454884767532349, 0.1145043596625328, 0.11448515206575394, 0.08141769468784332, 0.8060840964317322, 0.6112298965454102, 0.3642599880695343, 0.7366331815719604, 0.21370625495910645, 0.08406336605548859, -0.012462139129638672, 0.6553290486335754, 1.1943905353546143, 0.3453582227230072, 0.6450939774513245, 0.272566020488739, 0.0936489850282669, 0.18023847043514252], [-0.05911282077431679, 0.4257689416408539, -0.00032925064442679286, -0.06270977109670639, -0.34904828667640686, 0.3569059371948242, -0.009937480092048645, 0.3456089496612549, 0.3576214015483856, -0.0332644097507, -0.05526009947061539, -0.3289415240287781, -0.16415010392665863, -0.02918405830860138, -0.007544004358351231, 0.7975393533706665, 0.1653589904308319, 0.019085675477981567, 0.11622605472803116, -0.7207448482513428, -0.1850740909576416, 0.12591226398944855, 1.0520013570785522, 0.0887853279709816, 0.17286254465579987, 0.031637877225875854, -1.1456339359283447, -0.10811318457126617], [-0.24807289242744446, 0.1065991073846817, 0.7840144038200378, 0.10322616249322891, -0.17306692898273468, -0.0039510102942585945, -0.047050848603248596, -0.3663134276866913, 0.23625758290290833, 0.5954132676124573, 0.21573251485824585, -0.3268932104110718, -0.014071706682443619, 0.1876695305109024, -0.14185017347335815, -0.3524211049079895, 0.5318851470947266, 0.1785617172718048, -0.1175420731306076, -0.25411516427993774, 0.02626986801624298, -0.07887071371078491, -0.7804931402206421, 0.5365119576454163, 0.24032236635684967, -0.13688547909259796, -0.32531699538230896, 0.1370752602815628], [0.26863834261894226, 0.3971768617630005, 0.2291879504919052, -0.38864490389823914, 0.11042538285255432, -0.48335596919059753, -0.10010022670030594, 0.040677424520254135, 0.25177282094955444, 0.21196117997169495, -0.8542982339859009, 0.3249864876270294, -0.892350435256958, -0.05544719099998474, 0.14297327399253845, 0.3900453448295593, 0.1536770612001419, -0.6304457187652588, 0.17063862085342407, -1.110458254814148, -0.09587620943784714, 0.13631954789161682, -0.05976902320981026, 0.0711284726858139, -0.7428408861160278, 0.08094330877065659, -1.3836864233016968, 0.11292822659015656], [0.7695018649101257, 0.25965040922164917, -0.0074859377928078175, 0.17304910719394684, 0.2742516100406647, -0.2470092624425888, -0.0063362568616867065, 0.7854534983634949, 0.4278157353401184, -0.13657832145690918, 0.08820098638534546, 0.34854355454444885, -0.1928568184375763, -0.18578393757343292, 0.8045535087585449, 0.3768100440502167, -0.25619059801101685, 0.15133783221244812, -0.02153296023607254, -0.054822761565446854, -0.13428828120231628, 0.7167395949363708, 0.7561154365539551, -0.07026118785142899, 0.1377721130847931, -0.16597330570220947, 0.011017348617315292, 0.07789348065853119]], [[0.22734469175338745, 0.48722535371780396, 0.8788021802902222, 0.07509312778711319, -0.18204304575920105, -0.16065607964992523, 0.5965179800987244, 0.6753429174423218, -0.06497012078762054, 0.005162189248949289, 0.13223277032375336, 1.3986711502075195, 1.1949139833450317, 1.5587407350540161, 0.6566222906112671, -0.3129309117794037, -0.14916659891605377, 1.2632114887237549, 0.9307553172111511, 0.5221524834632874]]),
([[1.0731045007705688, -0.6817619204521179, -0.307602196931839, 0.46944475173950195, -0.2220783680677414, 0.33150461316108704, -0.33884334564208984, -0.5945377945899963, 0.6578924655914307, 0.3583754599094391, 0.49982497096061707, -0.22615087032318115, -0.2280937135219574, 0.22021758556365967, -0.0987841859459877, -0.33615344762802124, 0.05493680387735367, 0.3099276125431061, -0.126600444316864, -0.08762075752019882], [-0.2308676391839981, 0.5507097244262695, 0.21208080649375916, -0.24325399100780487, -0.2311481386423111, -0.4586877226829529, 0.3092144727706909, 0.27391189336776733, -0.3099513351917267, -0.37270161509513855, -0.1866384744644165, 0.7885584235191345, 0.6746284365653992, 0.7888086438179016, 0.4464649260044098, -0.350483238697052, -0.42386898398399353, 0.6437849998474121, 0.7107665538787842, -0.1536024510860443], [0.2757815420627594, -0.2025955766439438, 0.17394770681858063, -0.09156918525695801, -0.41590845584869385, -0.4391568899154663, 0.013611074537038803, -0.3062203824520111, -0.499551385641098, -0.32551103830337524, -0.14919538795948029, 0.4501836597919464, 0.333217978477478, 0.5779018998146057, -0.2154553085565567, -0.2866958975791931, -0.6189046502113342, 0.3555482029914856, -0.014679030515253544, -0.038156524300575256], [-0.20655089616775513, 0.19833844900131226, -0.10367564857006073, 0.34149056673049927, -0.12707538902759552, 0.3402027487754822, -0.20403678715229034, 0.16965512931346893, 0.08123668283224106, -0.1373990923166275, -0.24863973259925842, 0.4845249056816101, 0.6121570467948914, 0.5436928868293762, -0.029168007895350456, -0.18447373807430267, 0.07768438011407852, -0.055463045835494995, 0.6878474354743958, 0.20771312713623047]], [[0.1947849541902542, 0.3619373142719269, 0.19176222383975983, 0.007840010337531567]]),
]


def forward(x):
    x = nn.linear(x, WEIGHTS[0])
    x = nn.relu(x)
    x = nn.linear(x, WEIGHTS[1])
    x = nn.tanh(x)
    return x


def test():
    x = [[0.0]] * 28
    y = forward(x)
    print(y)
    
    
def show():
    for idx, (w, b) in enumerate(WEIGHTS):
        print("Layer %d:" % (idx+1))
        print("W: (%d, %d), B: (%d, %d)" % (len(w), len(w[0]), len(b), len(b[0])))

