#!/bin/bash

# Skrypt randomquote wybierający losowo z pliku jeden wiersz i wyświetlający
# go na stronie. Skrypt najlepiej jest wywoływać za pomocą funkcji SSI.

awkscript="/tmp/randomquote.awk.$$"

if [ $# -ne 1 ] ; then
  echo "Użycie: randomquote nazwa_pliku" >&2
  exit 1
elif [ ! -r "$1" ] ; then
  echo "Błąd: plik $1 nie istnieje lub nie można go odczytać." >&2
  exit 1
fi

trap "$(which rm) -f $awkscript" 0

cat << "EOF" > $awkscript
BEGIN { srand() }
      { s[NR] = $0 } 
END   { print s[randint(NR)] } 
function randint(n) { return int (n * rand() ) + 1 }
EOF

awk -f $awkscript < "$1"

exit 0
