define(['apple-home.tpl','apple-item.view'],function(appleHomeTpl,appleItemView){
return  Backbone.View.extend({
      el: 'body',
      listEl: '.apples-list',
      cartEl: '.cart-box',
      template: _.template(appleHomeTpl),
      initialize: function() {
        this.$el.html(this.template);
        this.collection.on('addToCart', this.showCart, this);
      },
      showCart: function(appleModel) {
        $(this.cartEl).append(appleModel.attributes.name+'<br/>');
      },      
      render: function(){
        view = this; // To pozwala na użycie widoku w domknięciu.
        this.collection.each(function(apple){
          var appleSubView = new appleItemView({model:apple}); // Utworzenie podwidoku wraz z modelem.
          appleSubView.render(); // Kompilacja szablonu i pojedynczego elementu danych.
          $(view.listEl).append(appleSubView.$el);   // Dołączenie obiektu jQuery z pojedynczego elementu do elementu w modelu DOM o klasie apples-list.
        });
      }


    });
})
