/*
  MotionCam Class v1.2
  29 Pa 2002
  (c) 2002 Robert Penner
  
  Kopia MotionCam potrafi nagrywa kolejne wartoci wybranej waciwoci
  do wasnego "filmu". Nastpnie mone odtworzy te same wartoci dla
  innej waciwoci lub tego samego "aktora".
  
  Zalenoci: 
  - Klasa Motion 
  - Object.superCon() (z core_setup.as)
  - Function.extend() (z core_setup.as)
  
  Zdarzenia:
  
  	onMotionChanged
  	onMotionFinished
  	onMotionLooped
  	onMotionStarted
  	onMotionStopped
  	onMotionResumed

*/ 
  
if (typeof _global.Motion != 'function') trace (">> Bd: brak klasy bazowej - Motion");
if (typeof Object.superCon != 'function') trace (">> Bd: brak Object.superCon() (core_setup.as)");
 
///////////////////////////////////////////////////////////////////

_global.MotionCam = function (obj, prop, duration) {
	this.superCon (obj, prop, obj[prop], duration);
	this.setActor (obj, prop);
	this.film = [];
};

MotionCam.extend (Motion);

var MCP = MotionCam.prototype;


///////// metody publiczne

MCP.startRecord = function () {
	this.isRecording = true;
};

MCP.stopRecord = function () {
	this.isRecording = false;
};

MCP.cutFilm = function (t) {
	if (t == undefined) var t = this.$time;
	this.film.length = t + 1;
	this.setDuration (t);
};

MCP.eraseFilm = function () {
	this.film = [];
	this.setDuration (0);
};

MCP.toString = function () {
	return "[MotionCam prop=" + this.$prop + " t=" + this.$time + 
		" pos=" + this.$position + " mode: " + this.mode + "]";
};

MCP.print = function () {
	trace (this.getFilmString());
};


////////// metody ustawiania i pobierania

// overrides abstract method Motion.getPosition()
MCP.getPosition = function (t) {
	if (t == undefined) t = this.$time;
	return this.film[t];
};

MCP.setActorObj = function (ao) {
	this.actorObj = ao;
};

MCP.getActorObj = function () {
	return this.actorObj;
};

MCP.setActorProp = function (ap) {
	this.actorProp = ap;
};

MCP.getActorProp = function () {
	return this.actorProp;
};

MCP.setActor = function (ao, ap) {
	this.setActorObj (ao);
	this.setActorProp (ap);
};

MCP.setFilm = function (film_arr) {
	this.film = film_arr;
};

MCP.getFilm = function () {
	return this.film;
};

MCP.setFilmString = function (str) {
	this.film = str.split (",");
};

MCP.getFilmString = function () {
	return this.film.toString();
};


////////////// metody prywatne

// overrides Motion.update()
MCP.update = function () {
	if (this.isRecording) 
		with (this) film[$time] = actorObj[actorProp];
	super.update();
};


delete MCP;

trace (">> wczytano klas MotionCam");


 ////////////////// koniec klasy MotionCam //////////////////////////////////////


