/*
  PhysicsParticle Class v1.1
  29 Pa 2002
  (c) 2002 Robert Penner
  
  Wasna klasa sterujca klipen filmowym i zamieniajca go w  
  czsteczk sterowan siami. 
  Zaprojektowane do wsppracy z klas Force (i jej klasami pochodnymi).
  
  Zalenoci: 
  - Klasa Vector 
  - MovieClip.addListener() (z core_setup.as)

*/

if (typeof _global.Vector != 'function') trace (">> Bd: brak wymaganej klasy - Vector");

_global.PhysicsParticle = function (target, x, y, xProp, yProp) {
	this.target = target;
	this.pos = new Vector (x, y);
	this.vel = new Vector (0, 0);
	this.accel = new Vector (0, 0);
	this.friction = new Vector (0, 0);
	this.setXYProps (xProp, yProp);
	this.forces = {};
	MovieClip.addListener (this);
};

var PPP = PhysicsParticle.prototype;

//////// metody publiczne

PPP.addForce = function (id_str, force_obj) {
	this.forces[id_str] = force_obj;
	force_obj.setParent (this);
};

PPP.removeForce = function (id_str) {
	delete this.forces[id_str];
};

//////// metody ustawiania i pobierania

PPP.setPosition = function (x, y) {
	this.pos.reset (x, y);
};

PPP.getPosition = function () {
	return this.pos;
};

PPP.setFriction = function (fx, fy) {
	if (fy == undefined) fy = fx;
	this.friction.reset (fx, fy);
};

PPP.getFriction = function () {
	return this.friction;
};

PPP.setXYProps = function (xp, yp) {
	this.xProp = (xp == undefined) ? "_x" : xp;
	this.yProp = (yp == undefined) ? "_y" : yp;
};


//////// metody prywatne

PPP.move = function () {
	var forceX = 0, forceY = 0;
	var fs = this.forces;
	for (var i in fs) {
		if (!fs[i].live()) {
			delete fs[i];
		} else {
			forceX += fs[i].value.x;
			forceY += fs[i].value.y;
		}
	}	
	this.accel.reset (forceX, forceY);
	var v = this.vel;
	v.plus (this.accel);
	v.x *= (1 - this.friction.x);
	v.y *= (1 - this.friction.y);
	this.pos.plus (v);
	this.render();
};

PPP.render = function () {
	this.target[this.xProp] = this.pos.x;
	this.target[this.yProp] = this.pos.y;
};

PPP.onEnterFrame = PPP.move;

delete PPP;

trace (">> wczytano klas PhysicsParticle");

