/*
  ElasticForce Class v1.1
  29 Pa 2002
  (c) 2002 Robert Penner
  
  Wasna klasa implementujca si sprystoci zgodn z prawem Hooke'a. 
  Zaprojektowana do wsppracy z klas PhysicsParticle.
  
  Zalenoci: 
  - Klasa Force
  - Function.extend() i Object.superCon() (z core_setup.as)

*/


if (typeof _global.Force != 'function') trace (">> Bd: brak klasy bazowej - Force");
if (typeof Object.superCon != 'function') trace (">> Bd: brak Object.superCon() (core_setup.as)");

_global.ElasticForce = function (anchorX, anchorY, tautness, life) {
    this.superCon (0, 0, life);
    this.$anchor = new Vector (anchorX, anchorY);
    this.$tautness = tautness;
};

ElasticForce.extend (Force);

var EFP = ElasticForce.prototype;


////////// metody ustawiania i pobierania

EFP.setAnchor = function (x, y) {
    this.$anchor.reset (x, y);
};

EFP.getAnchor = function () {
    return this.$anchor;
};

EFP.setTautness = function (t) {
    this.$tautness = t;
};

EFP.getTautness = function () {
    return this.$tautness;
};


////////// metody prywatne 

EFP.update = function () {
    with (this) {
        $value = parentPos.minusNew ($anchor);
        $value.scale (-$tautness);
    }
};

with (EFP) {
    addProperty ("tautness", getTautness, setTautness);
    addProperty ("anchor", getAnchor, null);
}

delete EFP;

trace (">> wczytano klas ElasticForce");