/*
  Zestaw narzdzi dla kolorw v1.2
  29 Pa 2002
  (c) 2002 Robert Penner
  
  
  waciwoci ustawiania i pobierania klipu filmowego:
 	
 		_brightness
 		_brightOffset
 		_negativeColor

		_rgb 		
 		_red
 		_green
 		_blue
 		
 		_redPercent
 		_greenPercent
 		_bluePercent
 		
 		_redOffset
 		_greenOffset
 		_blueOffset
   
   
  Metody Color:
  
  		setRGB2()
  		getRGB2()
   		reset()
 
  		setBrightness()
  		getBrightness()
  		setBrightOffset()
  		getBrightOffset()  		
  		
  		setTint()
  		getTint()
  		setTint2()
  		getTint2()
  		setTintOffset()
  		getTintOffset()
  		
  		setRed()
  		getRed()
  		setGreen()
  		getGreen()
  		setBlue()
  		getBlue()
  		
  		setRedPercent()
  		getRedPercent()
  		setGreenPercent()
  		getGreenPercent()
  		setBluePercent()
  		getBluePercent()
  		
  		setRedOffset()
  		getRedOffset()
  		setGreenOffset()
  		getGreenOffset()
  		setBlueOffset()
  		getBlueOffset()
  		
  		invert()
  		setNegative()
  		getNegative()
 
 	Metody MovieClip:
 		
   		setRGB()
  		getRGB()
   		setRGB2()
  		getRGB2()
   		resetColor()
  		setColorTransform()
  		getColorTransform()

 		setBrightness()
  		getBrightness()
  		setBrightOffset()
  		getBrightOffset()  		
  		
  		setTint()
  		getTint()
  		setTint2()
  		getTint2()
  		setTintOffset()
  		getTintOffset()
  		
  		setRed()
  		getRed()
  		setGreen()
  		getGreen()
  		setBlue()
  		getBlue()
  		
  		setRedPercent()
  		getRedPercent()
  		setGreenPercent()
  		getGreenPercent()
  		setBluePercent()
  		getBluePercent()
  		
  		setRedOffset()
  		getRedOffset()
  		setGreenOffset()
  		getGreenOffset()
  		setBlueOffset()
  		getBlueOffset()
  		
  		invertColor()
  		setNegativeColor()
		getNegativeColor()

*/


// --------------------------------------------------------
// ====== jednolite kolory - metody Color ======

Color.prototype.setRGBStr = function (hexStr) {
	// pobierz ostatnie sze znakw tekstu
	hexStr = hexStr.substr (-6, 6);
	this.setRGB (parseInt (hexStr, 16));
}; 

Color.prototype.getRGBStr = function () {
	var hexStr = this.getRGB().toString(16);
	// wypenij zerami, gdy konieczne
	var toFill = 6 - hexStr.length;
	while (toFill--) hexStr = "0" + hexStr;
	return hexStr.toUpperCase();
};

// ustaw czerwowny, zielony i niebieski narmalnymi wartociami
// r, g, b midzy 0 a 255 
Color.prototype.setRGB2 = function (r, g, b) {
	this.setRGB (r << 16 | g << 8 | b);
}; // Branden Hall - www.figleaf.com

// zwraca obiekt z waciwociami r, g i b 
Color.prototype.getRGB2 = function () {
	var t = this.getTransform();
	return {r:t.rb, g:t.gb, b:t.bb};
};

// ustawia kolor obiektu na pocztkowy
Color.prototype.reset = function () {
	this.setTransform ({ra:100, ga:100, ba:100, rb:0, gb:0, bb:0});
};


// --------------------------------------------------------
// ====== jednolity kolor - metody MovieClip ======

MovieClip.prototype.setRGB = function (col) {
	(new Color(this)).setRGB (col);
}; 

MovieClip.prototype.getRGB = function () {
	return (new Color(this)).getRGB();
};

MovieClip.prototype.setRGBStr = function (hexStr) {
	(new Color(this)).setRGBStr (hexStr);
}; 

MovieClip.prototype.getRGBStr = function () {
	return (new Color(this)).getRGBStr();
};

// ustaw czerwowny, zielony i niebieski narmalnymi wartociami
// r, g, b midzy 0 a 255 
MovieClip.prototype.setRGB2 = function (r, g, b) {
	(new Color(this)).setRGB2 (r, g, b);
}; 

// zwraca obiekt z waciwociami r, g i b 
MovieClip.prototype.getRGB2 = function () {
	return (new Color(this)).getRGB2();
};

// przywraca oryginalne kolory
MovieClip.prototype.resetColor = function () {
	(new Color(this)).reset();
};


// --------------------------------------------------------
// ====== przeksztacenia koloru - metody MovieClip ======

MovieClip.prototype.setColorTransform = function (trans) {
	(new Color(this)).setTransform (trans);
};

MovieClip.prototype.getColorTransform = function () {
	return (new Color(this)).getTransform();
};




// --------------------------------------------------------
// ====== jasno - metody Color ======

// rozjania jak Property Inspector
// bright midzy -100 a 100
Color.prototype.setBrightness = function (bright) {
	var trans = this.getTransform();
	with (trans) {
		ra = ga = ba = 100 - Math.abs (bright); // warto procentowa 
		rb = gb = bb = (bright > 0) ? bright * (256/100) : 0; // offset koloru
	}
	this.setTransform (trans);
};

Color.prototype.getBrightness = function () {
	var trans = this.getTransform();
	with (trans) return rb ? 100 - ra : ra - 100;
};


// ====== jasno - metody MovieClip ======

// rozjania jak Property Inspector
// bright midzy -100 a 100
MovieClip.prototype.setBrightness = function (bright) {
	(new Color(this)).setBrightness (bright);
};

MovieClip.prototype.getBrightness = function () {
	return (new Color(this)).getBrightness();
};

// --------------------------------------------------------
// ====== jasno offsetem - metody Color ======

// offset midzy -255 a 255
Color.prototype.setBrightOffset = function (offset) {
	var trans = this.getTransform()
	with (trans) rb = gb = bb = offset;
	this.setTransform (trans);
};

Color.prototype.getBrightOffset = function () {
	return this.getTransform().rb;
};

// ====== jasno offsetem - metody MovieClip ======

// offset between -255 and 255
MovieClip.prototype.setBrightOffset = function (offset) {
	(new Color(this)).setBrightOffset (offset);
};

MovieClip.prototype.getBrightOffset = function () {
	return (new Color(this)).getBrightOffset();
};


// --------------------------------------------------------
// ====== zabarwienie - metody Color ======

// dziaa jak Tint w Property Inspector
// r, g, b midzy 0 a 255; percent midzy 0 i 100
Color.prototype.setTint = function (r, g, b, percent) {
	var ratio = percent / 100;
	var trans = {rb:r*ratio, gb:g*ratio, bb:b*ratio};
	trans.ra = trans.ga = trans.ba = 100 - percent;
	this.setTransform (trans);
};

// zwraca obiekt zawierajcy waciwoci r, g, b i percent
Color.prototype.getTint = function () {
	var trans = this.getTransform();
	var tint = {percent: 100 - trans.ra};
	var ratio = 100 / tint.percent;
	tint.r = trans.rb * ratio;
	tint.g = trans.gb * ratio;
	tint.b = trans.bb * ratio;
	return tint;
};


// zabarwienie - podejcie alternatywne
// rgb to warto koloru od 0 do 0xFFFFFF; percent midzy 0 a 100
Color.prototype.setTint2 = function (rgb, percent) {
	var r = (rgb >> 16) ;
	var g = (rgb >> 8) & 0xFF;
	var b = rgb & 0xFF;
	var ratio = percent / 100;
	var trans = {rb:r*ratio, gb:g*ratio, bb:b*ratio};
	trans.ra = trans.ga = trans.ba = 100 - percent;
	this.setTransform (trans);
};

// zwraca obiekt zawierajcy waciwoci rgb (liczb 0xFFFFFF ) i percent
Color.prototype.getTint2 = function () {
	var trans = this.getTransform();
	var tint = {percent: 100 - trans.ra};
	var ratio = 100 / tint.percent;
	tint.rgb = (trans.rb*ratio)<<16 | (trans.gb*ratio)<<8 | trans.bb*ratio;
	return tint;
};


// ====== zabarwienie - metody MovieClip ======

// dziaa jak Tint w Property Inspector
// r, g, b midzy 0 a 255; percent midzy 0 i 100
MovieClip.prototype.setTint = function (r, g, b, percent) {
	(new Color(this)).setTint (r, g, b, percent);
};

// zwraca obiekt zawierajcy waciwoci r, g, b i percent
MovieClip.prototype.getTint = function () {
	return (new Color(this)).getTint();
};

// zabarwienie - podejcie alternatywne
// rgb to warto koloru od 0 do 0xFFFFFF; percent midzy 0 a 100
MovieClip.prototype.setTint2 = function (rgb, percent) {
	(new Color(this)).setTint2 (rgb, percent);
};

// zwraca obiekt zawierajcy waciwoci rgb (liczb 0xFFFFFF ) i percent
MovieClip.prototype.getTint2 = function () {
	return (new Color(this)).getTint2();
};

// --------------------------------------------------------
// ====== zabarwienie przez offset - metody Color ======

// r, g, b midzy -255 a 255
Color.prototype.setTintOffset = function (r, g, b) {
	var trans = this.getTransform();
	with (trans) { rb = r; gb = g; bb = b; }
	this.setTransform (trans);
};

Color.prototype.getTintOffset = function () {
	var t = this.getTransform();
	return {r:t.rb, g:t.gb, b:t.bb};
};

// ====== zabarwienie przez offset - metody MovieClip ======

// r, g, b midzy -255 i 255
MovieClip.prototype.setTintOffset = function (r, g, b) {
	(new Color(this)).setTintOffset (r, g, b, percent);
};

// zwraca obiekt zawierajcy waciwoci r, g i b
MovieClip.prototype.getTintOffset = function () {
	return (new Color(this)).getTintOffset();
};


// --------------------------------------------------------
// ====== inwersja kolorw - metody Color ======

// odwraca aktualne wartoci kolorw
Color.prototype.invert = function () {
	var trans = this.getTransform();
	with (trans) {
		ra = -ra;
		ga = -ga;
		ba = -ba;
		rb = 255 - rb;
		gb = 255 - gb;
		bb = 255 - bb;
	}
	this.setTransform (trans);
}; 

// tworzy negatyw z oryginau
Color.prototype.setNegative = function (percent) {
    var t = {};
    t.ra = t.ga = t.ba = 100 - 2 * percent;
    t.rb = t.gb = t.bb = percent * (255/100);
    this.setTransform (t);
};

Color.prototype.getNegative = function () {
    return this.getTransform().rb * (100/255);
};


// ====== inwersja kolorw - metody MovieClip ======

// odwraca aktualne wartoci kolorw
MovieClip.prototype.invertColor = function () {
	(new Color(this)).invert();
};

// tworzy negatyw z oryginau
MovieClip.prototype.setNegativeColor = function (percent) {
    (new Color(this)).setNegative (percent);
};

MovieClip.prototype.getNegativeColor = function () {
    return (new Color(this)).getNegative();
};


// --------------------------------------------------------
// ====== jednolity kolor - metody Color ======

Color.prototype.setRed = function (amount) {
	var t = this.getTransform();
	this.setRGB (amount << 16 | t.gb << 8 | t.bb);
};

Color.prototype.getRed = function () {
	return this.getTransform().rb;
};

Color.prototype.setGreen = function (amount) {
	var t = this.getTransform();
	this.setRGB (t.rb << 16 | amount << 8 | t.bb);
};

Color.prototype.getGreen = function () {
	return this.getTransform().gb;
};

Color.prototype.setBlue = function (amount) {
	var t = this.getTransform();
	this.setRGB (t.rb << 16 | t.gb << 8 | amount);
};

Color.prototype.getBlue = function () {
	return this.getTransform().bb;
};

// ====== jednolity kolor - metody MovieClip ======

MovieClip.prototype.setRed = function (percent) {
	(new Color(this)).setRed (percent);
};

MovieClip.prototype.getRed = function () {
	return (new Color(this)).getRed();
};

MovieClip.prototype.setGreen = function (percent) {
	(new Color(this)).setGreen (percent);
};

MovieClip.prototype.getGreen = function () {
	return (new Color(this)).getGreen();
};

MovieClip.prototype.setBlue = function (percent) {
	(new Color(this)).setBlue (percent);
};

MovieClip.prototype.getBlue = function () {
	return (new Color(this)).getBlue();
};


// --------------------------------------------------------
// ====== procent koloru - metody Color ======

Color.prototype.setRedPercent = function (percent) {
	var trans = this.getTransform();
	trans.ra = percent;
	this.setTransform (trans);
};

Color.prototype.getRedPercent = function () {
	return this.getTransform().ra;
};

Color.prototype.setGreenPercent = function (percent) {
	var trans = this.getTransform();
	trans.ga = percent;
	this.setTransform (trans);
};

Color.prototype.getGreenPercent = function () {
	return this.getTransform().ga;
};

Color.prototype.setBluePercent = function (percent) {
	var trans = this.getTransform();
	trans.ba = percent;
	this.setTransform (trans);
};

Color.prototype.getBluePercent = function () {
	return this.getTransform().ba;
};

// ====== procent koloru - metody MovieClip ======

MovieClip.prototype.setRedPercent = function (percent) {
	(new Color(this)).setRedPercent (percent);
};

MovieClip.prototype.getRedPercent = function () {
	return (new Color(this)).getRedPercent();
};

MovieClip.prototype.setGreenPercent = function (percent) {
	(new Color(this)).setGreenPercent (percent);
};


MovieClip.prototype.getGreenPercent = function () {
	return (new Color(this)).getGreenPercent();
};

MovieClip.prototype.setBluePercent = function (percent) {
	(new Color(this)).setBluePercent (percent);
};

MovieClip.prototype.getBluePercent = function () {
	return (new Color(this)).getBluePercent();
};


// --------------------------------------------------------
// ====== offset koloru - metody Color ======

Color.prototype.setRedOffset = function (offset) {
	var trans = this.getTransform();
	trans.rb = offset;
	this.setTransform (trans);
};

Color.prototype.getRedOffset = function () {
	return this.getTransform().rb;
};

Color.prototype.setGreenOffset = function (offset) {
	var trans = this.getTransform();
	trans.gb = offset;
	this.setTransform (trans);
};

Color.prototype.getGreenOffset = function () {
	return this.getTransform().gb;
};

Color.prototype.setBlueOffset = function (offset) {
	var trans = this.getTransform();
	trans.bb = offset;
	this.setTransform (trans);
};

Color.prototype.getBlueOffset = function () {
	return this.getTransform().bb;
};

// ====== offset koloru - metody MovieClip ======

MovieClip.prototype.setRedOffset = function (offset) {
	(new Color(this)).setRedOffset (offset);
};

MovieClip.prototype.getRedOffset = function () {
	return (new Color(this)).getRedOffset();
};

MovieClip.prototype.setGreenOffset = function (offset) {
	(new Color(this)).setGreenOffset (offset);
};


MovieClip.prototype.getGreenOffset = function () {
	return (new Color(this)).getGreenOffset();
};

MovieClip.prototype.setBlueOffset = function (offset) {
	(new Color(this)).setBlueOffset (offset);
};

MovieClip.prototype.getBlueOffset = function () {
	return (new Color(this)).getBlueOffset();
};



// --------------------------------------------------------

// tworzenie waciwoci kolorw dla klipu filmowego
// pooczenie nazw waciwoci z metodami ustawiania i pobierania
with (MovieClip.prototype) {
	addProperty ("_brightness", getBrightness, setBrightness);
	addProperty ("_brightOffset", getBrightOffset, setBrightOffset);
	addProperty ("_negativeColor", getNegativeColor, setNegativeColor);
	addProperty ("_rgb", getRGB, setRGB);
	addProperty ("_red", getRed, setRed);
	addProperty ("_green", getGreen, setGreen);
	addProperty ("_blue", getBlue, setBlue);
	addProperty ("_redPercent", getRedPercent, setRedPercent);
	addProperty ("_greenPercent", getGreenPercent, setGreenPercent);
	addProperty ("_bluePercent", getBluePercent, setBluePercent);
	addProperty ("_redOffset", getRed, setRedOffset);
	addProperty ("_greenOffset", getGreen, setGreenOffset);
	addProperty ("_blueOffset", getBlue, setBlueOffset);
}


// ukrycie elementw przed ptlami for..in
ASSetPropFlags (MovieClip.prototype, null, 1);

trace ("-- wycztano zestaw narzdzi do manipulacji kolorami --");


