/*
  Narzdzia korzystajce z funkcji trygonometrycznych
  29 Pa 2002
  (c) 2002 Robert Penner
  
  Zestaw narzdzi zwizanych z funkcjami trygonometrycznymi,
  ktrych uywam w omwieniu zagadnie trygonometrii i ukadw wsprzdnych.

*/

	
Math.distance = function (x1, y1, x2, y2) {
	var dx = x2 - x1;
	var dy = y2 - y1;
	return Math.sqrt (dx*dx + dy*dy);
};

Math.angleOfLine = function (x1, y1, x2, y2) {
	return Math.atan2D (y2 - y1, x2 - x1);
};

Math.degreesToRadians = function (angle) {
	return angle * (Math.PI / 180);
};

Math.radiansToDegrees = function (angle) {
	return angle * (180 / Math.PI);
};


/*
// wersja z ksiki - mniej zoptymalizowana
Math.fixAngle = function (angle) {
	angle %= 360;
	return (angle < 0) ? angle + 360 : angle;
};
*/

Math.fixAngle = function (angle) {
	return (angle %= 360 < 0) ? angle + 360 : angle;
};

Math.cartesianToPolar = function (p) {
	var radius = Math.sqrt (p.x*p.x + p.y*p.y);
	var theta = Math.atan2D (p.y, p.x);
	return {r:radius, t:theta};
};

Math.polarToCartesian = function (p) {
	var x = p.r * Math.cosD (p.t);
	var y = p.r * Math.sinD (p.t);
	return {x:x, y:y};
};






