/*
  Tween Class v1.2
  29 Pa 2002
  (c) 2002 Robert Penner
  
  Klasa Tween zapewnia elastyczny szkielet dla
  dynamicznej animacji ruchu w ActionScript.
  
  Zalenoci: 
  - Klasa Motion 
  - Object.superCon() (z core_setup.as)
  - Function.extend() (z core_setup.as)
  - Rwnania przej Pennera (easing_equations.as)
    (rwnania te nie s na 100% konieczne, ale przewaznie wykorzystuje sie je z Tween)
  
  Zdarzenia:
  
  	onMotionChanged
  	onMotionFinished
  	onMotionLooped
  	onMotionStarted
  	onMotionStopped
  	onMotionResumed
*/

if (typeof _global.Motion != 'function') trace (">> Bd: brak klasy bazowej - Motion");
if (typeof Object.superCon != 'function') trace (">> Bd: brak Object.superCon() (core_setup.as)");
 
/*  konstruktor klasy Tween

	obj: referencja- obiekt z celem dla  Tween
	prop: tekst - nazwa waciwoci (w obj), krra zaostanie zmieniona
	func: referencja- funkcja obliczajca pooenie w danej chwili czasu
	begin: liczba - pocztkowa warto prop (pocztek przejcia)
	finish: liczba - warto prop na kocu przejcia
	duration: liczba - dugo czasu ruchu; daje nieskoczono, gdy ujemne lub pominite
	useSeconds: boolean - znacznik okrelajcy, czy uywa sekund, czy klatek

*/

_global.Tween = function (obj, prop, func, begin, finish, duration, useSeconds) {
	this.superCon (obj, prop, begin, duration, useSeconds);
	this.setFunc (func);
	this.setFinish (finish);
};

Tween.extend (Motion);

var TP = Tween.prototype;


//////// metody publiczne

TP.toString = function () {
	return "[Tween obj=" + this.obj + " prop=" + this.prop + 
		" beg=" + this.begin + " fin=" + this.finish + " dur=" + this.duration +
		" t=" + this.time + 
		" pos=" + this.getPosition() + "]";
};

TP.continueTo = function (finish, duration) {
    this.setBegin (this.getPosition());
    this.setFinish (finish);
    if (duration != undefined)
        this.setDuration (duration);
    this.start();
};

TP.yoyo = function () {
    with (this) {
        continueTo (getBegin(), getTime());
    }
};


//////// metody ustawiania i pobierania

TP.getPosition = function (t) {
	if (t == undefined) t = this.$time;
	with (this) return $func (t, $begin, $change, $duration);
};

TP.setFunc = function (f) {
	this.$func = f;
};

TP.getFunc = function () {
	return this.$func;
};

TP.setChange = function (c) {
	this.$change = c;
};

TP.getChange = function () {
	return this.$change;
};

TP.setFinish = function (f) {
	this.$change = f - this.$begin;
};

TP.getFinish = function () {
	return this.$begin + this.$change;
};

/////////// waciwoci ustawiania i pobierania

with (TP) {
	addProperty ("func", getFunc, setFunc);
	addProperty ("change", getChange, setChange);
	addProperty ("finish", getFinish, setFinish);
}

delete TP;

trace (">> wczytano klas Tween");


