/*
  Rwnania przej v1.3
  29 Pa 2002
  (c) 2002 Robert Penner
  
  Te funkcje przej zapewniaj rne rodzaje ruchu 
  w jednolitym interfejsie uytkownika. 
  
  Rodzaje przej:
  
	  Liniowe
	  Kwadratowe
	  Stopnia trzeciego
	  Stopnia czwartego
	  Stopnia piego
	  Sinusoidalne
	  Wykadnicze
	  Koowe

*/


// proste przejcie liniowe - brak przyspieszenia
// t: aktualny czas, b: warto pocztkowa, c: zmiana wartoci, d: czas trwania
Math.linearTween = function (t, b, c, d) {
	return c*t/d + b;
};

 ///////////// przyspieszenie kwadratowe: t^2 ///////////////////

// przyspieszenie kwadratowe - przyspieszenie od zerowej prdkoci
// t: aktualny czas, b: warto pocztkowa, c: zmiana wartoci, d: czas trwania
// t i d moe by podane w klatkach lub sekundach/millisekundach
Math.easeInQuad = function (t, b, c, d) {
	return c*(t/=d)*t + b;
};

// spowolnienie kwadratowe - spowolnienie do zerowej prdkoci
Math.easeOutQuad = function (t, b, c, d) {
	return -c *(t/=d)*(t-2) + b;
};

// kwadratowe przyspieszenie ze spowolnieniem - przyspieszanie do poowy, potem spowolnienie
Math.easeInOutQuad = function (t, b, c, d) {
	if ((t/=d/2) < 1) return c/2*t*t + b;
	return -c/2 * ((--t)*(t-2) - 1) + b;
};


 ///////////// przyspieszenie stopnia trzeciego: t^3 ///////////////////////

// przyspieszenie stopnia trzeciego - przyspieszenie od zerowej prdkoci
// t: aktualny czas, b: warto pocztkowa, c: zmiana wartoci, d: czas trwania
// t i d moe by podane w klatkach lub sekundach/millisekundach
Math.easeInCubic = function (t, b, c, d) {
	return c*(t/=d)*t*t + b;
};

// spowolnienie stopnia trzeciego - spowolnienie do zerowej prdkoci
Math.easeOutCubic = function (t, b, c, d) {
	return c*((t=t/d-1)*t*t + 1) + b;
};

// przyspieszenie ze spowolnieniem stopnia trzeciego - przyspieszanie do poowy, potem spowolnienie
Math.easeInOutCubic = function (t, b, c, d) {
	if ((t/=d/2) < 1) return c/2*t*t*t + b;
	return c/2*((t-=2)*t*t + 2) + b;
};


 ///////////// przyspieszenie stopnia czwartego: t^4 /////////////////////

// przyspieszenie stopnia czwartego - przyspieszenie od zerowej prdkoci
// t: aktualny czas, b: warto pocztkowa, c: zmiana wartoci, d: czas trwania
// t i d moe by podane w klatkach lub sekundach/millisekundach
Math.easeInQuart = function (t, b, c, d) {
	return c*(t/=d)*t*t*t + b;
};

// spowolnienie stopnia czwartego - spowolnienie do zerowej prdkoci
Math.easeOutQuart = function (t, b, c, d) {
	return -c * ((t=t/d-1)*t*t*t - 1) + b;
};

// przyspieszenie ze spowolnieniem stopnia czwartego - przyspieszanie do poowy, potem spowolnienie
Math.easeInOutQuart = function (t, b, c, d) {
	if ((t/=d/2) < 1) return c/2*t*t*t*t + b;
	return -c/2 * ((t-=2)*t*t*t - 2) + b;
};


 ///////////// przyspieszenie stopnia pitego: t^5  ////////////////////

// przyspieszenie stopnia pitego - przyspieszenie od zerowej prdkoci
// t: aktualny czas, b: warto pocztkowa, c: zmiana wartoci, d: czas trwania
// t i d moe by podane w klatkach lub sekundach/millisekundach
Math.easeInQuint = function (t, b, c, d) {
	return c*(t/=d)*t*t*t*t + b;
};

// spowolnienie stopnia pitego - spowolnienie do zerowej prdkoci
Math.easeOutQuint = function (t, b, c, d) {
	return c*((t=t/d-1)*t*t*t*t + 1) + b;
};

// przyspieszenie ze spowolnieniem stopnia pitego - przyspieszanie do poowy, potem spowolnienie
Math.easeInOutQuint = function (t, b, c, d) {
	if ((t/=d/2) < 1) return c/2*t*t*t*t*t + b;
	return c/2*((t-=2)*t*t*t*t + 2) + b;
};



 ///////////// przyspieszenie sinusoidalne: sin(t) ///////////////

// przyspieszenie sinusoidalne - przyspieszenie od zerowej prdkoci
// t: aktualny czas, b: warto pocztkowa, c: zmiana wartoci, d: czas trwania
Math.easeInSine = function (t, b, c, d) {
	return -c * Math.cos(t/d * (Math.PI/2)) + c + b;
};

// spowolnienie sinusoidalne - spowolnienie do zerowej prdkoci
Math.easeOutSine = function (t, b, c, d) {
	return c * Math.sin(t/d * (Math.PI/2)) + b;
};

// sinusoidalne przyspieszenie ze spowolnieniem - przyspieszanie do poowy, potem spowolnienie
Math.easeInOutSine = function (t, b, c, d) {
	return -c/2 * (Math.cos(Math.PI*t/d) - 1) + b;
};


 ///////////// przyspieszenie wykadnicze: 2^t /////////////////

// przyspieszenie wykadnicze - przyspieszenie od zerowej prdkoci
// t: aktualny czas, b: warto pocztkowa, c: zmiana wartoci, d: czas trwania
Math.easeInExpo = function (t, b, c, d) {
	return (t==0) ? b : c * Math.pow(2, 10 * (t/d - 1)) + b;
};

// spowolnienie wykadnicze - spowolnienie do zerowej prdkoci
Math.easeOutExpo = function (t, b, c, d) {
	return (t==d) ? b+c : c * (-Math.pow(2, -10 * t/d) + 1) + b;
};

// wykadnicze przyspieszenie ze spowolnieniem - przyspieszanie do poowy, potem spowolnienie
Math.easeInOutExpo = function (t, b, c, d) {
	if (t==0) return b;
	if (t==d) return b+c;
	if ((t/=d/2) < 1) return c/2 * Math.pow(2, 10 * (t - 1)) + b;
	return c/2 * (-Math.pow(2, -10 * --t) + 2) + b;
};


 /////////// przyspieszenie koowe: sqrt(1-t^2) //////////////

// przyspieszenie koowe - przyspieszenie od zerowej prdkoci
// t: aktualny czas, b: warto pocztkowa, c: zmiana wartoci, d: czas trwania
Math.easeInCirc = function (t, b, c, d) {
	return -c * (Math.sqrt(1 - (t/=d)*t) - 1) + b;
};

// spowolnienie koowe - spowolnienie do zerowej prdkoci
Math.easeOutCirc = function (t, b, c, d) {
	return c * Math.sqrt(1 - (t=t/d-1)*t) + b;
};

// koowe przyspieszenie ze spowolnieniem - przyspieszanie do poowy, potem spowolnienie
Math.easeInOutCirc = function (t, b, c, d) {
	if ((t/=d/2) < 1) return -c/2 * (Math.sqrt(1 - t*t) - 1) + b;
	return c/2 * (Math.sqrt(1 - (t-=2)*t) + 1) + b;
};

trace (">> wczytano rwnania przej Pennera");






