/*
  FractalBranch Class v1.1
  29 Pa 2002
  (c) 2002 Robert Penner
  
  FractalBranch to podklasa MovieClip zawierajca zachowania dla
  gazi fraktalnego drzewa.
  
  Zalenoci: Klasa MotionCam 

*/ 


#initclip 2

_global.FractalBranch = function () {
	this.init();
};

Object.registerClass ("FractalBranchSymbol", FractalBranch);
FractalBranch.prototype.__proto__ = MovieClip.prototype;

var FBP = FractalBranch.prototype;

FBP.init = function () {
	this.numBranches = 0;
	if (this.myLevel == undefined) {
		this.myLevel = 0;
		this.fRoot = this._parent;
	} else {
		this.doColor();
		if (this.myBranch == 1) 
			this.fRoot.xCam.addListener (this);
		else if (this.myBranch == 2)
			this.fRoot.yCam.addListener (this);
	}
};

// procedura obsug zdarzenia - zdarzenia przychodz od kopii MotionCam
FBP.onMotionChanged = function (source, position) {
	if (position != undefined)
		this._rotation = position + 175;
};

FBP.doColor = function () {
	if (this.myBranch == 1) 
		var tint = {r:255, g:255, b:255};
	else
		var tint = {r:0, g:0, b:255};
		
	(new Color (this)).setTint (tint.r,
								tint.g,
								tint.b,
								30);
};

FBP.newBranch = function (bNum) {
	if (this.myLevel >= this.fRoot.maxLevels) return;
	var p = this.fRoot.posers[bNum];
	var initObj = {
		_x: p._x,
		_y: p._y,
		_xscale: p._xscale,
		_yscale: p._yscale,
		_rotation: p._rotation,
		myLevel: this.myLevel + 1,
		myBranch: bNum,
		fRoot: this.fRoot
	}
	this.attachMovie ("FractalBranchSymbol",
					  "b" + bNum,
					  bNum,
					  initObj);
	this.numBranches++;
};

FBP.nextBranch = function () {
	if (this.numBranches < this.fRoot.maxBranches
		&& this.myLevel < this.fRoot.maxLevels) {
		
		this.newBranch (this.numBranches + 1);
	} else {
		this._parent.nextBranch();
	}
};

delete FBP;


#endinitclip