/*
  Snowstorm Class v1.1
  29 Pa 2002
  (c) 2002 Robert Penner
  
  Klasa Snowstorm zarzdza zbiorem obiektw SnowFlake,
  definiujc ich ograniczenia, tarcie, szybko spradania i wiatr.
  
  Zalenoci: Klasa Snowflake 

*/

if (typeof Snowflake != "function") trace ("Bd: brak wymaganej klasy Snowflake");


_global.Snowstorm = function (limits, friction, fallSpeed, timeline) {
	this.limits = limits;
	this.friction = friction;
	this.fallSpeed = fallSpeed;
	this.timeline = timeline;
	this.flakes = []; 
};

var SSP = Snowstorm.prototype;


///////////// metody publiczne

SSP.addFlake = function () {
	var lm = this.limits;
	var newFlake = new Snowflake (this.fallSpeed,
								  this.timeline,
								  this.flakes.length);
	newFlake.setStorm (this);
	var x = Math.randRangeF (lm.xmin, lm.xmax);
	var y = lm.ymin;
	var z = Math.randRangeF (lm.zmin, lm.zmax);
	newFlake.setZ (z);
	newFlake.setScreenXY (x, y);
	this.flakes.unshift (newFlake);
};

SSP.removeFlake = function () {
	return this.flakes.pop();
};


/////////// metody ustawiania i pobierania

SSP.setWind = function (w) {
    this.$wind = w;
};

SSP.getWind = function () {
    return this.$wind;
};

/////////// waciwoci ustawiania i pobierania

with (SSP) {
    addProperty ("wind", getWind, setWind);
}

delete SSP;

trace (">> wczytano klas Snowstorm");
