/*
  SnowFlake Class v1.1
  29 Pa 2002
  (c) 2002 Robert Penner
  
  Klasa SnowFlake zawiera dziaania dotyczce animacji spadajcego
  patka niegu.
  Zaprojektowana do wsppracy z klas SnowStorm.
  
  Zalenoci: 
  - Klasa Vector3d 
  - MovieClip.addListener() dla zdarze onEnterFrame (z core_setup.as)
  - Math.randRangeF() (dodane poniej)
  - MovieClip.drawPoly() (dodane poniej)
  - MovieClip.drawRegPoly() (dodane poniej)
  - Color.setBrightness() (dodane poniej)

*/

// zwraca losow warto zmiennoprzecinkow z okrelonego zakresu
Math.randRangeF = function (low, high) {
	return Math.random() * (high - low) + low;
};

MovieClip.prototype.drawPoly = function (pts) {
	this.moveTo (pts[0].x, pts[0].y);
	var i = pts.length;
	while (i--) this.lineTo (pts[i].x, pts[i].y);
};

MovieClip.prototype.drawRegPoly = function (x, y, radius, numPts, rotation) {
		var angle = (-90 + rotation) * (Math.PI/180); // start at -90 deg.
		var pts = [];
		var px, py;
		var dAngle = 2 * Math.PI / numPts; // 360 deg. / numPts
		var cos = Math.cos, sin = Math.sin;
		while (numPts--) {
			angle += dAngle;
			px = radius * cos (angle) + x;
			py = radius * sin (angle) + y;
			pts.push ({x:px, y:py});	
		}
		this.drawPoly (pts);
};

// rozjania jak Property Inspector
// bright midzy -100 a 100
Color.prototype.setBrightness = function (bright) {
	var trans = this.getTransform();
	with (trans) {
		ra = ga = ba = 100 - Math.abs (bright); // procent koloru
		rb = gb = bb = (bright > 0) ? bright * (256/100) : 0; // offset koloru
	}
	this.setTransform (trans);
};

if (typeof Vector3d != "function") trace ("Bd: brak wymaganej klasy Vector3d");
if (typeof MovieClip.addListener != 'function') trace (">> Bd: brak MovieClip.addListener() (core_setup.as)");

//////////////////////////////////////////////////////////////////////

_global.Snowflake = function (fallSpeed, timeline, depth) {
    this.mc = this.attachGraphic (timeline, depth);
    this.mcColor = new Color (this.mc);
    this.pos = new Vector3d (0, 0, 0);
    this.vel = new Vector3d (0, -fallSpeed, 0);
    this.velRot = Math.randRangeF (-10, 10);
    MovieClip.addListener (this);
};

var SFP = Snowflake.prototype;


//////////// metody ustawiania i pobierania 

// ustawia wsprzdne x i y trjwymiaru
SFP.setXY = function (x, y) {
	this.pos.x = x;
	this.pos.y = y;
	this.renderXY();
};

// ustawia wsprzdn z (odlego od kamery)
SFP.setZ = function (z) {
	this.pos.z = z;
	this.renderZ();
};

// ustawia klip filmowy SnowFlake na odpowiednie pooenie _x i odpowiednio zmienia wsprzdn x trjwymiaru
SFP.setScreenX = function (x) {
	this.pos.x = (this.mc._x = x) / this.pers;
};

// ustawia klip filmowy SnowFlake na odpowiednie pooenie _y i odpowiednio zmienia wsprzdn y trjwymiaru
SFP.setScreenY = function (y) {
	this.pos.y = -(this.mc._y = y) / this.pers;
};

// ustawia _x i _y oraz dokonuje odpowiedniej aktualizacji wsprzdnych 3D
SFP.setScreenXY = function (x, y) {
	this.pos.x = (this.mc._x = x) / this.pers;
	this.pos.y = -(this.mc._y = y) / this.pers;
};

SFP.setStorm = function (s) {
	this.storm = s;
};

SFP.getStorm = function () {
	return this.storm;
};


//////////// metody prywatne

// dodaje klip filmowy reprezentujcy patek niegu
SFP.attachGraphic = function (timeline, depth) {
	var mc = timeline.createEmptyMovieClip ("s" + depth, depth);
	with (mc) {
		beginFill (0xFFFFFF);
		drawRegPoly (0, 0, 10, 6);
		endFill();
	}
	return mc;
};

// animuje patek
SFP.move = function () {
	// zmiana losowej siy Browna co 10 klatek
	if (++this.t % 10 == 0) {
		this.brown = Math.randRangeF (-.2, .2);
	}
	var v = this.vel;
	// dodaje przyspieszenie do prdkoci
	v.x += this.brown + this.storm.wind;
	v.x *= 1 - this.storm.friction;
	this.pos.plus (v);
	this.rotation += this.velRot;
	this.renderXY();
};

SFP.onEnterFrame = SFP.move;

// aktualizacji grafiki w celu odzwierciedlenia zmian we wsprzdnych  X i (lub) Y	
SFP.renderXY = function () {
	var mc = this.mc;
	mc._x = this.pos.x * this.pers;
	mc._y = -this.pos.y * this.pers;
	mc._rotation = this.rotation;
	// pobierz obiekt ogranicze ze Snowstorm
	var lm = this.storm.limits;
	// sprawd granice i zawi
	if (mc._y > lm.ymax) this.setScreenY (lm.ymin);
	if (mc._x > lm.xmax) this.setScreenX (lm.xmin)
	else if (mc._x < lm.xmin) this.setScreenX (lm.xmax);
};

// aktualizacji grafiki w celu odzwierciedlenia zmian we wsprzdnej z	
SFP.renderZ = function () {	
	// warto perspektywy
	this.pers = this.pos.getPerspective();
	// change z-order
	this.mc.swapDepths (Math.floor (100000 - this.pos.z * 100));
	// zmiana skali klipu
	with (this.mc) {
		_xscale = _yscale = 100 * this.pers;
	}
	// zmiania jasnoci wzgldem odlegoci od widza
	(new Color (this.mc)).setBrightness (-100 * (1 - this.pers));
};


delete SFP;

trace (">> wczytano klas Snowflake");
