/*
  WaveMotion Class v1.2
  29 Pa 2002
  (c) 2002 Robert Penner
  
  Ta klasa wykorzystywana jest do tworzenia oscylacji.
  
  Zalenoci: 
  - Klasa Motion 
  - Object.superCon() (z core_setup.as)
  - Function.extend() (z core_setup.as)
  
  Zdarzenia:
  
  	onMotionChanged
  	onMotionFinished
  	onMotionLooped
  	onMotionStarted
  	onMotionStopped
  	onMotionResumed
*/


if (typeof _global.Motion != 'function') trace (">> Bd: brak klasy bazowej - Motion");
if (typeof Object.superCon != 'function') trace (">> Bd: brak Object.superCon() (core_setup.as)");
 
///////////////////////////////////////////////////////////////////

_global.WaveMotion = function (obj, prop, begin, amp, period, duration, useSeconds) {
	this.superCon (obj, prop, begin, duration, useSeconds);
	this.setOffset (begin);
	this.setAmp (amp);
	this.setPeriod (period);
};

WaveMotion.extend (Motion);

var WMP = WaveMotion.prototype;

WMP.getPosition = function (t) {
	if (t == undefined) t = this.$time;
	return this.$amp * 
		Math.sin ((t-this.$timeShift) * (2*Math.PI) / this.$period) 
		+ this.$offset;	
};

WMP.setAmp = function (a) {
	if (a != undefined) this.$amp = a;
};

WMP.getAmp = function () {
	return this.$amp;
};

WMP.setPeriod = function (p) {
	if (p != undefined) this.$period = p;
};

WMP.getPeriod = function () {
	return this.$period;
};

WMP.setFreq = function (f) {
	this.setPeriod (1 / f);
};

WMP.getFreq = function () {
	return 1 / this.getPeriod();
};

WMP.setTimeShift = function (t) {
	if (t != undefined) this.$timeShift = t;
};

WMP.getTimeShift = function () {
	return this.$timeShift;
};

WMP.setOffset = function (f) {
	if (f != undefined) this.$offset = f;
};

WMP.getOffset = function () {
	return this.$offset;
};

WMP.setWavePhysics = function (amp, period, timeShift, offset) {
	this.setAmp (amp);
	this.setPeriod (period);
	this.setTimeShift (timeShift);
	this.setOffset (offset);
};


with (WaveMotion.prototype) {
	addProperty ("amp", getAmp, setAmp);
	addProperty ("offset", getOffset, setOffset);
	addProperty ("period", getPeriod, setPeriod);
	addProperty ("freq", getFreq, setFreq);
	addProperty ("timeShift", getTimeShift, setTimeShift);
}

delete WMP;
 
trace (">> wczytano klas WaveMotion");
 
