/*
  Motion Class v1.2
  29 Pa 2002
  (c) 2002 Robert Penner
  
  Klasa Motion zawiera logik wykorzystywan w klasach takich, jak
  Tween, WaveMotion i MotionCam (ch.13).
  
  Zalenoci: 
  - ASBroadcaster (nieudokumentowana funkcja Flasha MX)
  - MovieClip.addListener() dla zdarze onEnterFrame (w core_setup.as)
  
  Zdarzenia:
  
  	onMotionChanged
  	onMotionFinished
  	onMotionLooped
  	onMotionStarted
  	onMotionStopped
  	onMotionResumed
  
*/

if (typeof MovieClip.addListener != 'function') trace (">> Bd: brak MovieClip.addListener() (core_setup.as)");


/////////////////////////////////////////////////////////////////////////

/*  konstruktor klasy Motion

	obj: referencja- obiekt z celem dla  Motion
	prop: tekst - nazwa waciwoci (w obj), krra zaostanie zmieniona
	begin: liczba - pocztkowa warto prop
	duration: liczba - dugo czasu ruchu; daje nieskoczono, gdy ujemne lub pominite
	useSeconds: boolean - znacznik okrelajcy, czy uywa sekund, czy klatek
*/
_global.Motion = function (obj, prop, begin, duration, useSeconds) {
	this.setObj (obj);
	this.setProp (prop);
	this.setBegin (begin);
	this.setPosition (begin);
	this.setDuration (duration);
	this.setUseSeconds (useSeconds);
	this._listeners = [];
	this.addListener (this);
	this.start();
};

var MP = Motion.prototype;
AsBroadcaster.initialize (MP);

MP.start = function () {
	this.rewind();
	MovieClip.addListener (this);
	this.broadcastMessage ("onMotionStarted", this);
};

MP.stop = function () {
	MovieClip.removeListener (this);
	this.broadcastMessage ("onMotionStopped", this);
};

MP.resume = function () {
	this.fixTime();
	MovieClip.addListener (this);
	this.broadcastMessage ("onMotionResumed", this);
};

MP.rewind = function (t) {
	this.$time = (t == undefined) ? 0 : t;
	this.fixTime();
};

MP.fforward = function () {
	this.setTime (this.$duration);
	this.fixTime();
};

MP.nextFrame = function () {
	if (this.$useSeconds) {
		this.setTime ((getTimer() - this.startTime) / 1000);
	} else {
		this.setTime (this.$time + 1);
	}
};

MP.onEnterFrame = MP.nextFrame;


MP.prevFrame = function () {
	if (!this.$useSeconds) this.setTime (this.$time - 1);
};

MP.toString = function () {
	return "[Motion prop=" + this.prop + " t=" + this.time + 
		" pos=" + this.getPosition() + "]";
};

//////// metody ustawiania i pobierania

/*  zwraca pooenie Motion w danejchwili czasu
	metoda abstrakcyjna do przysonicia
*/
MP.getPosition = function (t) {};

MP.setPosition = function (p) {
	this.$prevPos = this.$pos;
	this.$obj[this.$prop] = this.$pos = p;
	this.broadcastMessage ("onMotionChanged", this, this.$pos);	
};

MP.setTime = function (t) {
	this.prevTime = this.$time;
	if (t > this.duration) {
		if (this.$looping) {
			this.rewind (t - this.$duration);
			this.update();
			this.broadcastMessage ("onMotionLooped", this);
		} else {
			if (this.$useSeconds) {
				this.$time = this.$duration;
				this.update();
			}
			this.stop();
			this.broadcastMessage ("onMotionFinished", this);
		}
	} else if (t < 0) {
		this.rewind();
		this.update();
	} else {
		this.$time = t;
		this.update();
	}
};

MP.getTime = function () {
	return this.$time;
};

MP.setBegin = function (b) {
	if (b == undefined) this.$begin = this.$obj[this.$prop];
	else this.$begin = b;
};

MP.getBegin = function () {
	return this.$begin;
};


MP.setDuration = function (d) {
	this.$duration = (d == null || d <= 0) ? Infinity : d;
};

MP.getDuration = function () {
	return this.$duration;
};

MP.setObj = function (o) {
	this.$obj = o;
};

MP.getObj = function () {
	return this.$obj;
};

MP.setProp = function (p) {
	this.$prop = p;
};

MP.getProp = function () {
	return this.$prop;
};

MP.setUseSeconds = function (useSecs) {
	this.$useSeconds = useSecs;
};

MP.getUseSeconds = function () {
	return this.$useSeconds;
};

MP.setLooping = function (b) {
	this.$looping = b;
};

MP.getLooping = function () {
	return this.$looping;
};

MP.getPrevPos = function () {
	return this.$prevPos;
};


/////////// metody prywatne

MP.fixTime = function () {
	if (this.$useSeconds) 
		this.startTime = getTimer() - this.$time*1000;
};

MP.update = function () {
	this.setPosition (this.getPosition (this.$time));
};


/////////// waciwoci ustawiania i pobierania

with (MP) {
	addProperty ("obj", getObj, setObj);
	addProperty ("prop", getProp, setProp);
	addProperty ("begin", getBegin, setBegin);
	addProperty ("duration", getDuration, setDuration);
	addProperty ("useSeconds", getUseSeconds, setUseSeconds);
	addProperty ("looping", getLooping, setLooping);
	addProperty ("prevPos", getPrevPos, null);
	addProperty ("time", getTime, setTime);
	addProperty ("position",
	                 function() { return this.getPosition(); },
	                 function(p){ this.setPosition (p); } );
}

delete MP;

trace (">> wczytano klas Motion");


 


