/*
  Klasa Particle3d
  29 Pa 2002
  (c) 2002 Robert Penner
  
  Definicja obiektu reprezentujcego i wywietlajcego czsteczk
  osadzon w symulowanej przestrzeni trjwymiarowej.
  Czsteczka jest reprezentowana na obrazie doczany klip filmowy,
  za jej pozycja przez trjwymiarowy wektor.
  
  Zalenoci: 
  - klasa Vector3d
  - plik trig_functions_degrees.as

*/


if (typeof Math.cosD != "function") trace ("bd: brak definicji funkcji Math.cosD");

// w podobny sposb mona sprawdzi, czy zostaa zdefiniowana klasa Vector3D

_global.Particle3d = function (x, y, z, timeline, mcID, depth) {
	this.position = new Vector3d (x, y, z);
	this.timeline = timeline;
	this.mc = this.attachGraphic (mcID, depth);
	this.scale = 100;
	this.render();
}

Particle3d.prototype.attachGraphic = function (mcID, depth) {
	return this.timeline.attachMovie (mcID,
									  mcID + "_" + depth,
									  depth);
};


Particle3d.prototype.render = function () {
	var pers = this.position.getPerspective();
	this.screenPos = this.position.persProjectNew (pers);
	with (this.mc) {
		_x = this.screenPos.x;
		_y = -this.screenPos.y;
		_xscale = _yscale = this.scale * pers;
		swapDepths (100000 - this.position.z * 100);
	}
};

trace (">> definicja klasy Particle3d wczytana");