<?
	// Flash for PHP
	
	// Basket class
	
	class Basket {
		// Class properties (Only one this time)
		
		var $items;	// This property will hold all of the contents of the basket.  Each item in this array will be an instance of the Item object

		// Class Methods
		
		// Constructor Function
		function Basket() {
			// Set up $items as an array
			$this->items = array();
		}
		
		// Add an item to the basket
		//  $description: 	A description of the item to add
		//  $price:			The price of the item to add
		
		function addItem($description, $price) {
			// Create a new instance of the Item object
			$newItem = new Item($description, $price);
			
			// Add the object to the $items array
			$this->items[] = $newItem;
			
		}
		

		// Remove all items from the basket		
		function removeAll() {
			// To do this, we reset the $items array
			$this->items = array();
		}
		
		// Still need to write
		//
		function getContents() {
			// Show the basket total
			print "&basketTotal=".$this->getTotalPrice();
			
			// Rewind the $items array back to the beginning
			reset($this->items);
			
			// Check if there are any items in the basket, if so, print them out
			if (count($this->items) > 0) {
				print '&basketList=';
				$itemNumber = 0;			
				// Loop through the items in the basket
				while(list($itemNumber, $currentItem) = each($this->items)) {
					// Get the price of the current item and add it to the total
					print '<p><b>'.$currentItem->description.'</b> -- '.$currentItem->price.'</p>';
				}
				
				// Now print out the variable basketTotal with the total price of the items in the basket
			}
			else {
				print '&basketList=<p>Your basket is currently empty.</p>';
			}
			
		}
		
		// Get the total price of the objects in the basket
		function getTotalPrice() {
			$total = 0;

			// Rewind the $items array back to the beginning
			reset($this->items);
			
			// Loop through the items in the basket
			while(list($null, $currentItem) = each($this->items)) {
				// Get the price of the current item and add it to the total
				$total += $currentItem->price;
			}
			
			// Return the total price of the items
			return $total;
		}
		
	}
	
	// The Item class
	class Item {
		var $description;
		var $price;
		
		// Class constructor
		function Item($description, $price) {
			$this->price = $price;
			$this->description = $description;
		}
		
		function getPrice() {
			return $this->price;
		}
		
		function getDescription() {
			return $this->description;
		}
	}

	
	// Start session variables and register the variable $myBasket as a session variable
	session_start();
	session_register(myBasket);

	// If this is the first time running this script, make $myBasket into an instance of the class "Basket"
	if (!isset($myBasket)) {
		$myBasket = new Basket;
	}

	// Now for the actions
	switch($action) {
		case "addItem":
       		$myBasket->addItem($description, $price);
        		break;
    	case "removeAll":
			$myBasket->removeAll();
			break;
    	case "removeItem":
        	$myBasket->removeItem($itemNumber);
        	break;
	}

	// Output the contents of the basket
	$myBasket->getContents();

?>
