<?php

define("FLICKR_ACCESS_KEY", "klucz_flickr");

$flickrURLTemplate = "http://farm%s.static.flickr.com/%s/%s_%s_s.jpg";

if(empty($_GET['tags']))
{
	exit();
}

$searchTags = $_GET['tags'];

$apiMethod = "flickr.photos.search";
$request = "http://api.flickr.com/services/rest/?method=" . $apiMethod . "&tags=" . $searchTags  ."&api_key=" . FLICKR_ACCESS_KEY. "&per_page=5";

$rawXml = file_get_contents($request);
$xmlResponse = simplexml_load_string($rawXml);

$nodeCount = getAttribute($xmlResponse->photos, "perpage");

$xml = "<?xml version=\"1.0\" ?>\n<photos>";

for($i=0; $i < $nodeCount; $i++)
{
	// zmienne flickr
			
	$farmID = getAttribute($xmlResponse->photos->photo[$i], "farm");
	$serverID = getAttribute($xmlResponse->photos->photo[$i], "server");
	$photoID = getAttribute($xmlResponse->photos->photo[$i], "id");
	$secret = getAttribute($xmlResponse->photos->photo[$i], "secret");
	
	$xml .= "	<photo>";
	$xml .= "		<title><![CDATA[" . getAttribute($xmlResponse->photos->photo[$i], "title") . "]]></title>";
	$xml .= "		<thumb>" . sprintf($flickrURLTemplate, $farmID, $serverID, $photoID, $secret) . "</thumb>";
	$xml .= "	</photo>";
}

$xml .= "</photos>";

header("content-type: text/xml");

print $xml;
	
function getAttribute($xml, $name)
{
	foreach($xml->attributes() as $key=>$val)
	{
		if($key == $name)
		{
			return (string)$val;
		}
	}
	return false;
}

?>