package
{
	import flash.display.MovieClip;
	import flash.geom.Rectangle;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.net.*;
	
	public class LoginWindow extends MovieClip
	{
		public var data:Object;
		
		private var _visible:Boolean = false;
		private var container:MovieClip;
		private var blocker:MovieClip = null;

		public static var LOGIN_ATTEMPT:String = "onLoginAttempt";
		
		function LoginWindow()
		{
			container = this;
			
			loginMC.resetBtn.addEventListener(MouseEvent.CLICK, resetHandler);
			loginMC.loginBtn.addEventListener(MouseEvent.CLICK, loginHandler);
		}
		
		public function redraw():void
		{	
			if(blocker == null)
			{
				blocker = new MovieClip();
				blocker.alpha = 0.5;
				blocker.graphics.beginFill(0x000000);
				blocker.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
				blocker.addEventListener(MouseEvent.ROLL_OVER, dummyHandler);
				blocker.addEventListener(MouseEvent.ROLL_OUT, dummyHandler);
				blocker.addEventListener(MouseEvent.CLICK, dummyHandler);
			}
			else
			{
				blocker.width = stage.stageWidth;
				blocker.height = stage.stageHeight;
			}
			
			// reverse the offset to position blocker
			blocker.y = y * -1;
			blocker.x = x * -1;
			
			addChild(blocker);
			
			container.swapChildren(loginMC, blocker);
		
			loginMC.x = (stage.stageWidth / 2) - (loginMC.width / 2);
			loginMC.y = (stage.stageHeight / 2) - (loginMC.height / 2);
			
			_visible = true;
		}
		
		public function close():void
		{
			container.parent.removeChild(container);
		}
		
		private function resetHandler(e:MouseEvent):void
		{			
			loginMC.username.text = "";
			loginMC.password.text = "";
			loginMC.responseTxt.text = "";
		}
		private function loginHandler(e:MouseEvent):void
		{
			loginMC.responseTxt.text = "";
			
			if(loginMC.username.text == "" || loginMC.password.text == "")
			{
				loginMC.responseTxt.text = "username & password required";
				return;
			}
			
			data = {username:loginMC.username.text, password:loginMC.password.text};	
			dispatchEvent(new Event(LOGIN_ATTEMPT));
		}
		
		public function set responseString(s:String):void
		{
			loginMC.responseTxt.text = s;
		}
		
		private function dummyHandler(e:MouseEvent):void
		{
			//
		}
		
	}
}