﻿package
{

	import flash.display.MovieClip;
	import flash.text.TextField;
	import flash.events.MouseEvent;
	import flash.net.*;
	
	public class ShoppingCart extends MovieClip
	{
		private var cartItemCount:uint = 0;
		private var cartContents:Array;
		
		private var cartItemHeight:uint = 20;
		private var lineSpacing:uint = 30;
		private var gateway:String;
		
		function ShoppingCart()
		{
			cartContents = new Array();
			
			checkoutBtn.addEventListener(MouseEvent.CLICK, function():void
			{
				var xml:String = "<?xml version='1.0' ?>\n\r<products total=\"" + totalTxt.text + "\">";
				for(var i in cartContents)
				{
					xml += "<product>";
					xml += "	<quantity>" + cartContents[i].cartItem.quantityTxt.text + "</quantity>";
					xml += "	<name>" + cartContents[i].name + "</name>";
					xml += "	<price>" + cartContents[i].price + "</price>";
					xml += "</product>";
				}
				xml += "</products>";
				
	            var variables:URLVariables = new URLVariables();
	            variables.action = "checkout";
	            variables.xml = xml;
						
				var urlRequest:URLRequest = new URLRequest(gateway);
				urlRequest.data = variables;
	            urlRequest.method = "GET";
				
				navigateToURL(urlRequest);
			})
		}
		
		public function addProduct(product:Object):void
		{	
			// Sprawdź, czy produkt znajduje się na liście
			for(var i in cartContents)
			{
				if(cartContents[i].id == product.id)
				{
					var quantity:Number = cartContents[i].cartItem.quantityTxt.text;
					cartContents[i].cartItem.quantityTxt.text = quantity + 1;
					updateTotal();
					return;
				}
			}
			
			if(cartItemCount == 0)
			{
				noItemsTxt.visible = false;
			}
			
			var cartItem:ShoppingCartItem = new ShoppingCartItem();			
			cartItem.removeItemBtn.addEventListener(MouseEvent.CLICK, removeProduct);
			cartItem.quantityTxt.text = String(1);
			cartItem.nameTxt.text = product.name;
			cartItem.setID(cartItemCount); // pozorny identyfikator na potrzeby mechanizmu usuwania
			cartItem.y = (cartItemCount * cartItemHeight) + lineSpacing;
			
			product.cartItem = cartItem;
			
			cartContents.push(product);
			
			addChild(cartItem);
			
			cartItemCount++;
			
			updateTotal();
		}
		
		public function removeProduct(e:MouseEvent):void
		{
			var id:uint = e.target.parent.getID();
			
			cartContents.splice(id, 1);
			removeChild(e.target.parent);
			cartItemCount--;
			
			if(cartItemCount == 0)
			{
				noItemsTxt.visible = true;
			}
			
			updateList();
			updateTotal();
		}
		
		public function updateList():void
		{
			for(var i:uint=0; i < cartItemCount; i++)
			{
				cartContents[i].cartItem.setID(i);
				cartContents[i].cartItem.y = (i * cartItemHeight) + lineSpacing;
			}
		}
		
		public function updateTotal():void
		{
			var total:Number = 0;
			for(var i:uint=0; i < cartItemCount; i++)
			{
				trace("Liczba produktów: " + cartContents[i].cartItem.quantityTxt.text);
				total += Number(cartContents[i].price) * Number(cartContents[i].cartItem.quantityTxt.text);
			}
			
			totalTxt.text = String(round2D(total));
			
			// Dodaj zero lub dwa zera
			if(totalTxt.text.indexOf(',') == -1)
			{
				totalTxt.appendText(",00");
			}
			else if(totalTxt.text.indexOf('.') + 2 == totalTxt.text.length)
			{
				totalTxt.appendText("0");
			}
			totalTxt.appendText("zł");
			
		}
		
		public function checkout():void
		{
			trace("Tutaj dodalibyśmy obsługę przeliczania");
		}
		
		public function setGatewayURL(url:String):void
		{
			gateway = url;
		}
		
		private function round2D(n:Number):Number
		{
			return Math.round(n * Math.pow(10, 2)) / Math.pow(10, 2);
		}
		
	}
	
}