<?php
if ($_POST && array_key_exists('editBook',$_POST) && !empty($_POST['book_id'])) {
  header('Location: editbook.php?book_id='.$_POST['book_id'][0]);
  }
elseif ($_POST && array_key_exists('delBook',$_POST) && !empty($_POST['delete'])) {
  header('Location: del_book.php?delete='.implode(',',$_POST['delete']));
  }
require_once('admin_funcs.php');
require_once('../classes/database.php');
$db = new Database('localhost','flashuser','deepthought','bookstore',0);
$getbooks = 'SELECT books.book_id, title, 
             CONCAT(LEFT(first_name,1),". ",family_name) AS author
             FROM books, book_to_author
			 LEFT JOIN authors USING (author_id)
			 WHERE books.book_id = book_to_author.book_id
			 ORDER BY title, family_name';
// pobierz dane dotyczce ksiek z bazy danych
$bookDets = $db->query($getbooks);
// jeli wyniki nie s puste, utwrz tablic zmiennych book_id, title oraz author
if ($bookDets->num_rows) {
  while ($row = $bookDets->fetch_assoc()) {
    $book_id[] = $row['book_id'];
    $title[] = $row['title'];
    $author[] = $row['author'];
    }
  // znajd cakowit liczb elementw dla kadej tablicy (wszystkie o tej samej dugoci)
  $totalResults = count($book_id);
  // zainicjalizuj licznik dla podtablicy 'author'
  $counter = 0;
  // przejd w ptli, aby dla kadej ksiki utworzy wielowymiarow tablic   
  for ($i = 0, $k = 0; $k < $totalResults; $k++) {
    $book[$i]['book_id'] = $book_id[$k];
    $book[$i]['title'] = $title[$k];
    $book[$i]['author'][$counter++] = $author[$k];
    // jeli identyfikator book_id nastpnego elementu jest inny, 
	// zwiksz licznik i ustaw licznik autorw na zero
	if (($k < $totalResults-1) && ($book_id[$k+1] != $book_id[$k])) {
      $i++;
	  $counter = 0;
	  }
    }
  }
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-2" />
<title>Lista ksiek</title>
<link href="admin.css" rel="stylesheet" type="text/css" />
</head>
<body>
<?php if (isset($_GET['action']) && isset($_GET['title'])) {
  echo '<p id="alert">'.stripslashes($_GET['title']).' has been ';
  echo $_GET['action'].' in the database.</p>';
  }
insertMenu(); ?>
<div id="maincontent">
  <form name="list" id="list" method="post" action="<?php $_SERVER['PHP_SELF']; ?>">
    <table id="booklist">
      <tr>
        <th scope="col">Tytu</th>
        <th scope="col">Autor</th>
        <th scope="col">Edytuj</th>
        <th scope="col">Usu</th>
      </tr>
      <?php if (!isset($book)) { ?>
      <tr><td colspan="4">W bazie nie ma ksiek</td></tr>
      <?php
        }
      else { // jeli adres URL zawiera acuch zapytania, skorzystaj z niego do zainicjalizowania zmiennej $start
        if (isset($_GET['start'])) {
        $start = $_GET['start'];
        }
      else { // w przeciwnym przypadku ustaw zmienn $start na zero
        $start = 0;
        }
      // ustaw warto maksymalnej liczby rekordw, ktre powinny by wywietlone
      $max = 10;
      if ($start+$max > count($book)) {
        // jeli $start + $max jest wiksze ni cakowita liczba rekordw 
        // ustaw grne ograniczenie w ptli na cakowit ich liczb, w przeciwnym przypadku ustaw na $start + $max
        $display = count($book);
        }
      else {
        $display = $start+$max;
        }
      // zainicjalizuj ptl, aby rozpoczynaa si od zmiennej $start
      for ($i = $start; $i < $display; $i++) { ?>
	  <tr class="<?php echo $i%2 ? 'hilite' : 'nohilite'; ?>">
        <td><?php echo $book[$i]['title'];?></td>
        <td><?php
	    array_splice($book[$i]['author'],3);
	    echo implode(', ',$book[$i]['author']);
	    ?></td>
        <td class="ctr"><input name="book_id[]" type="radio" value="<?php echo $book[$i]['book_id']; ?>" /></td>
        <td class="ctr"><input name="delete[]" type="checkbox" value="<?php echo $book[$i]['book_id']; ?>" /></td>
      </tr>
	  <?php } ?>
      <tr>
          <td colspan="2"><?php if ($start > 0) {
    echo '<a href="'.$_SERVER['PHP_SELF'].'?start='.($start-$max).'">';
    echo '&lt; POP</a>'; } ?></td>
  <td colspan="2"><?php if (count($book) > ($start+$max)) {
    echo '<a href="'.$_SERVER['PHP_SELF'].'?start='.($start+$max).'">';
    echo 'NAST &gt;</a>'; } ?></td>
      </tr>
	  <?php } ?>
      <tr>
        <td colspan="4"><input name="editBook" type="submit" id="editBook" value="Edytuj ksik" />
          <input name="delBook" type="submit" id="delBook" value="Usu ksiki" /></td>
      </tr>
    </table>
  </form>
</div>
</body>
</html>
