<?php
// utwórz instancję klasy SQLiteDatabase
$db = new SQLiteDatabase('../data/3esl.db');

// zainicjalizuj zapytanie do bazy danych
$numWords = 250;
$min = 5;
$sql = "SELECT word FROM wordlist WHERE LENGTH(word) >= $min ORDER BY RANDOM(*) LIMIT $numWords";

// wykonaj zapytanie
$result = $db->query($sql);

// zainicjalizuj łańcuch wynikowy, liczniki oraz wyrażenia regularne 
$words = '';
$count = 0;
$pattern = "/$'|[A-Z\.]/";

// przejdź w pętli poprzez wyniki, jednak pomiń te, które pasują do wyrażenia regularnego 
foreach ($result as $row) {
  if (preg_match($pattern, $row['word']))
    continue;
  // skorzystaj z licznika do utworzenia unikatowej zmiennej (word0, etc) i utwórz
  // pary ciągów znakowych nazwa/wartość, które przekażesz dalej do pliku Flasha  
  $words .= '&word'.$count.'='.urlencode($row['word']);
  $count++;
  }
unset($db);

// wynikowy ciąg znakowy przesyłany do pliku Flasha
// rozpoczyna się od całkowitej liczby zaakceptowanych słów, po której następuje ciąg par nazwa/wartość
echo 'total='.$count.$words;
?>