<?php
require_once('admin_funcs.php');
require_once('../classes/database.php');
// poniszy kod zawsze zadziaa i spowoduje pobranie listy autorw oraz wydawcw
$db=new Database('localhost','flashuser','deepthought','bookstore',0);
$getAuthors = 'SELECT author_id,
               CONCAT(first_name," ", UPPER(family_name)) AS author
               FROM authors
               ORDER BY family_name, first_name';
$authors = $db->query($getAuthors);
$getPublishers = 'SELECT * FROM publishers ORDER BY publisher';
$publishers = $db->query($getPublishers);
// pierwsza cz zostanie uruchomiona tylko wwczas, gdy formularz zostanie przesany
// zmienna book_id znajdujca si w acuchu zapytania jest uyta do pobrania szczegw dotyczcych ksiki
if ($_GET && !$_POST) {
  $book_id = $_GET['book_id'];
  // pobierz szczegy ksiki z tabeli ksiek 
    $getDets = "SELECT title,isbn,pub_id,image,description
              FROM books WHERE book_id = $book_id";
  $bookDets = $db->query($getDets);
  // przypisz wyniki do zwykych zmiennych 
  while ($row = $bookDets->fetch_assoc()) {
    $title = $row['title'];
    $isbn = $row['isbn'];
    $pub_id = $row['pub_id'];
    $image = $row['image'];
    $description = $row['description'];
    }
  // pobierz list autorw z tabeli pogldowej
  $getAuthors = "SELECT author_id FROM book_to_author
                 WHERE book_id = $book_id";
  $author_ids = $db->query($getAuthors);
  // przefiltruj wyniki do tabeli autorw
  while ($row = $author_ids->fetch_assoc()) {
    $authorList[] = $row['author_id'];
    }
  }
// ten blok zostanie wykonany tylko wwczas, gdy formularz zosta przesany 
if ($_POST && array_key_exists('updateBook',$_POST)) {
  // sprawd wystpowanie pustych pl
  foreach($_POST as $key=>$value) {
    // tabela autorw jest podtabel, wic przejd dalej
    if (is_array($value)) continue;
    $value = trim($value);
    if (empty($value)) {
      if ($key == 'isbn') {
        $error[] = 'ISBN is required';
        }
        // jeli nie zaznaczono adnego wydawcy, warto bdzie rwna 0, co PHP zinterpretuje jako warto pust 
      elseif ($key == 'publisher') {
        $error[] = 'Naley wybra wydawc';
        }
      else {
        $error[] = ucfirst($key).' jest wymagane';
        }
      }
    }
 // usu wszystkie mylniki z numeru ISBN i sprawd, czy dugo si zgadza
  $_POST['isbn'] = str_replace('-','',$_POST['isbn']);
  if (strlen($_POST['isbn']) != 10) {
    if (strlen($_POST['isbn']) != 13) {
      $error[] = 'Numer ISBN skada si z 10 lub 13 znakw (pomijajc mylniki)';
      }
    }
 // sprawd, czy autor zosta wybrany
  if ($_POST['author'][0] == 'choose' && count($_POST['author']) < 2) {
    $error[] = 'Wybierz co najmniej jednego autora lub wybierz "Not listed"';
    }
   // jeli wszystkie pola zostay poprawnie uzupenione, przygotuj wstawianie rekordw do bazy 
  if (!isset($error)) {
    // ostateczne przygotowania do wstawienia rekordw do bazy
	// poprzed cudzysowy i apostrofy znakami specjalnymi, jeli ustawienie magic_quotes_gpc off jest wczone
    if (!get_magic_quotes_gpc()) {
      foreach($_POST as $key=>$value) {
         // pomi podtablic autorw
        if (is_array($value)) continue;
        $temp = addslashes($value);
        $_POST[$key] = $temp;
        }
      }
   // utwrz nowy obiekt klasy Database i wycz raportowanie bdw
    $db = new Database('localhost','flashadmin','fortytwo','bookstore',0);
    // najpierw sprawd, czy nie istnieje ju taki sam numer ISBN
    $checkISBN = 'SELECT isbn FROM books WHERE isbn = "'.$_POST['isbn'].'"
	              AND book_id != '.$_POST['book_id'];
    $result = $db->query($checkISBN);
    if ($result->num_rows > 0) {
      $error[] = 'Ksika o podanym ISBN ju istnieje w bazie';
      }
    else {
      // jeli numer ISBN jest unikatowy, wstaw ksik do tablicy ksiek
      if ($_POST['publisher'] == 'other') $_POST['publisher'] = 0;
      $update = 'UPDATE books
                 SET title = "'.$_POST['title'].'",
                 isbn = "'.$_POST['isbn'].'",
                 pub_id = '.$_POST['publisher'].',
                 image = "'.$_POST['image'].'",
                 description = "'.$_POST['description'].'"
                 WHERE book_id = '.$_POST['book_id'];
      $result = $db->query($update);
      // pobierz klucz gwny rekordu, ktry wanie zostaw wstawiony
      if ($_POST['author'][0] == 'select') array_shift($_POST['author']);
      if (in_array('other',$_POST['author'])) {
        $i = array_search('other', $_POST['author']);
        $_POST['author'][$i] = 0;
        }
     // stwrz tablic par dla kadego autora identyfikatorw book_id, author_id 
      $values = array();
      foreach ($_POST['author'] as $author_id) {
        $values[] = '('.$_POST['book_id'].", $author_id)";
        }
      // zamie tablic na cig znakowy rozdzielony przecinkami
      $values = implode(',',$values);
      // usu istniejce rekordy, zawarte w ksice, z tabeli pogldowej
      $deleteAuthors = 'DELETE FROM book_to_author
                        WHERE book_id = '.$_POST['book_id'];
      $db->query($deleteAuthors);
       // wstaw pary book_id/author_id do tabeli pogldowej
      $createLookup = 'INSERT INTO book_to_author (book_id, author_id) 
                       VALUES '.$values;
      $result = $db->query($createLookup);
      // jeli zakoczone powodzeniem, przekieruj na stron z potwierdzeniem 
      if ($result) {
        $db->close();
        header('Location:listbooks.php?action=updated&title='.$_POST['title']);
        }
      }
	}
  }
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-2" />
<title>Edit book</title>
<link href="admin.css" rel="stylesheet" type="text/css" />
</head>
<body>
<?php insertMenu(); ?>
<div id="maincontent">
<h1>Edycja ksiki</h1>
<?php
if (isset($error)) {
  echo '<div id="alert"><p>Skoryguj ponisze dane:</p><ul>';
  foreach ($error as $item) {
    echo "<li>$item</li>";
	}
  echo '</ul></div>';
  }
?>
<form name="bookDets" id="bookDets" method="post" action="">
  <table>
    <tr>
      <th class="leftLabel">Tytu:</th>
      <td><input name="title" type="text" class="widebox" id="title" value="<?php if (isset($_POST['title'])) echo $_POST['title']; 
	  elseif (isset($title)) echo $title; ?>" /></td>
    </tr>
    <tr>
      <th class="leftLabel">ISBN:</th>
      <td><input name="isbn" type="text" class="narrowbox" id="isbn" value="<?php if (isset($_POST['isbn'])) echo $_POST['isbn']; 
	  elseif (isset($isbn)) echo $isbn; ?>" /></td>
    </tr>
    <tr>
      <th class="leftLabel">Autor:</th>
      <td><select name="author[]" size="6" multiple="multiple" id="author">
  <option value="choose" 
  <?php 
  if (isset($_POST['author']) && in_array('choose',$_POST['author'])) {
    echo 'selected="selected"'; } ?>
  >Wybierz autora</option>
  <option value="other"
  <?php if (isset($authorList) && in_array(0,$authorList) || (isset($_POST['author']) && $_POST['author'] == 'other'))
    echo 'selected="selected"'; ?>
  >Nie wylistowany</option>
  <?php while ($row = $authors->fetch_assoc()) {
    echo '<option value="'.$row['author_id'].'"';
    if ((isset($authorList) && in_array($row['author_id'],$authorList)) || (isset($_POST['author']) && in_array($row['author_id'], $_POST['author']))) {
      echo 'selected="selected"';
      }
    echo '>'.$row['author'].'</option>';
    }
  ?>
  </select></td>
    </tr>
    <tr>
      <th class="leftLabel">Wydawca:</th>
      <td><select name="publisher" id="publisher">
        <option value="0" 
		<?php if (isset($_POST['publisher']) && $_POST['publisher'] == '0')
		echo 'selected="selected"';?>>Wybierz wydawc</option>
        <option value="other"
        <?php
        if (isset($pub_id) && $pub_id == 0 || (isset($_POST['publisher']) && $_POST['publisher'] == 'other')) echo 'selected="selected"'; ?>
        >Nie wylistowany</option>
        <?php
        while ($row = $publishers->fetch_assoc()) {
          echo '<option value="'.$row['pub_id'].'"';
          if ((isset($pub_id) && $pub_id == $row['pub_id']) || (isset($_POST['publisher']) && $_POST['publisher'] == $row['pub_id']))
          echo 'selected="selected"';
        echo '>'.$row['publisher'].'</option>';
        }
      // zamknij poczenie z baz danych
      $db->close();
      ?>
	  </select></td>
    </tr>
    <tr>
      <th class="leftLabel">Rysunek:</th>
      <td>Tak
        <input name="image" type="radio" value="y"
        <?php if ((isset($image) && $image == 'y') || (isset($_POST['image']) && $_POST['image'] == 'y')) {
          echo 'checked="checked"'; }?>  /> 
        Nie 
        <input name="image" type="radio" value="n" 
        <?php if ((isset($image) && $image == 'n') || (isset($_POST['image']) && $_POST['image'] == 'n')) echo 'checked="checked"';?> /></td>
    </tr>
    <tr>
      <th class="leftLabel">Opis:</th>
      <td><textarea name="description" id="description"><?php 
	  if (isset($_POST['description'])) echo $_POST['description']; 
	  elseif (isset($description)) echo $description; ?></textarea></td>
    </tr>
    <tr>
      <td><input name="book_id" type="hidden" id="book_id" value="
      <?php if ($_GET) echo $book_id;
         elseif (isset($_POST['book_id'])) echo $_POST['book_id'];?>" /></td>
      <td><input type="submit" name="updateBook" value="Update book details" /></td>
    </tr>
  </table>
</form>
</div>
</body>
</html>
