<?php
require_once('admin_funcs.php');
require_once('../classes/database.php');
// ten kod jest uruchamiany zawsze i pobiera list autorw i wydawnictw
$db=new Database('localhost','flashuser','deepthought','bookstore',0);
$getAuthors = 'SELECT author_id,
               CONCAT(first_name," ", UPPER(family_name)) AS author
               FROM authors
               ORDER BY family_name, first_name';
$authors = $db->query($getAuthors);
$getPublishers = 'SELECT * FROM publishers ORDER BY publisher';
$publishers = $db->query($getPublishers);
// ten kod jest wykonywany, gdy przesano formularz
if ($_POST) {
  // szuka pustych pl
  foreach($_POST as $key=>$value) {
    //  element authors jako podtablica jest pomijany
    if (is_array($value)) continue;
    $value = trim($value);
    if (empty($value)) {
      if ($key == 'isbn') {
        $error[] = 'ISBN jest wymagany';
        }
      // jeeli nie wybrano wydawnictwa, warto wynosi 0, co PHP interpretuje jako puste pole
      elseif ($key == 'publisher') {
        $error[] = 'Musisz wybra wydawnictwo';
        }
      else {
        $error[] = ucfirst($key).' jest wymagany';
        }
      }
    }
  // usuwa mylniki z ISBN i sprawdza, czy ma poprawn dugo
  $_POST['isbn'] = str_replace('-','',$_POST['isbn']);
  if (strlen($_POST['isbn']) != 10) {
    if (strlen($_POST['isbn']) != 13) {
      $error[] = 'Numery ISBN skadaj si 10 lub 13 znakw (nie liczc mylnikw)';
      }
    }
  // check that an author has been chosen
  if ($_POST['author'][0] == 'choose' && count($_POST['author']) < 2) {
    $error[] = 'Select at least one author, or choose "spoza listy"';
    }
   // jeeli wszystkie pola s poprawnie wypenione przygotowuje dane do wstawienia
  // do bazy
  if (!isset($error)) {
    // ostateczne przygotowania do wstawienia
	// jeeli magic_quotes_gpc=off poprzedza wszystkie cudzysowy i apostrofy lewymi ukonikami
    if (!get_magic_quotes_gpc()) {
      foreach($_POST as $key=>$value) {
        // pomija podtablic author
        if (is_array($value)) continue;
        $temp = addslashes($value);
        $_POST[$key] = $temp;
        }
      }
    // tworzy egzemplarz klasy Database i ustawia raportowanie bdw na zwyky tekst
    $db = new Database('localhost','flashadmin','fortytwo','bookstore',0);
    // first check that the same ISBN doesn't already exist
    $checkISBN = 'SELECT isbn FROM books
	              WHERE isbn = "'.$_POST['isbn'].'"';
    $result = $db->query($checkISBN);
    if ($result->num_rows > 0) {
      $error[] = 'Ksika o takim numerze ISBN istnieje ju w bazie';
      }
    else {
      // Jeeli ISBN jest nowy, aktualizuje tabel books
	  if ($_POST['publisher'] == 'other') $_POST['publisher'] = 0;
	  $insert = 'INSERT INTO books (title,isbn,pub_id,image,description)
                 VALUES ("'.$_POST['title'].'","'.$_POST['isbn'].'",'.
                 $_POST['publisher'].',"'.$_POST['image'].'",
                 "'.$_POST['description'].'")';
      $result = $db->query($insert);
      // pobiera klucz gwny wanie wstawionego rekordu
	  $getBook_id = 'SELECT book_id FROM books
                     WHERE isbn = "'.$_POST['isbn'].'"';
      $result = $db->query($getBook_id);
      $row = $result->fetch_assoc();
      $book_id = $row['book_id'];
	  // jeeli w menu "Wybierz autora(autorw)" pozostao zaznaczenie, usuwa je z tablicy
	  if ($_POST['author'][0] == 'choose') array_shift($_POST['author']);
      if (in_array('other',$_POST['author'])) {
	    $i = array_search('other', $_POST['author']);
		$_POST['author'][$i] = 0;
		}
      // buduje tablic par book_id i author_id - po jednej dla kadego autora
      $values = array();
      foreach ($_POST['author'] as $author_id) {
        $values[] = "($book_id, $author_id)";
        }
      // konwertuje tablic na cig separowany przecinkami
      $values = implode(',',$values);
      // wstawia pary book_id-author_id do tablicy wyszukiwania
      $createLookup = 'INSERT INTO book_to_author (book_id, author_id)
                        VALUES '.$values;
      $result = $db->query($createLookup);
      // jeli wszystko si uda, przekierowuje na stron potwierdzajc sukces
      if ($result) {
	    $db->close();
        header('Location: listbooks.php?action=inserted&title='.$_POST['title']);
        }
      }
	}
  }
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<title>Insert new book</title>
<link href="admin.css" rel="stylesheet" type="text/css" />
</head>
<body>
<?php insertMenu(); ?>
<div id="maincontent">
<h1>Dodaj now ksik</h1>
<?php
if (isset($error)) {
  echo '<div id="alert"><p>Prosz poprawi nastpujce elementy:</p><ul>';
  foreach ($error as $item) {
    echo "<li>$item</li>";
	}
  echo '</ul></div>';
  }
?>
<form name="bookDets" id="bookDets" method="post" action="">
  <table>
    <tr>
      <th class="leftLabel">tytu:</th>
      <td><input name="title" type="text" class="widebox" id="title" value="<?php if (isset($_POST['title'])) echo $_POST['title']; ?>" /></td>
    </tr>
    <tr>
      <th class="leftLabel">ISBN:</th>
      <td><input name="isbn" type="text" class="narrowbox" id="isbn" value="<?php if (isset($_POST['isbn'])) echo $_POST['isbn']; ?>" /></td>
    </tr>
    <tr>
      <th class="leftLabel">autor(autorzy):</th>
      <td><select name="author[]" size="6" multiple="multiple" id="author">
            <option value="choose" 
            <?php 
            if (!isset($_POST['author']) || (isset($_POST['author']) && in_array('choose',$_POST['author']))) {
              echo 'selected="selected"';
              }
            ?>
            >Wybierz autora(autorw)</option>
            <option value="other"
			<?php
            if (isset($_POST['author']) && $_POST['author'] == 'other')
              echo 'selected="selected"'; ?>
			>spoza listy</option>
            <?php
            while ($row = $authors->fetch_assoc()) {
              echo '<option value="'.$row['author_id'].'"';
              if (isset($_POST['author']) && in_array($row['author_id'],$_POST['author'])) {
                echo 'selected="selected"';
                }
              echo '>'.$row['author'].'</option>';
              }
            ?>
          </select></td>
    </tr>
    <tr>
      <th class="leftLabel">Wydawnictwo:</th>
      <td><select name="publisher" id="publisher">
        <option value="0" 
		<?php if (isset($_POST['publisher']) && $_POST['publisher'] == '0')
		echo 'selected="selected"';?>>Wybierz wydawnictwo</option>
        <option value="other"
		<?php
		  if (isset($_POST['publisher']) && $_POST['publisher'] == 'other')
		    echo 'selected="selected"';
		?>
		>spoza listy</option>
      <?php
      while ($row = $publishers->fetch_assoc()) {
        echo '<option value="'.$row['pub_id'].'"';
		if (isset($_POST['publisher']) && $_POST['publisher'] == $row['pub_id'])
          echo 'selected="selected"';
        echo '>'.$row['publisher'].'</option>';
        }
      // zamyka poczenie z baz
      $db->close();
      ?>
	  </select></td>
    </tr>
    <tr>
      <th class="leftLabel">Okadka:</th>
      <td>tak
        <input name="image" type="radio" value="y"
        <?php
        if (!$_POST || (isset($_POST['image']) && $_POST['image'] == 'y')) {
          echo 'checked="checked"';
          }?> /> 
           nie
        <input name="image" type="radio" value="n" 
        <?php if (isset($_POST['image']) && $_POST['image'] == 'n')
          echo 'checked="checked"';?> /></td>
    </tr>
    <tr>
      <th class="leftLabel">Opis:</th>
      <td><textarea name="description" id="description"><?php 
	  if (isset($_POST['description'])) echo $_POST['description']; ?></textarea></td>
    </tr>
    <tr>
      <td>&nbsp;</td>
      <td><input type="submit" name="Submit" value="Dodaj now ksik" /></td>
    </tr>
  </table>
</form>
</div>
</body>
</html>
