<?php
require_once('admin_funcs.php');
require_once('../classes/database.php');
// ten kod jest uruchamiany zawsze i pobiera list autorw i wydawnictw
$db=new Database('localhost','flashuser','deepthought','bookstore',0);
$getAuthors = 'SELECT author_id,
               CONCAT(first_name," ", UPPER(family_name)) AS author
               FROM authors
               ORDER BY family_name, first_name';
$authors = $db->query($getAuthors);
$getPublishers = 'SELECT * FROM publishers ORDER BY publisher';
$publishers = $db->query($getPublishers);
// ten kod jest uruchamiany tylko wtedy, gdy przesany zosta formularz
if ($_POST) {
  // sprawdza, czy pola nie s puste
  foreach($_POST as $key=>$value) {
    // authors to podtablica wic nie jest tu brana pod uwag
    if (is_array($value)) continue;
    $value = trim($value);
    if (empty($value)) {
      if ($key == 'isbn') {
        $error[] = 'Wymagany jest numer ISBN';
        }
      // jeeli nie wybrano adnego wydawnictwa, warto wynosi 0, co PHP traktuje jako FALSE
      elseif ($key == 'publisher') {
        $error[] = 'Musisz wybra wydawnictwo';
        }
      else {
        $error[] = 'Pole: '.ucfirst($key).' jest wymagane';
        }
      }
    }
  // usuwa mylniki z numeru ISBN i sprawdza, czy ma poprawn dugo
  $_POST['isbn'] = str_replace('-','',$_POST['isbn']);
  if (strlen($_POST['isbn']) != 10) {
    if (strlen($_POST['isbn']) != 13) {
      $error[] = 'Numery ISBN maj od 10 do 13 znakw (nie liczc mylnikw)';
      }
    }
  // sprawdza, czy wybrano jakiego autora
  if ($_POST['author'][0] == 'choose' && count($_POST['author']) < 2) {
    $error[] = 'Wybierz przynajmniej jednego autora, albo opcj "spoza listy"';
    }
  // jeeli wszystkie pola s prawidowo wypenione przygotowuje dane do wstawienia do bazy
  if (!isset($error)) {
    // ostateczne przygotowania do wstawienia
	// cudzysowy i apostrofy poprzedza lewym ukonikiem jeli opcja 
        // magic_quotes_gpc jest wyczona (off)
    if (!get_magic_quotes_gpc()) {
      foreach($_POST as $key=>$value) {
        // pomija podtabel autorw
        if (is_array($value)) continue;
        $temp = addslashes($value);
        $_POST[$key] = $temp;
        }
      }
    // tworzy egzemplarz klasy Database i ustawia raportowanie bdw jako zwyky tekst
    $db = new Database('localhost','flashadmin','fortytwo','bookstore',0);
    // najpierw sprawdza, czy taki sam ISBN ju nie istnieje w bazie
    $checkISBN = 'SELECT isbn FROM books
	              WHERE isbn = "'.$_POST['isbn'].'"';
    $result = $db->query($checkISBN);
    if ($result->num_rows > 0) {
      $error[] = 'W bazie istnieje ju ksika o takim numerze ISBN';
      }
    else {
      // jeeli numer ISBN jest nowy, wtawia ksik do tabeli books
	  if ($_POST['publisher'] == 'other') $_POST['publisher'] = 0;
	  $insert = 'INSERT INTO books (title,isbn,pub_id,image,description)
                 VALUES ("'.$_POST['title'].'","'.$_POST['isbn'].'",'.
                 $_POST['publisher'].',"'.$_POST['image'].'",
                 "'.$_POST['description'].'")';
      $result = $db->query($insert);
      // pobiera klucz gwny wanie wstawionego rekordu
	  $getBook_id = 'SELECT book_id FROM books
                     WHERE isbn = "'.$_POST['isbn'].'"';
      $result = $db->query($getBook_id);
      $row = $result->fetch_assoc();
      $book_id = $row['book_id'];
	  // jeeli w menu "Wybierz autora(autorw)" pozostao zaznaczenie, jest usuwane z tablicy
	  if ($_POST['author'][0] == 'choose') array_shift($_POST['author']);
      if (in_array('other',$_POST['author'])) {
	    $i = array_search('other', $_POST['author']);
		$_POST['author'][$i] = 0;
		}
      // buduje tablic par book_id i author_id, po jednej dla kadego autora
      $values = array();
      foreach ($_POST['author'] as $author_id) {
        $values[] = "($book_id, $author_id)";
        }
      // konwertuje tablic na cig separowany przecinkami
      $values = implode(',',$values);
      // wstawia pary book_id/author_id do tabeli wyszukiwania
      $createLookup = 'INSERT INTO book_to_author (book_id, author_id)
                        VALUES '.$values;
      $result = $db->query($createLookup);
      // w razie sukcesu przekierowuje na stron potwierdzajc dodanie ksiki
      if ($result) {
	    $db->close();
        header('Location: listbooks.php?action=inserted&title='.$_POST['title']);
        }
      }
    }
  }
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<title>Insert new book</title>
<link href="admin.css" rel="stylesheet" type="text/css" />
</head>
<body>
<?php insertMenu(); ?>
<div id="maincontent">
<h1>Dodaj now ksik</h1>
<?php
if (isset($error)) {
  echo '<div id="alert"><p>Prosz poprawi nastpujce bdy:</p><ul>';
  foreach ($error as $item) {
    echo "<li>$item</li>";
	}
  echo '</ul></div>';
  }
?>
<form name="bookDets" id="bookDets" method="post" action="">
  <table>
    <tr>
      <th class="leftLabel">Tytu:</th>
      <td><input name="title" type="text" class="widebox" id="title" value="" /></td>
    </tr>
    <tr>
      <th class="leftLabel">ISBN:</th>
      <td><input name="isbn" type="text" class="narrowbox" id="isbn" value="" /></td>
    </tr>
    <tr>
      <th class="leftLabel">Autor(autorzy):</th>
      <td><select name="author[]" size="6" multiple="multiple" id="author">
          <option value="choose" selected="selected">Wybierz autora(autorw)</option>
          <option value="other">spoza listy</option>
	   <?php
       while ($row = $authors->fetch_assoc()) {
         echo '<option value="'.$row['author_id'].'">'; 
         echo $row['author'].'</option>';
         }
       ?>
        </select></td>
    </tr>
    <tr>
      <th class="leftLabel">Wydawnictwo:</th>
      <td><select name="publisher" id="publisher">
        <option value="0" selected="selected">Wybierz wydawnictwo</option>
        <option value="other">spoza listy</option>
      <?php
      while ($row = $publishers->fetch_assoc()) {
        echo '<option value="'.$row['pub_id'].'">'; 
        echo $row['publisher'].'</option>';
        }
      // zamyka poczenie z baz
      $db->close();
      ?>
	  </select></td>
    </tr>
    <tr>
      <th class="leftLabel">Okadka:</th>
      <td>tak
        <input name="image" type="radio" value="y" />
        No
        <input name="image" type="radio" value="n" /></td>
    </tr>
    <tr>
      <th class="leftLabel">Opis:</th>
      <td><textarea name="description" id="description"></textarea></td>
    </tr>
    <tr>
      <td>&nbsp;</td>
      <td><input type="submit" name="Submit" value="Dodaj now ksik" /></td>
    </tr>
  </table>
</form>
</div>
</body>
</html>
