<?php
if ($_POST && array_key_exists('editBook',$_POST) && !empty($_POST['book_id'])) {
  header('Location: editbook.php?book_id='.$_POST['book_id'][0]);
  }
elseif ($_POST && array_key_exists('delBook',$_POST) && !empty($_POST['delete'])) {
  header('Location: del_book.php?delete='.implode(',',$_POST['delete']));
  }
require_once('admin_funcs.php');
require_once('../classes/database.php');
$db = new Database('localhost','flashuser','deepthought','bookstore',0);
$getbooks = 'SELECT books.book_id, title, 
             CONCAT(LEFT(first_name,1),". ",family_name) AS author
             FROM books, book_to_author
			 LEFT JOIN authors USING (author_id)
			 WHERE books.book_id = book_to_author.book_id
			 ORDER BY title, family_name';
// pobiera dane ksiek z bazy
$bookDets = $db->query($getbooks);
// jeeli w bazie s jakie ksiki, tworzy tablice elementw book_id, title i author
if ($bookDets->num_rows) {
  while ($row = $bookDets->fetch_assoc()) {
    $book_id[] = $row['book_id'];
    $title[] = $row['title'];
    $author[] = $row['author'];
    }
  // ustala cakowit liczb elementw w kadej tabeli (wszystkie maj t sam dugo)
  $totalResults = count($book_id);
  // inicjalizuje licznik podtablicy 'author'
  $counter = 0;
  // ptla tworzca jedn wielowymiarow tablic dla wszystkich ksiek
  for ($i = 0, $k = 0; $k < $totalResults; $k++) {
    $book[$i]['book_id'] = $book_id[$k];
    $book[$i]['title'] = $title[$k];
    $book[$i]['author'][$counter++] = $author[$k];
     // jeeli book_id nastpnego elementu jest inny
	// zwiksza licznik ksiek i zeruje licznik autorw
	if (($k < $totalResults-1) && ($book_id[$k+1] != $book_id[$k])) {
      $i++;
	  $counter = 0;
	  }
    }
  }
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<title>Lista ksiek</title>
<link href="admin.css" rel="stylesheet" type="text/css" />
</head>
<body>
<?php insertMenu(); ?>
<div id="maincontent">
  <form name="list" id="list" method="post" action="<?php $_SERVER['PHP_SELF']; ?>">
    <table id="booklist">
      <tr>
        <th scope="col">Tytu</th>
        <th scope="col">Autorzy</th>
        <th scope="col">Edytuj</th>
        <th scope="col">Usu</th>
      </tr>
      <?php if (!isset($book)) { ?>
      <tr><td colspan="4">W bazie nie ma ksiek</td></tr>
      <?php
        }
      else { // jeeli URL zawiera cig zapytania inicjalizuje na jego podstawie $start
        if (isset($_GET['start'])) {
        $start = $_GET['start'];
        }
      else { // w innym wypadku ustawia $start na zero
        $start = 0;
        }
      // ustawia maksymaln ilo wywietlanych rekordw
      $max = 10;
      if ($start+$max > count($book)) {
        // jeeli $start + $max jest wiksze ni cakowita liczba rekordw
        // ustawia limit ptli na cakowit liczb rekordw, a w innym razie na $start + $max
        $display = count($book);
        }
      else {
        $display = $start+$max;
        }
      // inicjalizuje ptl tak by zacza si od wartoci $start
      for ($i = $start; $i < $display; $i++) { ?>
	  <tr class="<?php echo $i%2 ? 'hilite' : 'nohilite'; ?>">
        <td><?php echo $book[$i]['title'];?></td>
        <td><?php
	    array_splice($book[$i]['author'],3);
	    echo implode(', ',$book[$i]['author']);
	    ?></td>
        <td class="ctr"><input name="book_id[]" type="radio" value="<?php echo $book[$i]['book_id']; ?>" /></td>
        <td class="ctr"><input name="delete[]" type="checkbox" value="<?php echo $book[$i]['book_id']; ?>" /></td>
      </tr>
	  <?php } ?>
      <tr>
          <td colspan="2"><?php if ($start > 0) {
    echo '<a href="'.$_SERVER['PHP_SELF'].'?start='.($start-$max).'">';
    echo '&lt; Poprz</a>'; } ?></td>
  <td colspan="2"><?php if (count($book) > ($start+$max)) {
    echo '<a href="'.$_SERVER['PHP_SELF'].'?start='.($start+$max).'">';
    echo 'Nast &gt;</a>'; } ?></td>
      </tr>
	  <?php } ?>
      <tr>
        <td colspan="4"><input name="editBook" type="submit" id="editBook" value="Edytuj ksizk" />
          <input name="delBook" type="submit" id="delBook" value="Usu ksiki" /></td>
      </tr>
    </table>
  </form>
</div>
</body>
</html>
