<?php
if (isset($_POST['action'])) {
  require_once('../classes/database_mysql.php');
  $db = new Database('localhost','flashuser','deepthought','bookstore');
  // wsplne dla wszystkich zapyta SQL
  $sql = 'SELECT books.book_id,title,publisher,isbn,description,
          list_price,store_price,image FROM books,publishers';
  // buduje reszt zapytania w zalenoci od wartoci action otrzymanej z Flasha
  switch($_POST['action']) {
    case 'getLatest':
	  $sql .=  ' WHERE books.pub_id = publishers.pub_id
			    ORDER BY book_id DESC LIMIT 5';
	  break;
	case 'fullList':
	  $sql .= ' WHERE books.pub_id = publishers.pub_id
			   ORDER BY title';
	  break;
	case 'byAuthor':
	  $sql .= ',authors,book_to_author
			   WHERE CONCAT(first_name," ",family_name)
			   LIKE "%'.trim($_POST['searchFor']).'%"
			   AND book_to_author.author_id = authors.author_id
			   AND book_to_author.book_id = books.book_id
			   AND books.pub_id = publishers.pub_id';
	  break;
	case 'byTitle':
	  $sql .= ' WHERE title LIKE "%'.trim($_POST['searchFor']).'%"
			   AND books.pub_id = publishers.pub_id';
	  break;
	case 'byISBN':
	  $isbn = str_replace('-','',$_POST['searchFor']);
	  $sql .= ' WHERE isbn = "'.trim($isbn).'"
			   AND books.pub_id = publishers.pub_id';
	}
  // uruchamia zapytanie i przetwarza rezultaty
  $result = $db->query($sql);
  $numRows = $result->num_rows;
  // rozpoczyna cig wynikowy od liczby rezultatw i typu czynnoci
  $output = "total={$numRows}&resultType=".$_POST['action'];
  // tworzy licznik w celu identyfikacji zwizanych zmiennych
  $i=0;
  while ($row = $result->fetch_assoc()) {
    foreach ($row as $key => $value) {
      // pobiera list autorw na podstawie book_id
      if ($key == 'book_id') {
        $output .= "&authors{$i}=".urlencode(getAuthors($db,$value));
        }
      // tworzy krtk wersj opisu
      elseif ($key == 'description') {
        $output .= "&short{$i}=".urlencode(shortDesc($value));
        }
      // tworzy zmienn, skadajc si z klucza tablicy i $i
      // i przypisuje jej warto zakodowan w cigu URL
      $output .= "&{$key}{$i}=".urlencode($value);
      }
    // zwiksza licznik zmiennych, ktre maj by przesane do Flasha
    $i++;
    }
  // wysya wyniki z powrotem do Flasha
  echo $output;
  }

// pobiera list autorw uywajc book_id
function getAuthors($db,$book_id) {
  $authorQuery = "SELECT CONCAT(first_name,' ',family_name) AS author
                  FROM authors,book_to_author
			      WHERE book_to_author.book_id = $book_id
			      AND authors.author_id = book_to_author.author_id
			      ORDER BY family_name";
  $authorResult = $db->query($authorQuery);
  while ($row = $authorResult->fetch_assoc()) {
    // usuwa pierwsze pi znakw z kadego rezultatu rozpoczynajcego si od "NULL"
    if (strpos($row['author'],'NULL') === 0) {
	  $authors[] = substr($row['author'],5);
	  }
	else {
      $authors[] = $row['author'];
	  }
	}
  if (!empty($authors)) {
    // jeeli jest wicej ni trzech autorw, uywa tylko pierwszych dwch
	// i czy to z cigiem "i inni"
    if (count($authors) > 3) {
	  array_splice($authors,2);
	  return implode(', ',$authors).' i inni';
	  }
	// w innym wypadku tworzy separowany przecinkami cig autorw
	else {
      return implode(', ',$authors);
	  }
	}
  else {
    return '';
	}
  }

// pobiera pierwsze zdanie z wartoci description
function shortDesc($description) {
  // odnajduje pozycj pierwszej kropki po ktrej nastpuje spacja
  $period = strpos($description, '. ');
  // szuka pierwszego znaku zapytania lub wykrzyknika
  $marks = strcspn($description, '?!');
  // wybiera mniejsz warto, by oznaczy koniec pierwszego zdania
  if ($period && $period < $marks) { 
    return substr($description,0,$period+1);
	}
  elseif ($period && $marks < $period) {
    return substr($description,0,$marks+1);
	}
  // jeeli cig $period jest pusty, zwraca $description bez zmian
  else {
    return $description;
	}
  }
?>