<?php
// assign data incoming from Flash to simpler variables

$a = $_POST['value1'];
$b = $_POST['value2'];
$type = $_POST['conversionType'];
$units1 = $_POST['units1'];
$units2 = $_POST['units2'];

// select the appropriate conversion formula
switch($type) {
  // Area conversion
  case 'acreToHa':
    $r = $a * .405;
    $unitsR = 'ha';
    break;
  case 'haToAcre':
    $r = $a * 2.471;
    $unitsR = 'a';
    break;
  case 'sqftToM2':
    $r = $a * .0929;
    $unitsR = 'm';
    break;
  case 'sqydToM2':
    $r = $a * .836;
    $unitsR = 'm';
    break;
  case 'M2toSqft':
    $r = $a / .0929;
    $unitsR = 'sq ft';
    break;
  case 'M2toSqyd':
    $r = $a / .836;
    $unitsR = 'sq yd';
    break;
  
  // Length conversion
  case 'inToCm':
    $r = $a * 2.54;
    $unitsR = 'cm';
    break;
  case 'cmToIn':
    $r = $a / 2.54;
    $unitsR = 'in';
    break;
  case 'ftToM':
    $r = $a * .305;
    $unitsR = 'm';
    break;
  case 'ydToM':
    $r = $a * .914;
    $unitsR = 'm';
    break;

  // Temperature conversion
  case 'cToF':
    $r = ($a / 5) * 9 + 32;
    $unitsR = 'F';
    break;
  case 'fToC':
    $r = ($a - 32) / 9 * 5;
    $unitsR = 'C';
    break;
	
  // Capacity conversion
  case 'ptToLtr':
    $r = $a * .473;
    $r2 = $a * .568;
    $unitsUS = 'US pt';
    $unitsImp = 'GB pt';
    $unitsR = 'l';
    break;
  case 'galToLtr':
    $r = $a * 3.785;
    $r2 = $a * 4.546;
    $unitsUS = 'US gall';
    $unitsImp = 'GB gall';
    $unitsR = 'l';
    break;
  case 'ltrToPt':
    $r = $a / .473;
    $r2 = $a / .568;
    $unitsR = 'US pt';
    $unitsR2 = 'GB pt';
    break;
  case 'ltrToGal':
    $r = $a / 3.785;
    $r2 = $a / 4.546;
    $unitsR = 'US gall';
    $unitsR2 = 'GB gall';
    break;
  case 'UStoImp':
    $pints = $a * 8 + $b;
    $pints /= 1.201;
    $units1 = 'US gall';
    $units2 = empty($a) ? 'US pt' : 'pints';
    $unitsR = 'GB gall';
    $r = floor($pints / 8);
    $unitsR2 = $r ? 'pints' : 'GB pt';
    $r2 = $pints - ($r * 8);
    break;
  case 'ImpToUS':
    $pints = $a * 8 + $b;
    $pints *= 1.201;
    $units1 = 'GB gall';
    $units2 = empty($a) ? 'GB pt' : 'pints';
    $unitsR = 'US gall';
    $r = floor($pints / 8);
    $unitsR2 = $r ? 'pints' : 'US pt';
    $r2 = $pints - ($r * 8);
    break;

  // Weight conversion
  case 'lbToKg':
    $oz = $a * 16 + $b;
    $r = $oz / 16 * .454;
    $unitsR = 'kg';
    break;
  case 'kgToLb':
    $oz = $a / .454 * 16;
    $r = floor($oz / 16);
    $r2 = $oz % 16;
    $unitsR = 'lb';
    $unitsR2 = 'oz';
    break;
  case 'lbToSt':
    $r = floor($a / 14);
    $r2 = $a % 14;
    $unitsR = 'st';
    $unitsR2 = 'lb';
    break;
  case 'stToLb':
    $r = $a * 14 + $b;
    $unitsR = 'lb';
    break;

  }

// sformatuj wyniki, aby mc przesa je do pliku Flasha
switch($type) {
  case 'ptToLtr':
  case 'galToLtr':
    // sformatuj wyniki z pint amerykaskich/galonw na litry
    $output = $a.' '.$unitsUS.' = '.sprintf('%0.2f', $r).' '.$unitsR."\n";
	 // sformatuj wyniki z pint brytyjskich/galonw na litry
    $output .= $a.' '.$unitsImp.' = '.sprintf('%0.2f', $r2).' '.$unitsR;
    break;

 case 'ltrToPt':
  case 'ltrToGal':
    // zamie wyniki z litrw na pinty amerykaskie/galony
    $output = $a.' '.$units1.' = '.sprintf('%0.2f', $r).' '.$unitsR."\n";
    // analogicznie sformatuj wyniki na brytyjskie odpowiedniki 
    $output .= 'or '.sprintf('%0.2f', $r2).' '.$unitsR2;
    break;

  case 'UStoImp':
  case 'ImpToUS':
    // porwnaj lewe oraz prawe dane wejciowe - jeli nie s puste, odpowiednio je sformatuj 
	// jeli nie ma adnych danych wejciowych, zwr pusty cig znakowy
    $output = (!empty($a)) ? ($a.' '.$units1.' ') : '';
    $output .= (!empty($b)) ? ($b.' '.$units2) : '';
	// wywietl znak rwnoci, zakoczony znakiem nowej linii
    $output .= " =\n";
	// jeli $r (galony) jest rne od zera, odpowiednio sformatuj wyniki
    $output .= $r ? ($r.' '.$unitsR.' ' ): '';
	// sformatuj $r2 (pinty)
    $output .= sprintf('%0.2f',$r2).' '.$unitsR2;
    break;

  case 'lbToKg':
  case 'stToLb':
    $output = (!empty($a)) ? ($a.' '.$units1.' ') : '';
    $output .= (!empty($b)) ? ($b.' '.$units2) : '';
    $output .= ' = ';
    $output .= $unitsR == 'lb' ? $r : sprintf('%0.3f', $r);
    $output .= ' '.$unitsR;
    break;

  case 'mToFt':
  case 'mToYd':
  case 'kgToLb':
  case 'lbToSt':
    $output = "$a $units1 = $r $unitsR $r2 $unitsR2";
  break;

  default:
    // sformatuj pierwsze jednostki dla pojedynczych i podwjnych wartoci 
    $output = $a.' '.$units1.' = ';
	// sformatuj pomocnicze jednostki - zaokrglij temperatur do jednego miejsca po przecinku
	$output .= strpos($unitsR, '') === 0 ? sprintf('%0.1f', $r).$unitsR : (sprintf('%0.2f',$r).' '.$unitsR);
    }
// przelij dane z powrotem do pliku Flasha
echo 'output='.urlencode($output);
?>