package 
{
	import com.adobe.utils.AGALMiniAssembler;
	import com.adobe.utils.PerspectiveMatrix3D;
	import flash.display.Bitmap;
	import flash.display.Sprite;
	import flash.display.Stage3D;
	import flash.display3D.Context3D;
	import flash.display3D.Context3DProgramType;
	import flash.display3D.Context3DTextureFormat;
	import flash.display3D.Context3DVertexBufferFormat;
	import flash.display3D.IndexBuffer3D;
	import flash.display3D.Program3D;
	import flash.display3D.textures.Texture;
	import flash.display3D.VertexBuffer3D;
	import flash.events.Event;
	import flash.geom.Matrix3D;
	import flash.geom.Vector3D;
	import flash.utils.getTimer;
	
	public class Stage3DExample extends Sprite 
	{
		[Embed(source="../assets/flashlogo.jpg")]
		public var FlashJPG:Class;
		
		private var context3D:Context3D;
		private var stage3D:Stage3D;
		private var vertexBuffer3D:VertexBuffer3D;
		private var indexBuffer3D:IndexBuffer3D; 
		private var program3D:Program3D;
		private var texture:Texture;
		
		public function Stage3DExample():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			stage3D = stage.stage3Ds[0];
			stage3D.addEventListener(Event.CONTEXT3D_CREATE, context3DCreated);
			stage3D.requestContext3D();			
		}
		
		private function context3DCreated(e:Event):void
		{
			context3D = stage3D.context3D;
			context3D.configureBackBuffer(stage.stageWidth, stage.stageHeight, 4);
			
			var vertices:Vector.<Number> = Vector.<Number>([
				 .5, -.5, 0, 0, 0,
				 .5,  .5, 0, 0, 1,
				-.5,  .5, 0, 1, 1,
				-.5, -.5, 0, 1, 0
			]);
			vertexBuffer3D = context3D.createVertexBuffer(4, 5);
			vertexBuffer3D.uploadFromVector(vertices, 0, 4);
			
			indexBuffer3D = context3D.createIndexBuffer(6);			
			indexBuffer3D.uploadFromVector (Vector.<uint>([2, 1, 0, 2, 3, 0]), 0, 6);
			
			var bitmap:Bitmap = new FlashJPG();
			texture = context3D.createTexture(bitmap.bitmapData.width, bitmap.bitmapData.height, Context3DTextureFormat.BGRA, false);
			texture.uploadFromBitmapData(bitmap.bitmapData);
			
			var vertexShaderAssembler:AGALMiniAssembler = new AGALMiniAssembler();
			vertexShaderAssembler.assemble(Context3DProgramType.VERTEX,
				"m44 op, va0, vc0\n" +
				"mov v0, va1"
			);
			
			var fragmentShaderAssembler:AGALMiniAssembler= new AGALMiniAssembler();
			fragmentShaderAssembler.assemble( Context3DProgramType.FRAGMENT,
				"tex ft1, v0, fs0 <2d,linear,nomip>\n" +
				"mov oc, ft1"
			);
			
			program3D = context3D.createProgram();
			program3D.upload(vertexShaderAssembler.agalcode, fragmentShaderAssembler.agalcode);
			
			addEventListener(Event.ENTER_FRAME, enterFrame);	
		}
		
		private function enterFrame(e:Event):void
		{
			context3D.clear(1,1,1,1);
			context3D.setVertexBufferAt (0, vertexBuffer3D, 0, Context3DVertexBufferFormat.FLOAT_3);
			context3D.setVertexBufferAt(1, vertexBuffer3D, 3, Context3DVertexBufferFormat.FLOAT_2);
			context3D.setTextureAt(0, texture);
			context3D.setProgram(program3D);
			
			var projection:PerspectiveMatrix3D = new PerspectiveMatrix3D();
			projection.perspectiveFieldOfViewLH(45*Math.PI/180, 4/3, 0.1, 1000);
			
			var matrix:Matrix3D = new Matrix3D(); 
			matrix.appendRotation(getTimer() * .05, Vector3D.Y_AXIS);
			matrix.appendRotation(getTimer() * -.05, Vector3D.X_AXIS);
			matrix.appendTranslation(0, 0, 2);
			matrix.append(projection);
			context3D.setProgramConstantsFromMatrix(Context3DProgramType.VERTEX, 0, matrix, true);
			context3D.drawTriangles(indexBuffer3D);
			context3D.present();
		}
	}
}
