package
{	
	import flash.display.StageAlign;
	import flash.display.StageQuality;
	import flash.display.StageScaleMode;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.events.MouseEvent;
	import flash.geom.Vector3D;
	import flash.ui.Keyboard;
	
	import away3d.containers.View3D;
	import away3d.containers.ObjectContainer3D;
	import away3d.core.clip.FrustumClipping;
	import away3d.primitives.Cube;
	import away3d.primitives.Plane;
	
	import com.greensock.TimelineMax;
	import com.greensock.TweenMax;
	import com.greensock.easing.*;
	
	public class CameraPropertiesExample extends Sprite
	{
		private var panel:CameraPropertiesPanel;
		private var view:View3D;
		private var ctrlDown:Boolean = false;
		private var upArrowDown:Boolean = false;
		private var downArrowDown:Boolean = false;
		private var leftArrowDown:Boolean = false;
		private var rightArrowDown:Boolean = false;
		
		public function CameraPropertiesExample() 
		{
			stage.quality = StageQuality.LOW;
			stage.align =  StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
			stage.addEventListener(Event.RESIZE, onResize);
			stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
			stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
			//
			view = new View3D();
			view.clipping = new FrustumClipping();
			addChild(view);
			view.camera.z = 0;
			//
			addGroup(0);
			addGroup(1);
			addGroup(2);
			//
			addPanel();
			onResize();
		}
		
		private function addGroup(pos:Number):void
		{
			var group:ObjectContainer3D = new ObjectContainer3D();
			group.addChild(new Plane( {y:-100, bothsides:true, height:1124, width:1124, segmentsH:10, segmentsW:10 } ));
			group.addChild(new Plane( { y:100, bothsides:true, height:1124, width:1124, segmentsH:10, segmentsW:10 } ));
			//
			group.addChild(new Cube( { y:-50, x: -512, z:512 } ));
			group.addChild(new Cube( { y:-50, x: 512, z:512 } ));
			group.addChild(new Cube( { y:-50, x: -512, z:-512 } ));
			group.addChild(new Cube( { y: -50, x: 512, z: -512 } ));
			group.addChild(new Cube( { y:50, x: -256, z:256 } ));
			group.addChild(new Cube( { y:50, x: 256, z:256 } ));
			group.addChild(new Cube( { y:50, x: -256, z:-256 } ));
			group.addChild(new Cube( { y:50, x: 256, z: -256 } ));
			group.z = pos * 1124;
			view.scene.addChild(group);
		}
		
		private function addPanel():void
		{
			panel = new CameraPropertiesPanel();
			addChild(panel);
			panel.addEventListener('focusAnimationEvent', onPanelEvent);
			panel.addEventListener('zoomAnimationEvent', onPanelEvent);
			panel.addEventListener('startPositionEvent', onPanelEvent);
			panel.addEventListener('focusLessEvent', onPanelEvent);
			panel.addEventListener('focusMoreEvent', onPanelEvent);
			panel.addEventListener('zoomLessEvent', onPanelEvent);
			panel.addEventListener('zoomMoreEvent',onPanelEvent);
		}
		
		private function onPanelEvent(e:Event):void
		{
			var anim:TimelineMax;
			switch(e.type)
			{
				case 'focusAnimationEvent':
				{
					view.camera.zoom = 10;
					view.camera.focus = 100;
					anim = new TimelineMax();
					anim.append(TweenMax.to(view.camera, 3, { focus:10 } ));
					anim.append(TweenMax.to(view.camera, 2, { focus:100, ease:Elastic.easeOut } ));
					anim.play();
					break;
				}
				case 'zoomAnimationEvent':
				{
					view.camera.zoom = 10;
					view.camera.focus = 100;
					anim = new TimelineMax();
					anim.append(TweenMax.to(view.camera, 3, { zoom:1 } ));
					anim.append(TweenMax.to(view.camera, 2, { zoom:10, ease:Elastic.easeOut } ));
					anim.play();
					break;
				}
				case 'startPositionEvent':
				{
					TweenMax.to(view.camera, .5, { rotationX:0, rotationY:0, rotationZ:0, x:0, y:0, z:0, zoom:10, focus:100, onComplete:
						function()
						{
							panel.updateOutput(10, 100, Math.floor(view.camera.fov));
						} 
					} );
					break;
				}
				case 'focusLessEvent':
				{
					view.camera.focus--;
					break;
				}
				case 'focusMoreEvent':
				{
					view.camera.focus++;
					break;
				}
				case 'zoomLessEvent':
				{
					view.camera.zoom--;
					break;
				}
				case 'zoomMoreEvent':
				{
					view.camera.zoom++;
					break;
				}
			}
			panel.updateOutput(view.camera.zoom, view.camera.focus, Math.floor(view.camera.fov));
		}
		
		private function onKeyDown(e:KeyboardEvent):void
		{
			if (e.keyCode == Keyboard.UP) upArrowDown = true;
			if (e.keyCode == Keyboard.DOWN) downArrowDown = true;
			if (e.keyCode == Keyboard.LEFT) leftArrowDown = true;
			if (e.keyCode == Keyboard.RIGHT) rightArrowDown = true;
			if (e.keyCode == Keyboard.CONTROL) ctrlDown = true;
		}
		
		private function onKeyUp(e:KeyboardEvent):void
		{
			if (e.keyCode == Keyboard.UP) upArrowDown = false;
			if (e.keyCode == Keyboard.DOWN) downArrowDown = false;
			if (e.keyCode == Keyboard.LEFT) leftArrowDown = false;
			if (e.keyCode == Keyboard.RIGHT) rightArrowDown = false;
			if (e.keyCode == Keyboard.CONTROL) ctrlDown = false;
		}
		
		private function onEnterFrame(e:Event):void
		{
			if (upArrowDown)
			{
				if (ctrlDown) view.camera.rotationX++;
				else view.camera.moveForward(10);
			}
			if (downArrowDown)
			{
				if (ctrlDown) view.camera.rotationX--;
				else view.camera.moveBackward(10);
			}
			if (rightArrowDown)
			{
				if (ctrlDown) view.camera.rotationY++;
				else view.camera.moveRight(10);
			}
			if (leftArrowDown)
			{
				if (ctrlDown) view.camera.rotationY--;
				else view.camera.moveLeft(10);
			}
			view.render();
		}
		
		private function onResize(e:Event = null):void
		{
			view.x = stage.stageWidth * .5;
			view.y = stage.stageHeight * .5;
			panel.draw(stage.stageWidth, 70);
		}
	}
}