package 
{
	import away3d.events.MouseEvent3D;
	import flash.display.StageAlign;
	import flash.display.StageQuality;
	import flash.display.StageScaleMode;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.events.KeyboardEvent;
	import flash.ui.Keyboard;
	import flash.geom.Vector3D;
	//
	import away3d.containers.ObjectContainer3D;
	import away3d.containers.View3D;
	import away3d.loaders.Loader3D;
	import away3d.loaders.Max3DS;
	/**
	 * ...
	 * @author 
	 */
	public class MouseEventExample extends Sprite 
	{
		private var view:View3D;
		private var shipLoader:Loader3D;
		private var ship:ObjectContainer3D;
		private var mouseDown:Boolean = false;
		private var ctrlDown:Boolean = false;
		private var xPos:Number;
		private var yPos:Number;
		private var ease:Number = .3;
		
		public function MouseEventExample():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			stage.quality = StageQuality.LOW;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			removeEventListener(Event.ADDED_TO_STAGE, init);
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
			stage.addEventListener(Event.RESIZE, onResize);
			stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
			stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
			stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
			stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
			//
			view = new View3D();
			addChild(view);
			view.camera.z = -50;
			//
			ship = new ObjectContainer3D();
			shipLoader = Max3DS.load('../../resources/models/max3ds/spaceship/spaceship.3DS');
			shipLoader.rotationY = -90;
			shipLoader.rotationX = 90;
			shipLoader.position = new Vector3D(0, 0, 0);
			ship.addChild(shipLoader);
			view.scene.addChild(ship);
			//
			onResize();
		}
		
		private function onMouseDown(e:MouseEvent):void
		{
			mouseDown = true;
		}
		
		private function onMouseUp(e:MouseEvent):void
		{
			mouseDown = false;
		}
		
		private function onKeyDown(e:KeyboardEvent):void
		{
			if (e.keyCode == Keyboard.CONTROL) ctrlDown = true;
		}
		
		private function onKeyUp(e:KeyboardEvent):void
		{
			if (e.keyCode == Keyboard.CONTROL) ctrlDown = false;
		}
		
		private function onResize(e:Event = null):void
		{
			view.x = stage.stageWidth * .5;
			view.y = stage.stageHeight * .5;
		}
		
		private function onEnterFrame(e:Event):void
		{
			xPos = stage.mouseX - stage.stageWidth * .5;
			yPos = stage.mouseY - stage.stageHeight * .5;
			
			if (mouseDown && !ctrlDown)
			{
				ship.rotationY += (xPos * .5 - ship.rotationY) * ease;
				ship.rotationX += (yPos * .5 - ship.rotationX) * ease;
			}
			else if (mouseDown && ctrlDown)
			{
				ship.scale(Math.sqrt(xPos * xPos + yPos * yPos) * .01);
			}	
			view.render();
		}
	}
}